/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.propertysupport.customizers;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.netbeans.modules.uml.common.generics.ETPairT;
import org.netbeans.modules.uml.core.configstringframework.ConfigStringHelper;
import org.netbeans.modules.uml.core.configstringframework.IConfigStringTranslator;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IMultiplicity;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IMultiplicityRange;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IParameter;
import org.netbeans.modules.uml.core.metamodel.structure.IProject;
import org.netbeans.modules.uml.core.support.umlsupport.IStrings;
import org.netbeans.modules.uml.core.support.umlsupport.Strings;
import org.netbeans.modules.uml.core.support.umlutils.IPropertyDefinition;
import org.netbeans.modules.uml.core.support.umlutils.IPropertyElement;
import org.netbeans.modules.uml.core.typemanagement.IPickListManager;
import org.netbeans.modules.uml.core.typemanagement.ITypeManager;
import org.netbeans.modules.uml.propertysupport.customizers.Customizer;
import org.netbeans.modules.uml.propertysupport.customizers.MultiplictyRangeHandler;
import org.netbeans.modules.uml.propertysupport.customizers.PropertyDataFormatter;
import org.netbeans.modules.uml.propertysupport.nodes.CustomPropertyEditor;
import org.netbeans.modules.uml.ui.support.ProductHelper;
import org.netbeans.modules.uml.ui.support.applicationmanager.IProduct;
import org.netbeans.modules.uml.ui.support.applicationmanager.IProductProjectManager;
import org.openide.awt.Mnemonics;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ReturnTypeCustomizer
extends JPanel
implements Customizer,
EnhancedCustomPropertyEditor {
    private ResourceBundle bundle = NbBundle.getBundle(ReturnTypeCustomizer.class);
    private IPropertyElement mElement = null;
    private IPropertyDefinition mDefinition = null;
    private CustomPropertyEditor mEditor = null;
    private JButton addMulButton;
    private JScrollPane jScrollPane1;
    private JTextArea messageArea;
    private JLabel messageIcon;
    private JPanel messagePanel;
    private JPanel multiplicityPanel;
    private JTable multiplicityTable;
    private JButton removeMulButton;
    private JComboBox returnTypeCombo;
    private JLabel returnTypeLabel;

    public ReturnTypeCustomizer() {
        this.initComponents();
    }

    public void setElement(IPropertyElement iPropertyElement, IPropertyDefinition iPropertyDefinition) {
        this.mElement = iPropertyElement;
        this.mDefinition = iPropertyDefinition;
        this.initializeMulti();
        this.initializeType();
        this.setPreferredSize(new Dimension(680, 330));
    }

    public void setPropertySupport(CustomPropertyEditor customPropertyEditor) {
        this.mEditor = customPropertyEditor;
    }

    protected void notifyChanged() {
        if (this.mEditor != null) {
            this.mEditor.firePropertyChange();
        }
    }

    protected void initializeType() {
        IStrings iStrings;
        Vector vector = this.mElement.getSubElements();
        IPropertyElement iPropertyElement = null;
        IPropertyDefinition iPropertyDefinition = null;
        if (vector != null && vector.size() > 0) {
            iPropertyElement = (IPropertyElement)vector.get(0);
            iPropertyDefinition = iPropertyElement.getPropertyDefinition();
        }
        if ((iStrings = iPropertyDefinition != null && iPropertyElement != null ? iPropertyDefinition.getValidValue(iPropertyElement) : this.searchAllTypes()) != null) {
            DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(iStrings.toArray());
            this.returnTypeCombo.setModel(defaultComboBoxModel);
        }
        if (iPropertyElement != null) {
            this.returnTypeCombo.setSelectedItem(iPropertyElement.getValue());
            this.returnTypeChangedHandler(null);
        }
    }

    protected void initializeMulti() {
        IParameter iParameter = (IParameter)this.mElement.getElement();
        IMultiplicity iMultiplicity = iParameter.getMultiplicity();
        MultiplicityTableModel multiplicityTableModel = new MultiplicityTableModel(iMultiplicity);
        this.multiplicityTable.setModel(multiplicityTableModel);
        this.multiplicityTable.getModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                ReturnTypeCustomizer.this.tableChangeHandler(tableModelEvent);
            }
        });
        TableColumn tableColumn = this.multiplicityTable.getColumnModel().getColumn(2);
        tableColumn.setCellEditor(new CollectionTypeEditor());
        tableColumn.setCellRenderer(new CollectionTypeRender());
    }

    private void initComponents() {
        this.returnTypeLabel = new JLabel();
        this.returnTypeCombo = new JComboBox();
        this.multiplicityPanel = new JPanel();
        this.addMulButton = new JButton();
        this.removeMulButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.multiplicityTable = new JTable();
        this.messagePanel = new JPanel();
        this.messageIcon = new JLabel();
        this.messageArea = new JTextArea();
        this.setPreferredSize(new Dimension(480, 250));
        this.setLayout(new GridBagLayout());
        this.returnTypeLabel.setLabelFor(this.returnTypeCombo);
        Mnemonics.setLocalizedText((JLabel)this.returnTypeLabel, (String)this.bundle.getString("RETURN_TYPE"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 0, 5);
        this.add((Component)this.returnTypeLabel, gridBagConstraints);
        this.returnTypeCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                ReturnTypeCustomizer.this.returnTypeChangedHandler(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.2;
        gridBagConstraints.insets = new Insets(10, 0, 0, 10);
        this.add((Component)this.returnTypeCombo, gridBagConstraints);
        this.returnTypeCombo.getAccessibleContext().setAccessibleName(this.bundle.getString("ACSN_TYPE"));
        this.returnTypeCombo.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACSN_TYPE"));
        this.multiplicityPanel.setBorder(BorderFactory.createTitledBorder(this.bundle.getString("MULTIPLICITY")));
        this.multiplicityPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.addMulButton, (String)this.bundle.getString("BTN_ADDRANGE"));
        this.addMulButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReturnTypeCustomizer.this.addMulButtonactionHandler(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        this.multiplicityPanel.add((Component)this.addMulButton, gridBagConstraints);
        this.addMulButton.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACSN_ADDRANGE"));
        Mnemonics.setLocalizedText((AbstractButton)this.removeMulButton, (String)this.bundle.getString("BTN_REMOVERANGE"));
        this.removeMulButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReturnTypeCustomizer.this.removeMulButtonactionHandler(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 0, 0, 5);
        this.multiplicityPanel.add((Component)this.removeMulButton, gridBagConstraints);
        this.removeMulButton.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACSN_REMOVERANGE"));
        this.multiplicityTable.setModel(new MultiplicityTableModel());
        this.jScrollPane1.setViewportView(this.multiplicityTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.7;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.multiplicityPanel.add((Component)this.jScrollPane1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.add((Component)this.multiplicityPanel, gridBagConstraints);
        this.messagePanel.setLayout(new GridBagLayout());
        this.messageIcon.setLabelFor(this.messageArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.messagePanel.add((Component)this.messageIcon, gridBagConstraints);
        this.messageArea.setBackground(this.messagePanel.getBackground());
        this.messageArea.setEditable(false);
        this.messageArea.setLineWrap(true);
        this.messageArea.setRows(1);
        this.messageArea.setWrapStyleWord(true);
        this.messageArea.setAutoscrolls(false);
        Color color = UIManager.getColor("nb.errorForeground");
        if (color == null) {
            color = new Color(89, 79, 191);
        }
        this.messageArea.setForeground(color);
        this.messageArea.setFont(this.getFont());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.9;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.messagePanel.add((Component)this.messageArea, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.add((Component)this.messagePanel, gridBagConstraints);
    }

    private void removeMulButtonactionHandler(ActionEvent actionEvent) {
        MultiplicityTableModel multiplicityTableModel = (MultiplicityTableModel)this.multiplicityTable.getModel();
        if (multiplicityTableModel != null) {
            multiplicityTableModel.removeRange(this.multiplicityTable.getSelectedRow());
        }
    }

    private void addMulButtonactionHandler(ActionEvent actionEvent) {
        MultiplicityTableModel multiplicityTableModel = (MultiplicityTableModel)this.multiplicityTable.getModel();
        if (multiplicityTableModel != null) {
            multiplicityTableModel.addRange();
        }
    }

    private void returnTypeChangedHandler(ItemEvent itemEvent) {
        String string = (String)this.returnTypeCombo.getSelectedItem();
        MultiplicityTableModel multiplicityTableModel = (MultiplicityTableModel)this.multiplicityTable.getModel();
        if ("void".equals(string)) {
            if (multiplicityTableModel != null) {
                multiplicityTableModel.removeAllRanges();
            }
            this.enableButtons(false);
        } else {
            this.enableButtons(true);
        }
        this.setMessage("");
    }

    private void enableButtons(boolean bl) {
        this.removeMulButton.setEnabled(bl);
        this.addMulButton.setEnabled(bl);
    }

    public void tableChangeHandler(TableModelEvent tableModelEvent) {
        MultiplictyRangeHandler multiplictyRangeHandler = new MultiplictyRangeHandler();
        ETPairT<Boolean, String> eTPairT = multiplictyRangeHandler.tableValueChanged(tableModelEvent);
        if (eTPairT != null) {
            boolean bl = (Boolean)eTPairT.getParamOne();
            String string = (String)eTPairT.getParamTwo();
            this.setMessage(string);
            this.addMulButton.setEnabled(bl);
        }
    }

    private void setMessage(String string) {
        ImageIcon imageIcon = null;
        if (string != null) {
            this.messageArea.setText(string);
            if (string.trim().length() > 0) {
                imageIcon = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/uml/resources/images/error.png"));
            }
            this.messageIcon.setIcon(imageIcon);
        }
    }

    public Object getPropertyValue() throws IllegalStateException {
        IParameter iParameter = (IParameter)this.mElement.getElement();
        String string = (String)this.returnTypeCombo.getSelectedItem();
        if (string != null && string.trim().length() > 0) {
            iParameter.setType2(string);
            MultiplicityTableModel multiplicityTableModel = (MultiplicityTableModel)this.multiplicityTable.getModel();
            multiplicityTableModel.saveRanges();
            this.notifyChanged();
        }
        return null;
    }

    protected void save(IPropertyElement iPropertyElement) {
        if (iPropertyElement != null) {
            iPropertyElement.save();
            Vector vector = iPropertyElement.getSubElements();
            for (IPropertyElement iPropertyElement2 : vector) {
                this.save(iPropertyElement2);
            }
        }
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
    }

    private IStrings searchAllTypes() {
        IPickListManager iPickListManager;
        ITypeManager iTypeManager;
        IProject iProject;
        IProductProjectManager iProductProjectManager;
        Strings strings = new Strings();
        IProduct iProduct = ProductHelper.getProduct();
        if (iProduct != null && (iProductProjectManager = iProduct.getProjectManager()) != null && (iProject = iProductProjectManager.getCurrentProject()) != null && (iTypeManager = iProject.getTypeManager()) != null && (iPickListManager = iTypeManager.getPickListManager()) != null) {
            String string = "DataType Class Interface";
            strings = iPickListManager.getTypeNamesWithStringFilter(string);
        }
        return strings;
    }

    public class CollectionTypeRender
    extends DefaultTableCellRenderer {
        protected void setValue(Object object) {
            String string = PropertyDataFormatter.translateFullyQualifiedName((String)object);
            super.setValue(object);
        }
    }

    public class CollectionTypeEditor
    extends DefaultCellEditor {
        public CollectionTypeEditor() {
            super(new JComboBox());
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            JComboBox jComboBox = (JComboBox)super.getTableCellEditorComponent(jTable, object, bl, n, n2);
            IParameter iParameter = (IParameter)ReturnTypeCustomizer.this.mElement.getElement();
            for (String string : iParameter.getPossibleCollectionTypes()) {
                String string2 = PropertyDataFormatter.translateFullyQualifiedName(string);
                jComboBox.addItem(string2);
            }
            String string = PropertyDataFormatter.translateFullyQualifiedName((String)object);
            jComboBox.setSelectedItem(object);
            return jComboBox;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MultiplicityTableModel
    implements TableModel {
        private IMultiplicity multiplicity = null;
        private ArrayList<RangeData> ranges = new ArrayList();
        private ArrayList<TableModelListener> listeners = new ArrayList();

        public MultiplicityTableModel() {
        }

        public MultiplicityTableModel(IMultiplicity iMultiplicity) {
            for (IMultiplicityRange iMultiplicityRange : iMultiplicity.getRanges()) {
                RangeData rangeData = new RangeData(iMultiplicityRange.getLower(), iMultiplicityRange.getUpper(), iMultiplicityRange.getCollectionType());
                this.ranges.add(rangeData);
            }
            this.multiplicity = iMultiplicity;
        }

        public void addRange() {
            RangeData rangeData = new RangeData("0", "*", "");
            this.ranges.add(rangeData);
            this.fireRowAdded();
        }

        public void removeRange(int n) {
            if (n == -1) {
                return;
            }
            this.ranges.remove(n);
            this.fireRowRemoved(n);
        }

        public void removeAllRanges() {
            if (this.ranges != null) {
                for (int i = 0; i < this.ranges.size(); ++i) {
                    this.ranges.remove(i);
                    this.fireRowRemoved(i);
                }
            }
        }

        public void saveRanges() {
            this.multiplicity.removeAllRanges();
            if (this.ranges != null) {
                for (RangeData rangeData : this.ranges) {
                    IMultiplicityRange iMultiplicityRange = this.multiplicity.createRange();
                    iMultiplicityRange.setRange(rangeData.getLower(), rangeData.getUpper());
                    iMultiplicityRange.setCollectionType(PropertyDataFormatter.translateToFullyQualifiedName(rangeData.getCollection()));
                    this.multiplicity.addRange(iMultiplicityRange);
                }
            }
        }

        @Override
        public int getRowCount() {
            return this.ranges.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int n) {
            String string = "";
            if (n == 0) {
                string = NbBundle.getMessage(ReturnTypeCustomizer.class, (String)"LOWER");
            } else if (n == 1) {
                string = NbBundle.getMessage(ReturnTypeCustomizer.class, (String)"UPPER");
            } else {
                IConfigStringTranslator iConfigStringTranslator = ConfigStringHelper.instance().getTranslator();
                string = iConfigStringTranslator.translateWord("PSK_COLLECTION_OVERRIDE_DATA_TYPE");
            }
            return string;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            RangeData rangeData = this.ranges.get(n);
            String string = null;
            switch (n2) {
                case 0: {
                    string = rangeData.getLower();
                    break;
                }
                case 1: {
                    string = rangeData.getUpper();
                    break;
                }
                default: {
                    string = rangeData.getCollection();
                }
            }
            return string;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            RangeData rangeData = this.ranges.get(n);
            switch (n2) {
                case 0: {
                    rangeData.setLower((String)object);
                    break;
                }
                case 1: {
                    rangeData.setUpper((String)object);
                    break;
                }
                default: {
                    rangeData.setCollection((String)object);
                }
            }
            TableModelEvent tableModelEvent = new TableModelEvent(this, n, n, n2);
            for (TableModelListener tableModelListener : this.listeners) {
                tableModelListener.tableChanged(tableModelEvent);
            }
        }

        @Override
        public void addTableModelListener(TableModelListener tableModelListener) {
            this.listeners.add(tableModelListener);
        }

        @Override
        public void removeTableModelListener(TableModelListener tableModelListener) {
            this.listeners.remove(tableModelListener);
        }

        public void fireRowAdded() {
            TableModelEvent tableModelEvent = new TableModelEvent(this, this.ranges.size(), this.ranges.size(), -1, 1);
            for (TableModelListener tableModelListener : this.listeners) {
                tableModelListener.tableChanged(tableModelEvent);
            }
        }

        public void fireRowRemoved(int n) {
            TableModelEvent tableModelEvent = new TableModelEvent(this, n, n, -1, -1);
            for (TableModelListener tableModelListener : this.listeners) {
                tableModelListener.tableChanged(tableModelEvent);
            }
        }

        private class RangeData {
            private String lower = "";
            private String upper = "";
            private String collection = "";

            public RangeData(String string, String string2, String string3) {
                this.setLower(string);
                this.setUpper(string2);
                this.setCollection(string3);
            }

            public String getLower() {
                return this.lower;
            }

            public void setLower(String string) {
                this.lower = string;
            }

            public String getUpper() {
                return this.upper;
            }

            public void setUpper(String string) {
                this.upper = string;
            }

            public String getCollection() {
                return this.collection;
            }

            public void setCollection(String string) {
                this.collection = string;
            }
        }
    }
}

