/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.bean;

import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.bean.BeanAttributeList;
import org.dom4j.bean.BeanDocumentFactory;
import org.dom4j.tree.DefaultElement;

public class BeanElement
extends DefaultElement {
    private static final DocumentFactory DOCUMENT_FACTORY = BeanDocumentFactory.getInstance();
    private Object bean;

    public BeanElement(String name, Object bean) {
        this(DOCUMENT_FACTORY.createQName(name), bean);
    }

    public BeanElement(String name, Namespace namespace, Object bean) {
        this(DOCUMENT_FACTORY.createQName(name, namespace), bean);
    }

    public BeanElement(QName qname, Object bean) {
        super(qname);
        this.bean = bean;
    }

    public BeanElement(QName qname) {
        super(qname);
    }

    public Object getData() {
        return this.bean;
    }

    public void setData(Object data) {
        this.bean = this.bean;
        this.setAttributeList(null);
    }

    public Attribute attribute(String name) {
        return this.getBeanAttributeList().attribute(name);
    }

    public Attribute attribute(QName qname) {
        return this.getBeanAttributeList().attribute(qname);
    }

    public Element addAttribute(String name, String value) {
        Attribute attribute = this.attribute(name);
        if (attribute != null) {
            attribute.setValue(value);
        }
        return this;
    }

    public Element addAttribute(QName qName, String value) {
        Attribute attribute = this.attribute(qName);
        if (attribute != null) {
            attribute.setValue(value);
        }
        return this;
    }

    public void setAttributes(List attributes) {
        throw new UnsupportedOperationException("setAttributes(List) is not supported yet!");
    }

    protected DocumentFactory getDocumentFactory() {
        return DOCUMENT_FACTORY;
    }

    protected BeanAttributeList getBeanAttributeList() {
        return (BeanAttributeList)this.attributeList();
    }

    protected List createAttributeList() {
        return new BeanAttributeList(this);
    }
}

