/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.tree;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.dom4j.Namespace;

public class NamespaceCache {
    protected static Map cache;
    protected static Map noPrefixCache;

    public synchronized Namespace get(String prefix, String uri) {
        Map cache = this.getURICache(uri);
        Namespace answer = (Namespace)cache.get(prefix);
        if (answer == null) {
            answer = this.createNamespace(prefix, uri);
            cache.put(prefix, answer);
        }
        return answer;
    }

    public synchronized Namespace get(String uri) {
        Namespace answer;
        if (noPrefixCache == null) {
            noPrefixCache = this.createURIMap();
        }
        if ((answer = (Namespace)noPrefixCache.get(uri)) == null) {
            answer = this.createNamespace("", uri);
            noPrefixCache.put(uri, answer);
        }
        return answer;
    }

    protected synchronized Map getURICache(String uri) {
        Map answer;
        if (cache == null) {
            cache = this.createURIMap();
        }
        if ((answer = (Map)cache.get(uri)) == null) {
            answer = this.createPrefixMap();
            cache.put(uri, answer);
        }
        return answer;
    }

    protected Namespace createNamespace(String prefix, String uri) {
        return new Namespace(prefix, uri);
    }

    protected Map createPrefixMap() {
        return Collections.synchronizedMap(new HashMap());
    }

    protected Map createURIMap() {
        return Collections.synchronizedMap(new HashMap());
    }
}

