/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.lookup.ALPairComparator;
import org.openide.util.lookup.ArrayStorage;
import org.openide.util.lookup.DelegatingStorage;
import org.openide.util.lookup.InheritanceTree;
import org.openide.util.lookup.WaitableResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractLookup
extends Lookup
implements Serializable {
    static final long serialVersionUID = 5L;
    private static Object treeLock = new Object();
    private Object tree;
    private int count;

    public AbstractLookup(Content content) {
        content.attach(this);
    }

    AbstractLookup(Content content, Storage<?> storage) {
        this(content);
        this.tree = storage;
        this.initialize();
    }

    AbstractLookup(Content content, Integer n) {
        this(content);
        this.tree = n;
    }

    protected AbstractLookup() {
    }

    public String toString() {
        if (this.tree instanceof Storage) {
            return "AbstractLookup" + this.lookup(new Lookup.Template<Object>(Object.class)).allItems();
        }
        return super.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Storage<T> enterStorage() {
        while (true) {
            Object object = treeLock;
            synchronized (object) {
                if (this.tree instanceof Storage) {
                    if (this.tree instanceof DelegatingStorage) {
                        DelegatingStorage delegatingStorage = (DelegatingStorage)this.tree;
                        delegatingStorage.checkForTreeModification();
                        try {
                            treeLock.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        continue;
                    }
                    this.tree = new DelegatingStorage((Storage)this.tree);
                    return (Storage)this.tree;
                }
                this.tree = this.tree instanceof Integer ? new ArrayStorage((Integer)this.tree) : new ArrayStorage();
            }
            this.initialize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Storage exitStorage() {
        Object object = treeLock;
        synchronized (object) {
            Storage storage;
            this.tree = storage = ((DelegatingStorage)this.tree).exitDelegate();
            treeLock.notifyAll();
            return storage;
        }
    }

    protected void initialize() {
    }

    protected void beforeLookup(Lookup.Template<?> template) {
    }

    protected final void addPair(Pair<?> pair) {
        this.addPairImpl(pair);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <Transaction> void addPairImpl(Pair<?> pair) {
        HashSet<R> hashSet;
        block6: {
            hashSet = new HashSet<R>();
            Storage storage = this.enterStorage();
            Object Transaction2 = null;
            try {
                Transaction2 = storage.beginTransaction(-2);
                if (storage.add(pair, Transaction2)) {
                    try {
                        pair.setIndex(storage, this.count++);
                    }
                    catch (IllegalStateException illegalStateException) {
                        storage.remove(pair, Transaction2);
                        throw illegalStateException;
                    }
                    storage.endTransaction(Transaction2, hashSet);
                    break block6;
                }
                storage.endTransaction(Transaction2, new HashSet<R>());
            }
            finally {
                this.exitStorage();
            }
        }
        AbstractLookup.notifyListeners(hashSet);
    }

    protected final void removePair(Pair<?> pair) {
        this.removePairImpl(pair);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <Transaction> void removePairImpl(Pair<?> pair) {
        HashSet<R> hashSet = new HashSet<R>();
        Storage storage = this.enterStorage();
        Object Transaction2 = null;
        try {
            Transaction2 = storage.beginTransaction(-1);
            storage.remove(pair, Transaction2);
            storage.endTransaction(Transaction2, hashSet);
        }
        finally {
            this.exitStorage();
        }
        AbstractLookup.notifyListeners(hashSet);
    }

    protected final void setPairs(Collection<? extends Pair> collection) {
        this.notifyCollectedListeners(this.setPairsAndCollectListeners(collection));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final LinkedHashSet<Pair<?>> getPairsAsLHS() {
        Storage<Object> storage = this.enterStorage();
        try {
            Serializable serializable;
            Enumeration<Pair<Object>> enumeration = storage.lookup(Object.class);
            TreeSet treeSet = new TreeSet(ALPairComparator.DEFAULT);
            while (enumeration.hasMoreElements()) {
                serializable = enumeration.nextElement();
                treeSet.add((Pair<?>)serializable);
            }
            serializable = new LinkedHashSet(treeSet);
            return serializable;
        }
        finally {
            this.exitStorage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final <Transaction> HashSet<R> setPairsAndCollectListeners(Collection<? extends Pair> collection) {
        HashSet<R> hashSet = new HashSet<R>(27);
        Storage storage = this.enterStorage();
        Object Transaction2 = null;
        try {
            HashMap<Pair, Info> hashMap = new HashMap<Pair, Info>(collection.size() * 2);
            this.count = 0;
            Iterator<? extends Pair> iterator = collection.iterator();
            Transaction2 = storage.beginTransaction(collection.size());
            while (iterator.hasNext()) {
                Pair pair = iterator.next();
                if (storage.add(pair, Transaction2)) {
                    // empty if block
                }
                hashMap.put(pair, new Info(this.count++, Transaction2));
            }
            storage.retainAll(hashMap, Transaction2);
            storage.endTransaction(Transaction2, hashSet);
        }
        finally {
            this.exitStorage();
        }
        return hashSet;
    }

    final void notifyCollectedListeners(Set<R> set) {
        AbstractLookup.notifyListeners(set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Storage storage = this.enterStorage();
        try {
            storage.beginTransaction(Integer.MAX_VALUE);
            objectOutputStream.defaultWriteObject();
        }
        finally {
            this.exitStorage();
        }
    }

    @Override
    public final <T> T lookup(Class<T> clazz) {
        Lookup.Item<T> item = this.lookupItem(new Lookup.Template<T>(clazz));
        return item == null ? null : (T)item.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <T> Lookup.Item<T> lookupItem(Lookup.Template<T> template) {
        this.beforeLookup(template);
        ArrayList arrayList = null;
        Storage storage = this.enterStorage();
        try {
            Enumeration<Pair<T>> enumeration = storage.lookup(template.getType());
            Pair<T> pair = AbstractLookup.findSmallest(enumeration, template, false);
            return pair;
        }
        catch (ISE iSE) {
            arrayList = new ArrayList();
            Enumeration enumeration = storage.lookup(null);
            while (enumeration.hasMoreElements()) {
                arrayList.add(enumeration.nextElement());
            }
        }
        finally {
            this.exitStorage();
        }
        return AbstractLookup.findSmallest(Collections.enumeration(arrayList), template, true);
    }

    private static <T> Pair<T> findSmallest(Enumeration<Pair<T>> enumeration, Lookup.Template<T> template, boolean bl) {
        int n = InheritanceTree.unsorted(enumeration) ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        Pair<T> pair = null;
        while (enumeration.hasMoreElements()) {
            Pair<T> pair2 = enumeration.nextElement();
            if (!AbstractLookup.matches(template, pair2, bl)) continue;
            if (n == Integer.MIN_VALUE) {
                return pair2;
            }
            if (n <= pair2.getIndex()) continue;
            n = pair2.getIndex();
            pair = pair2;
        }
        return pair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <T> Lookup.Result<T> lookup(Lookup.Template<T> template) {
        while (true) {
            ISE iSE = null;
            Storage<T> storage = this.enterStorage();
            try {
                R r = new R();
                ReferenceToResult referenceToResult = new ReferenceToResult(r, this, template);
                referenceToResult.next = storage.registerReferenceToResult(referenceToResult);
                R r2 = r;
                return r2;
            }
            catch (ISE iSE2) {
                iSE = iSE2;
            }
            finally {
                this.exitStorage();
            }
            iSE.recover(this);
        }
    }

    private static void notifyListeners(Set<R> set) {
        if (set.isEmpty()) {
            return;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (R object : set) {
            object.collectFires(arrayList);
        }
        Iterator<R<Object>> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            LookupEvent lookupEvent = (LookupEvent)((Object)iterator.next());
            LookupListener lookupListener = (LookupListener)((Object)iterator.next());
            lookupListener.resultChanged(lookupEvent);
        }
    }

    static void notifyListeners(Object[] objectArray, LookupEvent lookupEvent, Collection<Object> collection) {
        for (int i = objectArray.length - 1; i >= 0; --i) {
            if (!(objectArray[i] instanceof LookupListener)) continue;
            LookupListener lookupListener = (LookupListener)objectArray[i];
            try {
                if (collection != null) {
                    if (lookupListener instanceof WaitableResult) {
                        WaitableResult waitableResult = (WaitableResult)((Object)lookupListener);
                        waitableResult.collectFires(collection);
                        continue;
                    }
                    collection.add(lookupEvent);
                    collection.add(lookupListener);
                    continue;
                }
                lookupListener.resultChanged(lookupEvent);
                continue;
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
            }
        }
    }

    static boolean matches(Lookup.Template<?> template, Pair<?> pair, boolean bl) {
        String string = template.getId();
        if (string != null && !string.equals(pair.getId())) {
            return false;
        }
        Object obj = template.getInstance();
        if (obj != null && !pair.creatorOf(obj)) {
            return false;
        }
        if (bl) {
            return pair.instanceOf(template.getType());
        }
        return true;
    }

    private static boolean compareArrays(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == null) {
            return objectArray2 == null;
        }
        if (objectArray2 == null) {
            return false;
        }
        if (objectArray.length != objectArray2.length) {
            return false;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null) {
                if (objectArray2[i] == null) continue;
                return false;
            }
            if (objectArray2[i] == null) {
                return false;
            }
            if (objectArray[i].equals(objectArray2[i])) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> boolean cleanUpResult(Lookup.Template<T> template) {
        Storage<T> storage = this.enterStorage();
        try {
            boolean bl = storage.cleanUpResult(template) == null;
            return bl;
        }
        finally {
            this.exitStorage();
        }
    }

    static Object modifyListenerList(boolean bl, LookupListener lookupListener, Object arrayList) {
        if (bl) {
            if (arrayList == null) {
                return lookupListener;
            }
            if (arrayList instanceof LookupListener) {
                ArrayList arrayList2 = new ArrayList();
                arrayList2.add(arrayList);
                arrayList = arrayList2;
            }
            ((ArrayList)arrayList).add(lookupListener);
            return arrayList;
        }
        if (arrayList == null) {
            return null;
        }
        if (arrayList == lookupListener) {
            return null;
        }
        ArrayList arrayList3 = arrayList;
        arrayList3.remove(lookupListener);
        if (arrayList3.size() == 1) {
            return arrayList3.iterator().next();
        }
        return arrayList3;
    }

    private static ReferenceQueue<Object> activeQueue() {
        return Utilities.activeReferenceQueue();
    }

    static final class ISE
    extends IllegalStateException {
        static final long serialVersionUID = 100L;
        private List<Job> jobs;

        public ISE(String string) {
            super(string);
        }

        public void registerJob(Job job) {
            if (this.jobs == null) {
                this.jobs = new ArrayList<Job>();
            }
            this.jobs.add(job);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void recover(AbstractLookup abstractLookup) {
            if (this.jobs == null) {
                throw this;
            }
            for (Job object : this.jobs) {
                object.before();
            }
            Storage storage = abstractLookup.enterStorage();
            try {
                for (Job job : this.jobs) {
                    job.inside();
                }
            }
            finally {
                abstractLookup.exitStorage();
            }
        }

        static interface Job {
            public void before();

            public void inside();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ReferenceIterator {
        private ReferenceToResult<?> first;
        private ReferenceToResult<?> current;
        private R<?> currentResult;

        public ReferenceIterator(ReferenceToResult<?> referenceToResult) {
            this.first = referenceToResult;
        }

        public boolean next() {
            ReferenceToResult referenceToResult;
            ReferenceToResult referenceToResult2;
            if (this.current == null) {
                referenceToResult2 = this.first;
                referenceToResult = null;
            } else {
                referenceToResult = this.current;
                referenceToResult2 = ((ReferenceToResult)this.current).next;
            }
            while (referenceToResult2 != null) {
                R r = (R)referenceToResult2.get();
                if (r == null) {
                    if (referenceToResult == null) {
                        this.first = referenceToResult2.next;
                    } else {
                        referenceToResult.next = (ReferenceToResult)referenceToResult2.next;
                    }
                    referenceToResult = referenceToResult2;
                    referenceToResult2 = referenceToResult2.next;
                    continue;
                }
                this.currentResult = r;
                this.current = referenceToResult2;
                return true;
            }
            this.currentResult = null;
            this.current = null;
            return false;
        }

        public ReferenceToResult<?> current() {
            return this.current;
        }

        public ReferenceToResult<?> first() {
            return this.first;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ReferenceToResult<T>
    extends WeakReference<R<T>>
    implements Runnable {
        private ReferenceToResult<?> next;
        public final Lookup.Template<T> template;
        public final AbstractLookup lookup;
        public Object caches;

        private ReferenceToResult(R<T> r, AbstractLookup abstractLookup, Lookup.Template<T> template) {
            super(r, AbstractLookup.activeQueue());
            this.template = template;
            this.lookup = abstractLookup;
            this.getResult().reference = this;
        }

        R<T> getResult() {
            return (R)this.get();
        }

        @Override
        public void run() {
            this.lookup.cleanUpResult(this.template);
        }

        public void cloneList(Storage<?> storage) {
            ReferenceIterator referenceIterator = new ReferenceIterator(this);
            while (referenceIterator.next()) {
                ReferenceToResult<?> referenceToResult = referenceIterator.current();
                ReferenceToResult<?> referenceToResult2 = super.cloneRef();
                referenceToResult2.next = storage.registerReferenceToResult(referenceToResult2);
                referenceToResult2.caches = referenceToResult.caches;
                if (referenceToResult.caches != referenceToResult) continue;
                ((R)referenceToResult.getResult()).initItems(storage);
            }
        }

        private ReferenceToResult<T> cloneRef() {
            return new ReferenceToResult<T>(this.getResult(), this.lookup, this.template);
        }
    }

    static final class Info {
        public int index;
        public Object transaction;

        public Info(int n, Object object) {
            this.index = n;
            this.transaction = object;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Content
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private AbstractLookup al = null;
        private transient ArrayList<Pair> earlyPairs;

        final synchronized void attach(AbstractLookup abstractLookup) {
            if (this.al == null) {
                this.al = abstractLookup;
                if (this.earlyPairs != null) {
                    ArrayList<Pair> arrayList = this.earlyPairs;
                    this.earlyPairs = null;
                    this.setPairs(arrayList);
                }
            } else {
                throw new IllegalStateException("Trying to use content for " + abstractLookup + " but it is already used for " + this.al);
            }
        }

        public final void addPair(Pair<?> pair) {
            AbstractLookup abstractLookup = this.al;
            if (abstractLookup != null) {
                abstractLookup.addPair(pair);
            } else {
                if (this.earlyPairs == null) {
                    this.earlyPairs = new ArrayList(3);
                }
                this.earlyPairs.add(pair);
            }
        }

        public final void removePair(Pair<?> pair) {
            AbstractLookup abstractLookup = this.al;
            if (abstractLookup != null) {
                abstractLookup.removePair(pair);
            } else {
                if (this.earlyPairs == null) {
                    this.earlyPairs = new ArrayList(3);
                }
                this.earlyPairs.remove(pair);
            }
        }

        public final void setPairs(Collection<? extends Pair> collection) {
            AbstractLookup abstractLookup = this.al;
            if (abstractLookup != null) {
                abstractLookup.setPairs(collection);
            } else {
                this.earlyPairs = new ArrayList<Pair>(collection);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class R<T>
    extends WaitableResult<T> {
        public ReferenceToResult<T> reference;
        private Object listeners;

        private boolean isSimple() {
            Storage storage = (Storage)this.reference.lookup.tree;
            return DelegatingStorage.isSimple(storage);
        }

        private Object getFromCache(int n) {
            if (this.isSimple()) {
                return null;
            }
            Object object = this.reference.caches;
            if (object instanceof Object[]) {
                return ((Object[])object)[n];
            }
            return null;
        }

        private Set<Class<? extends T>> getClassesCache() {
            return (Set)this.getFromCache(0);
        }

        private void setClassesCache(Set set) {
            if (this.isSimple()) {
                this.reference.caches = this.reference;
                return;
            }
            if (!(this.reference.caches instanceof Object[])) {
                this.reference.caches = new Object[3];
            }
            ((Object[])this.reference.caches)[0] = set;
        }

        private Collection<T> getInstancesCache() {
            return (Collection)this.getFromCache(1);
        }

        private void setInstancesCache(Collection collection) {
            if (this.isSimple()) {
                this.reference.caches = this.reference;
                return;
            }
            if (!(this.reference.caches instanceof Object[])) {
                this.reference.caches = new Object[3];
            }
            ((Object[])this.reference.caches)[1] = collection;
        }

        private Pair<T>[] getItemsCache() {
            return (Pair[])this.getFromCache(2);
        }

        private void setItemsCache(Collection<?> collection) {
            if (this.isSimple()) {
                this.reference.caches = this.reference;
                return;
            }
            if (!(this.reference.caches instanceof Object[])) {
                this.reference.caches = new Object[3];
            }
            ((Object[])this.reference.caches)[2] = collection.toArray(new Pair[0]);
        }

        private void clearCaches() {
            if (this.reference.caches instanceof Object[]) {
                this.reference.caches = new Object[3];
            }
        }

        @Override
        public synchronized void addLookupListener(LookupListener lookupListener) {
            this.listeners = AbstractLookup.modifyListenerList(true, lookupListener, this.listeners);
        }

        @Override
        public synchronized void removeLookupListener(LookupListener lookupListener) {
            this.listeners = AbstractLookup.modifyListenerList(false, lookupListener, this.listeners);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void collectFires(Collection<Object> collection) {
            Object[] objectArray;
            Object[] objectArray2 = this.getItemsCache();
            this.clearCaches();
            if (objectArray2 != null && AbstractLookup.compareArrays(objectArray2, objectArray = this.allItemsWithoutBeforeLookup().toArray())) {
                return;
            }
            Object[] objectArray3 = this;
            synchronized (this) {
                Serializable serializable;
                if (this.listeners == null) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return;
                }
                if (this.listeners instanceof LookupListener) {
                    objectArray = new LookupListener[]{(LookupListener)this.listeners};
                } else {
                    serializable = (ArrayList)this.listeners;
                    objectArray = serializable.toArray(new LookupListener[serializable.size()]);
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                objectArray3 = objectArray;
                serializable = new LookupEvent((Lookup.Result)this);
                AbstractLookup.notifyListeners(objectArray3, (LookupEvent)serializable, collection);
                return;
            }
        }

        @Override
        public Collection<T> allInstances() {
            this.reference.lookup.beforeLookup(this.reference.template);
            Collection<T> collection = this.getInstancesCache();
            if (collection != null) {
                return collection;
            }
            Collection<Pair<T>> collection2 = this.allItemsWithoutBeforeLookup();
            ArrayList arrayList = new ArrayList(collection2.size());
            for (Pair<T> pair : collection2) {
                Object t = pair.getInstance();
                if (!this.reference.template.getType().isInstance(t)) continue;
                arrayList.add(t);
            }
            collection = Collections.unmodifiableList(arrayList);
            this.setInstancesCache(collection);
            return collection;
        }

        @Override
        public Set<Class<? extends T>> allClasses() {
            this.reference.lookup.beforeLookup(this.reference.template);
            Set<Class<T>> set = this.getClassesCache();
            if (set != null) {
                return set;
            }
            set = new HashSet<Class<? extends T>>();
            for (Pair<T> pair : this.allItemsWithoutBeforeLookup()) {
                Class clazz = pair.getType();
                if (clazz == null) continue;
                set.add(clazz);
            }
            set = Collections.unmodifiableSet(set);
            this.setClassesCache(set);
            return set;
        }

        @Override
        public Collection<? extends Lookup.Item<T>> allItems() {
            this.reference.lookup.beforeLookup(this.reference.template);
            return this.allItemsWithoutBeforeLookup();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Collection<Pair<T>> allItemsWithoutBeforeLookup() {
            Pair<T>[] pairArray = this.getItemsCache();
            if (pairArray != null) {
                return Collections.unmodifiableList(Arrays.asList(pairArray));
            }
            ArrayList<Pair<Object>> arrayList = null;
            Storage storage = this.reference.lookup.enterStorage();
            try {
                Collection<Pair<T>> collection = Collections.unmodifiableCollection(this.initItems(storage));
                return collection;
            }
            catch (ISE iSE) {
                arrayList = new ArrayList<Pair<Object>>();
                Enumeration enumeration = storage.lookup(null);
                while (enumeration.hasMoreElements()) {
                    Pair pair = enumeration.nextElement();
                    arrayList.add(pair);
                }
            }
            finally {
                this.reference.lookup.exitStorage();
            }
            return this.extractPairs(arrayList);
        }

        private Collection<Pair<T>> extractPairs(ArrayList<Pair<Object>> arrayList) {
            TreeSet treeSet = new TreeSet(ALPairComparator.DEFAULT);
            for (Pair<Object> pair : arrayList) {
                if (!AbstractLookup.matches(this.reference.template, pair, false)) continue;
                treeSet.add(pair);
            }
            return Collections.unmodifiableCollection(treeSet);
        }

        private Collection<Pair<T>> initItems(Storage<?> storage) {
            Enumeration enumeration = storage.lookup(this.reference.template.getType());
            TreeSet<Pair<T>> treeSet = new TreeSet<Pair<T>>(ALPairComparator.DEFAULT);
            while (enumeration.hasMoreElements()) {
                Pair pair = enumeration.nextElement();
                if (!AbstractLookup.matches(this.reference.template, pair, false)) continue;
                treeSet.add(pair);
            }
            this.setItemsCache(treeSet);
            return treeSet;
        }

        @Override
        protected void beforeLookup(Lookup.Template template) {
            if (template.getType() == this.reference.template.getType()) {
                this.reference.lookup.beforeLookup(template);
            }
        }

        public String toString() {
            return super.toString() + " for " + this.reference.template;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Pair<T>
    extends Lookup.Item<T>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private int index = -1;

        protected Pair() {
        }

        final int getIndex() {
            return this.index;
        }

        final void setIndex(Storage<?> storage, int n) {
            if (storage == null) {
                this.index = n;
                return;
            }
            if (this.index != -1) {
                throw new IllegalStateException("You cannot use " + this + " in more than one AbstractLookup. Prev: " + this.index + " new: " + n);
            }
            this.index = n;
        }

        protected abstract boolean instanceOf(Class<?> var1);

        protected abstract boolean creatorOf(Object var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface Storage<Transaction> {
        public Transaction beginTransaction(int var1);

        public void endTransaction(Transaction var1, Set<R> var2);

        public boolean add(Pair<?> var1, Transaction var2);

        public void remove(Pair var1, Transaction var2);

        public void retainAll(Map var1, Transaction var2);

        public <T> Enumeration<Pair<T>> lookup(Class<T> var1);

        public ReferenceToResult<?> registerReferenceToResult(ReferenceToResult<?> var1);

        public ReferenceToResult<?> cleanUpResult(Lookup.Template<?> var1);
    }
}

