/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.disk;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.modules.cnd.repository.api.Repository;
import org.netbeans.modules.cnd.repository.disk.StorageAllocator;
import org.netbeans.modules.cnd.repository.disk.Unit;
import org.netbeans.modules.cnd.repository.disk.UnitImpl;
import org.netbeans.modules.cnd.repository.queue.KeyValueQueue;
import org.netbeans.modules.cnd.repository.queue.RepositoryQueue;
import org.netbeans.modules.cnd.repository.queue.RepositoryThreadManager;
import org.netbeans.modules.cnd.repository.queue.RepositoryWriter;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.spi.RepositoryListener;
import org.netbeans.modules.cnd.repository.translator.RepositoryTranslatorImpl;
import org.netbeans.modules.cnd.repository.util.RepositoryExceptionImpl;
import org.netbeans.modules.cnd.repository.util.RepositoryListenersManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DiskRepositoryManager
implements Repository,
RepositoryWriter {
    private final Map<String, Unit> units;
    private final RepositoryQueue queue;
    private final RepositoryThreadManager threadManager;
    private final Persistent removedObject;
    private final ReadWriteLock queueLock;
    private Map<String, Object> unitLocks = new HashMap<String, Object>();
    private String mainUnitLock = new String("DelegateRepository main lock");

    public DiskRepositoryManager() {
        this.removedObject = new RemovedPersistent();
        this.queueLock = new ReentrantReadWriteLock(true);
        this.threadManager = new RepositoryThreadManager(this, this.queueLock);
        this.queue = this.threadManager.startup();
        this.units = new ConcurrentHashMap<String, Unit>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getUnitLock(String string) {
        String string2 = this.mainUnitLock;
        synchronized (string2) {
            Object object = this.unitLocks.get(string);
            if (object == null) {
                object = new String(string);
                this.unitLocks.put(string, object);
            }
            return object;
        }
    }

    private Object getUnitLock(Key key) {
        return this.getUnitLock(((Object)key.getUnit()).toString());
    }

    private Unit getCreateUnit(Key key) throws IOException {
        assert (key != null);
        return this.getCreateUnit(((Object)key.getUnit()).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Unit getCreateUnit(String string) throws IOException {
        assert (string != null);
        Unit unit = this.units.get(string);
        if (unit == null) {
            Object object = this.getUnitLock(string);
            synchronized (object) {
                unit = this.units.get(string);
                if (unit == null && RepositoryListenersManager.getInstance().fireUnitOpenedEvent(string)) {
                    RepositoryTranslatorImpl.loadUnitIndex(string);
                    unit = new UnitImpl(string);
                    this.units.put(string, unit);
                }
            }
        }
        return unit;
    }

    public void put(Key key, Persistent persistent) {
        try {
            this.getCreateUnit(key).putToCache(key, persistent);
            this.queue.addLast(key, persistent);
        }
        catch (Throwable throwable) {
            RepositoryListenersManager.getInstance().fireAnException(((Object)key.getUnit()).toString(), new RepositoryExceptionImpl(throwable));
        }
    }

    public void hang(Key key, Persistent persistent) {
        try {
            this.getCreateUnit(key).hang(key, persistent);
        }
        catch (Throwable throwable) {
            RepositoryListenersManager.getInstance().fireAnException(((Object)key.getUnit()).toString(), new RepositoryExceptionImpl(throwable));
        }
    }

    @Override
    public void write(Key key, Persistent persistent) {
        try {
            Unit unit = this.getCreateUnit(key);
            if (persistent instanceof RemovedPersistent) {
                unit.removePhysically(key);
            } else {
                unit.putPhysically(key, persistent);
            }
        }
        catch (Throwable throwable) {
            RepositoryListenersManager.getInstance().fireAnException(((Object)key.getUnit()).toString(), new RepositoryExceptionImpl(throwable));
        }
    }

    public Persistent get(Key key) {
        try {
            return this.getCreateUnit(key).get(key);
        }
        catch (Throwable throwable) {
            RepositoryListenersManager.getInstance().fireAnException(((Object)key.getUnit()).toString(), new RepositoryExceptionImpl(throwable));
            return null;
        }
    }

    public Persistent tryGet(Key key) {
        try {
            return this.getCreateUnit(key).tryGet(key);
        }
        catch (Throwable throwable) {
            RepositoryListenersManager.getInstance().fireAnException(((Object)key.getUnit()).toString(), new RepositoryExceptionImpl(throwable));
            return null;
        }
    }

    public void remove(Key key) {
        try {
            this.getCreateUnit(key).removeFromCache(key);
            this.queue.addLast(key, this.removedObject);
        }
        catch (Throwable throwable) {
            RepositoryListenersManager.getInstance().fireAnException(((Object)key.getUnit()).toString(), new RepositoryExceptionImpl(throwable));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (this.threadManager != null) {
            this.threadManager.shutdown();
        }
        ArrayList<Map.Entry<String, Unit>> arrayList = new ArrayList<Map.Entry<String, Unit>>(this.units.entrySet());
        for (Map.Entry entry : arrayList) {
            this.closeUnit((String)entry.getKey(), false, null);
        }
        try {
            this.queueLock.writeLock().lock();
            this.cleanAndWriteQueue();
            this.units.clear();
        }
        finally {
            this.queueLock.writeLock().unlock();
        }
        RepositoryTranslatorImpl.shutdown();
    }

    @Override
    public boolean maintenance(long l) {
        if (this.units.size() == 0) {
            return false;
        }
        Collection<Unit> collection = this.units.values();
        Unit[] unitArray = collection.toArray(new Unit[collection.size()]);
        Arrays.sort(unitArray, new MaintenanceComparator());
        boolean bl = false;
        long l2 = System.currentTimeMillis();
        for (int i = 0; i < unitArray.length; ++i) {
            if (l <= 0L) {
                bl = true;
                break;
            }
            try {
                if (unitArray[i].maintenance(l)) {
                    bl = true;
                }
            }
            catch (IOException iOException) {
                RepositoryListenersManager.getInstance().fireAnException(unitArray[i].getName(), new RepositoryExceptionImpl(iOException));
            }
            l -= System.currentTimeMillis() - l2;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openUnit(String string) {
        try {
            Object object = this.getUnitLock(string);
            synchronized (object) {
                this.getCreateUnit(string);
            }
        }
        catch (Throwable throwable) {
            RepositoryListenersManager.getInstance().fireAnException(string, new RepositoryExceptionImpl(throwable));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeUnit(String string, boolean bl, Set<String> set) {
        Object object = this.getUnitLock(string);
        synchronized (object) {
            this.closeUnit2(string, bl, set);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeUnit2(String string, boolean bl, Set<String> set) {
        Object object;
        try {
            Object object2;
            this.queueLock.writeLock().lock();
            object = this.queue.clearQueue(new UnitFilter(string));
            if (!bl) {
                object2 = object.iterator();
                while (object2.hasNext()) {
                    KeyValueQueue.Entry entry = (KeyValueQueue.Entry)object2.next();
                    this.write((Key)entry.getKey(), (Persistent)entry.getValue());
                }
            }
            if ((object2 = this.units.remove(string)) != null) {
                try {
                    object2.close();
                }
                catch (Throwable throwable) {
                    RepositoryListenersManager.getInstance().fireAnException(string, new RepositoryExceptionImpl(throwable));
                }
            }
        }
        finally {
            this.queueLock.writeLock().unlock();
        }
        object = StorageAllocator.getInstance();
        if (bl) {
            ((StorageAllocator)object).deleteUnitFiles(string, true);
        }
        ((StorageAllocator)object).closeUnit(string);
        RepositoryTranslatorImpl.closeUnit(string, set);
        RepositoryListenersManager.getInstance().fireUnitClosedEvent(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUnit(String string) {
        Object object = this.getUnitLock(string);
        synchronized (object) {
            this.closeUnit(string, true, Collections.<String>emptySet());
            RepositoryTranslatorImpl.removeUnit(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void debugClear() {
        ArrayList<Map.Entry<String, Unit>> arrayList = new ArrayList<Map.Entry<String, Unit>>(this.units.entrySet());
        for (Map.Entry entry : arrayList) {
            ((Unit)entry.getValue()).debugClear();
        }
        try {
            this.queueLock.writeLock().lock();
            this.cleanAndWriteQueue();
        }
        finally {
            this.queueLock.writeLock().unlock();
        }
    }

    private void cleanAndWriteQueue() {
        Collection<KeyValueQueue.Entry> collection = this.queue.clearQueue(new AllFilter());
        for (KeyValueQueue.Entry entry : collection) {
            this.write((Key)entry.getKey(), (Persistent)entry.getValue());
        }
    }

    public void cleanCaches() {
        StorageAllocator.getInstance().cleanRepositoryCaches();
    }

    public void registerRepositoryListener(RepositoryListener repositoryListener) {
    }

    public void unregisterRepositoryListener(RepositoryListener repositoryListener) {
    }

    public void startup(int n) {
        RepositoryTranslatorImpl.startup(n);
    }

    private static int getMaintenanceWeight(Unit unit) {
        try {
            return unit.getMaintenanceWeight();
        }
        catch (IOException iOException) {
            RepositoryListenersManager.getInstance().fireAnException(unit.getName(), new RepositoryExceptionImpl(iOException));
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MaintenanceComparator
    implements Comparator<Unit>,
    Serializable {
        private static final long serialVersionUID = 7249069246763182397L;

        private MaintenanceComparator() {
        }

        @Override
        public int compare(Unit unit, Unit unit2) {
            return DiskRepositoryManager.getMaintenanceWeight(unit2) - DiskRepositoryManager.getMaintenanceWeight(unit);
        }
    }

    private class AllFilter
    implements RepositoryQueue.Filter {
        private AllFilter() {
        }

        public boolean accept(Key key, Persistent persistent) {
            return true;
        }
    }

    private static class UnitFilter
    implements RepositoryQueue.Filter {
        private String unitName;

        public UnitFilter(String string) {
            this.unitName = string;
        }

        public boolean accept(Key key, Persistent persistent) {
            return key.getUnit().equals(this.unitName);
        }
    }

    private static class RemovedPersistent
    implements Persistent {
        private RemovedPersistent() {
        }
    }
}

