/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.disk;

import java.io.IOException;
import org.netbeans.modules.cnd.repository.disk.FilesAccessStrategy;
import org.netbeans.modules.cnd.repository.disk.FilesAccessStrategyImpl;
import org.netbeans.modules.cnd.repository.disk.Storage;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.util.RepositoryExceptionImpl;
import org.netbeans.modules.cnd.repository.util.RepositoryListenersManager;

public class MultyFileStorage
implements Storage {
    private FilesAccessStrategy theFilesHelper;
    private String unitName;

    public MultyFileStorage(String string) {
        this.theFilesHelper = FilesAccessStrategyImpl.getInstance();
        this.unitName = string;
    }

    public MultyFileStorage(FilesAccessStrategy filesAccessStrategy) {
        this.theFilesHelper = filesAccessStrategy;
    }

    public void write(Key key, Persistent persistent) {
        assert (key != null);
        assert (persistent != null);
        try {
            this.theFilesHelper.write(key, persistent);
        }
        catch (Throwable throwable) {
            RepositoryListenersManager.getInstance().fireAnException(((Object)key.getUnit()).toString(), new RepositoryExceptionImpl(throwable));
        }
    }

    public boolean defragment(long l) {
        return false;
    }

    public Persistent read(Key key) {
        assert (key != null);
        Persistent persistent = null;
        try {
            persistent = this.theFilesHelper.read(key);
        }
        catch (Throwable throwable) {
            RepositoryListenersManager.getInstance().fireAnException(((Object)key.getUnit()).toString(), new RepositoryExceptionImpl(throwable));
        }
        return persistent;
    }

    public void remove(Key key) {
        assert (key != null);
        try {
            this.theFilesHelper.remove(key);
        }
        catch (Throwable throwable) {
            RepositoryListenersManager.getInstance().fireAnException(((Object)key.getUnit()).toString(), new RepositoryExceptionImpl(throwable));
        }
    }

    public void close() throws IOException {
        this.theFilesHelper.closeUnit(this.unitName);
    }

    public int getFragmentationPercentage() {
        return 0;
    }
}

