/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.disk;

import java.util.ArrayList;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.netbeans.modules.cnd.repository.util.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryCacheMap<K, V> {
    private final TreeMap<K, RepositoryCacheValue<V>> keyToValue = new TreeMap();
    private final TreeMap<RepositoryCacheValue<V>, K> valueToKey = new TreeMap();
    private AtomicInteger capacity;
    private static final int DEFAULT_CAPACITY = 20;
    private static AtomicInteger currentBornStamp = new AtomicInteger(0);
    private static final boolean ASSERTIONS = Boolean.getBoolean("cnd.repository.cache.map.assert");

    public RepositoryCacheMap(int n) {
        this.capacity = new AtomicInteger(n > 0 ? n : 20);
    }

    public V get(K k) {
        RepositoryCacheValue<V> repositoryCacheValue = this.keyToValue.get(k);
        if (repositoryCacheValue != null) {
            this.valueToKey.remove(repositoryCacheValue);
            repositoryCacheValue.frequency.incrementAndGet();
            repositoryCacheValue.newBorn.set(false);
            this.valueToKey.put((RepositoryCacheValue<K>)repositoryCacheValue, (RepositoryCacheValue<V>)k);
            return repositoryCacheValue.value;
        }
        return null;
    }

    public V put(K k, V v) {
        RepositoryCacheValue<V> repositoryCacheValue = new RepositoryCacheValue<V>(v);
        try {
            this.softAssert(this.keyToValue.size() >= this.valueToKey.size(), "valueToKeyStorage contains more elements than keyToValueStorage key=" + k);
            this.softAssert(this.keyToValue.size() <= this.valueToKey.size(), "keyToValueStorage contains more elements than valueToKeyStorage");
            if (this.capacity.intValue() != 0 && this.keyToValue.size() >= this.capacity.intValue()) {
                RepositoryCacheValue<V> repositoryCacheValue2 = this.valueToKey.firstKey();
                K k2 = this.valueToKey.get(repositoryCacheValue2);
                this.keyToValue.remove(k2);
                this.valueToKey.remove(repositoryCacheValue2);
                RepositoryCacheValue<V> repositoryCacheValue3 = this.keyToValue.put(k, repositoryCacheValue);
                this.softAssert(repositoryCacheValue3 == null, "Value replacement in RepositoryCacheMap key=" + k);
                this.valueToKey.put((RepositoryCacheValue<K>)repositoryCacheValue, (RepositoryCacheValue<V>)k);
                return repositoryCacheValue2.value;
            }
            RepositoryCacheValue<V> repositoryCacheValue4 = this.keyToValue.put(k, repositoryCacheValue);
            this.softAssert(repositoryCacheValue4 == null, "Value replacement in RepositoryCacheMap key=" + k);
            this.valueToKey.put((RepositoryCacheValue<K>)repositoryCacheValue, (RepositoryCacheValue<V>)k);
        }
        catch (NoSuchElementException noSuchElementException) {
            noSuchElementException.printStackTrace();
        }
        return null;
    }

    public V remove(Object object) {
        RepositoryCacheValue<V> repositoryCacheValue = this.keyToValue.remove(object);
        if (repositoryCacheValue != null) {
            this.valueToKey.remove(repositoryCacheValue);
            return repositoryCacheValue.value;
        }
        return null;
    }

    public Collection<V> remove(Filter<V> filter) {
        ArrayList arrayList = new ArrayList(this.size());
        ArrayList<RepositoryCacheValue<V>> arrayList2 = new ArrayList<RepositoryCacheValue<V>>(20);
        for (RepositoryCacheValue<Object> repositoryCacheValue : this.valueToKey.keySet()) {
            if (!filter.accept(repositoryCacheValue.value)) continue;
            arrayList.add(repositoryCacheValue.value);
            arrayList2.add(repositoryCacheValue);
        }
        for (RepositoryCacheValue<Object> repositoryCacheValue : arrayList2) {
            K k = this.valueToKey.get(repositoryCacheValue);
            this.valueToKey.remove(repositoryCacheValue);
            this.keyToValue.remove(k);
        }
        return arrayList;
    }

    public int size() {
        return this.keyToValue.size();
    }

    public Collection<V> values() {
        ArrayList arrayList = new ArrayList(this.size());
        for (RepositoryCacheValue<V> repositoryCacheValue : this.valueToKey.keySet()) {
            arrayList.add(repositoryCacheValue.value);
        }
        return arrayList;
    }

    public Collection<K> keys() {
        ArrayList<K> arrayList = new ArrayList<K>(this.size());
        for (K k : this.keyToValue.keySet()) {
            arrayList.add(k);
        }
        return arrayList;
    }

    private void softAssert(boolean bl, String string) {
        if (ASSERTIONS && !bl) {
            Exception exception = new Exception();
            StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
            System.err.println(string);
            for (int i = 1; i < stackTraceElementArray.length; ++i) {
                System.err.println("\tat " + stackTraceElementArray[i]);
            }
        }
    }

    static /* synthetic */ AtomicInteger access$000() {
        return currentBornStamp;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RepositoryCacheValue<V>
    implements Comparable {
        public V value;
        public AtomicInteger frequency = new AtomicInteger(1);
        public AtomicBoolean newBorn = new AtomicBoolean(true);
        public final int bornStamp = RepositoryCacheMap.access$000().incrementAndGet();

        RepositoryCacheValue(V v) {
            this.value = v;
        }

        private int compareAdults(RepositoryCacheValue<V> repositoryCacheValue) {
            int n;
            int n2 = this.frequency.intValue();
            if (n2 < (n = repositoryCacheValue.frequency.intValue())) {
                return -1;
            }
            if (n2 == n) {
                n2 = this.bornStamp;
                n = repositoryCacheValue.bornStamp;
                if (n2 < n) {
                    return -1;
                }
                if (n2 > n) {
                    return 1;
                }
                return 0;
            }
            return 1;
        }

        private int compareNewBorns(RepositoryCacheValue<V> repositoryCacheValue) {
            int n = this.bornStamp;
            int n2 = repositoryCacheValue.bornStamp;
            if (n < n2) {
                return -1;
            }
            if (n > n2) {
                return 1;
            }
            return 0;
        }

        public int compareTo(Object object) {
            RepositoryCacheValue repositoryCacheValue = (RepositoryCacheValue)object;
            boolean bl = this.newBorn.get();
            boolean bl2 = repositoryCacheValue.newBorn.get();
            if (bl && bl2) {
                return this.compareNewBorns(repositoryCacheValue);
            }
            if (bl && !bl2) {
                return 1;
            }
            if (!bl && bl2) {
                return -1;
            }
            return this.compareAdults(repositoryCacheValue);
        }
    }
}

