/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.sfs;

import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.netbeans.modules.cnd.repository.sfs.UTF;

public class BufferDataInput
implements DataInput {
    private ByteBuffer buffer;

    public BufferDataInput(ByteBuffer byteBuffer) {
        this.buffer = byteBuffer;
    }

    public byte readByte() throws IOException {
        return this.buffer.get();
    }

    public char readChar() throws IOException {
        return this.buffer.getChar();
    }

    public int readInt() throws IOException {
        return this.buffer.getInt();
    }

    public int readUnsignedShort() throws IOException {
        short s = this.buffer.getShort();
        return s & 0xFFFF;
    }

    public boolean readBoolean() throws IOException {
        return this.buffer.get() != 0;
    }

    public double readDouble() throws IOException {
        return this.buffer.getDouble();
    }

    public float readFloat() throws IOException {
        return this.buffer.getFloat();
    }

    public String readLine() throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        block4: while (this.buffer.hasRemaining()) {
            byte by = this.buffer.get();
            switch (by) {
                case 13: {
                    byte by2;
                    if (!this.buffer.hasRemaining() || (by2 = this.buffer.get()) == 10) break block4;
                    this.buffer.position(this.buffer.position() - 1);
                    break block4;
                }
                case 10: {
                    break block4;
                }
                default: {
                    stringBuilder.append((char)by);
                    continue block4;
                }
            }
        }
        return stringBuilder.toString();
    }

    public long readLong() throws IOException {
        return this.buffer.getLong();
    }

    public short readShort() throws IOException {
        return this.buffer.getShort();
    }

    public String readUTF() throws IOException {
        return UTF.readUTF(this);
    }

    public int readUnsignedByte() throws IOException {
        byte by = this.buffer.get();
        return (short)by & 0xFF;
    }

    public int skipBytes(int n) throws IOException {
        int n2 = Math.min(n, this.buffer.remaining());
        this.buffer.position(this.buffer.position() + n2);
        return n2;
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        this.buffer.get(byArray, n, n2);
    }

    public void readFully(byte[] byArray) throws IOException {
        this.buffer.get(byArray);
    }

    public static class NotImplementedException
    extends Error {
        public NotImplementedException() {
            super("Not implemented");
        }
    }
}

