/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.sfs;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Formatter;
import java.util.Iterator;
import org.netbeans.modules.cnd.repository.sfs.BufferedRWAccess;
import org.netbeans.modules.cnd.repository.sfs.FileRWAccess;
import org.netbeans.modules.cnd.repository.sfs.FileStorage;
import org.netbeans.modules.cnd.repository.sfs.SimpleRWAccess;
import org.netbeans.modules.cnd.repository.sfs.index.ChunkInfo;
import org.netbeans.modules.cnd.repository.sfs.index.CompactFileIndex;
import org.netbeans.modules.cnd.repository.sfs.index.FileIndex;
import org.netbeans.modules.cnd.repository.sfs.index.FileIndexFactory;
import org.netbeans.modules.cnd.repository.sfs.index.SimpleFileIndex;
import org.netbeans.modules.cnd.repository.sfs.statistics.FileStatistics;
import org.netbeans.modules.cnd.repository.sfs.statistics.RangeStatistics;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.testbench.Stats;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IndexedStorageFile
extends FileStorage {
    private final File dataFile;
    private final File indexFile;
    private final FileStatistics fileStatistics;
    private FileIndex index;
    private final FileRWAccess fileRWAccess;
    private long usedSize;
    private Object writeLock = new Object();

    public IndexedStorageFile(File file, String string, boolean bl) throws IOException {
        boolean bl2;
        this.dataFile = new File(file, string + "-data");
        this.indexFile = new File(file, string + "-index");
        this.fileStatistics = new FileStatistics();
        boolean bl3 = this.dataFile.exists() && this.indexFile.exists();
        this.fileRWAccess = this.createFileRWAccess(this.dataFile);
        boolean bl4 = bl2 = bl || !bl3;
        if (!bl2) {
            try {
                this.loadIndex();
                this.recalcUsedSize();
            }
            catch (IOException iOException) {
                bl2 = true;
            }
            this.indexFile.delete();
            if (this.usedSize == 0L) {
                this.fileRWAccess.truncate(0L);
            }
        }
        if (bl2) {
            this.index = Stats.useCompactIndex ? new CompactFileIndex() : new SimpleFileIndex();
            this.fileRWAccess.truncate(0L);
            if (this.indexFile.exists()) {
                this.indexFile.delete();
            }
            this.usedSize = 0L;
        }
    }

    @Override
    public Persistent read(Key key) throws IOException {
        Persistent persistent = null;
        ChunkInfo chunkInfo = this.index.get(key);
        if (chunkInfo != null) {
            persistent = this.fileRWAccess.read(key.getPersistentFactory(), chunkInfo.getOffset(), chunkInfo.getSize());
            this.fileStatistics.incrementReadCount(key);
        }
        return persistent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Key key, Persistent persistent) throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            long l = this.fileRWAccess.size();
            int n = this.fileRWAccess.write(key.getPersistentFactory(), persistent, l);
            int n2 = this.index.put(key, l, n);
            this.usedSize += (long)(n - n2);
            this.fileStatistics.incrementWriteCount(key, n2, n);
        }
    }

    @Override
    public void remove(Key key) throws IOException {
        this.fileStatistics.removeNotify(key);
        int n = this.index.remove(key);
        if (n != 0) {
            if (this.index.size() == 0) {
                this.fileRWAccess.truncate(0L);
                this.usedSize = 0L;
            } else {
                this.usedSize -= (long)(-n);
            }
        }
    }

    @Override
    public int getObjectsCount() {
        return this.index.size();
    }

    @Override
    public long getSize() throws IOException {
        return this.fileRWAccess.size();
    }

    @Override
    public void close() throws IOException {
        if (Stats.dumoFileOnExit) {
            this.dump(System.out);
        } else if (Stats.fileStatisticsLevel > 0) {
            this.dumpSummary(System.out);
        }
        this.fileRWAccess.close();
        this.storeIndex();
    }

    @Override
    public int getFragmentationPercentage() throws IOException {
        long l = this.fileRWAccess.size();
        float f = l - this.usedSize;
        float f2 = f * 100.0f / (float)l;
        return Math.round(f2);
    }

    @Override
    public void dump(PrintStream printStream) throws IOException {
        printStream.printf("\nDumping %s\n", this.dataFile.getAbsolutePath());
        printStream.printf("\nKeys:\n", new Object[0]);
        for (Key key : this.index.keySet()) {
            ChunkInfo chunkInfo = this.index.get(key);
            printStream.printf("\t%s: ", key);
            this.print(printStream, null, chunkInfo, true);
        }
        printStream.printf("\nChunks:\n", new Object[0]);
        ChunkInfo[] chunkInfoArray = this.sortedChunkInfos();
        for (int i = 0; i < chunkInfoArray.length; ++i) {
            this.print(printStream, null, chunkInfoArray[i], true);
        }
        this.dumpSummary(printStream, chunkInfoArray);
    }

    private long recalcUsedSize() {
        long l = 0L;
        for (Key key : this.index.keySet()) {
            ChunkInfo chunkInfo = this.index.get(key);
            l += (long)chunkInfo.getSize();
        }
        this.usedSize = l;
        return l;
    }

    @Override
    public void dumpSummary(PrintStream printStream) throws IOException {
        this.dumpSummary(printStream, null);
    }

    private void dumpSummary(PrintStream printStream, ChunkInfo[] chunkInfoArray) throws IOException {
        RangeStatistics rangeStatistics = new RangeStatistics("Writes:", Stats.fileStatisticsLevel, Stats.fileStatisticsRanges);
        RangeStatistics rangeStatistics2 = new RangeStatistics("Reads: ", Stats.fileStatisticsLevel, Stats.fileStatisticsRanges);
        RangeStatistics rangeStatistics3 = new RangeStatistics("Sizes: ", Stats.fileStatisticsLevel, Stats.fileStatisticsRanges);
        long l = 0L;
        for (Key key : this.index.keySet()) {
            ChunkInfo chunkInfo = this.index.get(key);
            l += (long)chunkInfo.getSize();
            rangeStatistics2.consume(this.fileStatistics.getReadCount(key));
            rangeStatistics.consume(this.fileStatistics.getWriteCount(key));
            rangeStatistics3.consume(chunkInfo.getSize());
        }
        long l2 = this.fileRWAccess.size();
        printStream.printf("\n", new Object[0]);
        printStream.printf("Dumping %s\n", this.dataFile.getAbsolutePath());
        printStream.printf("Entries count: %d\n", this.index.size());
        printStream.printf("\n", new Object[0]);
        rangeStatistics.print(printStream);
        rangeStatistics2.print(printStream);
        rangeStatistics3.print(printStream);
        printStream.printf("\n", new Object[0]);
        printStream.printf("File size:  %16d\n", l2);
        printStream.printf("Used size:  %16d\n", l);
        printStream.printf("Percentage used: %11d%%\n", l2 == 0L ? 0L : 100L * l / l2);
        printStream.printf("Fragmentation:   %11d%%\n", this.getFragmentationPercentage());
        if (chunkInfoArray == null) {
            chunkInfoArray = this.sortedChunkInfos();
        }
        long l3 = chunkInfoArray.length > 0 ? chunkInfoArray[0].getOffset() : 0L;
        printStream.printf("First busy extent: %9d (0x%H)\n\n", l3, l3);
    }

    private void print(PrintStream printStream, Key key, ChunkInfo chunkInfo, boolean bl) {
        long l = chunkInfo.getOffset() + (long)chunkInfo.getSize() - 1L;
        printStream.printf("%d-%d %d [0x%H-0x%H] read: %d written: %d (%s) %c", chunkInfo.getOffset(), l, chunkInfo.getSize(), chunkInfo.getOffset(), l, this.fileStatistics.getReadCount(key), this.fileStatistics.getWriteCount(key), chunkInfo.toString(), Character.valueOf(bl ? (char)'\n' : ' '));
    }

    private ChunkInfo[] sortedChunkInfos() {
        Object[] objectArray = new ChunkInfo[this.index.size()];
        int n = 0;
        for (Key key : this.index.keySet()) {
            objectArray[n++] = this.index.get(key);
        }
        Arrays.sort(objectArray);
        return objectArray;
    }

    String getTraceString() throws IOException {
        Formatter formatter = new Formatter();
        formatter.format("%s index size %d  file size %d  fragmentation %d%%", this.dataFile.getName(), this.index.size(), this.getSize(), this.getFragmentationPercentage());
        return formatter.toString();
    }

    Iterator<Key> getKeySetIterator() {
        return new IndexIterator();
    }

    ChunkInfo getChunkInfo(Key key) {
        return this.index.get(key);
    }

    String getDataFileName() {
        return this.dataFile.getName();
    }

    long getDataFileUsedSize() {
        return this.usedSize;
    }

    void moveDataFromOtherFile(FileRWAccess fileRWAccess, long l, int n, long l2, Key key) throws IOException {
        this.fileRWAccess.move(fileRWAccess, l, n, l2);
        this.index.put(key, l2, n);
        this.usedSize += (long)n;
    }

    FileRWAccess getDataFile() {
        return this.fileRWAccess;
    }

    FileRWAccess createFileRWAccess(File file) throws IOException {
        FileRWAccess fileRWAccess;
        switch (Stats.fileRWAccess) {
            case 0: {
                fileRWAccess = new BufferedRWAccess(file);
                break;
            }
            case 1: {
                fileRWAccess = new SimpleRWAccess(file);
                break;
            }
            default: {
                fileRWAccess = new BufferedRWAccess(file);
            }
        }
        return fileRWAccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadIndex() throws IOException {
        FilterInputStream filterInputStream = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(this.indexFile);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            filterInputStream = new DataInputStream(bufferedInputStream);
            this.index = FileIndexFactory.getDefaultFactory().readIndex((DataInput)((Object)filterInputStream));
        }
        finally {
            if (filterInputStream != null) {
                filterInputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeIndex() throws IOException {
        FilterOutputStream filterOutputStream = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.indexFile);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream, 1024);
            filterOutputStream = new DataOutputStream(bufferedOutputStream);
            FileIndexFactory.getDefaultFactory().writeIndex(this.index, (DataOutput)((Object)filterOutputStream));
        }
        finally {
            if (filterOutputStream != null) {
                filterOutputStream.close();
            }
        }
    }

    @Override
    public boolean defragment(long l) throws IOException {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IndexIterator
    implements Iterator<Key> {
        private Iterator<Key> indexIterator;
        private Key currentKey;

        IndexIterator() {
            this.indexIterator = IndexedStorageFile.this.index.getKeySetIterator();
        }

        @Override
        public boolean hasNext() {
            return this.indexIterator.hasNext();
        }

        @Override
        public Key next() {
            this.currentKey = this.indexIterator.next();
            return this.currentKey;
        }

        @Override
        public void remove() {
            assert (this.currentKey != null);
            ChunkInfo chunkInfo = IndexedStorageFile.this.getChunkInfo(this.currentKey);
            this.indexIterator.remove();
            if (IndexedStorageFile.this.index.size() == 0) {
                try {
                    IndexedStorageFile.this.fileRWAccess.truncate(0L);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                IndexedStorageFile.this.usedSize = 0L;
            } else {
                int n = chunkInfo.getSize();
                IndexedStorageFile.this.usedSize -= n;
            }
        }
    }
}

