/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.util;

import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.modules.cnd.repository.api.RepositoryException;
import org.netbeans.modules.cnd.repository.spi.RepositoryListener;

public class RepositoryListenersManager {
    private static final RepositoryListenersManager instance = new RepositoryListenersManager();
    private RepositoryListener theListener = null;
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();

    private RepositoryListenersManager() {
    }

    public static RepositoryListenersManager getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(RepositoryListener repositoryListener) {
        try {
            this.rwLock.writeLock().lock();
            this.theListener = repositoryListener;
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterListener(RepositoryListener repositoryListener) {
        try {
            this.rwLock.writeLock().lock();
            this.theListener = null;
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fireUnitOpenedEvent(String string) {
        boolean bl = true;
        try {
            this.rwLock.readLock().lock();
            if (this.theListener != null) {
                bl = this.theListener.unitOpened(string);
            }
        }
        finally {
            this.rwLock.readLock().unlock();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireUnitClosedEvent(String string) {
        try {
            this.rwLock.readLock().lock();
            if (this.theListener != null) {
                this.theListener.unitClosed(string);
            }
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireAnException(String string, RepositoryException repositoryException) {
        try {
            this.rwLock.readLock().lock();
            if (this.theListener != null) {
                this.theListener.anExceptionHappened(string, repositoryException);
            } else if (repositoryException.getCause() != null) {
                repositoryException.getCause().printStackTrace(System.err);
            }
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }
}

