/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.faces.dt;

import com.sun.rave.designtime.CheckedDisplayAction;
import com.sun.rave.designtime.DesignBean;
import com.sun.rave.designtime.DesignProperty;
import com.sun.rave.designtime.Result;
import com.sun.rave.designtime.impl.BasicDisplayAction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.component.html.HtmlSelectBooleanCheckbox;
import javax.faces.component.html.HtmlSelectManyCheckbox;
import javax.faces.component.html.HtmlSelectOneRadio;
import org.netbeans.modules.visualweb.faces.dt.component.html.HtmlFormDesignInfo;
import org.netbeans.modules.visualweb.faces.dt.util.ComponentBundle;

public class AutoSubmitOnChangeCheckedAction
extends BasicDisplayAction
implements CheckedDisplayAction {
    private static final ComponentBundle bundle = ComponentBundle.getBundle(AutoSubmitOnChangeCheckedAction.class);
    private static final Pattern thisDotFormDotSubmitPattern = Pattern.compile("this\\s*\\.\\s*form\\s*\\.\\s*submit\\s*\\(\\s*\\)\\s*;?");
    private static final String EE5_TIMEOUT_FUNCTION = "webui.suntheme.common.timeoutSubmitForm";
    private static final String EE4_TIMEOUT_FUNCTION = "common_timeoutSubmitForm";
    private static final String EE4_PAGE = "com.sun.rave.web.ui.component.Page";
    private static final String EE5_PAGE = "com.sun.webui.jsf.component.Page";
    private static final String SUBMIT_PATTERN_SUFFIX = "\\s*\\(\\s*this\\s*\\.\\s*form\\s*,\\s*'\\S+'\\s*\\)\\s*;?";
    private String timeoutFunction;
    private Pattern submitPattern;
    protected DesignBean bean;

    public AutoSubmitOnChangeCheckedAction(DesignBean designBean) {
        super(bundle.getMessage("autoSubmit"));
        this.bean = designBean;
        this.timeoutFunction = EE5_PAGE.equals(this.getPageClassName()) ? EE5_TIMEOUT_FUNCTION : EE4_TIMEOUT_FUNCTION;
        this.submitPattern = Pattern.compile(this.timeoutFunction + SUBMIT_PATTERN_SUFFIX);
    }

    public void setAutoSubmit(boolean bl) {
        this.cleanOnchangeIfAppropriate();
        DesignProperty designProperty = this.getSubmitProperty();
        if (designProperty != null) {
            String string = (String)designProperty.getValue();
            if (string == null) {
                string = "";
            }
            string = thisDotFormDotSubmitPattern.matcher(string).replaceFirst("");
            Matcher matcher = this.submitPattern.matcher(string);
            if (bl) {
                if (!matcher.find()) {
                    designProperty.setValue((Object)this.getSubmitScript(string));
                }
            } else {
                String string2 = matcher.replaceFirst("");
                if (string2.length() < 1) {
                    designProperty.unset();
                } else {
                    designProperty.setValue((Object)string2);
                }
            }
            if (this.getPageClassName() != null) {
                return;
            }
            designProperty = this.bean.getProperty("immediate");
            if (designProperty != null) {
                if (bl) {
                    designProperty.setValue((Object)Boolean.TRUE);
                } else {
                    designProperty.unset();
                }
            }
        }
    }

    public boolean isAutoSubmit() {
        DesignProperty designProperty = this.getSubmitProperty();
        if (designProperty == null) {
            return false;
        }
        String string = (String)designProperty.getValue();
        if (string == null) {
            return false;
        }
        return this.submitPattern.matcher(string).find() || thisDotFormDotSubmitPattern.matcher(string).find();
    }

    public void toggleAutoSubmit() {
        this.cleanOnchangeIfAppropriate();
        DesignProperty designProperty = this.getSubmitProperty();
        if (designProperty != null) {
            boolean bl = this.isAutoSubmit();
            String string = (String)designProperty.getValue();
            if (string == null || string.length() == 0) {
                designProperty.setValue((Object)this.getSubmitScript(null));
            } else {
                string = thisDotFormDotSubmitPattern.matcher(string).replaceFirst("");
                if (bl) {
                    designProperty.setValue((Object)this.submitPattern.matcher(string).replaceFirst(""));
                } else {
                    designProperty.setValue((Object)this.getSubmitScript(string));
                }
            }
            if (this.getPageClassName() != null) {
                return;
            }
            designProperty = this.bean.getProperty("immediate");
            if (designProperty != null) {
                if (bl) {
                    designProperty.unset();
                } else {
                    designProperty.setValue((Object)Boolean.TRUE);
                }
            }
        }
    }

    public boolean isChecked() {
        return this.isAutoSubmit();
    }

    public Result invoke() {
        this.toggleAutoSubmit();
        return Result.SUCCESS;
    }

    DesignProperty getSubmitProperty() {
        return this.bean.getProperty(this.getSubmitPropertyName());
    }

    private String getSubmitPropertyName() {
        Object object = this.bean.getInstance();
        if (object instanceof HtmlSelectBooleanCheckbox || object instanceof HtmlSelectManyCheckbox || object instanceof HtmlSelectOneRadio) {
            return "onclick";
        }
        return "onchange";
    }

    String getSubmitScript(String string) {
        String string2;
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            stringBuffer.append(string);
            if (!Pattern.compile(";\\s*$").matcher(string).find()) {
                stringBuffer.append(';');
            }
            if (!Pattern.compile("\\s+$").matcher(stringBuffer.toString()).find()) {
                stringBuffer.append(' ');
            }
        }
        if ((string2 = HtmlFormDesignInfo.getFullyQualifiedId(this.bean)) == null) {
            string2 = this.bean.getInstanceName();
        } else if (string2.startsWith(String.valueOf(':')) && string2.length() > 1) {
            string2 = string2.substring(1, string2.length());
        }
        stringBuffer.append(this.timeoutFunction);
        stringBuffer.append("(this.form, '");
        stringBuffer.append(string2);
        stringBuffer.append("');");
        return stringBuffer.toString();
    }

    private void cleanOnchangeIfAppropriate() {
        String string;
        DesignProperty designProperty;
        if (this.getPageClassName() == null && "onclick".equals(this.getSubmitPropertyName()) && (designProperty = this.bean.getProperty("onchange")) != null && (string = (String)designProperty.getValue()) != null) {
            string = thisDotFormDotSubmitPattern.matcher(string).replaceFirst("");
            designProperty.setValue((Object)this.submitPattern.matcher(string).replaceFirst(""));
        }
    }

    private String getPageClassName() {
        for (DesignBean designBean = this.bean; designBean != null; designBean = designBean.getBeanParent()) {
            String string;
            Object object = designBean.getInstance();
            if (object == null || !EE4_PAGE.equals(string = object.getClass().getName()) && !EE5_PAGE.equals(string)) continue;
            return string;
        }
        return null;
    }
}

