/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.faces.dt.binding;

import com.sun.rave.designtime.DesignBean;
import com.sun.rave.designtime.DesignContext;
import com.sun.rave.designtime.DesignProperty;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.visualweb.faces.dt.binding.BindingCallback;
import org.netbeans.modules.visualweb.faces.dt.binding.BindingsCustomizer;
import org.netbeans.modules.visualweb.faces.dt.binding.SourcePanel;
import org.netbeans.modules.visualweb.faces.dt.binding.TargetPanel;
import org.netbeans.modules.visualweb.faces.dt.util.ComponentBundle;

public class BindingPanel
extends JPanel
implements BindingCallback {
    private static final ComponentBundle bundle = ComponentBundle.getBundle(BindingPanel.class);
    JTextField curExprTextField = new JTextField();
    JTextField newExprTextField = new JTextField();
    JLabel curExprLabel = new JLabel();
    JLabel newExprLabel = new JLabel();
    JButton clearButton = new JButton();
    JButton applyButton = new JButton();
    JPanel topPanel = new JPanel();
    SourcePanel sourcePanel = new SourcePanel(this);
    TargetPanel targetPanel = new TargetPanel(this);
    JPanel filler1 = new JPanel();
    JPanel filler2 = new JPanel();
    protected boolean showSourcePanel = true;
    protected BindingsCustomizer customizer;
    protected DesignContext context;
    protected DesignBean bean;
    protected DesignProperty prop;

    public BindingPanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setShowSourcePanel(boolean bl) {
        this.showSourcePanel = bl;
        this.refresh();
    }

    public boolean isShowSourcePanel() {
        return this.showSourcePanel;
    }

    public void setCustomizer(BindingsCustomizer bindingsCustomizer) {
        this.customizer = bindingsCustomizer;
    }

    public void setSourceContext(DesignContext designContext) {
        this.context = designContext;
        this.sourcePanel.sourceContextChanged(designContext);
        this.targetPanel.sourceContextChanged(designContext);
        this.refreshCurExprText();
    }

    public DesignContext getSourceContext() {
        return this.context;
    }

    public void setSourceBean(DesignBean designBean) {
        this.bean = designBean;
        if (designBean != null && this.context != designBean.getDesignContext()) {
            this.setSourceContext(designBean.getDesignContext());
        }
        this.sourcePanel.sourceBeanChanged(designBean);
        this.targetPanel.sourceBeanChanged(designBean);
        this.refreshCurExprText();
    }

    public DesignBean getSourceBean() {
        return this.bean;
    }

    public void setSourceProperty(DesignProperty designProperty) {
        this.prop = designProperty;
        if (designProperty != null && this.bean != designProperty.getDesignBean()) {
            this.setSourceBean(designProperty.getDesignBean());
        }
        this.sourcePanel.sourcePropertyChanged(designProperty);
        this.targetPanel.sourcePropertyChanged(designProperty);
        this.refreshCurExprText();
    }

    public DesignProperty getSourceProperty() {
        return this.prop;
    }

    public void refreshCurExprText() {
        String string;
        DesignProperty designProperty = this.getSourceProperty();
        String string2 = designProperty != null ? designProperty.getPropertyDescriptor().getName() : "<font color=\"red\">" + bundle.getMessage("pickOneBrackets") + "</font>";
        DesignBean designBean = this.getSourceBean();
        this.curExprLabel.setText("<html>" + bundle.getMessage("currBindingForProp", string2) + "</html>");
        String string3 = this.newExprTextField.getText();
        this.applyButton.setEnabled(designBean != null && designProperty != null && string3 != null && !"".equals(string3));
        if (designProperty != null && (string = designProperty.getValueSource()) != null && string.startsWith("#{") && string.endsWith("}")) {
            this.curExprTextField.setText(string);
            this.clearButton.setEnabled(true);
            return;
        }
        this.curExprTextField.setText(null);
        this.clearButton.setEnabled(false);
        if (this.customizer != null) {
            this.customizer.firePropertyChange();
        }
    }

    public void refreshApplyState() {
        DesignProperty designProperty = this.getSourceProperty();
        DesignBean designBean = this.getSourceBean();
        String string = this.newExprTextField.getText();
        this.applyButton.setEnabled(designBean != null && designProperty != null && string != null && !"".equals(string));
        if (this.customizer != null) {
            this.customizer.firePropertyChange();
        }
    }

    public boolean isModified() {
        String string = this.curExprTextField.getText();
        String string2 = this.newExprTextField.getText();
        return !(string == null && string2 == null || string != null && string.equals(string2));
    }

    public void setNewExpressionText(String string) {
        this.newExprTextField.setText(string);
        this.refreshCurExprText();
    }

    public void refresh() {
        if (this.showSourcePanel) {
            this.topPanel.add((Component)this.sourcePanel, "West");
        } else {
            this.topPanel.remove(this.sourcePanel);
        }
        this.refreshCurExprText();
        this.validate();
        this.doLayout();
        this.repaint(100L);
    }

    void doClearExpr() {
        DesignProperty designProperty = this.getSourceProperty();
        if (designProperty != null) {
            designProperty.setValueSource(null);
            this.refresh();
        }
    }

    void doApplyExpr() {
        DesignProperty designProperty;
        if (this.applyButton.isEnabled() && (designProperty = this.getSourceProperty()) != null) {
            designProperty.setValueSource(this.newExprTextField.getText());
            this.refresh();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.topPanel.setLayout(new BorderLayout(0, 0));
        this.curExprTextField.setText("");
        this.curExprTextField.setEditable(false);
        this.curExprTextField.setBackground(SystemColor.control);
        this.newExprTextField.setText("");
        this.newExprTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                BindingPanel.this.refreshApplyState();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                BindingPanel.this.refreshApplyState();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                BindingPanel.this.refreshApplyState();
            }
        });
        String string = "<b><font color=\"red\">" + bundle.getMessage("pickOneBrackets") + "</font></b>";
        this.curExprLabel.setText("<html>" + bundle.getMessage("currBindingForProp", string) + "</html>");
        this.newExprLabel.setText(bundle.getMessage("newBindExpr"));
        this.curExprLabel.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 3 && mouseEvent.isMetaDown()) {
                    BindingPanel.this.setShowSourcePanel(!BindingPanel.this.isShowSourcePanel());
                }
            }
        });
        this.clearButton.setText(bundle.getMessage("clear"));
        this.clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BindingPanel.this.doClearExpr();
            }
        });
        this.applyButton.setText(bundle.getMessage("apply"));
        this.applyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BindingPanel.this.doApplyExpr();
            }
        });
        this.filler1.setBackground(SystemColor.controlShadow);
        this.filler1.setOpaque(true);
        this.filler1.setPreferredSize(new Dimension(10, 1));
        this.filler2.setBackground(SystemColor.controlShadow);
        this.filler2.setOpaque(true);
        this.filler2.setPreferredSize(new Dimension(10, 10));
        this.setPreferredSize(new Dimension(600, 400));
        if (this.showSourcePanel) {
            this.topPanel.add((Component)this.sourcePanel, "West");
        }
        this.topPanel.add((Component)this.targetPanel, "Center");
        this.topPanel.add((Component)this.filler1, "South");
        this.add((Component)this.topPanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.curExprLabel, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 2, new Insets(6, 8, 0, 8), 0, 0));
        this.add((Component)this.curExprTextField, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 8, 0, 0), 0, 0));
        this.add((Component)this.clearButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 4, 0, 8), 0, 0));
        this.add((Component)this.newExprLabel, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 2, new Insets(4, 8, 0, 8), 0, 0));
        this.add((Component)this.newExprTextField, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 8, 0, 0), 0, 0));
        this.add((Component)this.applyButton, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 4, 0, 8), 0, 0));
        this.add((Component)this.filler2, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 17, 2, new Insets(8, 0, 0, 0), 0, -9));
    }
}

