/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.MethodDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.form.BeanSupport;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.MethodPicker;
import org.netbeans.modules.form.ParametersPicker;
import org.netbeans.modules.form.PropertyPicker;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADConnectionPropertyEditor;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

class ConnectionCustomEditor
extends JPanel {
    private RADConnectionPropertyEditor propertyEditor;
    private FormModel formModel;
    private Class valueType;
    private List<RADComponent> beanList;
    private RADComponent selectedComponent;
    private PropertyDescriptor selectedProperty;
    private MethodDescriptor selectedMethod;
    private boolean initialized = false;
    private JComboBox beanCombo;
    private JRadioButton beanRadio;
    private ButtonGroup buttonGroup1;
    private JLabel jLabel1;
    private JButton methodDetailsButton;
    private JTextField methodField;
    private JRadioButton methodRadio;
    private JButton propertyDetailsButton;
    private JTextField propertyField;
    private JRadioButton propertyRadio;

    public ConnectionCustomEditor(RADConnectionPropertyEditor rADConnectionPropertyEditor, FormModel formModel, Class clazz) {
        this.propertyEditor = rADConnectionPropertyEditor;
        this.formModel = formModel;
        this.valueType = clazz;
        this.initComponents();
        ConnectionCustomEditor.setupBrowseButton(this.propertyDetailsButton);
        ConnectionCustomEditor.setupBrowseButton(this.methodDetailsButton);
        this.beanList = new ArrayList<RADComponent>();
        for (RADComponent rADComponent : formModel.getAllComponents()) {
            if (!clazz.isAssignableFrom(rADComponent.getBeanClass())) continue;
            this.beanList.add(rADComponent);
        }
        if (this.beanList.size() > 0) {
            Collections.sort(this.beanList, new ParametersPicker.ComponentComparator());
            this.beanCombo.addItem(FormUtils.getBundleString("CTL_CW_SelectBean"));
            for (RADComponent rADComponent : this.beanList) {
                if (rADComponent == formModel.getTopRADComponent()) {
                    this.beanCombo.addItem(FormUtils.getBundleString("CTL_FormTopContainerName"));
                    continue;
                }
                this.beanCombo.addItem(rADComponent.getName());
            }
        } else {
            this.beanRadio.setEnabled(false);
        }
        this.initialized = true;
    }

    private static void setupBrowseButton(JButton jButton) {
        Insets insets = jButton.getMargin();
        if (insets.left > 4) {
            insets.left = 4;
            insets.right = 4;
            jButton.setMargin(insets);
        }
    }

    void setValue(RADConnectionPropertyEditor.RADConnectionDesignValue rADConnectionDesignValue) {
        if (rADConnectionDesignValue == null) {
            this.updateControls();
            return;
        }
        switch (rADConnectionDesignValue.type) {
            case 4: {
                this.beanRadio.setSelected(true);
                this.selectedComponent = rADConnectionDesignValue.getRADComponent();
                int n = this.beanList.indexOf(this.selectedComponent);
                if (n <= -1) break;
                this.beanCombo.setSelectedIndex(n + 1);
                break;
            }
            case 0: {
                this.propertyRadio.setSelected(true);
                this.selectedComponent = rADConnectionDesignValue.getRADComponent();
                this.selectedProperty = rADConnectionDesignValue.getProperty();
                if (this.selectedComponent.getCodeExpression() == null) {
                    this.propertyField.setText(FormUtils.getBundleString("CTL_CONNECTION_INVALID"));
                    break;
                }
                if (this.selectedComponent == this.formModel.getTopRADComponent()) {
                    this.propertyField.setText(this.selectedProperty.getName());
                    break;
                }
                this.propertyField.setText(this.selectedComponent.getName() + "." + this.selectedProperty.getName());
                break;
            }
            case 1: {
                this.methodRadio.setSelected(true);
                this.selectedComponent = rADConnectionDesignValue.getRADComponent();
                this.selectedMethod = rADConnectionDesignValue.getMethod();
                if (this.selectedComponent.getCodeExpression() == null) {
                    this.methodField.setText(FormUtils.getBundleString("CTL_CONNECTION_INVALID"));
                    break;
                }
                if (this.selectedComponent == this.formModel.getTopRADComponent()) {
                    this.methodField.setText(this.selectedMethod.getName());
                    break;
                }
                this.methodField.setText(this.selectedComponent.getName() + "." + this.selectedMethod.getName());
            }
        }
        this.updateControls();
    }

    private void updateControls() {
        this.beanCombo.setEnabled(this.beanRadio.isSelected());
        this.propertyField.setEnabled(this.propertyRadio.isSelected());
        this.propertyDetailsButton.setEnabled(this.propertyRadio.isSelected());
        if (!this.propertyRadio.isSelected()) {
            this.propertyField.setText(FormUtils.getBundleString("CTL_CW_NoProperty"));
        }
        this.methodField.setEnabled(this.methodRadio.isSelected());
        this.methodDetailsButton.setEnabled(this.methodRadio.isSelected());
        if (!this.methodRadio.isSelected()) {
            this.methodField.setText(FormUtils.getBundleString("CTL_CW_NoMethod"));
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.beanRadio = new JRadioButton();
        this.propertyRadio = new JRadioButton();
        this.methodRadio = new JRadioButton();
        this.beanCombo = new JComboBox();
        this.propertyField = new JTextField();
        this.methodField = new JTextField();
        this.propertyDetailsButton = new JButton();
        this.methodDetailsButton = new JButton();
        FormListener formListener = new FormListener();
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(ConnectionCustomEditor.class, (String)"ConnectionCustomEditor.jLabel1.text"));
        this.buttonGroup1.add(this.beanRadio);
        Mnemonics.setLocalizedText((AbstractButton)this.beanRadio, (String)NbBundle.getMessage(ConnectionCustomEditor.class, (String)"ConnectionCustomEditor.beanRadio.text"));
        this.beanRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.beanRadio.setMargin(new Insets(0, 0, 0, 0));
        this.beanRadio.addActionListener(formListener);
        this.buttonGroup1.add(this.propertyRadio);
        Mnemonics.setLocalizedText((AbstractButton)this.propertyRadio, (String)NbBundle.getMessage(ConnectionCustomEditor.class, (String)"ConnectionCustomEditor.propertyRadio.text"));
        this.propertyRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.propertyRadio.setMargin(new Insets(0, 0, 0, 0));
        this.propertyRadio.addActionListener(formListener);
        this.buttonGroup1.add(this.methodRadio);
        Mnemonics.setLocalizedText((AbstractButton)this.methodRadio, (String)NbBundle.getMessage(ConnectionCustomEditor.class, (String)"ConnectionCustomEditor.methodRadio.text"));
        this.methodRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.methodRadio.setMargin(new Insets(0, 0, 0, 0));
        this.methodRadio.addActionListener(formListener);
        this.beanCombo.addActionListener(formListener);
        this.propertyField.setEditable(false);
        this.propertyField.setText(NbBundle.getMessage(ConnectionCustomEditor.class, (String)"CTL_CW_NoProperty"));
        this.methodField.setEditable(false);
        this.methodField.setText(NbBundle.getMessage(ConnectionCustomEditor.class, (String)"CTL_CW_NoMethod"));
        Mnemonics.setLocalizedText((AbstractButton)this.propertyDetailsButton, (String)NbBundle.getMessage(ConnectionCustomEditor.class, (String)"ConnectionCustomEditor.propertyDetailsButton.text"));
        this.propertyDetailsButton.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.methodDetailsButton, (String)NbBundle.getMessage(ConnectionCustomEditor.class, (String)"ConnectionCustomEditor.methodDetailsButton.text"));
        this.methodDetailsButton.addActionListener(formListener);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.beanRadio).add((Component)this.propertyRadio).add((Component)this.methodRadio)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.beanCombo, 0, 270, Short.MAX_VALUE).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.propertyField, -1, 217, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.propertyDetailsButton)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.methodField, -1, 217, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.methodDetailsButton)))).add((Component)this.jLabel1)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.beanRadio).add((Component)this.beanCombo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.propertyRadio).add((Component)this.propertyDetailsButton).add((Component)this.propertyField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.methodRadio).add((Component)this.methodField, -2, -1, -2).add((Component)this.methodDetailsButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.beanRadio.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConnectionCustomEditor.class, (String)"ConnectionCustomEditor.beanRadio.accessibleDescription"));
        this.propertyRadio.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConnectionCustomEditor.class, (String)"ConnectionCustomEditor.propertyRadio.accessibleDescription"));
        this.methodRadio.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConnectionCustomEditor.class, (String)"ConnectionCustomEditor.methodRadio.accessibleDescription"));
        this.beanCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConnectionCustomEditor.class, (String)"ConnectionCustomEditor.beanCombo.accessibleDescription"));
        this.propertyField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConnectionCustomEditor.class, (String)"ConnectionCustomEditor.propertyField.accessibleDescription"));
        this.methodField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConnectionCustomEditor.class, (String)"ConnectionCustomEditor.methodField.accessibleDescription"));
        this.propertyDetailsButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConnectionCustomEditor.class, (String)"ConnectionCustomEditor.propertyDetailsButton.accessibleDescription"));
        this.methodDetailsButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConnectionCustomEditor.class, (String)"ConnectionCustomEditor.methodDetailsButton.accessibleDescription"));
    }

    private void beanComboActionPerformed(ActionEvent actionEvent) {
        if (!this.initialized) {
            return;
        }
        int n = this.beanCombo.getSelectedIndex();
        if (n > 0) {
            this.selectedComponent = this.beanList.get(n - 1);
            this.propertyEditor.setValue(new RADConnectionPropertyEditor.RADConnectionDesignValue(this.selectedComponent));
        } else {
            this.selectedComponent = null;
            this.propertyEditor.setValue(BeanSupport.NO_VALUE);
        }
    }

    private void methodDetailsButtonActionPerformed(ActionEvent actionEvent) {
        MethodPicker methodPicker = new MethodPicker(this.formModel, null, this.valueType);
        methodPicker.setSelectedComponent(this.selectedComponent);
        methodPicker.setSelectedMethod(this.selectedMethod);
        String string = FormUtils.getFormattedBundleString("CTL_FMT_CW_SelectMethod", new Object[]{this.valueType.getSimpleName()});
        final DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)methodPicker, string);
        dialogDescriptor.setValid(methodPicker.isPickerValid());
        methodPicker.addPropertyChangeListener("pickerValid", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                dialogDescriptor.setValid(((Boolean)propertyChangeEvent.getNewValue()).booleanValue());
            }
        });
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            this.selectedComponent = methodPicker.getSelectedComponent();
            MethodPicker.MethodPickerItem methodPickerItem = methodPicker.getSelectedMethod();
            this.selectedMethod = methodPickerItem.getMethodDescriptor();
            this.methodField.setEnabled(true);
            if (this.selectedComponent == this.formModel.getTopRADComponent()) {
                this.methodField.setText(methodPickerItem.getMethodName());
            } else {
                this.methodField.setText(this.selectedComponent.getName() + "." + this.selectedMethod.getName());
            }
            if (this.selectedComponent != null && this.selectedMethod != null) {
                this.propertyEditor.setValue(new RADConnectionPropertyEditor.RADConnectionDesignValue(this.selectedComponent, this.selectedMethod));
            } else if (methodPickerItem.getMethodName() != null) {
                this.propertyEditor.setValue(new RADConnectionPropertyEditor.RADConnectionDesignValue(methodPickerItem.getMethodName()));
            } else {
                this.propertyEditor.setValue(BeanSupport.NO_VALUE);
            }
        }
    }

    private void propertyDetailsButtonActionPerformed(ActionEvent actionEvent) {
        PropertyPicker propertyPicker = new PropertyPicker(this.formModel, null, this.valueType);
        propertyPicker.setSelectedComponent(this.selectedComponent);
        propertyPicker.setSelectedProperty(this.selectedProperty);
        String string = FormUtils.getFormattedBundleString("CTL_FMT_CW_SelectProperty", new Object[]{this.valueType.getSimpleName()});
        final DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)propertyPicker, string);
        dialogDescriptor.setValid(propertyPicker.isPickerValid());
        propertyPicker.addPropertyChangeListener("pickerValid", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                dialogDescriptor.setValid(((Boolean)propertyChangeEvent.getNewValue()).booleanValue());
            }
        });
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            this.selectedComponent = propertyPicker.getSelectedComponent();
            PropertyPicker.PropertyPickerItem propertyPickerItem = propertyPicker.getSelectedProperty();
            this.propertyField.setEnabled(true);
            if (this.selectedComponent == this.formModel.getTopRADComponent()) {
                this.propertyField.setText(propertyPickerItem.getPropertyName());
            } else {
                this.propertyField.setText(this.selectedComponent.getName() + "." + propertyPickerItem.getPropertyName());
            }
            this.selectedProperty = propertyPickerItem.getPropertyDescriptor();
            if (this.selectedProperty == null) {
                this.propertyEditor.setValue(new RADConnectionPropertyEditor.RADConnectionDesignValue(propertyPickerItem.getReadMethodName()));
            } else if (this.selectedComponent != null && this.selectedProperty != null) {
                this.propertyEditor.setValue(new RADConnectionPropertyEditor.RADConnectionDesignValue(this.selectedComponent, this.selectedProperty));
            } else {
                this.propertyEditor.setValue(BeanSupport.NO_VALUE);
            }
        }
    }

    private void methodRadioActionPerformed(ActionEvent actionEvent) {
        if (this.methodRadio.isSelected()) {
            this.methodDetailsButton.requestFocus();
        }
        this.updateControls();
    }

    private void propertyRadioActionPerformed(ActionEvent actionEvent) {
        if (this.propertyRadio.isSelected()) {
            this.propertyDetailsButton.requestFocus();
        }
        this.updateControls();
    }

    private void beanRadioActionPerformed(ActionEvent actionEvent) {
        if (this.beanRadio.isSelected()) {
            this.beanCombo.requestFocus();
        }
        this.updateControls();
    }

    private class FormListener
    implements ActionListener {
        FormListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == ConnectionCustomEditor.this.beanRadio) {
                ConnectionCustomEditor.this.beanRadioActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == ConnectionCustomEditor.this.propertyRadio) {
                ConnectionCustomEditor.this.propertyRadioActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == ConnectionCustomEditor.this.methodRadio) {
                ConnectionCustomEditor.this.methodRadioActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == ConnectionCustomEditor.this.beanCombo) {
                ConnectionCustomEditor.this.beanComboActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == ConnectionCustomEditor.this.propertyDetailsButton) {
                ConnectionCustomEditor.this.propertyDetailsButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == ConnectionCustomEditor.this.methodDetailsButton) {
                ConnectionCustomEditor.this.methodDetailsButtonActionPerformed(actionEvent);
            }
        }
    }
}

