/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.Icon;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.form.ComponentContainer;
import org.netbeans.modules.form.ExternalValue;
import org.netbeans.modules.form.FormDataObject;
import org.netbeans.modules.form.FormDesignValue;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormModelEvent;
import org.netbeans.modules.form.FormModelListener;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormSettings;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.I18nService;
import org.netbeans.modules.form.I18nValue;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADProperty;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.ResourcePanel;
import org.netbeans.modules.form.ResourceService;
import org.netbeans.modules.form.ResourceValue;
import org.netbeans.modules.form.ResourceWrapperEditor;
import org.netbeans.modules.form.editors.EnumEditor;
import org.netbeans.modules.form.editors.IconEditor;
import org.netbeans.modules.form.editors2.BorderDesignSupport;
import org.netbeans.modules.form.editors2.TableColumnModelEditor;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceSupport {
    private FormModel formModel;
    private ResourceService resourceService;
    private I18nService i18nService;
    private String designLocale = "";
    private static Map<DataObject, String> rememberedLocales = new WeakHashMap<DataObject, String>();
    private Map<String, Object> droppedValues;
    private static final String EXCLUDE_FROM_RESOURCING = "does not want to be a resource";
    private static final String EXCLUSION_DETERMINED = "already consulted with exclusion filters";
    private static final String[] PROPERTY_ATTRS = new String[]{"already consulted with exclusion filters", "does not want to be a resource"};
    static final String PROP_AUTO_SET_COMPONENT_NAME = "autoSetComponentName";
    static final String PROP_AUTO_RESOURCING = "autoResourcing";
    static final int AUTO_OFF = 0;
    static final int AUTO_I18N = 1;
    static final int AUTO_RESOURCING = 2;
    static final int AUTO_INJECTION = 3;
    static final String PROP_FORM_BUNDLE = "formBundle";
    private static final String PROP_DESIGN_LOCALE = "designLocale";
    private static final String DEFAULT_BUNDLE_NAME = "Bundle";
    private String defaultI18nBundle;
    private static final int PLAIN_VALUE = 1;
    private static final int UNDEFINED_RESOURCE = 2;
    private static final int VALID_RESOURCE_VALUE = 4;
    static final FormProperty.Filter COPIED_PROPERTY_FILTER = new FormProperty.Filter(){

        public boolean accept(FormProperty formProperty) {
            return formProperty.isChanged() && !ResourceSupport.isAutoNamedProperty(formProperty);
        }
    };

    ResourceSupport(FormModel formModel) {
        this.formModel = formModel;
        formModel.addFormModelListener(new ModelListener());
    }

    void init() {
        String string = rememberedLocales.get(this.getSrcDataObject());
        if (string != null) {
            this.designLocale = string;
            if (!string.equals("") && this.formModel.isFormLoaded()) {
                this.updateDesignLocale();
            }
        }
    }

    private ResourceService getResourceService() {
        if (this.resourceService == null) {
            this.resourceService = (ResourceService)Lookup.getDefault().lookup(ResourceService.class);
        }
        return this.resourceService;
    }

    private I18nService getI18nService() {
        if (this.i18nService == null) {
            this.i18nService = (I18nService)Lookup.getDefault().lookup(I18nService.class);
        }
        return this.i18nService;
    }

    private static ResourceSupport getResourceSupport(FormProperty formProperty) {
        return FormEditor.getResourceSupport(formProperty.getPropertyContext().getFormModel());
    }

    private static ResourceSupport getResourceSupport(RADComponent rADComponent) {
        return FormEditor.getResourceSupport(rADComponent.getFormModel());
    }

    void prepareNewForm() {
        if (this.isResourceAutoMode()) {
            this.resourceService.prepareNew(this.getSourceFile());
        } else if (!this.isI18nAutoMode()) {
            return;
        }
        this.switchFormToResources();
        if (this.isAutoName()) {
            this.setupNameProperty(true);
        }
    }

    public static Object makeResource(Object object, FormProperty formProperty) {
        if (!ResourceSupport.isResourceableProperty(formProperty)) {
            return object;
        }
        ResourceSupport resourceSupport = ResourceSupport.getResourceSupport(formProperty);
        if (ResourceSupport.isResourceType(formProperty.getValueType())) {
            object = resourceSupport.makeResource0(object, formProperty);
        } else {
            for (FormProperty formProperty2 : resourceSupport.getNestedResourceProperties(FormProperty.getEnclosedValue(object), formProperty, 1)) {
                boolean bl = formProperty2.isChangeFiring();
                formProperty2.setChangeFiring(false);
                try {
                    Object object2 = formProperty2.getValue();
                    Object object3 = resourceSupport.makeResource0(object2, formProperty2);
                    if (object3 != object2) {
                        formProperty2.setValue(object3);
                        if (object3 instanceof ResourceValue) {
                            resourceSupport.formModel.raiseVersionLevel(FormModel.FormVersion.NB60, FormModel.FormVersion.NB60);
                        }
                    }
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify(1, (Throwable)exception);
                }
                formProperty2.setChangeFiring(bl);
            }
        }
        return object;
    }

    private Object makeResource0(Object object, FormProperty formProperty) {
        Object object2;
        Object object3 = FormProperty.getEnclosedValue(object);
        if (object3 instanceof ExternalValue) {
            ExternalValue externalValue = (ExternalValue)object3;
            if (externalValue.getKey() == "#auto") {
                if (object3 instanceof I18nValue && this.getI18nService() != null) {
                    String string = this.getDefaultKey0(formProperty, 1);
                    externalValue = this.i18nService.changeKey((I18nValue)object3, string);
                } else if (object3 instanceof ResourceValue && this.getResourceService() != null) {
                    String string = this.getDefaultKey0(formProperty, 2);
                    externalValue = this.resourceService.changeKey((ResourceValue)object3, string);
                }
                return externalValue;
            }
            return object;
        }
        if (object3 == null || !ResourceSupport.isConvertibleToResource(object3) || this.isExcludedProperty0(formProperty)) {
            return object;
        }
        try {
            object2 = formProperty.getValue();
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
            return object;
        }
        if (object2 instanceof I18nValue) {
            if (!this.isEditorSwitchingValue(object) && this.getI18nService() != null) {
                object = this.i18nService.changeValue((I18nValue)object2, object3.toString());
            }
        } else if (object2 instanceof ResourceValue) {
            if (this.getResourceService() != null) {
                object = this.resourceService.changeValue((ResourceValue)object2, object3, ResourceSupport.getStringValue(formProperty, object3));
            }
        } else if (this.isI18nAutoMode()) {
            if (object3 instanceof String) {
                I18nValue i18nValue = this.searchDroppedI18nValue(formProperty, object3.toString());
                if (i18nValue == null) {
                    i18nValue = this.i18nService.create(this.getDefaultKey0(formProperty, 1), object3.toString(), this.getSrcDataObject());
                }
                object = new FormProperty.ValueWithEditor(i18nValue, this.i18nService.getPropertyEditor(formProperty.getValueType(), formProperty.getCurrentEditor()));
            }
        } else if (this.isResourceAutoMode()) {
            PropertyEditor propertyEditor = object instanceof FormProperty.ValueWithEditor ? ((FormProperty.ValueWithEditor)object).getPropertyEditor() : null;
            ResourceValue resourceValue = this.searchDroppedResourceValue(formProperty, object3);
            if (resourceValue == null) {
                resourceValue = this.resourceService.create(this.getDefaultKey0(formProperty, 2), formProperty.getValueType(), object3, ResourceSupport.getStringValue(formProperty, object3), this.getSourceFile());
            }
            object = propertyEditor != null ? new FormProperty.ValueWithEditor(resourceValue, propertyEditor) : resourceValue;
        }
        return object;
    }

    private I18nValue searchDroppedI18nValue(FormProperty formProperty, String string) {
        I18nValue i18nValue;
        String string2;
        Object object;
        if (this.droppedValues != null && (object = this.droppedValues.get(string2 = this.getPropertyPath(formProperty, null))) instanceof I18nValue && (i18nValue = (I18nValue)object).getValue().equals(string)) {
            return i18nValue;
        }
        return null;
    }

    private ResourceValue searchDroppedResourceValue(FormProperty formProperty, Object object) {
        ResourceValue resourceValue;
        String string;
        Object object2;
        if (this.droppedValues != null && (object2 = this.droppedValues.get(string = this.getPropertyPath(formProperty, null))) instanceof ResourceValue && (resourceValue = (ResourceValue)object2).getValue().equals(object)) {
            return resourceValue;
        }
        return null;
    }

    public static void switchComponentToResources(RADComponent rADComponent) {
        ResourceSupport resourceSupport = ResourceSupport.getResourceSupport(rADComponent);
        if (resourceSupport.isAutoMode()) {
            resourceSupport.switchComponentToResources(rADComponent, false, true);
        }
    }

    private void switchComponentToResources(RADComponent rADComponent, boolean bl, boolean bl2) {
        int n = 3;
        for (FormProperty formProperty : this.getComponentResourceProperties(rADComponent, n, bl2)) {
            boolean bl3 = formProperty.isChangeFiring();
            formProperty.setChangeFiring(false);
            try {
                Object object = this.makeResource0(formProperty.getValue(), formProperty);
                formProperty.setValue(object);
                this.formModel.raiseVersionLevel(FormModel.FormVersion.NB60_PRE, FormModel.FormVersion.NB60);
                if (bl) {
                    object = formProperty.getValue();
                    if (object instanceof I18nValue) {
                        this.getI18nService().update(null, (I18nValue)object, this.getSrcDataObject(), this.getI18nBundleName(), this.designLocale, true);
                    } else if (object instanceof ResourceValue) {
                        this.getResourceService().update(null, (ResourceValue)object, this.getSourceFile(), this.designLocale);
                        this.formModel.raiseVersionLevel(FormModel.FormVersion.NB60, FormModel.FormVersion.NB60);
                    }
                }
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(1, (Throwable)exception);
            }
            formProperty.setChangeFiring(bl3);
        }
    }

    private static void setupNameProperty(RADComponent rADComponent, boolean bl, boolean bl2) {
        FormProperty formProperty = ResourceSupport.getNameProperty(rADComponent);
        if (formProperty != null) {
            try {
                if (bl && !formProperty.isChanged()) {
                    formProperty.setValue(rADComponent.getName());
                } else if (!bl && formProperty.isChanged() && rADComponent.getName().equals(formProperty.getValue())) {
                    formProperty.restoreDefaultValue();
                }
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(1, (Throwable)exception);
            }
        }
        if (bl2 && rADComponent instanceof ComponentContainer) {
            for (RADComponent rADComponent2 : ((ComponentContainer)((Object)rADComponent)).getSubBeans()) {
                ResourceSupport.setupNameProperty(rADComponent2, bl, bl2);
            }
        }
    }

    private void setupNameProperty(boolean bl) {
        for (RADComponent rADComponent : this.formModel.getAllComponents()) {
            ResourceSupport.setupNameProperty(rADComponent, bl, false);
        }
    }

    private static FormProperty getNameProperty(RADComponent rADComponent) {
        if (rADComponent.getBeanInstance() instanceof Component) {
            return (FormProperty)rADComponent.getPropertyByName("name");
        }
        return null;
    }

    private void switchFormToResources() {
        for (RADComponent rADComponent : this.formModel.getAllComponents()) {
            this.switchComponentToResources(rADComponent, true, false);
        }
        if (this.droppedValues != null) {
            this.droppedValues.clear();
        }
    }

    private void switchFormToPlainValues(String string) {
        for (RADComponent rADComponent : this.formModel.getAllComponents()) {
            for (FormProperty formProperty : this.getComponentResourceProperties(rADComponent, 4, false)) {
                ExternalValue externalValue = this.getAutoValue(formProperty);
                if (externalValue == null) continue;
                boolean bl = formProperty.isChangeFiring();
                formProperty.setChangeFiring(false);
                try {
                    FormDesignValue formDesignValue;
                    if (externalValue instanceof I18nValue) {
                        formDesignValue = (I18nValue)externalValue;
                        formProperty.setValue(new FormProperty.ValueWithEditor(formDesignValue.getValue(), formProperty.findDefaultEditor()));
                        this.i18nService.update((I18nValue)formDesignValue, null, this.getSrcDataObject(), string != null ? string : this.getI18nBundleName(), null, true);
                    } else if (externalValue instanceof ResourceValue) {
                        Object object;
                        formDesignValue = (ResourceValue)externalValue;
                        PropertyEditor propertyEditor = formProperty.getCurrentEditor();
                        if (propertyEditor instanceof ResourceWrapperEditor) {
                            propertyEditor.setValue(externalValue);
                            object = ((ResourceWrapperEditor)((Object)propertyEditor)).getUnwrappedValue();
                        } else {
                            object = formDesignValue.getValue();
                        }
                        formProperty.setValue(object);
                        this.resourceService.update((ResourceValue)formDesignValue, null, this.getSourceFile(), this.designLocale);
                    }
                    this.addDroppedValue(formProperty, externalValue);
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify(1, (Throwable)exception);
                }
                formProperty.setChangeFiring(bl);
            }
        }
    }

    private void addDroppedValue(FormProperty formProperty, Object object) {
        if (this.droppedValues == null) {
            this.droppedValues = new HashMap<String, Object>();
        }
        this.droppedValues.put(this.getPropertyPath(formProperty, null), object);
    }

    public static void componentRenamed(RADComponent rADComponent, String string, String string2) {
        FormProperty formProperty;
        ResourceSupport resourceSupport = ResourceSupport.getResourceSupport(rADComponent);
        if (resourceSupport.isAutoMode()) {
            resourceSupport.renameDefaultKeysForComponent(rADComponent, null, null, string, string2);
        }
        if ((formProperty = ResourceSupport.getNameProperty(rADComponent)) != null && formProperty.isChanged()) {
            try {
                Object object = formProperty.getValue();
                if (string.equals(object) && !object.equals(string2)) {
                    formProperty.setValue(string2);
                }
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(1, (Throwable)exception);
            }
        }
    }

    public static void formRenamed(FormModel formModel, String string) {
        ResourceSupport resourceSupport = FormEditor.getResourceSupport(formModel);
        if (resourceSupport.getAutoMode() == 1) {
            resourceSupport.renameDefaultKeys(string);
        }
    }

    private void renameDefaultKeys(String string) {
        for (RADComponent rADComponent : this.formModel.getAllComponents()) {
            this.renameDefaultKeysForComponent(rADComponent, string, this.getSrcDataObject().getName(), null, null);
        }
    }

    private void renameDefaultKeysForComponent(RADComponent rADComponent, String string, String string2, String string3, String string4) {
        if (string == null) {
            string2 = string = this.getSrcDataObject().getName();
        } else assert (string2 != null);
        if (string3 == null) {
            string4 = string3 = this.getComponentName(rADComponent);
        } else assert (string4 != null);
        for (FormProperty formProperty : this.getComponentResourceProperties(rADComponent, 4, false)) {
            Object object;
            int n = -1;
            I18nValue i18nValue = null;
            ResourceValue resourceValue = null;
            String string5 = null;
            try {
                object = (ExternalValue)formProperty.getValue();
                string5 = object.getKey();
                if (object instanceof I18nValue) {
                    i18nValue = (I18nValue)object;
                    n = 1;
                } else if (object instanceof ResourceValue) {
                    resourceValue = (ResourceValue)object;
                    n = 2;
                }
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(1, (Throwable)exception);
            }
            if (!ResourceSupport.isAutoKey(string5, (String)(object = this.getDefaultKey(string, this.getPropertyPath(formProperty, string3), n)))) continue;
            String string6 = string5.length() > ((String)object).length() ? string5.substring(((String)object).length()) : "";
            String string7 = this.getDefaultKey(string2, this.getPropertyPath(formProperty, string4), n) + string6;
            if (string7.equals(string5)) continue;
            boolean bl = formProperty.isChangeFiring();
            formProperty.setChangeFiring(false);
            try {
                FormDesignValue formDesignValue;
                FormDesignValue formDesignValue2;
                if (i18nValue != null) {
                    formDesignValue2 = i18nValue;
                    formDesignValue = this.i18nService.changeKey((I18nValue)formDesignValue2, string7);
                    formProperty.setValue(formDesignValue);
                    this.i18nService.update((I18nValue)formDesignValue2, (I18nValue)formDesignValue, this.getSrcDataObject(), this.getI18nBundleName(), this.designLocale, true);
                } else if (resourceValue != null) {
                    formDesignValue2 = resourceValue;
                    formDesignValue = this.resourceService.changeKey((ResourceValue)formDesignValue2, string7);
                    formProperty.setValue(formDesignValue);
                    this.resourceService.update((ResourceValue)formDesignValue2, (ResourceValue)formDesignValue, this.getSourceFile(), this.designLocale);
                }
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(1, (Throwable)exception);
            }
            formProperty.setChangeFiring(bl);
        }
    }

    public static void formMoved(FormModel formModel, FileObject fileObject) {
        ResourceSupport resourceSupport = FormEditor.getResourceSupport(formModel);
        if (resourceSupport.getAutoMode() == 1) {
            resourceSupport.moveFormI18n(fileObject);
        }
    }

    private void moveFormI18n(FileObject fileObject) {
        String string = ResourceSupport.getPkgResourceName(fileObject);
        String string2 = ResourceSupport.getPkgResourceName(this.getSourceFile());
        String string3 = this.getI18nBundleName();
        String string4 = string + string3.substring(string2.length());
        this.switchFormToPlainValues(string4);
        this.switchFormToResources();
    }

    public static void loadInjectedResources(RADComponent rADComponent) {
        ResourceSupport resourceSupport = ResourceSupport.getResourceSupport(rADComponent);
        if (resourceSupport != null && resourceSupport.getAutoMode() == 3) {
            resourceSupport.loadInjectedResources0(rADComponent);
        }
    }

    private void loadInjectedResources0(RADComponent rADComponent) {
        if (this.getResourceService() == null) {
            return;
        }
        String string = this.getComponentName(rADComponent);
        String string2 = string + "\\.\\w+";
        Collection<String> collection = this.resourceService.findKeys(string2, this.getSourceFile());
        if (collection.size() > 0) {
            String[] stringArray = new String[collection.size()];
            int n = string.length() + 1;
            int n2 = 0;
            for (String object : collection) {
                stringArray[n2++] = object.substring(n);
            }
            RADProperty[] rADPropertyArray = rADComponent.getBeanProperties(stringArray);
            n2 = 0;
            for (String string3 : collection) {
                RADProperty rADProperty;
                if ((rADProperty = rADPropertyArray[n2++]) == null || !ResourceSupport.isResourceType(rADProperty.getValueType())) continue;
                try {
                    rADProperty.setValue(this.resourceService.get(string3, rADProperty.getValueType(), this.designLocale, this.getSourceFile()));
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify(1, (Throwable)exception);
                }
            }
        }
    }

    public static void updateStoredValue(Object object, Object object2, FormProperty formProperty) {
        ResourceSupport resourceSupport;
        if (ResourceSupport.isResourceableProperty(formProperty) && (resourceSupport = ResourceSupport.getResourceSupport(formProperty)) != null) {
            resourceSupport.updateStoredValue0(object, object2, formProperty);
        }
    }

    private void updateStoredValue0(Object object, Object object2, FormProperty formProperty) {
        Iterator iterator;
        Object object3;
        Object object4;
        if (formProperty.getName().equals("name") && formProperty instanceof RADProperty && formProperty.getValueType() == String.class) {
            object4 = ((RADProperty)formProperty).getRADComponent();
            object3 = object instanceof String ? (String)object : ((RADComponent)object4).getName();
            Iterator iterator2 = iterator = formProperty.isChanged() && object2 instanceof String ? (String)object2 : ((RADComponent)object4).getName();
            if (!((String)((Object)iterator)).equals(object3)) {
                ResourceSupport.componentRenamed((RADComponent)object4, (String)object3, iterator);
            }
            if (!(object instanceof ExternalValue) && !(object2 instanceof ExternalValue)) {
                return;
            }
        }
        if (ResourceSupport.isResourceType(formProperty.getValueType())) {
            this.updateStoredValue1(object, object2, formProperty);
        } else {
            FormProperty formProperty2;
            object4 = this.getNestedResourceProperties(object, formProperty, 4);
            object3 = this.getNestedResourceProperties(object2, formProperty, 4);
            iterator = object4.iterator();
            while (iterator.hasNext()) {
                formProperty2 = (FormProperty)((Object)iterator.next());
                boolean bl = false;
                Iterator iterator3 = object3.iterator();
                while (iterator3.hasNext()) {
                    FormProperty formProperty3 = (FormProperty)((Object)iterator3.next());
                    if (!this.getPropertyPath(formProperty2, null).equals(this.getPropertyPath(formProperty3, null))) continue;
                    try {
                        this.updateStoredValue1(formProperty2.getValue(), formProperty3.getValue(), formProperty3);
                    }
                    catch (Exception exception) {
                        ErrorManager.getDefault().notify(1, (Throwable)exception);
                    }
                    iterator3.remove();
                    bl = true;
                    break;
                }
                if (bl) continue;
                try {
                    this.updateStoredValue1(formProperty2.getValue(), null, formProperty2);
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify(1, (Throwable)exception);
                }
            }
            iterator = object3.iterator();
            while (iterator.hasNext()) {
                formProperty2 = (FormProperty)((Object)iterator.next());
                try {
                    this.updateStoredValue1(null, formProperty2.getValue(), formProperty2);
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify(1, (Throwable)exception);
                }
            }
        }
    }

    private void updateStoredValue1(Object object, Object object2, FormProperty formProperty) {
        if (object instanceof I18nValue) {
            this.updateI18nValue(object, object2, formProperty);
            if (object2 instanceof ResourceValue) {
                this.updateResourceValue(object, object2, formProperty);
            }
        } else if (object instanceof ResourceValue) {
            this.updateResourceValue(object, object2, formProperty);
            if (object2 instanceof I18nValue) {
                this.updateI18nValue(object, object2, formProperty);
            }
        } else if (object2 instanceof I18nValue) {
            this.updateI18nValue(object, object2, formProperty);
        } else if (object2 instanceof ResourceValue) {
            this.updateResourceValue(object, object2, formProperty);
        }
    }

    private void updateI18nValue(Object object, Object object2, FormProperty formProperty) {
        if (this.getI18nService() != null) {
            I18nValue i18nValue = object instanceof I18nValue ? (I18nValue)object : null;
            I18nValue i18nValue2 = object2 instanceof I18nValue ? (I18nValue)object2 : null;
            try {
                this.i18nService.update(i18nValue, i18nValue2, this.getSrcDataObject(), this.getI18nBundleName(), this.designLocale, ResourceSupport.isAutoValue(i18nValue, this.getDefaultKey0(formProperty, 1)));
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
        }
    }

    private void updateResourceValue(Object object, Object object2, FormProperty formProperty) {
        if (this.getResourceService() != null) {
            ResourceValue resourceValue = object instanceof ResourceValue ? (ResourceValue)object : null;
            ResourceValue resourceValue2 = object2 instanceof ResourceValue ? (ResourceValue)object2 : null;
            try {
                this.resourceService.update(resourceValue, resourceValue2, this.getSourceFile(), this.designLocale);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
        }
    }

    public static ResourceValue findResource(String string, FormProperty formProperty) {
        return ResourceSupport.findResource(formProperty.getPropertyContext().getFormModel(), string, formProperty.getValueType());
    }

    public static ResourceValue findResource(FormModel formModel, String string, Class clazz) {
        return FormEditor.getResourceSupport(formModel).findResource0(string, clazz);
    }

    private ResourceValue findResource0(String string, Class clazz) {
        return this.getResourceService() != null ? this.resourceService.get(string, clazz, this.designLocale, this.getSourceFile()) : null;
    }

    public static boolean isResourceableProperty(FormProperty formProperty) {
        return formProperty.getPropertyContext().useMultipleEditors();
    }

    public static boolean isPropertyForResourcing(FormProperty formProperty) {
        if (!ResourceSupport.isResourceableProperty(formProperty)) {
            return false;
        }
        ResourceSupport resourceSupport = ResourceSupport.getResourceSupport(formProperty);
        return !resourceSupport.isExcludedProperty0(formProperty) && resourceSupport.isResourceAutoMode();
    }

    public static boolean isExcludedProperty(FormProperty formProperty) {
        assert (ResourceSupport.isResourceableProperty(formProperty));
        return Boolean.TRUE.equals(formProperty.getValue(EXCLUDE_FROM_RESOURCING)) ? true : ResourceSupport.getResourceSupport(formProperty).isExcludedProperty1(formProperty);
    }

    private boolean isExcludedProperty0(FormProperty formProperty) {
        return Boolean.TRUE.equals(formProperty.getValue(EXCLUDE_FROM_RESOURCING)) ? true : this.isExcludedProperty1(formProperty);
    }

    private boolean isExcludedProperty1(FormProperty formProperty) {
        if (!Boolean.TRUE.equals(formProperty.getValue(EXCLUSION_DETERMINED))) {
            if (this.getResourceService() == null) {
                return false;
            }
            formProperty.setValue(EXCLUSION_DETERMINED, true);
            Object object = formProperty.getPropertyContext().getOwner();
            Class clazz = null;
            if (object instanceof RADComponent) {
                clazz = ((RADComponent)object).getBeanClass();
            } else if (object instanceof FormProperty) {
                clazz = ((FormProperty)((Object)object)).getValueType();
            }
            boolean bl = clazz != null ? this.resourceService.isExcludedProperty(clazz, formProperty.getName()) : false;
            formProperty.setValue(EXCLUDE_FROM_RESOURCING, bl);
            return bl;
        }
        return false;
    }

    public static void setExcludedProperty(FormProperty formProperty, boolean bl) {
        if (ResourceSupport.isResourceableProperty(formProperty) && bl != ResourceSupport.isExcludedProperty(formProperty)) {
            formProperty.setValue(EXCLUDE_FROM_RESOURCING, bl);
        }
    }

    static String[] getPropertyAttrNames() {
        return PROPERTY_ATTRS;
    }

    public static String getInjectionCode(RADComponent rADComponent, String string) {
        return ResourceSupport.getResourceSupport(rADComponent).getInjectionCode0(rADComponent, string);
    }

    private String getInjectionCode0(RADComponent rADComponent, String string) {
        return this.getAutoMode() == 3 && this.getResourceService() != null ? this.resourceService.getInjectionCode(rADComponent.getBeanInstance(), string, this.getSourceFile()) : null;
    }

    public static boolean isInjectedProperty(FormProperty formProperty) {
        ResourceSupport resourceSupport;
        if (ResourceSupport.isResourceableProperty(formProperty) && (resourceSupport = ResourceSupport.getResourceSupport(formProperty)).getAutoMode() == 3) {
            try {
                String string;
                Object object = formProperty.getValue();
                if (object instanceof ResourceValue && (string = ((ResourceValue)object).getKey()) != null && resourceSupport.getDefaultKey0(formProperty, 3).equals(string)) {
                    return true;
                }
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(1, (Throwable)exception);
            }
        }
        return false;
    }

    public boolean isDefaultInternationalizableProject() {
        if (this.getI18nService() != null) {
            return this.i18nService.isDefaultInternationalizableProject(this.getSourceFile());
        }
        return false;
    }

    public boolean projectUsesResources() {
        if (this.getResourceService() != null) {
            return this.resourceService.projectUsesResources(this.getSourceFile());
        }
        return false;
    }

    public boolean projectWantsUseResources() {
        if (this.getResourceService() != null) {
            return this.resourceService.projectWantsUseResources(this.getSourceFile());
        }
        return false;
    }

    private void bundleChanged(String string) {
        this.switchFormToPlainValues(string);
        String string2 = this.designLocale;
        this.setDesignLocale("");
        FormEditor.getFormEditor(this.formModel).getFormRootNode().firePropertyChangeHelper(PROP_DESIGN_LOCALE, string2, this.designLocale);
        this.switchFormToResources();
    }

    String getDesignLocale() {
        return this.designLocale;
    }

    private void changeDesignLocale(String string) {
        this.setDesignLocale(string);
        this.updateDesignLocale();
        this.formModel.fireEvents(null);
    }

    private void setDesignLocale(String string) {
        this.designLocale = string;
        rememberedLocales.put(this.getSrcDataObject(), string);
    }

    void updateDesignLocale() {
        Collection<FormProperty> collection = this.getAllResourceProperties(4);
        ArrayList<Object> arrayList = new ArrayList<Object>(collection.size());
        for (FormProperty object : collection) {
            try {
                arrayList.add(object.getValue());
            }
            catch (Exception formProperty) {
                ErrorManager.getDefault().notify(1, (Throwable)formProperty);
            }
        }
        Iterator<FormProperty> iterator = arrayList.iterator();
        for (FormProperty formProperty : collection) {
            FormProperty formProperty2 = iterator.next();
            boolean bl = formProperty.isChangeFiring();
            formProperty.setChangeFiring(false);
            try {
                if (formProperty2 instanceof I18nValue) {
                    formProperty.setValue(this.getI18nService().switchLocale((I18nValue)((Object)formProperty2), this.designLocale));
                } else if (formProperty2 instanceof ResourceValue) {
                    formProperty.setValue(this.getResourceService().switchLocale((ResourceValue)((Object)formProperty2), this.designLocale));
                }
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(1, (Throwable)exception);
            }
            formProperty.setChangeFiring(bl);
        }
    }

    public static ResourcePanel createResourcePanel(FormProperty formProperty, boolean bl) {
        if (!ResourceSupport.isResourceableProperty(formProperty)) {
            return null;
        }
        return ResourceSupport.getResourceSupport(formProperty).createResourcePanel0(formProperty, bl);
    }

    private ResourcePanel createResourcePanel0(FormProperty formProperty, boolean bl) {
        if (this.getResourceService() != null && (bl || !this.isI18nAutoMode() && (this.isResourceAutoMode() || this.projectUsesResources()) && !this.isAutoNamedProperty0(formProperty))) {
            return this.resourceService.createResourcePanel(formProperty.getValueType(), this.getSourceFile());
        }
        return null;
    }

    private static boolean isAutoNamedProperty(FormProperty formProperty) {
        return "name".equals(formProperty.getName()) && formProperty instanceof RADProperty && ResourceSupport.getNameProperty(((RADProperty)formProperty).getRADComponent()) == formProperty && ResourceSupport.getResourceSupport(formProperty).isAutoName();
    }

    private boolean isAutoNamedProperty0(FormProperty formProperty) {
        return this.isAutoName() && "name".equals(formProperty.getName()) && formProperty instanceof RADProperty && ResourceSupport.getNameProperty(((RADProperty)formProperty).getRADComponent()) == formProperty;
    }

    public static List<URL> getFilesForContentChangeBackup(FormModel formModel) {
        return FormEditor.getResourceSupport(formModel).getFilesForContentChangeBackup();
    }

    private List<URL> getFilesForContentChangeBackup() {
        if (this.isI18nAutoMode()) {
            return this.getI18nService().getResourceFiles(this.getSourceFile(), this.getI18nBundleName());
        }
        if (this.isResourceAutoMode()) {
            return this.getResourceService().getResourceFiles(this.getSourceFile());
        }
        return Collections.emptyList();
    }

    public static List<URL> getFilesForFormRenameBackup(FormModel formModel) {
        return FormEditor.getResourceSupport(formModel).getI18nFilesForFormRenameBackup();
    }

    private List<URL> getI18nFilesForFormRenameBackup() {
        if (this.isI18nAutoMode()) {
            return this.getI18nService().getResourceFiles(this.getSourceFile(), this.getI18nBundleName());
        }
        return Collections.emptyList();
    }

    public static List<URL> getFilesForFormMoveBackup(FormModel formModel, FileObject fileObject) {
        return FormEditor.getResourceSupport(formModel).getFilesForFormMoveBackup(fileObject);
    }

    private List<URL> getFilesForFormMoveBackup(FileObject fileObject) {
        if (this.isI18nAutoMode()) {
            String string = ResourceSupport.getPkgResourceName(fileObject);
            String string2 = ResourceSupport.getPkgResourceName(this.getSourceFile());
            String string3 = this.getI18nBundleName();
            String string4 = string + string3.substring(string2.length());
            List<URL> list = this.getI18nService().getResourceFiles(this.getSourceFile(), string4);
            List<URL> list2 = this.getI18nService().getResourceFiles(this.getSourceFile(), string3);
            ArrayList<URL> arrayList = new ArrayList<URL>(list.size() + list2.size());
            arrayList.addAll(list);
            arrayList.addAll(list2);
            return arrayList;
        }
        return Collections.emptyList();
    }

    private Collection<FormProperty> getAllResourceProperties(int n) {
        Collection<RADComponent> collection = this.formModel.getAllComponents();
        ArrayList<FormProperty> arrayList = new ArrayList<FormProperty>(collection.size());
        for (RADComponent rADComponent : collection) {
            this.collectResourceProperties(rADComponent, n, false, arrayList);
        }
        return arrayList;
    }

    private Collection<FormProperty> getComponentResourceProperties(RADComponent rADComponent, int n, boolean bl) {
        Collection<FormProperty> collection = this.collectResourceProperties(rADComponent, n, bl, null);
        if (collection == null) {
            collection = Collections.emptyList();
        }
        return collection;
    }

    private Collection<FormProperty> getNestedResourceProperties(Object object, FormProperty formProperty, int n) {
        Collection<FormProperty> collection = this.collectNestedResourceProperties(object, formProperty, n, null);
        if (collection == null) {
            collection = Collections.emptyList();
        }
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    private Collection<FormProperty> collectResourceProperties(RADComponent rADComponent, int n, boolean bl, Collection<FormProperty> collection) {
        Node.Property[] propertyArray;
        for (RADProperty rADProperty : rADComponent.getKnownBeanProperties()) {
            if (!rADProperty.isChanged() || !ResourceSupport.isResourceableProperty(rADProperty) || this.isExcludedProperty0(rADProperty)) continue;
            collection = this.collectNestedResourceProperties(rADProperty, n, collection);
        }
        if (rADComponent instanceof RADVisualComponent && (propertyArray = ((RADVisualComponent)rADComponent).getConstraintsProperties()) != null) {
            void var8_14;
            Node.Property[] propertyArray2 = propertyArray;
            int n2 = propertyArray2.length;
            boolean bl2 = false;
            while (var8_14 < n2) {
                FormProperty formProperty;
                Node.Property property = propertyArray2[var8_14];
                if (property instanceof FormProperty && (formProperty = (FormProperty)property).isChanged() && ResourceSupport.isResourceableProperty(formProperty) && !this.isExcludedProperty0(formProperty)) {
                    collection = this.collectNestedResourceProperties(formProperty, n, collection);
                }
                ++var8_14;
            }
        }
        if (bl && rADComponent instanceof ComponentContainer) {
            for (RADComponent rADComponent2 : ((ComponentContainer)((Object)rADComponent)).getSubBeans()) {
                collection = this.collectResourceProperties(rADComponent2, n, bl, collection);
            }
        }
        return collection;
    }

    private Collection<FormProperty> collectNestedResourceProperties(Object object, FormProperty formProperty, int n, Collection<FormProperty> collection) {
        Node.Property[] propertyArray = ResourceSupport.getNestedProperties(object);
        if (propertyArray == null) {
            if ((n != 1 || ResourceSupport.isResourceType(formProperty.getValueType())) && ResourceSupport.isWanted(n, object)) {
                if (collection == null) {
                    collection = new LinkedList<FormProperty>();
                }
                collection.add(formProperty);
            }
            return collection;
        }
        for (Node.Property property : propertyArray) {
            FormProperty formProperty2;
            if (!(property instanceof FormProperty) || !(formProperty2 = (FormProperty)property).isChanged() || !ResourceSupport.isResourceableProperty(formProperty2) || this.isExcludedProperty0(formProperty2)) continue;
            collection = this.collectNestedResourceProperties(formProperty2, n, collection);
        }
        return collection;
    }

    private Collection<FormProperty> collectNestedResourceProperties(FormProperty formProperty, int n, Collection<FormProperty> collection) {
        try {
            return this.collectNestedResourceProperties(formProperty.getValue(), formProperty, n, collection);
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
            return collection;
        }
    }

    private static Node.Property[] getNestedProperties(Object object) {
        if (object instanceof BorderDesignSupport) {
            return ((BorderDesignSupport)object).getProperties();
        }
        if (object instanceof TableColumnModelEditor.FormTableColumnModel) {
            TableColumnModelEditor.FormTableColumnModel formTableColumnModel = (TableColumnModelEditor.FormTableColumnModel)object;
            ArrayList<FormProperty> arrayList = new ArrayList<FormProperty>(formTableColumnModel.getColumns().size());
            for (TableColumnModelEditor.FormTableColumn formTableColumn : formTableColumnModel.getColumns()) {
                arrayList.add(formTableColumn.getTitle());
            }
            return arrayList.toArray(new Node.Property[arrayList.size()]);
        }
        return null;
    }

    private static boolean isWanted(int n, Object object) {
        String string;
        if (object instanceof ExternalValue) {
            string = ((ExternalValue)object).getKey();
            if (string == null) {
                string = "";
            }
        } else {
            string = null;
        }
        if (string == null) {
            return (n & 1) != 0 && !(object instanceof FormDesignValue);
        }
        if ((n & 2) != 0 && string.equals("#auto")) {
            return true;
        }
        return (n & 4) != 0 && !string.startsWith("#");
    }

    private String getComponentName(RADComponent rADComponent) {
        String string = null;
        boolean bl = false;
        if (this.isResourceAutoMode()) {
            FormProperty formProperty = ResourceSupport.getNameProperty(rADComponent);
            if (formProperty != null && formProperty.isChanged()) {
                try {
                    string = (String)formProperty.getValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            bl = true;
        }
        if (!(rADComponent == this.formModel.getTopRADComponent() && !bl || string != null && string.trim().length() != 0)) {
            string = rADComponent.getName();
        }
        return string;
    }

    private String getPropertyPath(FormProperty formProperty, String string) {
        Object object;
        ListIterator listIterator;
        String string2 = formProperty.getName();
        ArrayList arrayList = new ArrayList();
        do {
            if ((listIterator = (object = formProperty.getPropertyContext()).getOwner()) instanceof FormProperty) {
                arrayList.add(listIterator);
                formProperty = (FormProperty)((Object)listIterator);
                continue;
            }
            if (listIterator instanceof RADComponent) {
                arrayList.add(listIterator);
            }
            formProperty = null;
        } while (formProperty != null);
        object = new StringBuilder();
        listIterator = arrayList.listIterator(arrayList.size());
        while (listIterator.hasPrevious()) {
            Object e = listIterator.previous();
            String string3 = e instanceof RADComponent ? (string != null ? string : this.getComponentName((RADComponent)e)) : ((FormProperty)((Object)e)).getName();
            if (string3 == null) continue;
            if (((StringBuilder)object).length() > 0) {
                ((StringBuilder)object).append(".");
            }
            ((StringBuilder)object).append(string3);
        }
        if (((StringBuilder)object).length() > 0) {
            ((StringBuilder)object).append(".");
        }
        ((StringBuilder)object).append(string2);
        return ((StringBuilder)object).toString();
    }

    private String getDefaultKey0(FormProperty formProperty, int n) {
        return this.getDefaultKey(this.getSrcDataObject().getName(), this.getPropertyPath(formProperty, null), n);
    }

    static String getDefaultKey(FormProperty formProperty, int n) {
        return ResourceSupport.getResourceSupport(formProperty).getDefaultKey0(formProperty, n);
    }

    private String getDefaultKey(String string, String string2, int n) {
        if (n != 1) {
            string = null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (string != null) {
            stringBuilder.append(string).append(".");
        }
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    private String getDefaultKey(FormProperty formProperty, ExternalValue externalValue) {
        if (externalValue instanceof I18nValue) {
            return this.getDefaultKey0(formProperty, 1);
        }
        if (externalValue instanceof ResourceValue) {
            return this.getDefaultKey0(formProperty, 2);
        }
        return null;
    }

    private FileObject getSourceFile() {
        FormDataObject formDataObject = FormEditor.getFormDataObject(this.formModel);
        return formDataObject != null ? formDataObject.getPrimaryFile() : null;
    }

    private DataObject getSrcDataObject() {
        return FormEditor.getFormDataObject(this.formModel);
    }

    private int getAutoMode() {
        return this.formModel.getSettings().getResourceAutoMode();
    }

    private boolean isAutoMode() {
        return this.getAutoMode() != 0;
    }

    private boolean isResourceAutoMode() {
        int n = this.formModel.getSettings().getResourceAutoMode();
        return this.getResourceService() != null && (n == 2 || n == 3);
    }

    private boolean isI18nAutoMode() {
        return this.getI18nService() != null && this.formModel.getSettings().getResourceAutoMode() == 1;
    }

    private boolean isAutoName() {
        return this.formModel.getSettings().getAutoSetComponentName();
    }

    private String getI18nBundleName() {
        String string = this.formModel.getSettings().getFormBundle();
        if (string == null) {
            if (this.defaultI18nBundle == null) {
                FileObject fileObject = this.getSourceFile();
                this.defaultI18nBundle = ResourceSupport.composeBundleName(ResourceSupport.getPkgResourceName(this.getSourceFile()), DEFAULT_BUNDLE_NAME);
            }
            string = this.defaultI18nBundle;
        }
        return string;
    }

    private static String getPkgResourceName(FileObject fileObject) {
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
        if (classPath != null) {
            return classPath.getResourceName(fileObject.isFolder() ? fileObject : fileObject.getParent());
        }
        return null;
    }

    private static String composeBundleName(String string, String string2) {
        return string != null && string.length() > 0 ? string + "/" + string2 : string2;
    }

    private static boolean isResourceType(Class clazz) {
        return clazz == String.class || Font.class.isAssignableFrom(clazz) || Icon.class.isAssignableFrom(clazz) || Color.class.isAssignableFrom(clazz);
    }

    private static boolean isConvertibleToResource(Object object) {
        return object instanceof String || object instanceof Font || object instanceof IconEditor.NbImageIcon || object instanceof Color;
    }

    private boolean isEditorSwitchingValue(Object object) {
        FormProperty.ValueWithEditor valueWithEditor;
        return object instanceof FormProperty.ValueWithEditor && (valueWithEditor = (FormProperty.ValueWithEditor)object).getEditorSetByUser();
    }

    private ExternalValue getAutoValue(FormProperty formProperty) {
        ExternalValue externalValue;
        Object object;
        try {
            object = formProperty.getValue();
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
            return null;
        }
        if (object instanceof ExternalValue && ResourceSupport.isAutoValue(externalValue = (ExternalValue)object, this.getDefaultKey(formProperty, externalValue))) {
            return externalValue;
        }
        return null;
    }

    private static boolean isAutoValue(ExternalValue externalValue, String string) {
        String string2 = externalValue != null ? externalValue.getKey() : null;
        return string2 != null ? ResourceSupport.isAutoKey(string2, string) : false;
    }

    private static boolean isAutoKey(String string, String string2) {
        return string != null && string.startsWith(string2);
    }

    private static String getStringValue(FormProperty formProperty, Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        PropertyEditor propertyEditor = formProperty.getCurrentEditor();
        propertyEditor.setValue(object);
        return propertyEditor.getAsText();
    }

    Node.Property[] createFormProperties() {
        Node.Property[] propertyArray;
        PropertySupport.ReadWrite<Boolean> readWrite = new PropertySupport.ReadWrite<Boolean>(PROP_AUTO_SET_COMPONENT_NAME, Boolean.TYPE, FormUtils.getBundleString("PROP_AUTO_SET_COMPONENT_NAME"), FormUtils.getBundleString("HINT_AUTO_SET_COMPONENT_NAME")){

            public void setValue(Boolean bl) {
                Boolean bl2 = this.getValue();
                if (!bl2.equals(bl)) {
                    boolean bl3 = bl;
                    ResourceSupport.this.formModel.getSettings().setAutoSetComponentName(bl3);
                    ResourceSupport.this.setupNameProperty(bl3);
                    ResourceSupport.this.formModel.fireSyntheticPropertyChanged(null, ResourceSupport.PROP_AUTO_SET_COMPONENT_NAME, bl2, bl);
                    FormEditor.getFormEditor(ResourceSupport.this.formModel).getFormRootNode().firePropertyChangeHelper(ResourceSupport.PROP_AUTO_SET_COMPONENT_NAME, bl2, bl);
                }
            }

            public Boolean getValue() {
                return ResourceSupport.this.formModel.getSettings().getAutoSetComponentName();
            }
        };
        int n = this.getAutoMode();
        Object object = this.projectUsesResources() || n == 2 || n == 3 ? new PropertySupport.ReadWrite<Integer>(PROP_AUTO_RESOURCING, Integer.TYPE, FormUtils.getBundleString("PROP_AUTO_RESOURCE"), FormUtils.getBundleString("HINT_AUTO_RESOURCE_LOCAL")){

            public void setValue(Integer n) {
                boolean bl;
                int n2 = ResourceSupport.this.getAutoMode();
                if (n == null || n.equals(n2)) {
                    return;
                }
                int n3 = n;
                FormSettings formSettings = ResourceSupport.this.formModel.getSettings();
                boolean bl2 = bl = n2 == 1 && (n3 == 2 || n3 == 3) || n3 == 1 && (n2 == 2 || n2 == 3);
                if (n3 == 0 || bl) {
                    ResourceSupport.this.switchFormToPlainValues(null);
                }
                formSettings.setResourceAutoMode(n3);
                if (n2 == 0 || bl) {
                    ResourceSupport.this.switchFormToResources();
                }
                if (n3 == 3 && !ResourceSupport.this.isAutoName()) {
                    ResourceSupport.this.formModel.getSettings().setAutoSetComponentName(true);
                    ResourceSupport.this.setupNameProperty(true);
                    FormEditor.getFormEditor(ResourceSupport.this.formModel).getFormRootNode().firePropertyChangeHelper(ResourceSupport.PROP_AUTO_SET_COMPONENT_NAME, n2, n3);
                }
                ResourceSupport.this.formModel.fireSyntheticPropertyChanged(null, ResourceSupport.PROP_AUTO_RESOURCING, n2, n3);
                FormEditor.getFormEditor(ResourceSupport.this.formModel).getFormRootNode().firePropertyChangeHelper(ResourceSupport.PROP_AUTO_RESOURCING, n2, n3);
            }

            public Integer getValue() {
                return ResourceSupport.this.getAutoMode();
            }

            public PropertyEditor getPropertyEditor() {
                return new EnumEditor(new Object[]{FormUtils.getBundleString("CTL_AUTO_OFF"), 0, "", FormUtils.getBundleString("CTL_AUTO_I18N"), 1, "", FormUtils.getBundleString("CTL_AUTO_RESOURCING"), 2, "", FormUtils.getBundleString("CTL_AUTO_INJECTION"), 3, ""});
            }
        } : new PropertySupport.ReadWrite<Boolean>(PROP_AUTO_RESOURCING, Boolean.TYPE, FormUtils.getBundleString("PROP_AUTO_I18N"), FormUtils.getBundleString("HINT_AUTO_I18N")){

            public void setValue(Boolean bl) {
                boolean bl2 = ResourceSupport.this.getAutoMode() == 1;
                Boolean bl3 = bl2;
                if (!bl3.equals(bl)) {
                    boolean bl4 = bl;
                    FormSettings formSettings = ResourceSupport.this.formModel.getSettings();
                    if (bl4) {
                        formSettings.setResourceAutoMode(1);
                        ResourceSupport.this.switchFormToResources();
                    } else {
                        ResourceSupport.this.switchFormToPlainValues(null);
                        formSettings.setResourceAutoMode(0);
                    }
                    ResourceSupport.this.formModel.fireSyntheticPropertyChanged(null, ResourceSupport.PROP_AUTO_RESOURCING, bl3, bl);
                    FormEditor.getFormEditor(ResourceSupport.this.formModel).getFormRootNode().firePropertyChangeHelper(ResourceSupport.PROP_AUTO_RESOURCING, bl3, bl);
                }
            }

            public Boolean getValue() {
                return ResourceSupport.this.getAutoMode() == 1;
            }
        };
        PropertySupport.ReadWrite<String> readWrite2 = new PropertySupport.ReadWrite<String>(PROP_FORM_BUNDLE, String.class, FormUtils.getBundleString("PROP_FORM_BUNDLE"), FormUtils.getBundleString("HINT_FORM_BUNDLE")){

            public void setValue(String string) {
                String string2 = ResourceSupport.this.getI18nBundleName();
                if (string2 == null && string != null || !string2.equals(string)) {
                    String string3 = string;
                    if (string3 != null && string3.toLowerCase().endsWith(".properties")) {
                        string3 = string3.substring(0, string3.length() - ".properties".length());
                    }
                    ResourceSupport.this.formModel.getSettings().setFormBundle(string3);
                    ResourceSupport.this.bundleChanged(string2);
                    ResourceSupport.this.formModel.fireSyntheticPropertyChanged(null, ResourceSupport.PROP_FORM_BUNDLE, string2, string);
                    FormEditor.getFormEditor(ResourceSupport.this.formModel).getFormRootNode().firePropertyChangeHelper(ResourceSupport.PROP_FORM_BUNDLE, string2, string);
                }
            }

            public String getValue() {
                return ResourceSupport.this.getI18nBundleName();
            }

            public PropertyEditor getPropertyEditor() {
                return new BundleFilePropertyEditor();
            }
        };
        PropertySupport.ReadWrite<String> readWrite3 = new PropertySupport.ReadWrite<String>(PROP_DESIGN_LOCALE, String.class, FormUtils.getBundleString("PROP_DESIGN_LOCALE"), FormUtils.getBundleString("HINT_DESIGN_LOCALE")){

            public void setValue(String string) {
                String string2 = ResourceSupport.this.designLocale;
                ResourceSupport.this.changeDesignLocale(string);
                ResourceSupport.this.formModel.fireSyntheticPropertyChanged(null, ResourceSupport.PROP_DESIGN_LOCALE, string2, string);
                FormEditor.getFormEditor(ResourceSupport.this.formModel).getFormRootNode().firePropertyChangeHelper(ResourceSupport.PROP_DESIGN_LOCALE, string2, string);
            }

            public String getValue() {
                return ResourceSupport.this.designLocale;
            }

            public PropertyEditor getPropertyEditor() {
                return new LocalePropertyEditor();
            }
        };
        int n2 = this.getAutoMode();
        if (n2 == 0 || n2 == 1) {
            Node.Property[] propertyArray2 = new Node.Property[4];
            propertyArray2[0] = readWrite;
            propertyArray2[1] = object;
            propertyArray2[2] = readWrite2;
            propertyArray = propertyArray2;
            propertyArray2[3] = readWrite3;
        } else {
            Node.Property[] propertyArray3 = new Node.Property[3];
            propertyArray3[0] = readWrite;
            propertyArray3[1] = object;
            propertyArray = propertyArray3;
            propertyArray3[2] = readWrite3;
        }
        return propertyArray;
    }

    private class LocalePropertyEditor
    extends PropertyEditorSupport {
        private String[][] tags;

        private LocalePropertyEditor() {
        }

        public String[] getTags() {
            FileObject fileObject;
            if (this.tags == null && (fileObject = ResourceSupport.this.getSourceFile()) != null) {
                if (ResourceSupport.this.isI18nAutoMode()) {
                    this.tags = ResourceSupport.this.i18nService.getAvailableLocales(fileObject, ResourceSupport.this.getI18nBundleName());
                } else if (ResourceSupport.this.isResourceAutoMode()) {
                    this.tags = ResourceSupport.this.resourceService.getAvailableLocales(fileObject);
                }
            }
            return this.tags != null ? this.tags[1] : null;
        }

        public void setAsText(String string) {
            this.getTags();
            if (this.tags != null) {
                int n = this.tags[0].length;
                for (int i = 0; i < n; ++i) {
                    if (!this.tags[1][i].equals(string)) continue;
                    this.setValue(this.tags[0][i]);
                    return;
                }
            }
            this.setValue(string);
        }

        public String getAsText() {
            Object object = this.getValue();
            this.getTags();
            if (this.tags != null) {
                int n = this.tags[0].length;
                for (int i = 0; i < n; ++i) {
                    if (!this.tags[0][i].equals(object)) continue;
                    return this.tags[1][i];
                }
            }
            return object != null ? object.toString() : null;
        }

        public boolean supportsCustomEditor() {
            return this.getTags() != null;
        }

        public Component getCustomEditor() {
            if (ResourceSupport.this.isI18nAutoMode()) {
                return ResourceSupport.this.i18nService.getCreateLocaleComponent(this, ResourceSupport.this.getSourceFile(), ResourceSupport.this.getI18nBundleName());
            }
            if (ResourceSupport.this.isResourceAutoMode()) {
                return ResourceSupport.this.resourceService.getCreateLocaleComponent(this, ResourceSupport.this.getSourceFile());
            }
            return null;
        }
    }

    private class BundleFilePropertyEditor
    extends PropertyEditorSupport {
        private BundleFilePropertyEditor() {
        }

        public boolean supportsCustomEditor() {
            return ResourceSupport.this.getI18nService() != null;
        }

        public Component getCustomEditor() {
            return ResourceSupport.this.getI18nService() != null ? ResourceSupport.this.i18nService.getBundleSelectionComponent(this, ResourceSupport.this.getSourceFile()) : null;
        }
    }

    private class ModelListener
    implements FormModelListener {
        private ModelListener() {
        }

        public void formChanged(FormModelEvent[] formModelEventArray) {
            if (formModelEventArray == null) {
                return;
            }
            ResourceSupport.this.getI18nService();
            ResourceSupport.this.getResourceService();
            if (ResourceSupport.this.i18nService == null && ResourceSupport.this.resourceService == null) {
                return;
            }
            block10: for (int i = 0; i < formModelEventArray.length; ++i) {
                FormModelEvent formModelEvent = formModelEventArray[i];
                switch (formModelEvent.getChangeType()) {
                    case 8: {
                        Object object;
                        if (!formModelEvent.getCreatedDeleted()) continue block10;
                        for (Object object2 : ResourceSupport.this.getComponentResourceProperties(formModelEvent.getComponent(), 4, true)) {
                            object = ResourceSupport.this.getAutoValue(object2);
                            if (object == null) continue;
                            try {
                                if (object instanceof I18nValue && ResourceSupport.this.i18nService != null) {
                                    ResourceSupport.this.i18nService.update((I18nValue)object, null, ResourceSupport.this.getSrcDataObject(), ResourceSupport.this.getI18nBundleName(), null, true);
                                    continue;
                                }
                                if (!(object instanceof ResourceValue) || ResourceSupport.this.resourceService == null) continue;
                                ResourceSupport.this.resourceService.update((ResourceValue)object, null, ResourceSupport.this.getSourceFile(), null);
                            }
                            catch (IOException iOException) {
                                ErrorManager.getDefault().notify(1, (Throwable)iOException);
                            }
                        }
                        continue block10;
                    }
                    case 7: {
                        Object object;
                        Object object2;
                        if (!formModelEvent.getCreatedDeleted()) continue block10;
                        RADComponent rADComponent = formModelEvent.getComponent();
                        object2 = ResourceSupport.this.getComponentResourceProperties(rADComponent, 4, true).iterator();
                        while (object2.hasNext()) {
                            object = (FormProperty)((Object)object2.next());
                            try {
                                Object object3 = object.getValue();
                                if (object3 instanceof I18nValue && ResourceSupport.this.i18nService != null) {
                                    ResourceSupport.this.i18nService.update(null, (I18nValue)object3, ResourceSupport.this.getSrcDataObject(), ResourceSupport.this.getI18nBundleName(), ResourceSupport.this.designLocale, false);
                                    continue;
                                }
                                if (!(object3 instanceof ResourceValue) || ResourceSupport.this.resourceService == null) continue;
                                ResourceSupport.this.resourceService.update(null, (ResourceValue)object3, ResourceSupport.this.getSourceFile(), ResourceSupport.this.designLocale);
                            }
                            catch (Exception exception) {
                                ErrorManager.getDefault().notify(1, (Throwable)exception);
                            }
                        }
                        if (!ResourceSupport.this.isAutoName() || rADComponent == ResourceSupport.this.formModel.getTopRADComponent() || !ResourceSupport.this.formModel.isUndoRedoRecording()) continue block10;
                        ResourceSupport.setupNameProperty(rADComponent, true, true);
                        continue block10;
                    }
                    case 2: {
                        if (ResourceSupport.this.i18nService != null) {
                            ResourceSupport.this.i18nService.autoSave(ResourceSupport.this.getSrcDataObject());
                        }
                        if (ResourceSupport.this.resourceService == null) continue block10;
                        ResourceSupport.this.resourceService.autoSave(ResourceSupport.this.getSourceFile());
                        continue block10;
                    }
                    case 3: {
                        if (ResourceSupport.this.i18nService != null) {
                            ResourceSupport.this.i18nService.close(ResourceSupport.this.getSrcDataObject());
                        }
                        if (ResourceSupport.this.resourceService == null) continue block10;
                        ResourceSupport.this.resourceService.close(ResourceSupport.this.getSourceFile());
                    }
                }
            }
        }
    }
}

