/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.beans.FeatureDescriptor;
import java.beans.PropertyEditorSupport;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.form.FormAwareEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormUtils;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class StringEditor
extends PropertyEditorSupport
implements FormAwareEditor,
ExPropertyEditor,
DocumentListener,
Runnable {
    private boolean editable = true;
    private Component customEditor;
    private JTextComponent textComp;
    private boolean htmlText;
    private boolean valueUpdateInvoked;

    public void setValue(Object object) {
        super.setValue(object);
        if (!this.valueUpdateInvoked && this.textComp != null && this.textComp.isShowing()) {
            this.setValueToCustomEditor();
        }
    }

    public void setAsText(String string) {
        this.setValue(string);
    }

    public String getJavaInitializationString() {
        String string = (String)this.getValue();
        return "\"" + FormUtils.escapeCharactersInString(string) + "\"";
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        if (this.customEditor == null) {
            JTextArea jTextArea = new JTextArea();
            jTextArea.setWrapStyleWord(true);
            jTextArea.setLineWrap(true);
            jTextArea.setColumns(60);
            jTextArea.setRows(8);
            jTextArea.getDocument().addDocumentListener(this);
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.setViewportView(jTextArea);
            JLabel jLabel = new JLabel(NbBundle.getMessage(StringEditor.class, (String)"StringEditor.htmlTipLabel.text"));
            JPanel jPanel = new JPanel();
            GroupLayout groupLayout = new GroupLayout((Container)jPanel);
            groupLayout.setAutocreateGaps(true);
            jPanel.setLayout((LayoutManager)groupLayout);
            groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup().add((Component)jScrollPane).add((Component)jLabel)).addContainerGap());
            groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)jScrollPane).add((Component)jLabel));
            this.customEditor = jPanel;
            this.textComp = jTextArea;
            jLabel.setVisible(this.htmlText);
        }
        this.textComp.setEditable(this.editable);
        this.setValueToCustomEditor();
        return this.customEditor;
    }

    public void setContext(FormModel formModel, FormProperty formProperty) {
        this.htmlText = FormUtils.isHTMLTextProperty(formProperty);
    }

    public void updateFormVersionLevel() {
    }

    public void attachEnv(PropertyEnv propertyEnv) {
        FeatureDescriptor featureDescriptor = propertyEnv.getFeatureDescriptor();
        if (featureDescriptor instanceof Node.Property) {
            Node.Property property = (Node.Property)featureDescriptor;
            this.editable = property.canWrite();
            if (this.textComp != null) {
                this.textComp.setEditable(this.editable);
            }
        }
    }

    private void setValueToCustomEditor() {
        this.valueUpdateInvoked = true;
        this.textComp.setText(this.getAsText());
        this.valueUpdateInvoked = false;
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        if (!this.valueUpdateInvoked) {
            this.valueUpdateInvoked = true;
            EventQueue.invokeLater(this);
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        if (!this.valueUpdateInvoked) {
            this.valueUpdateInvoked = true;
            EventQueue.invokeLater(this);
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void run() {
        if (this.textComp != null) {
            this.setValue(this.textComp.getText());
        }
        this.valueUpdateInvoked = false;
    }
}

