/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.editors2;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyEditorSupport;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.form.FormAwareEditor;
import org.netbeans.modules.form.FormDesignValueAdapter;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.NamedPropertyEditor;
import org.openide.awt.Mnemonics;
import org.openide.explorer.propertysheet.editors.XMLPropertyEditor;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpinnerModelEditor
extends PropertyEditorSupport
implements XMLPropertyEditor,
NamedPropertyEditor,
FormAwareEditor {
    private boolean initialized;
    private boolean fireChanges;
    private FormProperty property;
    private JComboBox calendarFieldCombo;
    private JLabel calendarFieldLabel;
    private JPanel customizerPanel;
    private JPanel datePanel;
    private JPanel defaultPanel;
    private JLabel initialDateLabel;
    private JSpinner initialDateSpinner;
    private JComboBox initialListCombo;
    private JLabel initialListLabel;
    private JCheckBox initialNowCheckBox;
    private JLabel initialNumberLabel;
    private JSpinner initialNumberSpinner;
    private JTextArea listItemsArea;
    private JLabel listItemsLabel;
    private JPanel listPanel;
    private JCheckBox maximumDateCheckBox;
    private JSpinner maximumDateSpinner;
    private JCheckBox maximumNowCheckBox;
    private JCheckBox maximumNumberCheckBox;
    private JSpinner maximumNumberSpinner;
    private JCheckBox minimumDateCheckBox;
    private JSpinner minimumDateSpinner;
    private JCheckBox minimumNowCheckBox;
    private JCheckBox minimumNumberCheckBox;
    private JSpinner minimumNumberSpinner;
    private JLabel modelPropertiesLabel;
    private JComboBox modelTypeCombo;
    private JLabel modelTypeLabel;
    private JPanel modelTypePanel;
    private JPanel numberPanel;
    private JComboBox numberTypeCombo;
    private JLabel numberTypeLabel;
    private JScrollPane scrollPane;
    private JSeparator separator;
    private JLabel stepSizeLabel;
    private JSpinner stepSizeSpinner;
    private static final String XML_SPINNER_MODEL = "SpinnerModel";
    private static final String XML_LIST_ITEM = "ListItem";
    private static final String ATTR_INITIAL = "initial";
    private static final String ATTR_MINIMUM = "minimum";
    private static final String ATTR_MAXIMUM = "maximum";
    private static final String ATTR_STEP_SIZE = "stepSize";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_NUMBER_TYPE = "numberType";
    private static final String ATTR_VALUE = "value";
    private static final String VALUE_TYPE_DEFAULT = "default";
    private static final String VALUE_TYPE_NUMBER = "number";
    private static final String VALUE_TYPE_DATE = "date";
    private static final String VALUE_TYPE_LIST = "list";
    private static final String VALUE_NOW = "now";

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        Object object;
        this.fireChanges = false;
        if (!this.initialized) {
            this.initGUI();
        }
        if ((object = this.getValue()) instanceof FormSpinnerModel) {
            this.updateUI((FormSpinnerModel)object);
        } else {
            this.modelTypeCombo.setSelectedIndex(0);
        }
        this.fireChanges = true;
        return this.customizerPanel;
    }

    private void initGUI() {
        this.fireChanges = false;
        this.initComponents();
        this.initModelTypeCombo();
        this.initCalendarFieldCombo();
        this.initNumberTypeCombo();
        this.initListItems();
        this.initialDateSpinner.setModel(new SpinnerDateModel());
        this.initialDateSpinner.setValue(new Date());
        this.minimumDateSpinner.setModel(new SpinnerDateModel());
        this.maximumDateSpinner.setModel(new SpinnerDateModel());
        this.stepSizeSpinner.setValue(1);
        this.initialListLabel.setVisible(false);
        this.initialListCombo.setVisible(false);
        this.fireChanges = true;
        this.initialized = true;
    }

    private void initListItems() {
        String string = NbBundle.getMessage(this.getClass(), (String)"SpinnerModelEditor_Item");
        String[] stringArray = new String[4];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = MessageFormat.format(string, i);
        }
        StringBuilder stringBuilder = new StringBuilder();
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        for (String string2 : stringArray) {
            stringBuilder.append((Object)string2).append('\n');
            defaultComboBoxModel.addElement(string2);
        }
        this.listItemsArea.setText(stringBuilder.toString());
        this.initialListCombo.setModel(defaultComboBoxModel);
        this.initialListCombo.setSelectedIndex(0);
    }

    private void initModelTypeCombo() {
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        ResourceBundle resourceBundle = NbBundle.getBundle(this.getClass());
        defaultComboBoxModel.addElement(resourceBundle.getString("SpinnerModelEditor_Default"));
        defaultComboBoxModel.addElement(resourceBundle.getString("SpinnerModelEditor_Date"));
        defaultComboBoxModel.addElement(resourceBundle.getString("SpinnerModelEditor_List"));
        defaultComboBoxModel.addElement(resourceBundle.getString("SpinnerModelEditor_Number"));
        this.modelTypeCombo.setModel(defaultComboBoxModel);
    }

    private void initCalendarFieldCombo() {
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        ResourceBundle resourceBundle = NbBundle.getBundle(this.getClass());
        defaultComboBoxModel.addElement(resourceBundle.getString("SpinnerModelEditor_Era"));
        defaultComboBoxModel.addElement(resourceBundle.getString("SpinnerModelEditor_Year"));
        defaultComboBoxModel.addElement(resourceBundle.getString("SpinnerModelEditor_Month"));
        defaultComboBoxModel.addElement(resourceBundle.getString("SpinnerModelEditor_WeekOfYear"));
        defaultComboBoxModel.addElement(resourceBundle.getString("SpinnerModelEditor_WeekOfMonth"));
        defaultComboBoxModel.addElement(resourceBundle.getString("SpinnerModelEditor_DayOfMonth"));
        defaultComboBoxModel.addElement(resourceBundle.getString("SpinnerModelEditor_DayOfYear"));
        defaultComboBoxModel.addElement(resourceBundle.getString("SpinnerModelEditor_DayOfWeek"));
        defaultComboBoxModel.addElement(resourceBundle.getString("SpinnerModelEditor_DayOfWeekInMonth"));
        defaultComboBoxModel.addElement(resourceBundle.getString("SpinnerModelEditor_AMPM"));
        defaultComboBoxModel.addElement(resourceBundle.getString("SpinnerModelEditor_Hour"));
        defaultComboBoxModel.addElement(resourceBundle.getString("SpinnerModelEditor_HourOfDay"));
        defaultComboBoxModel.addElement(resourceBundle.getString("SpinnerModelEditor_Minute"));
        defaultComboBoxModel.addElement(resourceBundle.getString("SpinnerModelEditor_Second"));
        defaultComboBoxModel.addElement(resourceBundle.getString("SpinnerModelEditor_Millisecond"));
        this.calendarFieldCombo.setModel(defaultComboBoxModel);
        this.calendarFieldCombo.setSelectedIndex(5);
    }

    private void initNumberTypeCombo() {
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        ResourceBundle resourceBundle = NbBundle.getBundle(this.getClass());
        defaultComboBoxModel.addElement(resourceBundle.getString("SpinnerModelEditor_Byte"));
        defaultComboBoxModel.addElement(resourceBundle.getString("SpinnerModelEditor_Double"));
        defaultComboBoxModel.addElement(resourceBundle.getString("SpinnerModelEditor_Float"));
        defaultComboBoxModel.addElement(resourceBundle.getString("SpinnerModelEditor_Integer"));
        defaultComboBoxModel.addElement(resourceBundle.getString("SpinnerModelEditor_Long"));
        defaultComboBoxModel.addElement(resourceBundle.getString("SpinnerModelEditor_Short"));
        this.numberTypeCombo.setModel(defaultComboBoxModel);
        this.numberTypeCombo.setSelectedIndex(3);
    }

    private void updateUI(FormSpinnerModel formSpinnerModel) {
        SpinnerModel spinnerModel = formSpinnerModel.getModel();
        if (spinnerModel instanceof SpinnerDateModel) {
            this.modelTypeCombo.setSelectedIndex(1);
            this.updateDateUI(formSpinnerModel);
        } else if (spinnerModel instanceof SpinnerListModel) {
            this.modelTypeCombo.setSelectedIndex(2);
            this.updateListUI(formSpinnerModel);
        } else if (spinnerModel instanceof SpinnerNumberModel) {
            this.modelTypeCombo.setSelectedIndex(3);
            this.updateNumberUI(formSpinnerModel);
        } else assert (false);
        this.updateVisibilityOfModelProperties();
    }

    private void updateDateUI(FormSpinnerModel formSpinnerModel) {
        Date date = new Date();
        SpinnerDateModel spinnerDateModel = (SpinnerDateModel)formSpinnerModel.getModel();
        this.initialNowCheckBox.setSelected(formSpinnerModel.isInitialNow());
        this.initialDateSpinner.setValue(formSpinnerModel.isInitialNow() ? date : formSpinnerModel.getInitialValue());
        this.initialDateSpinner.setEnabled(!formSpinnerModel.isInitialNow());
        Comparable<Date> comparable = spinnerDateModel.getStart();
        this.minimumDateCheckBox.setSelected(comparable != null);
        this.minimumNowCheckBox.setEnabled(comparable != null);
        this.minimumNowCheckBox.setSelected(formSpinnerModel.isMinimumNow());
        this.minimumDateSpinner.setEnabled(comparable != null && !formSpinnerModel.isMinimumNow());
        comparable = formSpinnerModel.isMinimumNow() ? date : comparable;
        this.minimumDateSpinner.setValue(comparable == null ? date : comparable);
        Comparable<Date> comparable2 = spinnerDateModel.getEnd();
        this.maximumDateCheckBox.setSelected(comparable2 != null);
        this.maximumNowCheckBox.setEnabled(comparable2 != null);
        this.maximumNowCheckBox.setSelected(formSpinnerModel.isMaximumNow());
        this.maximumDateSpinner.setEnabled(comparable2 != null && !formSpinnerModel.isMaximumNow());
        comparable2 = formSpinnerModel.isMaximumNow() ? date : comparable2;
        this.maximumDateSpinner.setValue(comparable2 == null ? date : comparable2);
        int n = 0;
        switch (spinnerDateModel.getCalendarField()) {
            case 0: {
                n = 0;
                break;
            }
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = 2;
                break;
            }
            case 3: {
                n = 3;
                break;
            }
            case 4: {
                n = 4;
                break;
            }
            case 5: {
                n = 5;
                break;
            }
            case 6: {
                n = 6;
                break;
            }
            case 7: {
                n = 7;
                break;
            }
            case 8: {
                n = 8;
                break;
            }
            case 9: {
                n = 9;
                break;
            }
            case 10: {
                n = 10;
                break;
            }
            case 11: {
                n = 11;
                break;
            }
            case 12: {
                n = 12;
                break;
            }
            case 13: {
                n = 13;
                break;
            }
            case 14: {
                n = 14;
            }
        }
        this.calendarFieldCombo.setSelectedIndex(n);
    }

    private void updateListUI(FormSpinnerModel formSpinnerModel) {
        SpinnerListModel spinnerListModel = (SpinnerListModel)formSpinnerModel.getModel();
        List<?> list = spinnerListModel.getList();
        StringBuilder stringBuilder = new StringBuilder();
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        for (Object obj : list) {
            stringBuilder.append(obj).append('\n');
            defaultComboBoxModel.addElement(obj);
        }
        this.listItemsArea.setText(stringBuilder.toString());
        this.initialListCombo.setModel(defaultComboBoxModel);
        this.initialListCombo.setSelectedItem(formSpinnerModel.getInitialValue());
    }

    private void updateNumberUI(FormSpinnerModel formSpinnerModel) {
        Comparable<?> comparable;
        SpinnerNumberModel spinnerNumberModel = (SpinnerNumberModel)formSpinnerModel.getModel();
        Class<?> clazz = formSpinnerModel.getInitialValue().getClass();
        int n = 0;
        if (clazz == Byte.class) {
            n = 0;
        } else if (clazz == Double.class) {
            n = 1;
        } else if (clazz == Float.class) {
            n = 2;
        } else if (clazz == Integer.class) {
            n = 3;
        } else if (clazz == Long.class) {
            n = 4;
        } else if (clazz == Short.class) {
            n = 5;
        } else assert (false);
        this.numberTypeCombo.setSelectedIndex(n);
        this.minimumNumberSpinner.setValue(0);
        this.maximumNumberSpinner.setValue(0);
        this.updateNumberEditors();
        this.initialNumberSpinner.setValue(formSpinnerModel.getInitialValue());
        Comparable<?> comparable2 = spinnerNumberModel.getMinimum();
        this.minimumNumberCheckBox.setSelected(comparable2 != null);
        this.minimumNumberSpinner.setEnabled(comparable2 != null);
        if (comparable2 != null) {
            this.minimumNumberSpinner.setValue(comparable2);
        }
        this.maximumNumberCheckBox.setSelected((comparable = spinnerNumberModel.getMaximum()) != null);
        this.maximumNumberSpinner.setEnabled(comparable != null);
        if (comparable != null) {
            this.maximumNumberSpinner.setValue(comparable);
        }
        this.stepSizeSpinner.setValue(spinnerNumberModel.getStepSize());
    }

    private void updateFromUI() {
        if (!this.fireChanges) {
            return;
        }
        Object object = this.valueFromUI();
        if (object == null) {
            object = this.property.getDefaultValue();
        }
        this.setValue(object);
    }

    private FormSpinnerModel valueFromUI() {
        FormSpinnerModel formSpinnerModel = null;
        int n = this.modelTypeCombo.getSelectedIndex();
        if (n == 0) {
            formSpinnerModel = null;
        } else if (n == 1) {
            formSpinnerModel = this.dateFromUI();
        } else if (n == 2) {
            formSpinnerModel = this.listFromUI();
        } else if (n == 3) {
            formSpinnerModel = this.numberFromUI();
        } else assert (false);
        return formSpinnerModel;
    }

    private FormSpinnerModel dateFromUI() {
        Date date;
        Date date2 = new Date();
        boolean bl = false;
        Date date3 = null;
        if (this.minimumDateCheckBox.isSelected()) {
            if (this.minimumNowCheckBox.isSelected()) {
                bl = true;
                date3 = date2;
            } else {
                date3 = (Date)this.minimumDateSpinner.getValue();
            }
        }
        boolean bl2 = false;
        if (this.initialNowCheckBox.isSelected()) {
            bl2 = true;
            date = date2;
        } else {
            date = (Date)this.initialDateSpinner.getValue();
            if (bl && date.getTime() - date3.getTime() < 0L) {
                date = date3;
            }
        }
        boolean bl3 = false;
        Date date4 = null;
        if (this.maximumDateCheckBox.isSelected()) {
            if (this.maximumNowCheckBox.isSelected()) {
                bl3 = true;
                date4 = date2;
            } else {
                date4 = (Date)this.maximumDateSpinner.getValue();
                if (bl2 && date4.getTime() - date.getTime() < 0L) {
                    date4 = date;
                }
                if (bl && date4.getTime() - date3.getTime() < 0L) {
                    date4 = date3;
                }
            }
        }
        int n = 0;
        switch (this.calendarFieldCombo.getSelectedIndex()) {
            case 0: {
                n = 0;
                break;
            }
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = 2;
                break;
            }
            case 3: {
                n = 3;
                break;
            }
            case 4: {
                n = 4;
                break;
            }
            case 5: {
                n = 5;
                break;
            }
            case 6: {
                n = 6;
                break;
            }
            case 7: {
                n = 7;
                break;
            }
            case 8: {
                n = 8;
                break;
            }
            case 9: {
                n = 9;
                break;
            }
            case 10: {
                n = 10;
                break;
            }
            case 11: {
                n = 11;
                break;
            }
            case 12: {
                n = 12;
                break;
            }
            case 13: {
                n = 13;
                break;
            }
            case 14: {
                n = 14;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        SpinnerDateModel spinnerDateModel = new SpinnerDateModel(date, date3, date4, n);
        return new FormSpinnerModel(spinnerDateModel, date, bl2, bl, bl3);
    }

    private FormSpinnerModel listFromUI() {
        String string = (String)this.initialListCombo.getSelectedItem();
        List<String> list = this.listItemsFromUI();
        SpinnerListModel spinnerListModel = new SpinnerListModel(list);
        return new FormSpinnerModel(spinnerListModel, (Object)string);
    }

    private List<String> listItemsFromUI() {
        String string = this.listItemsArea.getText();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        LinkedList<String> linkedList = new LinkedList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            linkedList.add(stringTokenizer.nextToken());
        }
        if (linkedList.size() == 0) {
            linkedList.add("");
        }
        return linkedList;
    }

    private Class selectedNumberType() {
        Class clazz = null;
        switch (this.numberTypeCombo.getSelectedIndex()) {
            case 0: {
                clazz = Byte.class;
                break;
            }
            case 1: {
                clazz = Double.class;
                break;
            }
            case 2: {
                clazz = Float.class;
                break;
            }
            case 3: {
                clazz = Integer.class;
                break;
            }
            case 4: {
                clazz = Long.class;
                break;
            }
            case 5: {
                clazz = Short.class;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return clazz;
    }

    private FormSpinnerModel numberFromUI() {
        Number number = (Number)this.initialNumberSpinner.getValue();
        Number number2 = null;
        if (this.minimumNumberCheckBox.isSelected()) {
            number2 = (Number)this.minimumNumberSpinner.getValue();
        }
        Number number3 = null;
        if (this.maximumNumberCheckBox.isSelected()) {
            number3 = (Number)this.maximumNumberSpinner.getValue();
        }
        Number number4 = (Number)this.stepSizeSpinner.getValue();
        Number[] numberArray = SpinnerModelEditor.cast(this.selectedNumberType(), number, number2, number3, number4);
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(numberArray[0], (Comparable)((Object)numberArray[1]), (Comparable)((Object)numberArray[2]), numberArray[3]);
        return new FormSpinnerModel(spinnerNumberModel, (Object)numberArray[0]);
    }

    private static Number[] cast(Class clazz, Number ... numberArray) {
        Number[] numberArray2 = new Number[numberArray.length];
        for (int i = 0; i < numberArray.length; ++i) {
            Number number = numberArray[i];
            if (number == null) {
                numberArray2[i] = null;
                continue;
            }
            if (Integer.class == clazz) {
                numberArray2[i] = number.intValue();
                continue;
            }
            if (Long.class == clazz) {
                numberArray2[i] = number.longValue();
                continue;
            }
            if (Float.class == clazz) {
                numberArray2[i] = Float.valueOf(number.floatValue());
                continue;
            }
            if (Double.class == clazz) {
                numberArray2[i] = number.doubleValue();
                continue;
            }
            if (Byte.class == clazz) {
                numberArray2[i] = number.byteValue();
                continue;
            }
            if (Short.class == clazz) {
                numberArray2[i] = number.shortValue();
                continue;
            }
            assert (false);
        }
        return numberArray2;
    }

    private void initComponents() {
        this.customizerPanel = new JPanel();
        this.modelTypeLabel = new JLabel();
        this.modelTypeCombo = new JComboBox();
        this.modelPropertiesLabel = new JLabel();
        this.separator = new JSeparator();
        this.modelTypePanel = new JPanel();
        this.datePanel = new JPanel();
        this.initialDateLabel = new JLabel();
        this.initialDateSpinner = new JSpinner();
        this.initialNowCheckBox = new JCheckBox();
        this.minimumDateCheckBox = new JCheckBox();
        this.minimumDateSpinner = new JSpinner();
        this.minimumNowCheckBox = new JCheckBox();
        this.maximumDateCheckBox = new JCheckBox();
        this.maximumDateSpinner = new JSpinner();
        this.maximumNowCheckBox = new JCheckBox();
        this.calendarFieldLabel = new JLabel();
        this.calendarFieldCombo = new JComboBox();
        this.listPanel = new JPanel();
        this.listItemsLabel = new JLabel();
        this.scrollPane = new JScrollPane();
        this.listItemsArea = new JTextArea();
        this.initialListLabel = new JLabel();
        this.initialListCombo = new JComboBox();
        this.numberPanel = new JPanel();
        this.numberTypeLabel = new JLabel();
        this.numberTypeCombo = new JComboBox();
        this.initialNumberLabel = new JLabel();
        this.initialNumberSpinner = new JSpinner();
        this.minimumNumberCheckBox = new JCheckBox();
        this.minimumNumberSpinner = new JSpinner();
        this.maximumNumberCheckBox = new JCheckBox();
        this.maximumNumberSpinner = new JSpinner();
        this.stepSizeLabel = new JLabel();
        this.stepSizeSpinner = new JSpinner();
        this.defaultPanel = new JPanel();
        FormListener formListener = new FormListener();
        this.modelTypeLabel.setLabelFor(this.modelTypeCombo);
        Mnemonics.setLocalizedText((JLabel)this.modelTypeLabel, (String)NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_ModelType"));
        this.modelTypeCombo.addActionListener(formListener);
        this.modelPropertiesLabel.setText(NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_ModelProperties"));
        this.modelTypePanel.setLayout(new CardLayout());
        this.initialDateLabel.setLabelFor(this.initialDateSpinner);
        Mnemonics.setLocalizedText((JLabel)this.initialDateLabel, (String)NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_InitialDate"));
        this.initialDateSpinner.setEnabled(false);
        this.initialDateSpinner.addChangeListener(formListener);
        this.initialNowCheckBox.setSelected(true);
        this.initialNowCheckBox.setText(NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_InitialNow"));
        this.initialNowCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.initialNowCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.initialNowCheckBox.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.minimumDateCheckBox, (String)NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_MinimumDate"));
        this.minimumDateCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.minimumDateCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.minimumDateCheckBox.addActionListener(formListener);
        this.minimumDateSpinner.setEnabled(false);
        this.minimumDateSpinner.addChangeListener(formListener);
        this.minimumNowCheckBox.setText(NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_MinimumNow"));
        this.minimumNowCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.minimumNowCheckBox.setEnabled(false);
        this.minimumNowCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.minimumNowCheckBox.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.maximumDateCheckBox, (String)NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_MaximumDate"));
        this.maximumDateCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.maximumDateCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.maximumDateCheckBox.addActionListener(formListener);
        this.maximumDateSpinner.setEnabled(false);
        this.maximumDateSpinner.addChangeListener(formListener);
        this.maximumNowCheckBox.setText(NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_MaximumNow"));
        this.maximumNowCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.maximumNowCheckBox.setEnabled(false);
        this.maximumNowCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.maximumNowCheckBox.addActionListener(formListener);
        this.calendarFieldLabel.setLabelFor(this.calendarFieldCombo);
        Mnemonics.setLocalizedText((JLabel)this.calendarFieldLabel, (String)NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_CalendarField"));
        this.calendarFieldCombo.addActionListener(formListener);
        GroupLayout groupLayout = new GroupLayout((Container)this.datePanel);
        this.datePanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.initialDateLabel).add((Component)this.minimumDateCheckBox).add((Component)this.maximumDateCheckBox).add((Component)this.calendarFieldLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1, false).add(2, (Component)this.initialDateSpinner).add(2, (Component)this.minimumDateSpinner).add(2, (Component)this.maximumDateSpinner).add(2, (Component)this.calendarFieldCombo, 0, -1, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addPreferredGap(0).add((Component)this.maximumNowCheckBox)).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addPreferredGap(0).add((Component)this.minimumNowCheckBox))).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addPreferredGap(0).add((Component)this.initialNowCheckBox))).addContainerGap(14, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.initialDateLabel).add((Component)this.initialNowCheckBox).add((Component)this.initialDateSpinner, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.minimumDateCheckBox).add((Component)this.minimumNowCheckBox).add((Component)this.minimumDateSpinner, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.maximumDateCheckBox).add((Component)this.maximumNowCheckBox).add((Component)this.maximumDateSpinner, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.calendarFieldLabel).add((Component)this.calendarFieldCombo, -2, -1, -2)).addContainerGap(45, Short.MAX_VALUE)));
        this.initialDateSpinner.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_InitialDate_ACSD"));
        this.initialNowCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_InitialNow_ACSD"));
        this.minimumDateCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_MinimumDate_ACSD"));
        this.minimumDateSpinner.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_MinimumDate_ACSN"));
        this.minimumDateSpinner.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_MinimumDate_ACSD"));
        this.minimumNowCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_MinimumNow_ACSD"));
        this.maximumDateCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_MaximumDate_ACSD"));
        this.maximumDateSpinner.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_MaximumDate_ACSN"));
        this.maximumDateSpinner.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_MaximumDate_ACSD"));
        this.maximumNowCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_MaximumNow_ACSD"));
        this.calendarFieldCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_StepSize_ACSD"));
        this.modelTypePanel.add((Component)this.datePanel, VALUE_TYPE_DATE);
        this.listItemsLabel.setLabelFor(this.listItemsArea);
        Mnemonics.setLocalizedText((JLabel)this.listItemsLabel, (String)NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_ListItems"));
        this.listItemsArea.setRows(4);
        this.listItemsArea.addFocusListener(formListener);
        this.scrollPane.setViewportView(this.listItemsArea);
        this.listItemsArea.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_ListItems"));
        this.initialListLabel.setLabelFor(this.initialListCombo);
        Mnemonics.setLocalizedText((JLabel)this.initialListLabel, (String)NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_InitialList"));
        this.initialListCombo.addActionListener(formListener);
        GroupLayout groupLayout2 = new GroupLayout((Container)this.listPanel);
        this.listPanel.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.scrollPane, -1, 147, Short.MAX_VALUE).add((Component)this.listItemsLabel).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.initialListLabel).addPreferredGap(0).add((Component)this.initialListCombo, 0, 84, Short.MAX_VALUE))).addContainerGap()));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((Component)this.listItemsLabel).addPreferredGap(0).add((Component)this.scrollPane, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.initialListLabel).add((Component)this.initialListCombo, -2, -1, -2)).addContainerGap(13, Short.MAX_VALUE)));
        this.initialListCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_InitialList_ACSD"));
        this.modelTypePanel.add((Component)this.listPanel, VALUE_TYPE_LIST);
        this.numberTypeLabel.setLabelFor(this.numberTypeCombo);
        Mnemonics.setLocalizedText((JLabel)this.numberTypeLabel, (String)NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_NumberType"));
        this.numberTypeCombo.addActionListener(formListener);
        this.initialNumberLabel.setLabelFor(this.initialNumberSpinner);
        Mnemonics.setLocalizedText((JLabel)this.initialNumberLabel, (String)NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_InitialNumber"));
        this.initialNumberSpinner.addChangeListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.minimumNumberCheckBox, (String)NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_MinimumNumber"));
        this.minimumNumberCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.minimumNumberCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.minimumNumberCheckBox.addActionListener(formListener);
        this.minimumNumberSpinner.setEnabled(false);
        this.minimumNumberSpinner.addChangeListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.maximumNumberCheckBox, (String)NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_MaximumNumber"));
        this.maximumNumberCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.maximumNumberCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.maximumNumberCheckBox.addActionListener(formListener);
        this.maximumNumberSpinner.setEnabled(false);
        this.maximumNumberSpinner.addChangeListener(formListener);
        this.stepSizeLabel.setLabelFor(this.stepSizeSpinner);
        Mnemonics.setLocalizedText((JLabel)this.stepSizeLabel, (String)NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_StepSize"));
        this.stepSizeSpinner.addChangeListener(formListener);
        GroupLayout groupLayout3 = new GroupLayout((Container)this.numberPanel);
        this.numberPanel.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((Component)this.numberTypeLabel).add((Component)this.initialNumberLabel).add((Component)this.minimumNumberCheckBox).add((Component)this.maximumNumberCheckBox).add((Component)this.stepSizeLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout3.createParallelGroup(1, false).add((Component)this.numberTypeCombo, 0, -1, Short.MAX_VALUE).add((Component)this.initialNumberSpinner).add((Component)this.minimumNumberSpinner).add((Component)this.maximumNumberSpinner).add((Component)this.stepSizeSpinner)).addContainerGap(56, Short.MAX_VALUE)));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout3.createParallelGroup(3).add((Component)this.numberTypeLabel).add((Component)this.numberTypeCombo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout3.createParallelGroup(3).add((Component)this.initialNumberLabel).add((Component)this.initialNumberSpinner, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout3.createParallelGroup(3).add((Component)this.minimumNumberCheckBox).add((Component)this.minimumNumberSpinner, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout3.createParallelGroup(3).add((Component)this.maximumNumberCheckBox).add((Component)this.maximumNumberSpinner, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout3.createParallelGroup(3).add((Component)this.stepSizeLabel).add((Component)this.stepSizeSpinner, -2, -1, -2)).addContainerGap(21, Short.MAX_VALUE)));
        this.numberTypeCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_NumberType_ACSD"));
        this.initialNumberSpinner.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_InitialNumber_ACSD"));
        this.minimumNumberCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_MinimumNumber_ACSD"));
        this.minimumNumberSpinner.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_MinimumNumber_ACSN"));
        this.minimumNumberSpinner.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_MinimumNumber_ACSD"));
        this.maximumNumberCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_MaximumNumber_ACSD"));
        this.maximumNumberSpinner.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_MaximumNumber_ACSN"));
        this.maximumNumberSpinner.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_MaximumNumber_ACSD"));
        this.stepSizeSpinner.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_StepSize_ACSD"));
        this.modelTypePanel.add((Component)this.numberPanel, VALUE_TYPE_NUMBER);
        GroupLayout groupLayout4 = new GroupLayout((Container)this.defaultPanel);
        this.defaultPanel.setLayout((LayoutManager)groupLayout4);
        groupLayout4.setHorizontalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add(0, 167, Short.MAX_VALUE));
        groupLayout4.setVerticalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add(0, 150, Short.MAX_VALUE));
        this.modelTypePanel.add((Component)this.defaultPanel, VALUE_TYPE_DEFAULT);
        GroupLayout groupLayout5 = new GroupLayout((Container)this.customizerPanel);
        this.customizerPanel.setLayout((LayoutManager)groupLayout5);
        groupLayout5.setHorizontalGroup((GroupLayout.Group)groupLayout5.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout5.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout5.createParallelGroup(2).add(1, (Component)this.modelTypePanel, -1, -1, Short.MAX_VALUE).add(1, (GroupLayout.Group)groupLayout5.createSequentialGroup().add((Component)this.modelTypeLabel).addPreferredGap(0).add((Component)this.modelTypeCombo, -2, -1, -2)).add(1, (GroupLayout.Group)groupLayout5.createSequentialGroup().add((Component)this.modelPropertiesLabel).addPreferredGap(0).add((Component)this.separator, -1, 83, Short.MAX_VALUE))).addContainerGap()));
        groupLayout5.setVerticalGroup((GroupLayout.Group)groupLayout5.createParallelGroup(1).add((GroupLayout.Group)groupLayout5.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout5.createParallelGroup(3).add((Component)this.modelTypeLabel).add((Component)this.modelTypeCombo, -2, -1, -2)).add(11, 11, 11).add((GroupLayout.Group)groupLayout5.createParallelGroup(2).add((Component)this.modelPropertiesLabel).add((Component)this.separator, -2, 10, -2)).addPreferredGap(0).add((Component)this.modelTypePanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.modelTypeCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_ModelType_ACSD"));
    }

    private void listItemsAreaFocusLost(FocusEvent focusEvent) {
        if (!this.fireChanges) {
            return;
        }
        this.fireChanges = false;
        int n = this.initialListCombo.getSelectedIndex();
        Object object = this.initialListCombo.getSelectedItem();
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        for (String string : this.listItemsFromUI()) {
            defaultComboBoxModel.addElement(string);
        }
        this.initialListCombo.setModel(defaultComboBoxModel);
        if (object != null) {
            this.initialListCombo.setSelectedItem(object);
            if (!object.equals(this.initialListCombo.getSelectedItem()) && this.initialListCombo.getModel().getSize() > n) {
                this.initialListCombo.setSelectedIndex(n);
            }
        }
        this.fireChanges = true;
        this.updateFromUI();
    }

    private void initialListComboActionPerformed(ActionEvent actionEvent) {
        this.updateFromUI();
    }

    private void maximumNumberCheckBoxActionPerformed(ActionEvent actionEvent) {
        Comparable comparable;
        Comparable comparable2;
        if (!this.fireChanges) {
            return;
        }
        this.maximumNumberSpinner.setEnabled(this.maximumNumberCheckBox.isSelected());
        if (this.maximumNumberCheckBox.isSelected() && (comparable2 = (Comparable)this.maximumNumberSpinner.getValue()).compareTo(comparable = (Comparable)this.initialNumberSpinner.getValue()) < 0) {
            this.fireChanges = false;
            this.maximumNumberSpinner.setValue(comparable);
            this.fireChanges = true;
        }
        this.updateFromUI();
    }

    private void minimumNumberCheckBoxActionPerformed(ActionEvent actionEvent) {
        Comparable comparable;
        Comparable comparable2;
        if (!this.fireChanges) {
            return;
        }
        this.minimumNumberSpinner.setEnabled(this.minimumNumberCheckBox.isSelected());
        if (this.minimumNumberCheckBox.isSelected() && (comparable2 = (Comparable)this.minimumNumberSpinner.getValue()).compareTo(comparable = (Comparable)this.initialNumberSpinner.getValue()) > 0) {
            this.fireChanges = false;
            this.minimumNumberSpinner.setValue(comparable);
            this.fireChanges = true;
        }
        this.updateFromUI();
    }

    private void maximumNumberSpinnerStateChanged(ChangeEvent changeEvent) {
        this.maximumNumberUpdated();
        this.updateFromUI();
    }

    private void minimumNumberSpinnerStateChanged(ChangeEvent changeEvent) {
        this.minimumNumberUpdated();
        this.updateFromUI();
    }

    private void initialNumberSpinnerStateChanged(ChangeEvent changeEvent) {
        Comparable comparable;
        if (!this.fireChanges) {
            return;
        }
        this.fireChanges = false;
        Comparable comparable2 = (Comparable)this.initialNumberSpinner.getValue();
        if (this.minimumNumberCheckBox.isSelected() && comparable2.compareTo(comparable = (Comparable)this.minimumNumberSpinner.getValue()) < 0) {
            this.minimumNumberSpinner.setValue(comparable2);
        }
        if (this.maximumNumberCheckBox.isSelected() && comparable2.compareTo(comparable = (Comparable)this.maximumNumberSpinner.getValue()) > 0) {
            this.maximumNumberSpinner.setValue(comparable2);
        }
        this.fireChanges = true;
        this.updateFromUI();
    }

    private void stepSizeSpinnerStateChanged(ChangeEvent changeEvent) {
        this.updateFromUI();
    }

    private void numberTypeComboActionPerformed(ActionEvent actionEvent) {
        if (!this.fireChanges) {
            return;
        }
        this.fireChanges = false;
        this.updateNumberEditors();
        this.fireChanges = true;
        this.updateFromUI();
    }

    private void updateNumberEditors() {
        Number[] numberArray = SpinnerModelEditor.cast(this.selectedNumberType(), (Number)this.initialNumberSpinner.getValue(), (Number)this.minimumNumberSpinner.getValue(), (Number)this.maximumNumberSpinner.getValue(), (Number)this.stepSizeSpinner.getValue());
        this.initialNumberSpinner.setValue(numberArray[0]);
        this.initialNumberSpinner.setEditor(new JSpinner.NumberEditor(this.initialNumberSpinner));
        this.minimumNumberSpinner.setValue(numberArray[1]);
        this.minimumNumberSpinner.setEditor(new JSpinner.NumberEditor(this.minimumNumberSpinner));
        this.maximumNumberSpinner.setValue(numberArray[2]);
        this.maximumNumberSpinner.setEditor(new JSpinner.NumberEditor(this.maximumNumberSpinner));
        this.stepSizeSpinner.setValue(numberArray[3]);
        this.stepSizeSpinner.setEditor(new JSpinner.NumberEditor(this.stepSizeSpinner));
    }

    private void calendarFieldComboActionPerformed(ActionEvent actionEvent) {
        this.updateFromUI();
    }

    private void maximumDateSpinnerStateChanged(ChangeEvent changeEvent) {
        if (!this.fireChanges) {
            return;
        }
        this.maximumDateUpdated();
        this.updateFromUI();
    }

    private void minimumDateSpinnerStateChanged(ChangeEvent changeEvent) {
        if (!this.fireChanges) {
            return;
        }
        this.minimumDateUpdated();
        this.updateFromUI();
    }

    private void initialDateSpinnerStateChanged(ChangeEvent changeEvent) {
        if (!this.fireChanges) {
            return;
        }
        this.initialDateUpdated();
        this.updateFromUI();
    }

    private void maximumDateCheckBoxActionPerformed(ActionEvent actionEvent) {
        if (!this.fireChanges) {
            return;
        }
        this.fireChanges = false;
        boolean bl = this.maximumDateCheckBox.isSelected();
        this.maximumNowCheckBox.setEnabled(bl);
        if (bl) {
            Date date = (Date)this.maximumDateSpinner.getValue();
            Date date2 = (Date)this.initialDateSpinner.getValue();
            if (date.getTime() - date2.getTime() < 0L) {
                if (this.maximumNowCheckBox.isSelected()) {
                    if (!this.initialNowCheckBox.isSelected()) {
                        this.maximumNowCheckBox.setSelected(false);
                        this.maximumDateSpinner.setValue(date2);
                    }
                } else {
                    this.maximumDateSpinner.setValue(date2);
                }
            }
        }
        this.maximumDateSpinner.setEnabled(bl && !this.maximumNowCheckBox.isSelected());
        this.fireChanges = true;
        this.updateFromUI();
    }

    private void minimumDateCheckBoxActionPerformed(ActionEvent actionEvent) {
        if (!this.fireChanges) {
            return;
        }
        this.fireChanges = false;
        boolean bl = this.minimumDateCheckBox.isSelected();
        this.minimumNowCheckBox.setEnabled(bl);
        if (bl) {
            Date date = (Date)this.minimumDateSpinner.getValue();
            Date date2 = (Date)this.initialDateSpinner.getValue();
            if (date2.getTime() - date.getTime() < 0L) {
                if (this.minimumNowCheckBox.isSelected()) {
                    if (!this.initialNowCheckBox.isSelected()) {
                        this.minimumNowCheckBox.setSelected(false);
                        this.minimumDateSpinner.setValue(date2);
                    }
                } else {
                    this.minimumDateSpinner.setValue(date2);
                }
            }
        }
        this.minimumDateSpinner.setEnabled(bl && !this.minimumNowCheckBox.isSelected());
        this.fireChanges = true;
        this.updateFromUI();
    }

    private void maximumNowCheckBoxActionPerformed(ActionEvent actionEvent) {
        if (!this.fireChanges) {
            return;
        }
        this.fireChanges = false;
        boolean bl = !this.maximumNowCheckBox.isSelected();
        this.maximumDateSpinner.setEnabled(bl);
        if (!bl) {
            this.maximumDateSpinner.setValue(new Date());
        }
        this.maximumDateUpdated();
        this.fireChanges = true;
        this.updateFromUI();
    }

    private void minimumNowCheckBoxActionPerformed(ActionEvent actionEvent) {
        if (!this.fireChanges) {
            return;
        }
        this.fireChanges = false;
        boolean bl = !this.minimumNowCheckBox.isSelected();
        this.minimumDateSpinner.setEnabled(bl);
        if (!bl) {
            this.minimumDateSpinner.setValue(new Date());
        }
        this.minimumDateUpdated();
        this.fireChanges = true;
        this.updateFromUI();
    }

    private void initialNowCheckBoxActionPerformed(ActionEvent actionEvent) {
        if (!this.fireChanges) {
            return;
        }
        this.fireChanges = false;
        boolean bl = !this.initialNowCheckBox.isSelected();
        this.initialDateSpinner.setEnabled(bl);
        if (!bl) {
            this.initialDateSpinner.setValue(new Date());
        }
        this.initialDateUpdated();
        this.fireChanges = true;
        this.updateFromUI();
    }

    private void modelTypeComboActionPerformed(ActionEvent actionEvent) {
        CardLayout cardLayout = (CardLayout)this.modelTypePanel.getLayout();
        String string = null;
        switch (this.modelTypeCombo.getSelectedIndex()) {
            case 0: {
                string = VALUE_TYPE_DEFAULT;
                break;
            }
            case 1: {
                string = VALUE_TYPE_DATE;
                break;
            }
            case 2: {
                string = VALUE_TYPE_LIST;
                break;
            }
            case 3: {
                string = VALUE_TYPE_NUMBER;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        this.updateVisibilityOfModelProperties();
        cardLayout.show(this.modelTypePanel, string);
        this.updateFromUI();
    }

    private void updateVisibilityOfModelProperties() {
        boolean bl = this.modelTypeCombo.getSelectedIndex() != 0;
        this.modelPropertiesLabel.setVisible(bl);
        this.separator.setVisible(bl);
    }

    private void minimumNumberUpdated() {
        if (!this.fireChanges) {
            return;
        }
        this.fireChanges = false;
        if (this.minimumNumberCheckBox.isSelected()) {
            Comparable comparable;
            Comparable comparable2 = (Comparable)this.minimumNumberSpinner.getValue();
            Comparable comparable3 = (Comparable)this.initialNumberSpinner.getValue();
            if (comparable3.compareTo(comparable2) < 0) {
                this.initialNumberSpinner.setValue(comparable2);
            }
            if (this.maximumNumberCheckBox.isSelected() && (comparable = (Comparable)this.maximumNumberSpinner.getValue()).compareTo(comparable2) < 0) {
                this.maximumNumberSpinner.setValue(comparable2);
            }
        }
        this.fireChanges = true;
    }

    private void maximumNumberUpdated() {
        if (!this.fireChanges) {
            return;
        }
        this.fireChanges = false;
        if (this.maximumNumberCheckBox.isSelected()) {
            Comparable comparable;
            Comparable comparable2 = (Comparable)this.maximumNumberSpinner.getValue();
            Comparable comparable3 = (Comparable)this.initialNumberSpinner.getValue();
            if (comparable3.compareTo(comparable2) > 0) {
                this.initialNumberSpinner.setValue(comparable2);
            }
            if (this.minimumNumberCheckBox.isSelected() && comparable2.compareTo(comparable = (Comparable)this.minimumNumberSpinner.getValue()) < 0) {
                this.minimumNumberSpinner.setValue(comparable2);
            }
        }
        this.fireChanges = true;
    }

    private void initialDateUpdated() {
        Date date;
        this.fireChanges = false;
        Date date2 = (Date)this.initialDateSpinner.getValue();
        if (this.minimumDateCheckBox.isSelected()) {
            date = (Date)this.minimumDateSpinner.getValue();
            if (date2.getTime() - date.getTime() < 0L) {
                if (this.minimumNowCheckBox.isSelected()) {
                    if (!this.initialNowCheckBox.isSelected()) {
                        this.minimumNowCheckBox.setSelected(false);
                        this.minimumDateSpinner.setEnabled(true);
                        this.minimumDateSpinner.setValue(date2);
                    }
                } else {
                    this.minimumDateSpinner.setValue(date2);
                }
            }
        }
        if (this.maximumDateCheckBox.isSelected() && (date = (Date)this.maximumDateSpinner.getValue()).getTime() - date2.getTime() < 0L) {
            if (this.maximumNowCheckBox.isSelected()) {
                if (!this.initialNowCheckBox.isSelected()) {
                    this.maximumNowCheckBox.setSelected(false);
                    this.maximumDateSpinner.setEnabled(true);
                    this.maximumDateSpinner.setValue(date2);
                }
            } else {
                this.maximumDateSpinner.setValue(date2);
            }
        }
        this.fireChanges = true;
    }

    private void minimumDateUpdated() {
        Date date;
        this.fireChanges = false;
        if (!this.minimumDateCheckBox.isSelected()) {
            return;
        }
        Date date2 = (Date)this.minimumDateSpinner.getValue();
        Date date3 = (Date)this.initialDateSpinner.getValue();
        if (date3.getTime() - date2.getTime() < 0L) {
            if (this.initialNowCheckBox.isSelected()) {
                if (!this.minimumNowCheckBox.isSelected()) {
                    this.initialNowCheckBox.setSelected(false);
                    this.initialDateSpinner.setEnabled(true);
                    this.initialDateSpinner.setValue(date2);
                }
            } else {
                this.initialDateSpinner.setValue(date2);
            }
        }
        if (this.maximumDateCheckBox.isSelected() && (date = (Date)this.maximumDateSpinner.getValue()).getTime() - date2.getTime() < 0L) {
            if (this.maximumNowCheckBox.isSelected()) {
                if (!this.minimumNowCheckBox.isSelected()) {
                    this.maximumNowCheckBox.setSelected(false);
                    this.maximumDateSpinner.setEnabled(true);
                    this.maximumDateSpinner.setValue(date2);
                }
            } else {
                this.maximumDateSpinner.setValue(date2);
            }
        }
        this.fireChanges = true;
    }

    private void maximumDateUpdated() {
        if (!this.maximumDateCheckBox.isSelected()) {
            return;
        }
        this.fireChanges = false;
        Date date = (Date)this.maximumDateSpinner.getValue();
        Date date2 = (Date)this.initialDateSpinner.getValue();
        if (date.getTime() - date2.getTime() < 0L) {
            if (this.initialNowCheckBox.isSelected()) {
                if (!this.maximumNowCheckBox.isSelected()) {
                    this.initialNowCheckBox.setSelected(false);
                    this.initialDateSpinner.setEnabled(true);
                    this.initialDateSpinner.setValue(date);
                }
            } else {
                this.initialDateSpinner.setValue(date);
            }
        }
        if (this.minimumDateCheckBox.isSelected()) {
            Date date3 = (Date)this.minimumDateSpinner.getValue();
            if (date.getTime() - date3.getTime() < 0L) {
                if (this.minimumNowCheckBox.isSelected()) {
                    if (!this.maximumNowCheckBox.isSelected()) {
                        this.minimumNowCheckBox.setSelected(false);
                        this.minimumDateSpinner.setEnabled(true);
                        this.minimumDateSpinner.setValue(date);
                    }
                } else {
                    this.minimumDateSpinner.setValue(date);
                }
            }
        }
        this.fireChanges = true;
    }

    @Override
    public String getJavaInitializationString() {
        Object object = this.getValue();
        if (!(object instanceof FormSpinnerModel)) {
            return super.getJavaInitializationString();
        }
        FormSpinnerModel formSpinnerModel = (FormSpinnerModel)object;
        SpinnerModel spinnerModel = formSpinnerModel.getModel();
        String string = null;
        if (spinnerModel instanceof SpinnerDateModel) {
            string = this.dateInitializationString(formSpinnerModel);
        } else if (spinnerModel instanceof SpinnerNumberModel) {
            string = this.numberInitializationString(formSpinnerModel);
        } else if (spinnerModel instanceof SpinnerListModel) {
            string = SpinnerModelEditor.listInitializationString(formSpinnerModel);
        } else assert (false);
        return string;
    }

    private static String listInitializationString(FormSpinnerModel formSpinnerModel) {
        StringBuilder stringBuilder = new StringBuilder("new javax.swing.SpinnerListModel(new String[] {");
        SpinnerListModel spinnerListModel = (SpinnerListModel)formSpinnerModel.getModel();
        List<?> list = spinnerListModel.getList();
        for (Object obj : list) {
            String string = obj.toString();
            string = string.replace("\"", "\\\"");
            stringBuilder.append('\"').append(string).append("\", ");
        }
        stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
        stringBuilder.append("})");
        return stringBuilder.toString();
    }

    private String numberInitializationString(FormSpinnerModel formSpinnerModel) {
        StringBuilder stringBuilder = new StringBuilder();
        SpinnerNumberModel spinnerNumberModel = (SpinnerNumberModel)formSpinnerModel.getModel();
        stringBuilder.append("new javax.swing.SpinnerNumberModel(");
        Object object = formSpinnerModel.getInitialValue();
        Comparable<?> comparable = spinnerNumberModel.getMinimum();
        Comparable<?> comparable2 = spinnerNumberModel.getMaximum();
        Number number = spinnerNumberModel.getStepSize();
        Class<?> clazz = object.getClass();
        boolean bl = false;
        if (clazz == Integer.class) {
            if (Integer.valueOf(0).equals(object) && comparable == null && comparable2 == null && Integer.valueOf(1).equals(number)) {
                stringBuilder.append(')');
                bl = true;
            } else if (comparable != null && comparable2 != null) {
                stringBuilder.append(object).append(", ");
                stringBuilder.append(comparable).append(", ");
                stringBuilder.append(comparable2).append(", ");
                stringBuilder.append(number).append(')');
                bl = true;
            }
        } else if (clazz == Double.class && comparable != null && comparable2 != null) {
            stringBuilder.append(object).append("d, ");
            stringBuilder.append(comparable).append("d, ");
            stringBuilder.append(comparable2).append("d, ");
            stringBuilder.append(number).append("d)");
            bl = true;
        }
        if (!bl) {
            String string = clazz.getName();
            string = string.substring(string.lastIndexOf(46) + 1);
            string = string + ".valueOf(";
            String string2 = "";
            if (clazz == Long.class) {
                string2 = "L";
            } else if (clazz == Float.class) {
                string2 = "f";
            } else if (clazz == Double.class) {
                string2 = "d";
            } else if (clazz == Byte.class) {
                string = string + "(byte)";
            } else if (clazz == Short.class) {
                string = string + "(short)";
            }
            stringBuilder.append(string).append(object).append(string2).append("), ");
            if (comparable == null) {
                stringBuilder.append("null, ");
            } else {
                stringBuilder.append(string).append(comparable).append(string2).append("), ");
            }
            if (comparable2 == null) {
                stringBuilder.append("null, ");
            } else {
                stringBuilder.append(string).append(comparable2).append(string2).append("), ");
            }
            stringBuilder.append(string).append(number).append(string2).append("))");
        }
        return stringBuilder.toString();
    }

    private String dateInitializationString(FormSpinnerModel formSpinnerModel) {
        StringBuilder stringBuilder = new StringBuilder();
        SpinnerDateModel spinnerDateModel = (SpinnerDateModel)formSpinnerModel.getModel();
        stringBuilder.append("new javax.swing.SpinnerDateModel(");
        if (formSpinnerModel.isInitialNow() && spinnerDateModel.getCalendarField() == 5 && spinnerDateModel.getStart() == null && spinnerDateModel.getEnd() == null) {
            stringBuilder.append(')');
        } else {
            stringBuilder.append("new java.util.Date(");
            if (!formSpinnerModel.isInitialNow()) {
                stringBuilder.append(((Date)formSpinnerModel.getInitialValue()).getTime());
                stringBuilder.append('L');
            }
            stringBuilder.append("), ");
            Date date = (Date)spinnerDateModel.getStart();
            if (date == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("new java.util.Date(");
                if (!formSpinnerModel.isMinimumNow()) {
                    stringBuilder.append(date.getTime());
                    stringBuilder.append('L');
                }
                stringBuilder.append(')');
            }
            stringBuilder.append(", ");
            Date date2 = (Date)spinnerDateModel.getEnd();
            if (date2 == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("new java.util.Date(");
                if (!formSpinnerModel.isMaximumNow()) {
                    stringBuilder.append(date2.getTime());
                    stringBuilder.append('L');
                }
                stringBuilder.append(')');
            }
            stringBuilder.append(", ");
            int n = spinnerDateModel.getCalendarField();
            String string = null;
            switch (n) {
                case 0: {
                    string = "ERA";
                    break;
                }
                case 1: {
                    string = "YEAR";
                    break;
                }
                case 2: {
                    string = "MONTH";
                    break;
                }
                case 3: {
                    string = "WEEK_OF_YEAR";
                    break;
                }
                case 4: {
                    string = "WEEK_OF_MONTH";
                    break;
                }
                case 5: {
                    string = "DAY_OF_MONTH";
                    break;
                }
                case 6: {
                    string = "DAY_OF_YEAR";
                    break;
                }
                case 7: {
                    string = "DAY_OF_WEEK";
                    break;
                }
                case 8: {
                    string = "DAY_OF_WEEK_IN_MONTH";
                    break;
                }
                case 9: {
                    string = "AM_PM";
                    break;
                }
                case 10: {
                    string = "HOUR";
                    break;
                }
                case 11: {
                    string = "HOUR_OF_DAY";
                    break;
                }
                case 12: {
                    string = "MINUTE";
                    break;
                }
                case 13: {
                    string = "SECOND";
                    break;
                }
                case 14: {
                    string = "MILLISECOND";
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            stringBuilder.append("java.util.Calendar.").append(string).append(')');
        }
        return stringBuilder.toString();
    }

    public void readFromXML(Node node) throws IOException {
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string = namedNodeMap.getNamedItem(ATTR_TYPE).getNodeValue();
        Object object = null;
        if (VALUE_TYPE_DEFAULT.equals(string)) {
            object = this.property.getDefaultValue();
        } else if (VALUE_TYPE_DATE.equals(string)) {
            object = SpinnerModelEditor.readDateFromXML(node);
        } else if (VALUE_TYPE_NUMBER.equals(string)) {
            object = SpinnerModelEditor.readNumberFromXML(node);
        } else if (VALUE_TYPE_LIST.equals(string)) {
            object = SpinnerModelEditor.readListFromXML(node);
        }
        this.setValue(object);
    }

    public Node storeToXML(Document document) {
        Element element = document.createElement(XML_SPINNER_MODEL);
        Object object = this.getValue();
        if (!(object instanceof FormSpinnerModel)) {
            element.setAttribute(ATTR_TYPE, VALUE_TYPE_DEFAULT);
        } else {
            FormSpinnerModel formSpinnerModel = (FormSpinnerModel)object;
            SpinnerModel spinnerModel = formSpinnerModel.getModel();
            if (spinnerModel instanceof SpinnerNumberModel) {
                SpinnerModelEditor.storeNumberToXML(element, formSpinnerModel);
            } else if (spinnerModel instanceof SpinnerDateModel) {
                SpinnerModelEditor.storeDateToXML(element, formSpinnerModel);
            } else if (spinnerModel instanceof SpinnerListModel) {
                SpinnerModelEditor.storeListToXML(document, element, formSpinnerModel);
            }
        }
        return element;
    }

    private static void storeNumberToXML(Element element, FormSpinnerModel formSpinnerModel) {
        Comparable<?> comparable;
        element.setAttribute(ATTR_TYPE, VALUE_TYPE_NUMBER);
        SpinnerNumberModel spinnerNumberModel = (SpinnerNumberModel)formSpinnerModel.getModel();
        element.setAttribute(ATTR_NUMBER_TYPE, formSpinnerModel.getInitialValue().getClass().getName());
        element.setAttribute(ATTR_INITIAL, formSpinnerModel.getInitialValue().toString());
        Comparable<?> comparable2 = spinnerNumberModel.getMinimum();
        if (comparable2 != null) {
            element.setAttribute(ATTR_MINIMUM, comparable2.toString());
        }
        if ((comparable = spinnerNumberModel.getMaximum()) != null) {
            element.setAttribute(ATTR_MAXIMUM, comparable.toString());
        }
        element.setAttribute(ATTR_STEP_SIZE, spinnerNumberModel.getStepSize().toString());
    }

    private static Object readNumberFromXML(Node node) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string = namedNodeMap.getNamedItem(ATTR_NUMBER_TYPE).getNodeValue();
        String string2 = namedNodeMap.getNamedItem(ATTR_INITIAL).getNodeValue();
        Node node2 = namedNodeMap.getNamedItem(ATTR_MINIMUM);
        String string3 = null;
        if (node2 != null) {
            string3 = node2.getNodeValue();
        }
        node2 = namedNodeMap.getNamedItem(ATTR_MAXIMUM);
        String string4 = null;
        if (node2 != null) {
            string4 = node2.getNodeValue();
        }
        String string5 = namedNodeMap.getNamedItem(ATTR_STEP_SIZE).getNodeValue();
        Number number = null;
        Integer n = null;
        Integer n2 = null;
        Number number2 = null;
        if (string.equals("java.lang.Integer")) {
            number2 = Integer.parseInt(string2);
            n = string3 == null ? null : Integer.valueOf(Integer.parseInt(string3));
            n2 = string4 == null ? null : Integer.valueOf(Integer.parseInt(string4));
            number = Integer.parseInt(string5);
        } else if (string.equals("java.lang.Long")) {
            number2 = Long.parseLong(string2);
            n = string3 == null ? null : Long.valueOf(Long.parseLong(string3));
            n2 = string4 == null ? null : Long.valueOf(Long.parseLong(string4));
            number = Long.parseLong(string5);
        } else if (string.equals("java.lang.Float")) {
            number2 = Float.valueOf(Float.parseFloat(string2));
            n = string3 == null ? null : Float.valueOf(Float.parseFloat(string3));
            n2 = string4 == null ? null : Float.valueOf(Float.parseFloat(string4));
            number = Float.valueOf(Float.parseFloat(string5));
        } else if (string.equals("java.lang.Double")) {
            number2 = Double.parseDouble(string2);
            n = string3 == null ? null : Double.valueOf(Double.parseDouble(string3));
            n2 = string4 == null ? null : Double.valueOf(Double.parseDouble(string4));
            number = Double.parseDouble(string5);
        } else if (string.equals("java.lang.Short")) {
            number2 = Short.parseShort(string2);
            n = string3 == null ? null : Short.valueOf(Short.parseShort(string3));
            n2 = string4 == null ? null : Short.valueOf(Short.parseShort(string4));
            number = Short.parseShort(string5);
        } else if (string.equals("java.lang.Byte")) {
            number2 = Byte.parseByte(string2);
            n = string3 == null ? null : Byte.valueOf(Byte.parseByte(string3));
            n2 = string4 == null ? null : Byte.valueOf(Byte.parseByte(string4));
            number = Byte.parseByte(string5);
        }
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(number2, n, n2, number);
        return new FormSpinnerModel(spinnerNumberModel, (Object)number2);
    }

    private static void storeDateToXML(Element element, FormSpinnerModel formSpinnerModel) {
        Object object;
        Date date;
        String string;
        element.setAttribute(ATTR_TYPE, VALUE_TYPE_DATE);
        SpinnerDateModel spinnerDateModel = (SpinnerDateModel)formSpinnerModel.getModel();
        if (formSpinnerModel.isInitialNow()) {
            string = VALUE_NOW;
        } else {
            date = (Date)formSpinnerModel.getInitialValue();
            string = "" + date.getTime();
        }
        element.setAttribute(ATTR_INITIAL, string);
        date = (Date)spinnerDateModel.getStart();
        if (date != null) {
            object = formSpinnerModel.isMinimumNow() ? VALUE_NOW : "" + date.getTime();
            element.setAttribute(ATTR_MINIMUM, (String)object);
        }
        if ((object = (Date)spinnerDateModel.getEnd()) != null) {
            String string2 = formSpinnerModel.isMaximumNow() ? VALUE_NOW : "" + ((Date)object).getTime();
            element.setAttribute(ATTR_MAXIMUM, string2);
        }
        element.setAttribute(ATTR_STEP_SIZE, "" + spinnerDateModel.getCalendarField());
    }

    private static Object readDateFromXML(Node node) {
        Date date;
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string = namedNodeMap.getNamedItem(ATTR_INITIAL).getNodeValue();
        Date date2 = new Date();
        boolean bl = false;
        if (VALUE_NOW.equals(string)) {
            bl = true;
            date = date2;
        } else {
            date = new Date(Long.parseLong(string));
        }
        Node node2 = namedNodeMap.getNamedItem(ATTR_MINIMUM);
        String string2 = node2 == null ? null : node2.getNodeValue();
        boolean bl2 = false;
        Date date3 = null;
        if (string2 != null) {
            if (VALUE_NOW.equals(string2)) {
                bl2 = true;
                date3 = date2;
            } else {
                date3 = new Date(Long.parseLong(string2));
            }
        }
        String string3 = (node2 = namedNodeMap.getNamedItem(ATTR_MAXIMUM)) == null ? null : node2.getNodeValue();
        boolean bl3 = false;
        Date date4 = null;
        if (string3 != null) {
            if (VALUE_NOW.equals(string3)) {
                bl3 = true;
                date4 = date2;
            } else {
                date4 = new Date(Long.parseLong(string3));
            }
        }
        String string4 = namedNodeMap.getNamedItem(ATTR_STEP_SIZE).getNodeValue();
        int n = Integer.parseInt(string4);
        SpinnerDateModel spinnerDateModel = new SpinnerDateModel(date, date3, date4, n);
        return new FormSpinnerModel(spinnerDateModel, date, bl, bl2, bl3);
    }

    private static void storeListToXML(Document document, Element element, FormSpinnerModel formSpinnerModel) {
        element.setAttribute(ATTR_TYPE, VALUE_TYPE_LIST);
        SpinnerListModel spinnerListModel = (SpinnerListModel)formSpinnerModel.getModel();
        List<?> list = spinnerListModel.getList();
        for (Object obj : list) {
            Element element2 = document.createElement(XML_LIST_ITEM);
            element2.setAttribute(ATTR_VALUE, obj.toString());
            element.appendChild(element2);
        }
    }

    private static Object readListFromXML(Node node) {
        NodeList nodeList = node.getChildNodes();
        LinkedList<String> linkedList = new LinkedList<String>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!XML_LIST_ITEM.equals(node2.getNodeName())) continue;
            linkedList.add(node2.getAttributes().getNamedItem(ATTR_VALUE).getNodeValue());
        }
        SpinnerListModel spinnerListModel = new SpinnerListModel(linkedList);
        return new FormSpinnerModel(spinnerListModel, linkedList.get(0));
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(this.getClass(), (String)"SpinnerModelEditor");
    }

    @Override
    public void setContext(FormModel formModel, FormProperty formProperty) {
        this.property = formProperty;
    }

    @Override
    public void updateFormVersionLevel() {
        this.property.getPropertyContext().getFormModel().raiseVersionLevel(FormModel.FormVersion.NB60, FormModel.FormVersion.NB60);
    }

    public static class FormSpinnerModel
    extends FormDesignValueAdapter {
        private SpinnerModel model;
        private Object initialValue;
        private boolean initialNow;
        private boolean minimumNow;
        private boolean maximumNow;

        public FormSpinnerModel(SpinnerListModel spinnerListModel, Object object) {
            this.model = spinnerListModel;
            this.initialValue = object;
        }

        public FormSpinnerModel(SpinnerNumberModel spinnerNumberModel, Object object) {
            this.model = spinnerNumberModel;
            this.initialValue = object;
        }

        public FormSpinnerModel(SpinnerDateModel spinnerDateModel, Object object, boolean bl, boolean bl2, boolean bl3) {
            this.model = spinnerDateModel;
            this.initialValue = object;
            this.initialNow = bl;
            this.minimumNow = bl2;
            this.maximumNow = bl3;
        }

        public SpinnerModel getModel() {
            return this.model;
        }

        public Object getInitialValue() {
            return this.initialValue;
        }

        public boolean isInitialNow() {
            return this.initialNow;
        }

        public boolean isMinimumNow() {
            return this.minimumNow;
        }

        public boolean isMaximumNow() {
            return this.maximumNow;
        }

        public SpinnerModel getDesignValue() {
            return this.model;
        }
    }

    private class FormListener
    implements ActionListener,
    FocusListener,
    ChangeListener {
        FormListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == SpinnerModelEditor.this.modelTypeCombo) {
                SpinnerModelEditor.this.modelTypeComboActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == SpinnerModelEditor.this.initialNowCheckBox) {
                SpinnerModelEditor.this.initialNowCheckBoxActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == SpinnerModelEditor.this.minimumDateCheckBox) {
                SpinnerModelEditor.this.minimumDateCheckBoxActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == SpinnerModelEditor.this.minimumNowCheckBox) {
                SpinnerModelEditor.this.minimumNowCheckBoxActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == SpinnerModelEditor.this.maximumDateCheckBox) {
                SpinnerModelEditor.this.maximumDateCheckBoxActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == SpinnerModelEditor.this.maximumNowCheckBox) {
                SpinnerModelEditor.this.maximumNowCheckBoxActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == SpinnerModelEditor.this.calendarFieldCombo) {
                SpinnerModelEditor.this.calendarFieldComboActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == SpinnerModelEditor.this.initialListCombo) {
                SpinnerModelEditor.this.initialListComboActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == SpinnerModelEditor.this.numberTypeCombo) {
                SpinnerModelEditor.this.numberTypeComboActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == SpinnerModelEditor.this.minimumNumberCheckBox) {
                SpinnerModelEditor.this.minimumNumberCheckBoxActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == SpinnerModelEditor.this.maximumNumberCheckBox) {
                SpinnerModelEditor.this.maximumNumberCheckBoxActionPerformed(actionEvent);
            }
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            if (focusEvent.getSource() == SpinnerModelEditor.this.listItemsArea) {
                SpinnerModelEditor.this.listItemsAreaFocusLost(focusEvent);
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent.getSource() == SpinnerModelEditor.this.initialDateSpinner) {
                SpinnerModelEditor.this.initialDateSpinnerStateChanged(changeEvent);
            } else if (changeEvent.getSource() == SpinnerModelEditor.this.minimumDateSpinner) {
                SpinnerModelEditor.this.minimumDateSpinnerStateChanged(changeEvent);
            } else if (changeEvent.getSource() == SpinnerModelEditor.this.maximumDateSpinner) {
                SpinnerModelEditor.this.maximumDateSpinnerStateChanged(changeEvent);
            } else if (changeEvent.getSource() == SpinnerModelEditor.this.initialNumberSpinner) {
                SpinnerModelEditor.this.initialNumberSpinnerStateChanged(changeEvent);
            } else if (changeEvent.getSource() == SpinnerModelEditor.this.minimumNumberSpinner) {
                SpinnerModelEditor.this.minimumNumberSpinnerStateChanged(changeEvent);
            } else if (changeEvent.getSource() == SpinnerModelEditor.this.maximumNumberSpinner) {
                SpinnerModelEditor.this.maximumNumberSpinnerStateChanged(changeEvent);
            } else if (changeEvent.getSource() == SpinnerModelEditor.this.stepSizeSpinner) {
                SpinnerModelEditor.this.stepSizeSpinnerStateChanged(changeEvent);
            }
        }
    }
}

