/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.menu;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TooManyListenersException;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.PopupMenuUI;
import org.netbeans.modules.form.ComponentInspector;
import org.netbeans.modules.form.FormDesigner;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormModelEvent;
import org.netbeans.modules.form.FormModelListener;
import org.netbeans.modules.form.MetaComponentCreator;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADComponentNode;
import org.netbeans.modules.form.RADProperty;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.ResourceValue;
import org.netbeans.modules.form.actions.PropertyAction;
import org.netbeans.modules.form.editors.IconEditor;
import org.netbeans.modules.form.menu.DragOperation;
import org.netbeans.modules.form.menu.DropTargetLayer;
import org.netbeans.modules.form.menu.KeyboardMenuNavigator;
import org.netbeans.modules.form.menu.VisualDesignerJPanelPopup;
import org.netbeans.modules.form.menu.VisualDesignerPopupFactory;
import org.netbeans.modules.form.menu.VisualDesignerPopupMenuUI;
import org.netbeans.modules.form.palette.PaletteItem;
import org.netbeans.modules.form.palette.PaletteUtils;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOp;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MenuEditLayer
extends JPanel {
    public static final Border DRAG_MENU_BORDER = BorderFactory.createLineBorder(Color.BLACK, 1);
    public static final Border DRAG_SEPARATOR_BORDER = BorderFactory.createLineBorder(Color.RED, 1);
    public static final Color SELECTED_MENU_BACKGROUND = new Color(10856105);
    public static final Color EMPTY_ICON_COLOR = new Color(0xDDDDDD);
    public static final int EMPTY_ICON_BORDER_WIDTH = 2;
    private static final boolean USE_NEW_ITEM_COLOR_SWITCHING = false;
    VisualDesignerPopupFactory hackedPopupFactory = null;
    FormDesigner formDesigner;
    JLayeredPane layers;
    JComponent glassLayer;
    DropTargetLayer dropTargetLayer;
    boolean showMenubarWarning = false;
    private Map<JMenu, PopupMenuUI> menuPopupUIMap;
    private SelectedPortion selectedPortion = SelectedPortion.None;
    private KeyboardMenuNavigator keyboardMenuNavigator;
    private Map<RADVisualContainer, FormModelListener> formModelListeners;
    private DragOperation dragop;
    private FormModelListener menuBarFormListener;
    private PropertyChangeListener selectionListener;
    private boolean isAlive = true;
    private static final boolean USE_JSEPARATOR_FIX = true;
    PropertyChangeListener paletteListener = null;
    FileObject paletteContext = null;
    static final int ACCEL_PREVIEW_WIDTH = 80;
    private static final Border accel_border = new Border(){

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.setColor(Color.WHITE);
            int n5 = 5;
            if (DropTargetLayer.isAqua()) {
                n5 = 2;
            }
            int n6 = 0;
            if (DropTargetLayer.isVista()) {
                n6 = -2;
            }
            graphics.fillRect(n3 - 80 + n5, 1, 80 + n6, n4 + n6);
            graphics.setColor(EMPTY_ICON_COLOR);
            graphics.drawRect(n3 - 80 + n5, 1, 79 + n6, n4 + n6);
            graphics.drawRect(n3 - 80 + n5 + 1, 2, 77 + n6, n4 - 2 + n6);
            graphics.setColor(Color.LIGHT_GRAY);
            graphics.setFont(new Font("SansSerif", 0, 10));
            String string = NbBundle.getMessage(MenuEditLayer.class, (String)"MENU_Shortcut");
            graphics.drawString(string, n3 - 80 + 15, n4 - 3 + n6);
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(0, 0, 0, 80);
        }

        public boolean isBorderOpaque() {
            return true;
        }
    };
    private List<RADComponent> selectedComponents = new ArrayList<RADComponent>();
    private Map<JComponent, Color> backgroundMap = new HashMap<JComponent, Color>();
    private JComponent prevRollover = null;
    private boolean dragProxying = false;

    public MenuEditLayer(FormDesigner formDesigner) {
        this.formDesigner = formDesigner;
        this.menuPopupUIMap = new HashMap<JMenu, PopupMenuUI>();
        this.formModelListeners = new HashMap<RADVisualContainer, FormModelListener>();
        this.layers = new JLayeredPane();
        this.setLayout(new BorderLayout());
        this.add((Component)this.layers, "Center");
        this.dragop = new DragOperation(this);
        this.glassLayer = new JComponent(){

            public void paintComponent(Graphics graphics) {
            }
        };
        this.layers.add((Component)this.glassLayer, new Integer(500));
        this.glassLayer.setSize(400, 400);
        this.dropTargetLayer = new DropTargetLayer(this);
        this.layers.add((Component)this.dropTargetLayer, new Integer(JLayeredPane.DRAG_LAYER - 5));
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                MenuEditLayer.this.glassLayer.setSize(MenuEditLayer.this.getSize());
                MenuEditLayer.this.dropTargetLayer.setSize(MenuEditLayer.this.getSize());
            }
        });
        GlassLayerMouseListener glassLayerMouseListener = new GlassLayerMouseListener();
        this.glassLayer.addMouseListener(glassLayerMouseListener);
        this.glassLayer.addMouseMotionListener(glassLayerMouseListener);
        this.configureSelectionListener();
    }

    DragOperation getDragOperation() {
        return this.dragop;
    }

    public static boolean isMenuRelatedRADComponent(RADComponent rADComponent) {
        if (rADComponent == null) {
            return false;
        }
        return MenuEditLayer.isMenuRelatedComponentClass(rADComponent.getBeanClass());
    }

    public static boolean isNonMenuJSeparator(RADComponent rADComponent) {
        if (rADComponent == null) {
            return false;
        }
        if (JSeparator.class.isAssignableFrom(rADComponent.getBeanClass())) {
            RADComponent rADComponent2 = rADComponent.getParentComponent();
            return rADComponent2 == null || !JMenu.class.isAssignableFrom(rADComponent2.getBeanClass());
        }
        return false;
    }

    public static boolean isMenuBarContainer(RADComponent rADComponent) {
        if (rADComponent == null) {
            return false;
        }
        Class<? extends Object> clazz = rADComponent.getBeanClass();
        if (clazz == null) {
            return false;
        }
        return JMenuBar.class.isAssignableFrom(clazz);
    }

    public static boolean isMenuRelatedContainer(RADComponent rADComponent) {
        if (rADComponent == null) {
            return false;
        }
        Class<? extends Object> clazz = rADComponent.getBeanClass();
        if (clazz == null) {
            return false;
        }
        if (JMenu.class.isAssignableFrom(clazz)) {
            return true;
        }
        return JPopupMenu.class.isAssignableFrom(clazz);
    }

    public static boolean isMenuRelatedComponentClass(Class clazz) {
        if (clazz == null) {
            return false;
        }
        if (JMenuItem.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (JMenu.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (JSeparator.class.isAssignableFrom(clazz)) {
            return true;
        }
        return JMenuBar.class.isAssignableFrom(clazz);
    }

    public boolean isPossibleNewMenuComponent(PaletteItem paletteItem) {
        if (paletteItem == null) {
            return false;
        }
        if (paletteItem.getComponentClass() == null) {
            return false;
        }
        return JMenuItem.class.isAssignableFrom(paletteItem.getComponentClass());
    }

    public void startNewMenuComponentPickAndPlop(PaletteItem paletteItem, Point point) {
        this.setVisible(true);
        this.requestFocus();
        this.dragop = new DragOperation(this);
        this.dragop.start(paletteItem, point);
    }

    public void startNewMenuComponentDragAndDrop(PaletteItem paletteItem) {
        this.setVisible(true);
        this.requestFocus();
        this.configureGlassLayer();
        this.configureFormListeners();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setColor(Color.BLACK);
        graphics2D.dispose();
    }

    public void openAndShowMenu(RADComponent rADComponent, Component component) {
        if (this.hackedPopupFactory == null) {
            this.hackedPopupFactory = new VisualDesignerPopupFactory(this);
        }
        this.openMenu(rADComponent, component);
        this.glassLayer.requestFocusInWindow();
    }

    void openMenu(RADComponent rADComponent, Component component) {
        this.getPopupFactory();
        this.configureGlassLayer();
        this.registerKeyListeners();
        this.configureFormListeners();
        this.configureSelectionListener();
        JMenu jMenu = (JMenu)component;
        this.configureMenu(null, jMenu);
        this.showMenuPopup(jMenu);
        if (rADComponent instanceof RADVisualContainer) {
            this.keyboardMenuNavigator.setCurrentMenuRAD((RADVisualContainer)rADComponent);
        }
    }

    public void hideMenuLayer() {
        this.unconfigureFormListeners();
        this.unconfigureSelectionListener();
        for (JMenu jMenu : this.menuPopupUIMap.keySet()) {
            this.unconfigureMenu(jMenu);
        }
        this.menuPopupUIMap.clear();
        if (this.hackedPopupFactory != null) {
            this.hackedPopupFactory.containerMap.clear();
            this.hackedPopupFactory = null;
        }
        if (this.dragop.isStarted()) {
            this.dragop.fastEnd();
        }
        this.setVisible(false);
        if (this.keyboardMenuNavigator != null) {
            this.glassLayer.removeKeyListener(this.keyboardMenuNavigator);
            this.keyboardMenuNavigator.unconfigure();
            this.keyboardMenuNavigator = null;
        }
        this.backgroundMap.clear();
        if (this.formDesigner.getHandleLayer() != null) {
            this.formDesigner.getHandleLayer().requestFocusInWindow();
        }
    }

    private synchronized void registerKeyListeners() {
        if (this.keyboardMenuNavigator == null) {
            this.keyboardMenuNavigator = new KeyboardMenuNavigator(this);
            this.glassLayer.addKeyListener(this.keyboardMenuNavigator);
            this.glassLayer.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 27) {
                        MenuEditLayer.this.dragop.fastEnd();
                    }
                }
            });
        }
    }

    private VisualDesignerPopupFactory getPopupFactory() {
        if (this.hackedPopupFactory == null) {
            this.hackedPopupFactory = new VisualDesignerPopupFactory(this);
        }
        return this.hackedPopupFactory;
    }

    private void configureGlassLayer() {
        try {
            this.glassLayer.setDropTarget(new DropTarget());
            this.glassLayer.getDropTarget().addDropTargetListener(new GlassLayerDropTargetListener());
        }
        catch (TooManyListenersException tooManyListenersException) {
            tooManyListenersException.printStackTrace();
        }
    }

    private void configureFormListeners() {
        if (this.menuBarFormListener == null) {
            this.menuBarFormListener = new FormModelListener(){

                public void formChanged(FormModelEvent[] formModelEventArray) {
                    if (formModelEventArray != null) {
                        for (FormModelEvent formModelEvent : formModelEventArray) {
                            if (formModelEvent.getChangeType() == 8 && formModelEvent.getComponent() != null && JMenuBar.class.isAssignableFrom(formModelEvent.getComponent().getBeanClass())) {
                                MenuEditLayer.this.hideMenuLayer();
                            }
                            if (formModelEvent.getChangeType() == 3) {
                                MenuEditLayer.this.hideMenuLayer();
                                MenuEditLayer.this.isAlive = false;
                            }
                            if (formModelEvent.getChangeType() == 7 && !formModelEvent.getCreatedDeleted()) continue;
                        }
                    }
                }
            };
            this.formDesigner.getFormModel().addFormModelListener(this.menuBarFormListener);
        }
        if (this.paletteListener == null) {
            this.paletteListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ((PaletteUtils.getSelectedItem() == null || !MenuEditLayer.isMenuRelatedComponentClass(PaletteUtils.getSelectedItem().getComponentClass())) && MenuEditLayer.this.dragop != null && MenuEditLayer.this.dragop.isStarted()) {
                        MenuEditLayer.this.dragop.fastEnd();
                    }
                }
            };
            this.paletteContext = this.formDesigner.getFormEditor().getFormDataObject().getFormFile();
            PaletteUtils.addPaletteListener(this.paletteListener, this.paletteContext);
        }
    }

    private void unconfigureFormListeners() {
        if (this.menuBarFormListener != null && this.formDesigner != null && this.formDesigner.getFormModel() != null) {
            this.formDesigner.getFormModel().removeFormModelListener(this.menuBarFormListener);
        }
        if (this.paletteListener != null) {
            PaletteUtils.removePaletteListener(this.paletteListener, this.paletteContext);
            this.paletteContext = null;
            this.paletteListener = null;
        }
        this.menuBarFormListener = null;
    }

    private void configureSelectionListener() {
        if (this.selectionListener == null) {
            this.selectionListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (!MenuEditLayer.this.isAlive) {
                        return;
                    }
                    Node[] nodeArray = (Node[])propertyChangeEvent.getNewValue();
                    ArrayList<RADComponent> arrayList = new ArrayList<RADComponent>();
                    for (Node node : nodeArray) {
                        if (!(node instanceof RADComponentNode)) continue;
                        RADComponentNode rADComponentNode = (RADComponentNode)node;
                        arrayList.add(rADComponentNode.getRADComponent());
                    }
                    MenuEditLayer.this.setSelectedRADComponents(arrayList);
                }
            };
            this.formDesigner.addPropertyChangeListener("activatedNodes", this.selectionListener);
        }
    }

    private void unconfigureSelectionListener() {
        if (this.selectionListener != null) {
            this.formDesigner.removePropertyChangeListener("activatedNodes", this.selectionListener);
            this.selectionListener = null;
        }
    }

    void showMenuPopup(final JMenu jMenu) {
        this.getPopupFactory();
        if (this.hackedPopupFactory.containerMap.containsKey(jMenu)) {
            JPanel jPanel = this.hackedPopupFactory.containerMap.get(jMenu);
            jPanel.setVisible(true);
        } else {
            JPopupMenu jPopupMenu;
            if (!this.isConfigured(jMenu)) {
                this.configureMenu(null, jMenu);
            }
            if (!((jPopupMenu = jMenu.getPopupMenu()).getUI() instanceof VisualDesignerPopupMenuUI)) {
                jPopupMenu.setUI(new VisualDesignerPopupMenuUI(this, jPopupMenu.getUI()));
            }
            if (jMenu.isShowing()) {
                this.hackedPopupFactory.getPopup(jMenu, null, 0, 0);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        try {
                            jPopupMenu.show(jMenu, 0, jMenu.getHeight());
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                });
            }
        }
        this.validate();
    }

    public boolean isMenuLayerComponent(RADComponent rADComponent) {
        if (rADComponent == null) {
            return false;
        }
        if (rADComponent.getBeanClass().equals(JMenuItem.class)) {
            return true;
        }
        return rADComponent.getBeanClass().equals(JMenu.class);
    }

    void configureMenu(JComponent jComponent, JMenu jMenu) {
        jMenu.setBorderPainted(true);
        if (!MenuEditLayer.isTopLevelMenu(jMenu) && !(jMenu.getIcon() instanceof WrapperIcon)) {
            jMenu.setIcon(new WrapperIcon(jMenu.getIcon()));
        }
        JPopupMenu jPopupMenu = jMenu.getPopupMenu();
        this.menuPopupUIMap.put(jMenu, jPopupMenu.getUI());
        jPopupMenu.setUI(new VisualDesignerPopupMenuUI(this, jPopupMenu.getUI()));
        Component[] componentArray = jMenu.getMenuComponents();
        JPanel jPanel = this.getPopupFactory().containerMap.get(jMenu);
        if (jPanel != null) {
            componentArray = jPanel.getComponents();
        }
        RADVisualContainer rADVisualContainer = (RADVisualContainer)this.formDesigner.getMetaComponent(jMenu);
        this.registerForm(rADVisualContainer, jMenu);
        for (Component component : componentArray) {
            if (component instanceof JMenu) {
                this.configureMenu(jMenu, (JMenu)component);
                RADComponent rADComponent = this.formDesigner.getMetaComponent(component);
                this.registerForm((RADVisualContainer)rADComponent, (JMenu)component);
                continue;
            }
            this.configureMenuItem(jMenu, (JComponent)component);
        }
    }

    private void unconfigureMenu(JMenu jMenu) {
        Object object;
        jMenu.getPopupMenu().setUI(this.menuPopupUIMap.get(jMenu));
        JPanel jPanel = this.hackedPopupFactory.containerMap.get(jMenu);
        if (jPanel != null) {
            object = jPanel.getComponents();
            int n = ((Component[])object).length;
            for (int i = 0; i < n; ++i) {
                Object object2 = object[i];
                if (object2 instanceof JMenu) {
                    this.unconfigureMenu((JMenu)object2);
                    continue;
                }
                this.unconfigureMenuItem((JComponent)object2);
            }
            if (jMenu.getPopupMenu() != null) {
                jMenu.getPopupMenu().setVisible(false);
            }
            jPanel.setVisible(false);
        }
        if ((object = this.hackedPopupFactory.getPopup(jMenu)) != null) {
            ((VisualDesignerJPanelPopup)object).hide();
        }
        if (jPanel != null) {
            jPanel.setVisible(false);
        }
        jMenu.setPopupMenuVisible(false);
        this.hackedPopupFactory.containerMap.remove(jMenu);
    }

    private boolean isConfigured(JComponent jComponent) {
        return this.menuPopupUIMap.containsKey(jComponent);
    }

    void configureMenuItem(JMenu jMenu, JComponent jComponent) {
        if (jComponent instanceof JMenuItem) {
            JMenuItem jMenuItem = (JMenuItem)jComponent;
            if (!(jMenuItem.getIcon() instanceof WrapperIcon)) {
                jMenuItem.setIcon(new WrapperIcon(jMenuItem.getIcon()));
            }
            MenuEditLayer.installAcceleratorPreview(jMenuItem);
            jMenuItem.setBorderPainted(true);
        }
    }

    private static void installAcceleratorPreview(JMenuItem jMenuItem) {
        CompoundBorder compoundBorder;
        if (jMenuItem instanceof JMenu) {
            return;
        }
        boolean bl = false;
        if (jMenuItem.getAccelerator() != null) {
            bl = true;
        }
        if (jMenuItem.getAction() != null && jMenuItem.getAction().getValue("AcceleratorKey") != null) {
            bl = true;
        }
        boolean bl2 = false;
        if (jMenuItem.getBorder() == accel_border) {
            bl2 = true;
            if (bl) {
                jMenuItem.setBorder(null);
                return;
            }
        }
        if (jMenuItem.getBorder() instanceof CompoundBorder && (compoundBorder = (CompoundBorder)jMenuItem.getBorder()).getInsideBorder() == accel_border) {
            bl2 = true;
            if (bl) {
                jMenuItem.setBorder(compoundBorder.getOutsideBorder());
                return;
            }
        }
        if (bl2) {
            return;
        }
        if (bl) {
            return;
        }
        if (jMenuItem.getBorder() == null) {
            jMenuItem.setBorder(accel_border);
            return;
        }
        jMenuItem.setBorder(BorderFactory.createCompoundBorder(jMenuItem.getBorder(), accel_border));
    }

    void unconfigureMenuItem(JComponent jComponent) {
    }

    @Override
    public boolean isOpaque() {
        return false;
    }

    boolean isAncestor(JComponent jComponent, JComponent jComponent2) {
        if (!(jComponent2 instanceof JMenu)) {
            return false;
        }
        RADComponent rADComponent = this.formDesigner.getMetaComponent(jComponent);
        RADComponent rADComponent2 = rADComponent.getParentComponent();
        if (rADComponent2 == null) {
            return false;
        }
        Object object = this.formDesigner.getComponent(rADComponent2);
        RADComponent rADComponent3 = this.formDesigner.getMetaComponent(jComponent2);
        if (rADComponent2 == rADComponent3) {
            return true;
        }
        if (jComponent2 == object) {
            return true;
        }
        if (object instanceof JMenu) {
            return this.isAncestor((JMenu)object, jComponent2);
        }
        return false;
    }

    boolean hasSelectedDescendants(JMenu jMenu) {
        RADComponent rADComponent = this.formDesigner.getMetaComponent(jMenu);
        if (rADComponent instanceof RADVisualContainer) {
            return this.hasSelectedDescendants((RADVisualContainer)rADComponent);
        }
        return false;
    }

    boolean hasSelectedDescendants(RADVisualContainer rADVisualContainer) {
        if (this.selectedComponents.contains(rADVisualContainer)) {
            return true;
        }
        for (RADComponent rADComponent : rADVisualContainer.getSubBeans()) {
            boolean bl;
            if (this.selectedComponents.contains(rADComponent)) {
                return true;
            }
            if (!(rADComponent instanceof RADVisualContainer) || !(bl = this.hasSelectedDescendants((RADVisualContainer)rADComponent))) continue;
            return true;
        }
        return false;
    }

    JComponent getMenuParent(JComponent jComponent) {
        Object object;
        RADComponent rADComponent = this.formDesigner.getMetaComponent(jComponent);
        RADComponent rADComponent2 = rADComponent.getParentComponent();
        if (rADComponent2 != null && (object = this.formDesigner.getComponent(rADComponent2)) instanceof JComponent) {
            return (JComponent)object;
        }
        return null;
    }

    List<RADComponent> getSelectedRADComponents() {
        return Collections.unmodifiableList(this.selectedComponents);
    }

    RADComponent getSingleSelectedComponent() {
        if (this.selectedComponents.isEmpty()) {
            return null;
        }
        if (this.selectedComponents.size() > 1) {
            this.setSelectedRADComponent(this.selectedComponents.get(0));
        }
        return this.selectedComponents.get(0);
    }

    boolean isComponentSelected() {
        return !this.selectedComponents.isEmpty();
    }

    void setSelectedRADComponent(RADComponent rADComponent) {
        ArrayList<RADComponent> arrayList = new ArrayList<RADComponent>();
        arrayList.add(rADComponent);
        this.setSelectedRADComponents(arrayList);
        this.formDesigner.setSelectedComponent(rADComponent);
    }

    void addSelectedRADComponent(RADComponent rADComponent) {
        ArrayList<RADComponent> arrayList = new ArrayList<RADComponent>();
        arrayList.addAll(this.selectedComponents);
        arrayList.add(rADComponent);
        this.setSelectedRADComponents(arrayList);
        this.formDesigner.addComponentToSelection(rADComponent);
    }

    void setSelectedRADComponents(List<RADComponent> list) {
        try {
            JComponent jComponent;
            for (RADComponent rADComponent : this.selectedComponents) {
                if (!MenuEditLayer.isMenuRelatedRADComponent(rADComponent) || MenuEditLayer.isMenuBarContainer(rADComponent) || MenuEditLayer.isNonMenuJSeparator(rADComponent) || (jComponent = (JComponent)this.formDesigner.getComponent(rADComponent)) == null) continue;
                jComponent.setBackground(this.getNormalBackground(rADComponent, jComponent));
            }
            this.selectedComponents.clear();
            this.selectedComponents.addAll(list);
            for (RADComponent rADComponent : this.selectedComponents) {
                if (MenuEditLayer.isMenuRelatedRADComponent(rADComponent) && !MenuEditLayer.isNonMenuJSeparator(rADComponent)) continue;
                this.setVisible(false);
                return;
            }
            this.registerKeyListeners();
            for (RADComponent rADComponent : this.selectedComponents) {
                jComponent = (JComponent)this.formDesigner.getComponent(rADComponent);
                if (jComponent == null) continue;
                if (!MenuEditLayer.isMenuBarContainer(rADComponent)) {
                    jComponent.setBackground(this.getSelectedBackground(jComponent));
                }
                this.makeSureShowingOnScreen(rADComponent, jComponent);
                if (!(jComponent instanceof JMenu)) continue;
                this.showMenuPopup((JMenu)jComponent);
            }
            this.repaint();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String getComponentDefaultsPrefix(JComponent jComponent) {
        if (jComponent instanceof JMenuBar) {
            return "MenuBar";
        }
        if (jComponent instanceof JMenu) {
            return "Menu";
        }
        if (jComponent instanceof JCheckBoxMenuItem) {
            return "CheckBoxMenuItem";
        }
        if (jComponent instanceof JRadioButtonMenuItem) {
            return "RadioButtonMenuItem";
        }
        return "MenuItem";
    }

    private Color getNormalBackground(RADComponent rADComponent, JComponent jComponent) {
        RADProperty rADProperty = rADComponent.getBeanProperty("background");
        Color color = null;
        if (rADProperty != null) {
            try {
                Object object = rADProperty.getTargetValue();
                if (object instanceof Color) {
                    color = (Color)object;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (color == null) {
            color = this.backgroundMap.get(jComponent);
        }
        return color;
    }

    private Color getSelectedBackground(JComponent jComponent) {
        if (!this.backgroundMap.containsKey(jComponent)) {
            this.backgroundMap.put(jComponent, jComponent.getBackground());
        }
        return SELECTED_MENU_BACKGROUND;
    }

    private Color getNormalForeground(JComponent jComponent) {
        String string = this.getComponentDefaultsPrefix(jComponent);
        Color color = UIManager.getDefaults().getColor(string + ".foreground");
        if (color == null) {
            color = Color.BLACK;
        }
        return color;
    }

    private void makeSureShowingOnScreen(RADComponent rADComponent, JComponent jComponent) {
        if (!this.isVisible()) {
            this.setVisible(true);
            this.registerKeyListeners();
            if (rADComponent instanceof RADVisualContainer) {
                this.keyboardMenuNavigator.setCurrentMenuRAD((RADVisualContainer)rADComponent);
            } else {
                this.keyboardMenuNavigator.setCurrentMenuRAD((RADVisualContainer)rADComponent.getParentComponent());
            }
        }
        ArrayList<RADComponent> arrayList = new ArrayList<RADComponent>();
        RADComponent rADComponent2 = rADComponent.getParentComponent();
        while (rADComponent2 != null) {
            arrayList.add(rADComponent2);
            if (MenuEditLayer.isMenuRelatedRADComponent(rADComponent2 = rADComponent2.getParentComponent())) continue;
        }
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            RADComponent rADComponent3 = (RADComponent)arrayList.get(i);
            JComponent jComponent2 = (JComponent)this.formDesigner.getComponent(rADComponent3);
            if (!(jComponent2 instanceof JMenu)) continue;
            this.showMenuPopup((JMenu)jComponent2);
        }
    }

    private void showContextMenu(Point point) {
        ComponentInspector componentInspector = ComponentInspector.getInstance();
        Node[] nodeArray = componentInspector.getSelectedNodes();
        JPopupMenu jPopupMenu = NodeOp.findContextMenu((Node[])nodeArray);
        if (!this.isVisible()) {
            this.setVisible(true);
        }
        if (jPopupMenu != null) {
            jPopupMenu.show(this, point.x, point.y);
        }
    }

    public boolean canHighlightContainer(RADVisualContainer rADVisualContainer, RADVisualComponent rADVisualComponent) {
        Class<? extends Object> clazz = rADVisualComponent.getBeanClass();
        return rADVisualContainer != null && rADVisualContainer.isMenuComponent() && rADVisualContainer.canAddComponent(clazz);
    }

    public void rolloverContainer(RADVisualContainer rADVisualContainer) {
        if (rADVisualContainer == null && this.prevRollover != null) {
            this.clearRollover();
        }
        if (rADVisualContainer != null) {
            JComponent jComponent = (JComponent)this.formDesigner.getComponent(rADVisualContainer);
            if (jComponent != this.prevRollover) {
                this.clearRollover();
            }
            this.prevRollover = jComponent;
            this.prevRollover.setBorder(new Border(){

                public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    graphics2D.setStroke(DropTargetLayer.DROP_TARGET_LINE_STROKE);
                    graphics2D.setColor(DropTargetLayer.DROP_TARGET_COLOR);
                    graphics2D.drawRect(n, n2, n3, n4);
                }

                public Insets getBorderInsets(Component component) {
                    return new Insets(2, 2, 2, 2);
                }

                public boolean isBorderOpaque() {
                    return false;
                }
            });
            this.prevRollover.repaint();
            if (jComponent instanceof JMenu) {
                this.formDesigner.openMenu(rADVisualContainer);
            }
        }
    }

    public void clearRollover() {
        if (this.prevRollover == null) {
            return;
        }
        this.prevRollover.setBorder(BorderFactory.createEmptyBorder());
        this.prevRollover.repaint();
        this.prevRollover = null;
    }

    void addRadComponentToBefore(RADVisualComponent rADVisualComponent, JComponent jComponent) {
        this.addRadComponentTo(rADVisualComponent, jComponent, 0);
    }

    void addRadComponentToAfter(RADVisualComponent rADVisualComponent, JComponent jComponent) {
        this.addRadComponentTo(rADVisualComponent, jComponent, 1);
    }

    private void addRadComponentTo(RADVisualComponent rADVisualComponent, JComponent jComponent, int n) {
        try {
            JComponent jComponent2 = this.getMenuParent(jComponent);
            if (jComponent.getParent() instanceof JMenuBar) {
                jComponent2 = (JComponent)jComponent.getParent();
            }
            RADVisualComponent rADVisualComponent2 = (RADVisualComponent)this.formDesigner.getMetaComponent(jComponent);
            RADVisualContainer rADVisualContainer = (RADVisualContainer)this.formDesigner.getMetaComponent(jComponent2);
            assert (rADVisualContainer != null);
            int n2 = rADVisualContainer.getIndexOf(rADVisualComponent2) + n;
            this.formDesigner.getFormModel().fireComponentAdded(rADVisualComponent, false);
            this.formDesigner.getFormModel().addVisualComponent(rADVisualComponent, rADVisualContainer, new Integer(n2), true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    boolean addRadComponentToEnd(JComponent jComponent, MetaComponentCreator metaComponentCreator) {
        RADVisualContainer rADVisualContainer = (RADVisualContainer)this.formDesigner.getMetaComponent(jComponent);
        Object var4_4 = null;
        boolean bl = metaComponentCreator.addPrecreatedComponent(rADVisualContainer, var4_4);
        return bl;
    }

    void moveRadComponentInto(JComponent jComponent, JComponent jComponent2) {
        try {
            if (jComponent == jComponent2) {
                return;
            }
            if (this.isAncestor(jComponent2, jComponent)) {
                return;
            }
            JComponent jComponent3 = this.getMenuParent(jComponent);
            if (jComponent3 == null) {
                jComponent3 = (JComponent)jComponent.getParent();
            }
            RADVisualComponent rADVisualComponent = (RADVisualComponent)this.formDesigner.getMetaComponent(jComponent);
            RADVisualContainer rADVisualContainer = (RADVisualContainer)this.formDesigner.getMetaComponent(jComponent3);
            if (rADVisualComponent != null && rADVisualContainer != null) {
                int n = rADVisualContainer.getIndexOf(rADVisualComponent);
                rADVisualContainer.remove(rADVisualComponent);
                this.formDesigner.getFormModel().fireComponentRemoved(rADVisualComponent, rADVisualContainer, n, false);
            }
            RADVisualContainer rADVisualContainer2 = (RADVisualContainer)this.formDesigner.getMetaComponent(jComponent2);
            rADVisualContainer2.add(rADVisualComponent, -1);
            rADVisualContainer2.getLayoutSupport().addComponents(new RADVisualComponent[]{rADVisualComponent}, null, -1);
            this.formDesigner.getFormModel().fireComponentAdded(rADVisualComponent, false);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    void moveRadComponentToBefore(JComponent jComponent, JComponent jComponent2) {
        this.moveRadComponentTo(jComponent, jComponent2, 0);
    }

    void moveRadComponentToAfter(JComponent jComponent, JComponent jComponent2) {
        this.moveRadComponentTo(jComponent, jComponent2, 1);
    }

    private void moveRadComponentTo(JComponent jComponent, JComponent jComponent2, int n) {
        try {
            int n2;
            if (jComponent == jComponent2) {
                return;
            }
            if (this.isAncestor(jComponent2, jComponent)) {
                return;
            }
            JComponent jComponent3 = this.getMenuParent(jComponent);
            JComponent jComponent4 = this.getMenuParent(jComponent2);
            if (jComponent4 == null) {
                jComponent4 = (JComponent)jComponent2.getParent();
            }
            RADVisualComponent rADVisualComponent = (RADVisualComponent)this.formDesigner.getMetaComponent(jComponent);
            RADVisualComponent rADVisualComponent2 = (RADVisualComponent)this.formDesigner.getMetaComponent(jComponent2);
            RADVisualContainer rADVisualContainer = (RADVisualContainer)this.formDesigner.getMetaComponent(jComponent3);
            RADVisualContainer rADVisualContainer2 = (RADVisualContainer)this.formDesigner.getMetaComponent(jComponent4);
            if (jComponent instanceof JMenu && jComponent.getParent() instanceof JMenuBar && jComponent2 instanceof JMenu && jComponent2.getParent() instanceof JMenuBar) {
                jComponent4 = (JComponent)jComponent2.getParent();
                jComponent3 = (JComponent)jComponent.getParent();
                rADVisualContainer = (RADVisualContainer)this.formDesigner.getMetaComponent(jComponent3);
                rADVisualContainer2 = (RADVisualContainer)this.formDesigner.getMetaComponent(jComponent4);
            }
            if (rADVisualComponent != null && rADVisualContainer != null) {
                n2 = rADVisualContainer.getIndexOf(rADVisualComponent);
                rADVisualContainer.remove(rADVisualComponent);
                this.formDesigner.getFormModel().fireComponentRemoved(rADVisualComponent, rADVisualContainer, n2, false);
            }
            if (jComponent4 == null && jComponent2 instanceof JMenu && jComponent2.getParent() instanceof JMenuBar) {
                rADVisualContainer2 = (RADVisualContainer)rADVisualComponent2;
                rADVisualContainer2.add(rADVisualComponent, -1);
                rADVisualContainer2.getLayoutSupport().addComponents(new RADVisualComponent[]{rADVisualComponent}, null, -1);
                this.formDesigner.getFormModel().fireComponentAdded(rADVisualComponent, false);
                return;
            }
            if (rADVisualContainer2 != null) {
                n2 = rADVisualContainer2.getIndexOf(rADVisualComponent2) + n;
                rADVisualContainer2.add(rADVisualComponent, n2);
                rADVisualContainer2.getLayoutSupport().addComponents(new RADVisualComponent[]{rADVisualComponent}, null, n2);
                this.formDesigner.getFormModel().fireComponentAdded(rADVisualComponent, false);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static boolean addComponentToEndOfMenu(RADComponent rADComponent, PaletteItem paletteItem) {
        FormModel formModel = rADComponent.getFormModel();
        MetaComponentCreator metaComponentCreator = formModel.getComponentCreator();
        metaComponentCreator.precreateVisualComponent(paletteItem.getComponentClassSource());
        boolean bl = metaComponentCreator.addPrecreatedComponent(rADComponent, null);
        return bl;
    }

    void configureNewComponent(RADComponent rADComponent) {
        JComponent jComponent;
        if (rADComponent != null && (jComponent = (JComponent)this.formDesigner.getComponent(rADComponent)) != null) {
            jComponent.setForeground(Color.LIGHT_GRAY);
        }
    }

    private void configureEditedComponent(JComponent jComponent) {
        if (jComponent == null) {
            return;
        }
    }

    void configureEditedComponent(RADComponent rADComponent) {
        if (rADComponent != null) {
            this.configureEditedComponent((JComponent)this.formDesigner.getComponent(rADComponent));
        }
    }

    private void registerForm(final RADVisualContainer rADVisualContainer, final JMenu jMenu) {
        if (!this.formModelListeners.containsKey(rADVisualContainer)) {
            FormModelListener formModelListener = new FormModelListener(){

                public void formChanged(FormModelEvent[] formModelEventArray) {
                    if (formModelEventArray != null) {
                        for (FormModelEvent formModelEvent : formModelEventArray) {
                            Component component;
                            if (formModelEvent.getChangeType() == 3) {
                                MenuEditLayer.this.formModelListeners.remove(rADVisualContainer);
                                rADVisualContainer.getFormModel().addFormModelListener(this);
                                continue;
                            }
                            if (formModelEvent.getChangeType() == 10 && "action".equals(formModelEvent.getPropertyName())) {
                                MenuEditLayer.this.configureEditedComponent(formModelEvent.getComponent());
                            }
                            if (formModelEvent.getChangeType() == 10 || formModelEvent.getChangeType() == 16) {
                                if (formModelEvent.getContainer() == rADVisualContainer || formModelEvent.getComponent() == rADVisualContainer) {
                                    MenuEditLayer.this.rebuildOnScreenMenu(rADVisualContainer);
                                }
                                MenuEditLayer.this.updateIcon(formModelEvent.getComponent());
                            }
                            if (formModelEvent.getChangeType() == 7) {
                                MenuEditLayer.this.updateIcon(formModelEvent.getComponent());
                                if (formModelEvent.getComponent() != null && (component = (Component)MenuEditLayer.this.formDesigner.getComponent(formModelEvent.getComponent())) instanceof JMenuItem) {
                                    MenuEditLayer.installAcceleratorPreview((JMenuItem)component);
                                }
                            }
                            if (formModelEvent.getChangeType() == 8 && formModelEvent.getComponent() == rADVisualContainer) {
                                MenuEditLayer.this.unconfigureMenu(jMenu);
                                continue;
                            }
                            if (formModelEvent.getChangeType() != 7 && formModelEvent.getChangeType() != 9 && formModelEvent.getChangeType() != 8) continue;
                            if (formModelEvent.getContainer() == rADVisualContainer) {
                                MenuEditLayer.this.rebuildOnScreenMenu(rADVisualContainer);
                                return;
                            }
                            if (formModelEvent.getContainer() != MenuEditLayer.this.getFormMenuBar() || (component = (JComponent)MenuEditLayer.this.formDesigner.getComponent(MenuEditLayer.this.getFormMenuBar())) == null) continue;
                            RADVisualContainer rADVisualContainer2 = (RADVisualContainer)MenuEditLayer.this.getFormMenuBar();
                            ((Container)component).removeAll();
                            for (RADVisualComponent rADVisualComponent : rADVisualContainer2.getSubComponents()) {
                                if (rADVisualComponent == null) continue;
                                ((Container)component).add((JComponent)MenuEditLayer.this.formDesigner.getComponent(rADVisualComponent));
                            }
                        }
                    }
                }
            };
            this.formModelListeners.put(rADVisualContainer, formModelListener);
            rADVisualContainer.getFormModel().addFormModelListener(formModelListener);
        }
    }

    private void rebuildOnScreenMenu(RADVisualContainer rADVisualContainer) {
        if (rADVisualContainer == null) {
            return;
        }
        if (this.hackedPopupFactory == null) {
            return;
        }
        JMenu jMenu = (JMenu)this.formDesigner.getComponent(rADVisualContainer);
        if (this.hackedPopupFactory.containerMap.containsKey(jMenu)) {
            JPanel jPanel = this.hackedPopupFactory.containerMap.get(jMenu);
            if (jPanel == null) {
                return;
            }
            for (Component object : jPanel.getComponents()) {
                if (object instanceof JMenu) {
                    this.unconfigureMenu((JMenu)object);
                    continue;
                }
                this.unconfigureMenuItem((JComponent)object);
            }
            jPanel.removeAll();
            for (RADVisualComponent rADVisualComponent : rADVisualContainer.getSubComponents()) {
                if (rADVisualComponent == null) continue;
                JComponent jComponent = (JComponent)this.formDesigner.getComponent(rADVisualComponent);
                if (!this.isConfigured(jComponent)) {
                    if (jComponent instanceof JMenu) {
                        this.configureMenu(jMenu, (JMenu)jComponent);
                    } else {
                        this.configureMenuItem(jMenu, jComponent);
                    }
                }
                jPanel.add(jComponent);
            }
            jPanel.setSize(jPanel.getLayout().preferredLayoutSize(jPanel));
            this.validate();
            jPanel.repaint();
        }
    }

    private void updateIcon(RADComponent rADComponent) {
        try {
            Component component = (Component)this.formDesigner.getComponent(rADComponent);
            if (component instanceof JMenuItem) {
                JMenuItem jMenuItem = (JMenuItem)component;
                RADProperty rADProperty = rADComponent.getBeanProperty("icon");
                Object object = rADProperty.getValue();
                Icon icon = null;
                if (object instanceof Icon) {
                    icon = (Icon)object;
                }
                if (object instanceof IconEditor.NbImageIcon) {
                    icon = ((IconEditor.NbImageIcon)object).getIcon();
                }
                if (object instanceof ResourceValue) {
                    ResourceValue resourceValue = (ResourceValue)object;
                    Object object2 = resourceValue.getDesignValue();
                    if (object2 instanceof Icon) {
                        icon = (Icon)object2;
                    }
                    if (object2 instanceof IconEditor.NbImageIcon) {
                        icon = ((IconEditor.NbImageIcon)object2).getIcon();
                    }
                }
                if (!(jMenuItem.getIcon() instanceof WrapperIcon) && !MenuEditLayer.isTopLevelMenu(jMenuItem)) {
                    jMenuItem.setIcon(new WrapperIcon(jMenuItem.getIcon()));
                }
                if (jMenuItem.getIcon() instanceof WrapperIcon) {
                    ((WrapperIcon)jMenuItem.getIcon()).setIcon(icon);
                } else {
                    jMenuItem.setIcon(icon);
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static boolean containsMenuTypeComponent(RADVisualComponent[] rADVisualComponentArray) {
        if (rADVisualComponentArray == null) {
            return false;
        }
        if (rADVisualComponentArray.length < 1) {
            return false;
        }
        for (RADVisualComponent rADVisualComponent : rADVisualComponentArray) {
            if (JMenuItem.class.isAssignableFrom(rADVisualComponent.getBeanClass())) {
                return true;
            }
            if (JMenuBar.class.isAssignableFrom(rADVisualComponent.getBeanClass())) {
                return true;
            }
            if (!JMenu.class.isAssignableFrom(rADVisualComponent.getBeanClass())) continue;
            return true;
        }
        return false;
    }

    public static boolean containsMenuBar(RADVisualComponent[] rADVisualComponentArray) {
        if (rADVisualComponentArray == null) {
            return false;
        }
        if (rADVisualComponentArray.length < 1) {
            return false;
        }
        for (RADVisualComponent rADVisualComponent : rADVisualComponentArray) {
            if (!JMenuBar.class.isAssignableFrom(rADVisualComponent.getBeanClass())) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidMenuContainer(RADVisualContainer rADVisualContainer) {
        if (rADVisualContainer == null) {
            return false;
        }
        if (JMenuBar.class.isAssignableFrom(rADVisualContainer.getBeanClass())) {
            return true;
        }
        return JMenu.class.isAssignableFrom(rADVisualContainer.getBeanClass());
    }

    public static boolean isTopLevelMenu(JComponent jComponent) {
        if (jComponent == null) {
            return false;
        }
        return jComponent instanceof JMenu && jComponent.getParent() instanceof JMenuBar;
    }

    public boolean doesFormContainMenuBar() {
        for (RADComponent rADComponent : this.formDesigner.getFormModel().getAllComponents()) {
            if (!JMenuBar.class.isAssignableFrom(rADComponent.getBeanClass())) continue;
            return true;
        }
        return false;
    }

    public RADComponent getFormMenuBar() {
        for (RADComponent rADComponent : this.formDesigner.getFormModel().getAllComponents()) {
            if (!JMenuBar.class.isAssignableFrom(rADComponent.getBeanClass())) continue;
            return rADComponent;
        }
        return null;
    }

    private boolean shouldRedispatchDnDToHandle(DropTargetDragEvent dropTargetDragEvent) {
        RADComponent rADComponent = this.formDesigner.getHandleLayer().getMetaComponentAt(dropTargetDragEvent.getLocation(), 0);
        if (rADComponent != null && MenuEditLayer.isMenuRelatedComponentClass(rADComponent.getBeanClass())) {
            return false;
        }
        PaletteItem paletteItem = PaletteUtils.getSelectedItem();
        return paletteItem != null && JSeparator.class.isAssignableFrom(paletteItem.getComponentClass());
    }

    public SelectedPortion getCurrentSelectedPortion() {
        return this.selectedPortion;
    }

    public boolean isDragProxying() {
        return this.dragProxying;
    }

    static class WrapperIcon
    implements Icon {
        private Icon wrapee;

        public WrapperIcon() {
            this(null);
        }

        public WrapperIcon(Icon icon) {
            this.wrapee = icon;
        }

        public void setIcon(Icon icon) {
            this.wrapee = icon;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (this.wrapee != null) {
                this.wrapee.paintIcon(component, graphics, n, n2);
            } else {
                Graphics graphics2 = graphics.create();
                graphics2.setColor(Color.WHITE);
                graphics2.fillRect(n, n2, this.getIconWidth() - 1, this.getIconHeight() - 1);
                graphics2.setColor(EMPTY_ICON_COLOR);
                graphics2.drawRect(n, n2, this.getIconWidth() - 1, this.getIconHeight() - 1);
                graphics2.drawRect(n + 1, n2 + 1, this.getIconWidth() - 3, this.getIconHeight() - 3);
                graphics2.dispose();
            }
        }

        public int getIconWidth() {
            if (this.wrapee != null) {
                return this.wrapee.getIconWidth();
            }
            return 16;
        }

        public int getIconHeight() {
            if (this.wrapee != null) {
                return this.wrapee.getIconHeight();
            }
            return 16;
        }
    }

    private class GlassLayerDropTargetListener
    implements DropTargetListener {
        private GlassLayerDropTargetListener() {
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            if (MenuEditLayer.this.shouldRedispatchDnDToHandle(dropTargetDragEvent)) {
                MenuEditLayer.this.dragProxying = true;
                MenuEditLayer.this.formDesigner.getHandleLayer().getNewComponentDropListener().dragEnter(dropTargetDragEvent);
                return;
            }
            if (!MenuEditLayer.this.dragop.isStarted()) {
                this.start(dropTargetDragEvent);
            }
        }

        private void start(DropTargetDragEvent dropTargetDragEvent) {
            PaletteItem paletteItem = PaletteUtils.getSelectedItem();
            if (paletteItem != null && !MenuEditLayer.isMenuRelatedComponentClass(paletteItem.getComponentClass())) {
                MenuEditLayer.this.hideMenuLayer();
                return;
            }
            if (MenuEditLayer.this.formDesigner.getDesignerMode() == 2 && paletteItem != null) {
                if (JMenuBar.class.isAssignableFrom(paletteItem.getComponentClass())) {
                    MenuEditLayer.this.hideMenuLayer();
                    return;
                }
                MenuEditLayer.this.dragop.start(paletteItem, dropTargetDragEvent.getLocation());
            }
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            if (MenuEditLayer.this.dragProxying && MenuEditLayer.this.shouldRedispatchDnDToHandle(dropTargetDragEvent)) {
                MenuEditLayer.this.formDesigner.getHandleLayer().getNewComponentDropListener().dragOver(dropTargetDragEvent);
                return;
            }
            MenuEditLayer.this.dragProxying = false;
            if (MenuEditLayer.this.dragop.isStarted()) {
                MenuEditLayer.this.dragop.move(dropTargetDragEvent.getLocation());
            } else {
                this.start(dropTargetDragEvent);
            }
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
            if (MenuEditLayer.this.dragProxying) {
                MenuEditLayer.this.formDesigner.getHandleLayer().getNewComponentDropListener().dragExit(dropTargetEvent);
            }
            MenuEditLayer.this.dragProxying = false;
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            if (MenuEditLayer.this.dragProxying) {
                MenuEditLayer.this.formDesigner.getHandleLayer().getNewComponentDropListener().drop(dropTargetDropEvent);
                MenuEditLayer.this.dragProxying = false;
                return;
            }
            if (MenuEditLayer.this.dragop.isStarted()) {
                MenuEditLayer.this.dragop.end(dropTargetDropEvent.getLocation());
                MenuEditLayer.this.dragProxying = false;
                return;
            }
        }
    }

    private class GlassLayerMouseListener
    extends MouseInputAdapter {
        Point pressPoint = null;
        JComponent pressComp = null;
        private boolean isEditing = false;

        private GlassLayerMouseListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            JComponent jComponent;
            Object object;
            if (MenuEditLayer.this.dragop.isStarted() && MenuEditLayer.this.dragop.getTargetComponent() != null && MenuEditLayer.isMenuRelatedComponentClass(MenuEditLayer.this.dragop.getTargetComponent().getClass())) {
                if (mouseEvent.isShiftDown()) {
                    MenuEditLayer.this.dragop.end(mouseEvent.getPoint(), false);
                    PaletteItem paletteItem = PaletteUtils.getSelectedItem();
                    MenuEditLayer.this.dragop.start(paletteItem, mouseEvent.getPoint());
                } else {
                    MenuEditLayer.this.dragop.end(mouseEvent.getPoint(), true);
                }
                return;
            }
            if (this.shouldRedispatchToHandle()) {
                MenuEditLayer.this.dragop.fastEnd();
                MenuEditLayer.this.formDesigner.getHandleLayer().dispatchEvent(mouseEvent);
                return;
            }
            if (MenuEditLayer.this.dragop.isStarted()) {
                MenuEditLayer.this.dragop.end(mouseEvent.getPoint());
                return;
            }
            RADComponent rADComponent = MenuEditLayer.this.formDesigner.getHandleLayer().getMetaComponentAt(mouseEvent.getPoint(), 0);
            if (rADComponent != null) {
                object = MenuEditLayer.this.formDesigner.getComponent(rADComponent);
                JComponent jComponent2 = jComponent = object instanceof JComponent ? (JComponent)object : null;
                if (jComponent != null && MenuEditLayer.isTopLevelMenu(jComponent)) {
                    if (mouseEvent.getClickCount() > 1) {
                        this.isEditing = true;
                        MenuEditLayer.this.configureEditedComponent(jComponent);
                        MenuEditLayer.this.formDesigner.startInPlaceEditing(rADComponent);
                    } else {
                        MenuEditLayer.this.openMenu(rADComponent, jComponent);
                        MenuEditLayer.this.glassLayer.requestFocusInWindow();
                        if (DropTargetLayer.isMultiselectPressed(mouseEvent)) {
                            MenuEditLayer.this.addSelectedRADComponent(rADComponent);
                        } else {
                            MenuEditLayer.this.setSelectedRADComponent(rADComponent);
                        }
                        if (mouseEvent.isPopupTrigger()) {
                            MenuEditLayer.this.showContextMenu(mouseEvent.getPoint());
                            return;
                        }
                        if (!MenuEditLayer.this.dragop.isStarted()) {
                            this.pressPoint = mouseEvent.getPoint();
                            this.pressComp = jComponent;
                            return;
                        }
                    }
                    return;
                }
                if (jComponent instanceof JMenuBar) {
                    MenuEditLayer.this.setSelectedRADComponent(rADComponent);
                    if (mouseEvent.isPopupTrigger()) {
                        MenuEditLayer.this.showContextMenu(mouseEvent.getPoint());
                        return;
                    }
                    return;
                }
            }
            if ((object = MenuEditLayer.this.dragop.getDeepestComponentInPopups(mouseEvent.getPoint())) == null && !MenuEditLayer.isMenuRelatedRADComponent(rADComponent)) {
                PaletteUtils.clearPaletteSelection();
                MenuEditLayer.this.hideMenuLayer();
                MenuEditLayer.this.formDesigner.getHandleLayer().mousePressed(mouseEvent);
                return;
            }
            if (mouseEvent.getClickCount() > 1 && object instanceof JMenuItem) {
                jComponent = (JMenuItem)object;
                Point point = SwingUtilities.convertPoint(MenuEditLayer.this.glassLayer, mouseEvent.getPoint(), jComponent);
                SelectedPortion selectedPortion = DropTargetLayer.calculateSelectedPortion((JMenuItem)jComponent, point);
                RADComponent rADComponent2 = MenuEditLayer.this.formDesigner.getMetaComponent(jComponent);
                MenuEditLayer.this.configureEditedComponent((JComponent)object);
                if (selectedPortion == SelectedPortion.Icon) {
                    this.showIconEditor(rADComponent2);
                } else if (selectedPortion == SelectedPortion.Accelerator) {
                    this.showAcceleratorEditor(rADComponent2);
                } else {
                    this.isEditing = true;
                    MenuEditLayer.this.formDesigner.startInPlaceEditing(rADComponent2);
                }
            }
            if (mouseEvent.isPopupTrigger()) {
                MenuEditLayer.this.showContextMenu(mouseEvent.getPoint());
                return;
            }
            if (!MenuEditLayer.this.dragop.isStarted() && object instanceof JMenuItem) {
                this.pressPoint = mouseEvent.getPoint();
                this.pressComp = object;
                return;
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                MenuEditLayer.this.showContextMenu(mouseEvent.getPoint());
                return;
            }
            if (MenuEditLayer.this.dragop.isStarted() && !mouseEvent.isShiftDown()) {
                MenuEditLayer.this.dragop.end(mouseEvent.getPoint());
            } else {
                JComponent jComponent;
                if (!this.isEditing && (jComponent = MenuEditLayer.this.dragop.getDeepestComponentInPopups(mouseEvent.getPoint())) != null) {
                    Object object;
                    if (jComponent instanceof JMenuItem) {
                        object = SwingUtilities.convertPoint(MenuEditLayer.this.glassLayer, mouseEvent.getPoint(), jComponent);
                        MenuEditLayer.this.selectedPortion = DropTargetLayer.calculateSelectedPortion((JMenuItem)jComponent, (Point)object);
                        MenuEditLayer.this.dropTargetLayer.repaint();
                    } else {
                        MenuEditLayer.this.selectedPortion = SelectedPortion.None;
                    }
                    MenuEditLayer.this.glassLayer.requestFocusInWindow();
                    object = MenuEditLayer.this.formDesigner.getMetaComponent(jComponent);
                    if (DropTargetLayer.isMultiselectPressed(mouseEvent)) {
                        MenuEditLayer.this.addSelectedRADComponent((RADComponent)object);
                    } else {
                        MenuEditLayer.this.setSelectedRADComponent((RADComponent)object);
                    }
                }
                this.isEditing = false;
            }
        }

        private void showIconEditor(RADComponent rADComponent) {
            try {
                RADProperty rADProperty = rADComponent.getBeanProperty("icon");
                new PropertyAction(rADProperty).actionPerformed(null);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }

        private void showAcceleratorEditor(RADComponent rADComponent) {
            try {
                RADProperty rADProperty = rADComponent.getBeanProperty("accelerator");
                new PropertyAction(rADProperty).actionPerformed(null);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (MenuEditLayer.this.showMenubarWarning) {
                MenuEditLayer.this.showMenubarWarning = false;
                MenuEditLayer.this.repaint();
            }
            if (MenuEditLayer.this.dragop.isStarted()) {
                if (PaletteUtils.getSelectedItem() == null && MenuEditLayer.this.dragop.isPickAndPlop()) {
                    MenuEditLayer.this.dragop.fastEnd();
                } else {
                    MenuEditLayer.this.dragop.setTargetVisible(true);
                }
            }
            if (!MenuEditLayer.this.dragop.isStarted() || PaletteUtils.getSelectedItem() != MenuEditLayer.this.dragop.getCurrentItem()) {
                PaletteItem paletteItem = PaletteUtils.getSelectedItem();
                if (paletteItem != null && !MenuEditLayer.isMenuRelatedComponentClass(paletteItem.getComponentClass())) {
                    MenuEditLayer.this.hideMenuLayer();
                    return;
                }
                if (MenuEditLayer.this.formDesigner.getDesignerMode() == 2 && paletteItem != null) {
                    if (JMenuBar.class.isAssignableFrom(paletteItem.getComponentClass())) {
                        MenuEditLayer.this.hideMenuLayer();
                        return;
                    }
                    MenuEditLayer.this.dragop.start(paletteItem, mouseEvent.getPoint());
                }
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (MenuEditLayer.this.dragop.isStarted()) {
                MenuEditLayer.this.dragop.setTargetVisible(false);
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (!MenuEditLayer.this.dragop.isStarted() && this.pressPoint != null && this.pressComp instanceof JMenuItem && mouseEvent.getPoint().distance(this.pressPoint) > 10.0) {
                MenuEditLayer.this.dragop.start((JMenuItem)this.pressComp, mouseEvent.getPoint());
                this.pressPoint = null;
                this.pressComp = null;
            }
            if (MenuEditLayer.this.dragop.isStarted()) {
                MenuEditLayer.this.dragop.move(mouseEvent.getPoint());
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (this.shouldRedispatchToHandle()) {
                MenuEditLayer.this.formDesigner.getHandleLayer().dispatchEvent(mouseEvent);
            }
            if (MenuEditLayer.this.dragop.isStarted()) {
                if (!MenuEditLayer.this.doesFormContainMenuBar()) {
                    FormEditor.getAssistantModel(MenuEditLayer.this.formDesigner.getFormModel()).setContext("missingMenubar");
                }
                MenuEditLayer.this.dragop.move(mouseEvent.getPoint());
            }
        }

        private boolean shouldRedispatchToHandle() {
            return MenuEditLayer.this.dragop.isStarted() && MenuEditLayer.this.dragop.isPickAndPlop() && MenuEditLayer.this.dragop.getDragComponent() instanceof JSeparator;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SelectedPortion {
        Icon,
        Text,
        Accelerator,
        All,
        None;

    }
}

