/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.viewmodel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import javax.swing.ActionMap;
import javax.swing.ComponentInputMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.modules.viewmodel.Column;
import org.netbeans.modules.viewmodel.DefaultColumn;
import org.netbeans.modules.viewmodel.DefaultTreeExpansionManager;
import org.netbeans.modules.viewmodel.TreeModelNode;
import org.netbeans.modules.viewmodel.TreeModelRoot;
import org.netbeans.spi.viewmodel.ColumnModel;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.ErrorManager;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.TreeTableView;
import org.openide.explorer.view.Visualizer;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.nodes.PropertySupport;
import org.openide.windows.TopComponent;

public class TreeTable
extends JPanel
implements ExplorerManager.Provider,
PropertyChangeListener,
TreeExpansionListener {
    private ExplorerManager explorerManager;
    private MyTreeTable treeTable;
    Node.Property[] columns;
    private IndexedColumn[] icolumns;
    private boolean isDefaultColumnAdded;
    private TreeModelRoot currentTreeModelRoot;
    private Models.CompoundModel model;

    public TreeTable() {
        this.setLayout(new BorderLayout());
        this.treeTable = new MyTreeTable();
        this.treeTable.setRootVisible(false);
        this.treeTable.setVerticalScrollBarPolicy(22);
        this.treeTable.setHorizontalScrollBarPolicy(30);
        this.add((Component)((Object)this.treeTable), "Center");
        this.treeTable.getTree().addTreeExpansionListener(this);
        ActionMap actionMap = this.getActionMap();
        ExplorerManager explorerManager = this.getExplorerManager();
        actionMap.put("copy-to-clipboard", ExplorerUtils.actionCopy((ExplorerManager)explorerManager));
        actionMap.put("cut-to-clipboard", ExplorerUtils.actionCut((ExplorerManager)explorerManager));
        actionMap.put("paste-from-clipboard", ExplorerUtils.actionPaste((ExplorerManager)explorerManager));
        actionMap.put("delete", ExplorerUtils.actionDelete((ExplorerManager)explorerManager, (boolean)false));
    }

    public void setModel(Models.CompoundModel compoundModel) {
        this.saveWidths();
        this.model = compoundModel;
        if (this.currentTreeModelRoot != null) {
            this.currentTreeModelRoot.destroy();
        }
        if (compoundModel == null) {
            this.getExplorerManager().setRootContext((Node)new AbstractNode(Children.LEAF));
            return;
        }
        this.columns = this.createColumns(compoundModel);
        this.currentTreeModelRoot = new TreeModelRoot(compoundModel, this);
        TreeModelNode treeModelNode = this.currentTreeModelRoot.getRootNode();
        this.getExplorerManager().setRootContext((Node)treeModelNode);
        this.treeTable.setProperties(this.columns);
        this.updateColumnWidths();
    }

    public ExplorerManager getExplorerManager() {
        if (this.explorerManager == null) {
            this.explorerManager = new ExplorerManager();
        }
        return this.explorerManager;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        TopComponent topComponent = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, this);
        if (topComponent == null) {
            return;
        }
        if (string.equals("currentNodes")) {
            ExplorerUtils.activateActions((ExplorerManager)this.getExplorerManager(), (boolean)this.equalNodes());
        } else if (string.equals("selectedNodes")) {
            topComponent.setActivatedNodes((Node[])propertyChangeEvent.getNewValue());
        }
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        this.model.nodeExpanded(this.initExpandCollapseNotify(treeExpansionEvent));
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        this.model.nodeCollapsed(this.initExpandCollapseNotify(treeExpansionEvent));
    }

    private Object initExpandCollapseNotify(TreeExpansionEvent treeExpansionEvent) {
        Children children;
        Node node = Visualizer.findNode((Object)treeExpansionEvent.getPath().getLastPathComponent());
        Object object = node.getLookup().lookup(Object.class);
        Integer n = (node = node.getParentNode()) == null ? new Integer(0) : ((children = node.getChildren()) instanceof TreeModelNode.TreeModelChildren ? ((TreeModelNode.TreeModelChildren)children).getTreeDepth() : children);
        DefaultTreeExpansionManager.get(this.model).setChildrenToActOn(n);
        return object;
    }

    private boolean equalNodes() {
        Node[] nodeArray;
        Node[] nodeArray2 = TopComponent.getRegistry().getCurrentNodes();
        if (nodeArray2 == (nodeArray = this.getExplorerManager().getSelectedNodes())) {
            return true;
        }
        if (nodeArray2 == null || nodeArray == null) {
            return false;
        }
        if (nodeArray2.length != nodeArray.length) {
            return false;
        }
        int n = nodeArray2.length;
        for (int i = 0; i < n; ++i) {
            if (nodeArray2[i].equals((Object)nodeArray[i])) continue;
            return false;
        }
        return true;
    }

    private Node.Property[] createColumns(Models.CompoundModel compoundModel) {
        int n;
        ColumnModel[] columnModelArray = compoundModel.getColumns();
        int n2 = columnModelArray.length;
        Column[] columnArray = new Column[n2];
        boolean bl = true;
        for (n = 0; n < n2; ++n) {
            columnArray[n] = new Column(columnModelArray[n], this);
            if (columnModelArray[n].getType() != null) continue;
            bl = false;
        }
        this.icolumns = new IndexedColumn[columnArray.length];
        for (n = 0; n < this.icolumns.length; ++n) {
            this.icolumns[n] = new IndexedColumn((Node.Property)columnArray[n], n, columnModelArray[n].getCurrentOrderNumber());
        }
        if (!bl) {
            return columnArray;
        }
        PropertySupport.ReadWrite[] readWriteArray = new PropertySupport.ReadWrite[columnArray.length + 1];
        System.arraycopy(columnArray, 0, readWriteArray, 1, columnArray.length);
        readWriteArray[0] = new DefaultColumn();
        this.isDefaultColumnAdded = true;
        return readWriteArray;
    }

    int getColumnVisibleIndex(Column column, int n) {
        int n2 = this.isDefaultColumnAdded ? 1 : 0;
        int n3 = 0;
        ColumnModel[] columnModelArray = this.model.getColumns();
        if (columnModelArray.length == 0) {
            return -1;
        }
        for (int i = 0; i < this.columns.length - n2; ++i) {
            int n4;
            if (Boolean.TRUE.equals(this.columns[i].getValue("InvisibleInTreeTableView")) || (n4 = columnModelArray[i].getCurrentOrderNumber()) < 0 || n4 >= n) continue;
            ++n3;
        }
        return n3;
    }

    int getColumnGlobalIndex(Column column, int n) {
        int n2;
        ColumnModel[] columnModelArray = this.model.getColumns();
        if (columnModelArray.length == 0) {
            return -1;
        }
        for (n2 = 0; n2 < this.icolumns.length; ++n2) {
            this.icolumns[n2].order = columnModelArray[this.icolumns[n2].index].getCurrentOrderNumber();
        }
        Arrays.sort(this.icolumns, new IndexedColumn.Cmp());
        for (n2 = 0; n2 < this.icolumns.length; ++n2) {
            if (Boolean.TRUE.equals(this.icolumns[n2].getColumn().getValue("InvisibleInTreeTableView"))) continue;
            if (n <= 0) {
                return n2;
            }
            --n;
        }
        return this.icolumns.length;
    }

    void updateColumnWidths() {
        int n = this.columns.length;
        int n2 = this.isDefaultColumnAdded ? 1 : 0;
        TableColumnModel tableColumnModel = this.treeTable.getTable().getColumnModel();
        for (int i = 0; i < n; ++i) {
            TableColumn tableColumn;
            int n3;
            if (Boolean.TRUE.equals(this.columns[i].getValue("InvisibleInTreeTableView")) || !(this.columns[i] instanceof Column)) continue;
            Column column = (Column)this.columns[i];
            if (column.isDefault()) {
                n3 = column.getColumnWidth();
                this.treeTable.setTreePreferredWidth(n3);
                continue;
            }
            n3 = column.getModelOrderNumber();
            if (n3 < 0) {
                n3 = i;
            }
            n3 = this.getColumnVisibleIndex(column, n3);
            try {
                tableColumn = tableColumnModel.getColumn(n3 + n2);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                ErrorManager.getDefault().notify(ErrorManager.getDefault().annotate((Throwable)arrayIndexOutOfBoundsException, "Column(" + i + ") " + column.getName() + " model order = " + column.getModelOrderNumber() + " visible index = " + n3 + " => column index = " + (n3 + n2)));
                continue;
            }
            tableColumn.setPreferredWidth(column.getColumnWidth());
        }
    }

    private void saveWidths() {
        if (this.columns == null) {
            return;
        }
        int n = this.columns.length;
        if (n == 0) {
            return;
        }
        TableColumnModel tableColumnModel = this.treeTable.getTable().getColumnModel();
        Enumeration<TableColumn> enumeration = tableColumnModel.getColumns();
        boolean bl = true;
        while (enumeration.hasMoreElements()) {
            if (enumeration.nextElement().getWidth() == 75) continue;
            bl = false;
            break;
        }
        if (bl) {
            return;
        }
        int n2 = this.isDefaultColumnAdded ? 1 : 0;
        for (int i = 0; i < n; ++i) {
            TableColumn tableColumn;
            if (Boolean.TRUE.equals(this.columns[i].getValue("InvisibleInTreeTableView")) || !(this.columns[i] instanceof Column)) continue;
            Column column = (Column)this.columns[i];
            if (column.isDefault()) {
                TableColumn tableColumn2 = tableColumnModel.getColumn(0);
                int n3 = tableColumn2.getWidth();
                column.setColumnWidth(n3);
                continue;
            }
            int n4 = column.getModelOrderNumber();
            if (n4 < 0) {
                n4 = i;
            }
            n4 = this.getColumnVisibleIndex(column, n4);
            try {
                tableColumn = tableColumnModel.getColumn(n4 + n2);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                ErrorManager.getDefault().notify(ErrorManager.getDefault().annotate((Throwable)arrayIndexOutOfBoundsException, "Column(" + i + ") " + column.getName() + " model order = " + column.getModelOrderNumber() + " visible index = " + n4 + " => column index = " + (n4 + n2)));
                continue;
            }
            int n5 = tableColumn.getWidth();
            column.setColumnWidth(n5);
        }
    }

    private void expandDefault(Object[] objectArray) {
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            try {
                if (!this.model.isExpanded(objectArray[i])) continue;
                this.expandNode(objectArray[i]);
                continue;
            }
            catch (UnknownTypeException unknownTypeException) {
                // empty catch block
            }
        }
    }

    public boolean requestFocusInWindow() {
        super.requestFocusInWindow();
        return this.treeTable.requestFocusInWindow();
    }

    public void addNotify() {
        super.addNotify();
        TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)this);
        ExplorerUtils.activateActions((ExplorerManager)this.getExplorerManager(), (boolean)true);
        this.getExplorerManager().addPropertyChangeListener((PropertyChangeListener)this);
    }

    public void removeNotify() {
        TopComponent.getRegistry().removePropertyChangeListener((PropertyChangeListener)this);
        ExplorerUtils.activateActions((ExplorerManager)this.getExplorerManager(), (boolean)false);
        this.getExplorerManager().removePropertyChangeListener((PropertyChangeListener)this);
        super.removeNotify();
    }

    public boolean isExpanded(Object object) {
        TreeModelNode treeModelNode = this.currentTreeModelRoot.findNode(object);
        if (treeModelNode == null) {
            return false;
        }
        return this.treeTable.isExpanded((Node)treeModelNode);
    }

    public void expandNode(Object object) {
        TreeModelNode treeModelNode = this.currentTreeModelRoot.findNode(object);
        if (this.treeTable != null && treeModelNode != null) {
            this.treeTable.expandNode((Node)treeModelNode);
        }
    }

    public void collapseNode(Object object) {
        TreeModelNode treeModelNode = this.currentTreeModelRoot.findNode(object);
        this.treeTable.collapseNode((Node)treeModelNode);
    }

    private static class IndexedColumn {
        private Node.Property column;
        public int index;
        public int order;

        public IndexedColumn(Node.Property property, int n, int n2) {
            this.column = property;
            this.index = n;
            this.order = n2;
        }

        public Node.Property getColumn() {
            return this.column;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Cmp
        implements Comparator<IndexedColumn> {
            @Override
            public int compare(IndexedColumn indexedColumn, IndexedColumn indexedColumn2) {
                if (indexedColumn.order == -1 && indexedColumn2.order >= 0) {
                    return 1;
                }
                if (indexedColumn2.order == -1 && indexedColumn.order >= 0) {
                    return -1;
                }
                return indexedColumn.order - indexedColumn2.order;
            }
        }
    }

    private static final class F8FilterInputMap
    extends InputMap {
        private KeyStroke f8 = KeyStroke.getKeyStroke(119, 0);

        public F8FilterInputMap(InputMap inputMap) {
            this.setParent(inputMap);
        }

        public Object get(KeyStroke keyStroke) {
            if (this.f8.equals(keyStroke)) {
                return null;
            }
            return super.get(keyStroke);
        }
    }

    private static final class F8FilterComponentInputMap
    extends ComponentInputMap {
        private KeyStroke f8 = KeyStroke.getKeyStroke(119, 0);

        public F8FilterComponentInputMap(JComponent jComponent, InputMap inputMap) {
            super(jComponent);
            this.setParent(inputMap);
        }

        public Object get(KeyStroke keyStroke) {
            if (this.f8.equals(keyStroke)) {
                return null;
            }
            return super.get(keyStroke);
        }
    }

    private static class MyTreeTable
    extends TreeTableView {
        MyTreeTable() {
            this.treeTable.setShowHorizontalLines(true);
            this.treeTable.setShowVerticalLines(false);
            this.filterInputMap(this.treeTable, 0);
            this.filterInputMap(this.treeTable, 2);
            this.filterInputMap(this.treeTable, 1);
        }

        private void filterInputMap(JComponent jComponent, int n) {
            InputMap inputMap = jComponent.getInputMap(n);
            inputMap = inputMap instanceof ComponentInputMap ? new F8FilterComponentInputMap(jComponent, inputMap) : new F8FilterInputMap(inputMap);
            jComponent.setInputMap(n, inputMap);
        }

        JTable getTable() {
            return this.treeTable;
        }

        JTree getTree() {
            return this.tree;
        }

        public void expandNodes(List list) {
            for (String[] stringArray : list) {
                TreePath treePath = this.stringPath2TreePath(stringArray);
                if (treePath == null) continue;
                this.showPath(treePath);
            }
        }

        private TreePath stringPath2TreePath(String[] stringArray) {
            ExplorerManager explorerManager = ExplorerManager.find((Component)((Object)this));
            try {
                Node node = NodeOp.findPath((Node)explorerManager.getRootContext(), (String[])stringArray);
                Object[] objectArray = new TreeNode[stringArray.length + 1];
                for (int i = stringArray.length; i >= 0; --i) {
                    objectArray[i] = Visualizer.findVisualizer((Node)node);
                    node = node.getParentNode();
                }
                return new TreePath(objectArray);
            }
            catch (NodeNotFoundException nodeNotFoundException) {
                return null;
            }
        }
    }
}

