/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.navigation.hierarchy;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.navigation.classhierarchy.ClassHierarchyPanel;
import org.netbeans.modules.cnd.navigation.includeview.IncludeHierarchyPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

class HierarchyDialog {
    private static Rectangle lastBounds;
    private static boolean firstInvocation;

    HierarchyDialog() {
    }

    public static void show(CsmClass csmClass) {
        if (csmClass != null) {
            ClassHierarchyPanel classHierarchyPanel = new ClassHierarchyPanel(false);
            String string = csmClass.getName() + " - " + NbBundle.getMessage(HierarchyDialog.class, (String)"CTL_ClassHierarchyDialogTitle");
            Dialog dialog = HierarchyDialog.createDialog(classHierarchyPanel, string);
            classHierarchyPanel.setClose(new DialogClose(classHierarchyPanel));
            classHierarchyPanel.setClass(csmClass);
            HierarchyDialog.addKeyListeners(classHierarchyPanel.getTreeView(), classHierarchyPanel);
            dialog.setVisible(true);
        }
    }

    public static void show(CsmFile csmFile) {
        if (csmFile != null) {
            IncludeHierarchyPanel includeHierarchyPanel = new IncludeHierarchyPanel(false);
            String string = csmFile.getName() + " - " + NbBundle.getMessage(HierarchyDialog.class, (String)"CTL_IncludeHierarchyDialogTitle");
            Dialog dialog = HierarchyDialog.createDialog(includeHierarchyPanel, string);
            includeHierarchyPanel.setClose(new DialogClose(includeHierarchyPanel));
            includeHierarchyPanel.setFile(csmFile);
            HierarchyDialog.addKeyListeners(includeHierarchyPanel.getTreeView(), includeHierarchyPanel);
            dialog.setVisible(true);
        }
    }

    private static void addKeyListeners(BeanTreeView beanTreeView, ExplorerManager.Provider provider) {
    }

    private static JPanel createPanel(JPanel jPanel) {
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("SplitPane.shadow")));
        jPanel2.add((Component)jPanel3, gridBagConstraints);
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)jPanel, "Center");
        return jPanel2;
    }

    private static Dialog createDialog(JPanel jPanel, String string) {
        JButton jButton = new JButton(NbBundle.getMessage(HierarchyDialog.class, (String)"CTL_OK"));
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)HierarchyDialog.createPanel(jPanel), string, true, new Object[]{jButton, DialogDescriptor.CANCEL_OPTION}, (Object)jButton, 0, HelpCtx.DEFAULT_HELP, (ActionListener)new DialogButtonListener((ExplorerManager.Provider)jPanel, jButton));
        dialogDescriptor.setClosingOptions(new Object[]{jButton, DialogDescriptor.CANCEL_OPTION});
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        if (firstInvocation) {
            Rectangle rectangle = WindowManager.getDefault().getMainWindow().getBounds();
            lastBounds.setLocation(rectangle.x + (rectangle.width - HierarchyDialog.lastBounds.width) / 2, rectangle.y + (rectangle.height - HierarchyDialog.lastBounds.height) / 2);
            firstInvocation = false;
        }
        dialog.setBounds(lastBounds);
        dialog.addWindowListener(new DialogBoundsKeeper(jPanel));
        return dialog;
    }

    static {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        lastBounds = new Rectangle(dimension.width / 2 - 200, dimension.height / 2 - 300, 400, 600);
        firstInvocation = true;
    }

    private static class DialogClose
    extends AbstractAction {
        private ExplorerManager.Provider panel;

        public DialogClose(ExplorerManager.Provider provider) {
            this.panel = provider;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Window window = SwingUtilities.getWindowAncestor((Component)this.panel);
            if (window != null) {
                window.setVisible(false);
            }
        }
    }

    private static class DialogButtonListener
    implements ActionListener {
        private ExplorerManager.Provider panel;
        private JButton okButton;

        public DialogButtonListener(ExplorerManager.Provider provider, JButton jButton) {
            this.panel = provider;
            this.okButton = jButton;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Action action;
            Node[] nodeArray;
            if (actionEvent.getSource() == this.okButton && (nodeArray = this.panel.getExplorerManager().getSelectedNodes()).length > 0 && (action = nodeArray[0].getPreferredAction()) != null) {
                action.actionPerformed(null);
                Window window = SwingUtilities.getWindowAncestor((Component)this.panel);
                if (window != null) {
                    window.setVisible(false);
                }
            }
        }
    }

    private static class DialogBoundsKeeper
    extends WindowAdapter {
        private JPanel panel;

        public DialogBoundsKeeper(JPanel jPanel) {
            this.panel = jPanel;
        }

        public void windowOpened(WindowEvent windowEvent) {
            this.panel.requestFocusInWindow();
        }

        public void windowClosed(WindowEvent windowEvent) {
            lastBounds = windowEvent.getWindow().getBounds();
        }
    }
}

