/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.netbeans.modules.versioning.Utils;
import org.netbeans.modules.versioning.VersioningManager;
import org.netbeans.modules.versioning.spi.VCSAnnotator;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.spi.VersioningSystem;
import org.openide.awt.DynamicMenuContent;
import org.openide.awt.Mnemonics;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersioningMainMenu
extends AbstractAction
implements DynamicMenuContent {
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    public JComponent[] getMenuPresenters() {
        return this.createMenu();
    }

    public JComponent[] synchMenuPresenters(JComponent[] jComponentArray) {
        return this.createMenu();
    }

    private JComponent[] createMenu() {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>(20);
        VCSContext vCSContext = VCSContext.forNodes(TopComponent.getRegistry().getActivatedNodes());
        List<VersioningSystem> list = Arrays.asList(VersioningManager.getInstance().getVersioningSystems());
        VersioningSystem[] versioningSystemArray = VersioningManager.getInstance().getOwners(vCSContext);
        if (versioningSystemArray.length == 1) {
            if (versioningSystemArray[0].getVCSAnnotator() != null) {
                object = VersioningMainMenu.actionsToItems(versioningSystemArray[0].getVCSAnnotator().getActions(vCSContext, VCSAnnotator.ActionDestination.MainMenu));
                arrayList.addAll((Collection<Object>)object);
            }
            arrayList.add(Utils.createJSeparator());
        } else if (versioningSystemArray.length > 1) {
            object = new JMenuItem("<multiple systems>");
            ((JMenuItem)object).setEnabled(false);
            arrayList.add(object);
            arrayList.add(Utils.createJSeparator());
        }
        Collections.sort(list, new Comparator<VersioningSystem>(){

            @Override
            public int compare(VersioningSystem versioningSystem, VersioningSystem versioningSystem2) {
                return Utils.getDisplayName(versioningSystem).compareTo(Utils.getDisplayName(versioningSystem2));
            }
        });
        object = null;
        for (VersioningSystem versioningSystem : list) {
            if (Utils.isLocalHistory(versioningSystem)) {
                object = versioningSystem;
                continue;
            }
            JMenu jMenu = this.createVersioningSystemMenu(versioningSystem, vCSContext);
            arrayList.add(jMenu);
        }
        if (object != null) {
            arrayList.add(Utils.createJSeparator());
            arrayList.add(this.createVersioningSystemMenu((VersioningSystem)object, vCSContext));
        }
        return arrayList.toArray(new JComponent[arrayList.size()]);
    }

    private JMenu createVersioningSystemMenu(final VersioningSystem versioningSystem, final VCSContext vCSContext) {
        final JMenu jMenu = new JMenu();
        Mnemonics.setLocalizedText((AbstractButton)jMenu, (String)Utils.getMenuLabel(versioningSystem));
        jMenu.addMenuListener(new MenuListener(){

            public void menuSelected(MenuEvent menuEvent) {
                if (jMenu.getItemCount() != 0) {
                    return;
                }
                VersioningMainMenu.this.constructMenu(jMenu, versioningSystem, vCSContext);
            }

            public void menuDeselected(MenuEvent menuEvent) {
            }

            public void menuCanceled(MenuEvent menuEvent) {
            }
        });
        return jMenu;
    }

    private void constructMenu(JMenu jMenu, VersioningSystem versioningSystem, VCSContext vCSContext) {
        if (versioningSystem.getVCSAnnotator() != null) {
            List<JComponent> list = VersioningMainMenu.actionsToItems(versioningSystem.getVCSAnnotator().getActions(vCSContext, VCSAnnotator.ActionDestination.MainMenu));
            for (JComponent jComponent : list) {
                jMenu.add(jComponent);
            }
        }
    }

    private static List<JComponent> actionsToItems(Action[] actionArray) {
        ArrayList<JComponent> arrayList = new ArrayList<JComponent>(actionArray.length);
        for (Action action : actionArray) {
            Object object;
            if (action == null) {
                arrayList.add(Utils.createJSeparator());
                continue;
            }
            if (action instanceof DynamicMenuContent) {
                object = (DynamicMenuContent)action;
                JComponent[] jComponentArray = object.getMenuPresenters();
                arrayList.addAll(Arrays.asList(jComponentArray));
                continue;
            }
            object = Utils.toMenuItem(action);
            arrayList.add((JComponent)object);
        }
        return arrayList;
    }
}

