/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.InputStream;
import java.io.PrintStream;
import org.jruby.Ruby;
import org.jruby.RubyException;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyNumeric;
import org.jruby.exceptions.MainExitException;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.SimpleSampler;

public class Main {
    private boolean hasPrintedUsage = false;
    private RubyInstanceConfig config;

    public Main(RubyInstanceConfig rubyInstanceConfig) {
        this.config = rubyInstanceConfig;
    }

    public Main(final InputStream inputStream, final PrintStream printStream, final PrintStream printStream2) {
        this(new RubyInstanceConfig(){
            {
                this.setInput(inputStream);
                this.setOutput(printStream);
                this.setError(printStream2);
            }
        });
    }

    public Main() {
        this(new RubyInstanceConfig());
    }

    public static void main(String[] stringArray) {
        Main main = new Main();
        int n = main.run(stringArray);
        if (n != 0) {
            System.exit(n);
        }
    }

    public int run(String[] stringArray) {
        try {
            this.config.processArguments(stringArray);
            return this.run();
        }
        catch (MainExitException mainExitException) {
            if (!mainExitException.isAborted()) {
                this.config.getOutput().println(mainExitException.getMessage());
                if (mainExitException.isUsageError()) {
                    this.printUsage();
                }
            }
            return mainExitException.getStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int run() {
        if (this.config.isShowVersion()) {
            this.showVersion();
        }
        if (this.config.isShowCopyright()) {
            this.showCopyright();
        }
        if (!this.config.shouldRunInterpreter()) {
            if (this.config.shouldPrintUsage()) {
                this.printUsage();
            }
            if (!this.config.shouldPrintProperties()) return 0;
            this.printProperties();
            return 0;
        }
        InputStream inputStream = this.config.getScriptSource();
        String string = this.config.displayedFileName();
        Ruby ruby = Ruby.newInstance(this.config);
        if (inputStream == null) return 0;
        if (this.config.isShouldCheckSyntax()) {
            ruby.parseFromMain(inputStream, string);
            this.config.getOutput().println("Syntax OK");
            return 0;
        }
        long l = -1L;
        try {
            if (this.config.isBenchmarking()) {
                l = System.currentTimeMillis();
            }
            if (this.config.isSamplingEnabled()) {
                SimpleSampler.startSampleThread();
            }
            try {
                ruby.runFromMain(inputStream, string);
                Object var7_5 = null;
                ruby.tearDown();
                if (this.config.isBenchmarking()) {
                    this.config.getOutput().println("Runtime: " + (System.currentTimeMillis() - l) + " ms");
                }
                if (!this.config.isSamplingEnabled()) return 0;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                ruby.tearDown();
                if (this.config.isBenchmarking()) {
                    this.config.getOutput().println("Runtime: " + (System.currentTimeMillis() - l) + " ms");
                }
                if (!this.config.isSamplingEnabled()) throw throwable;
                SimpleSampler.report();
                throw throwable;
            }
            SimpleSampler.report();
            return 0;
        }
        catch (RaiseException raiseException) {
            RubyException rubyException = raiseException.getException();
            if (ruby.fastGetClass("SystemExit").isInstance(rubyException)) {
                IRubyObject iRubyObject = rubyException.callMethod(ruby.getCurrentContext(), "status");
                if (iRubyObject == null || iRubyObject.isNil()) return 0;
                return RubyNumeric.fix2int(iRubyObject);
            }
            ruby.printError(rubyException);
            return 1;
        }
    }

    private void showVersion() {
        this.config.getOutput().print(this.config.getVersionString());
    }

    private void showCopyright() {
        this.config.getOutput().print(this.config.getCopyrightString());
    }

    public void printUsage() {
        if (!this.hasPrintedUsage) {
            this.config.getOutput().print(this.config.getBasicUsageHelp());
            this.hasPrintedUsage = true;
        }
    }

    public void printProperties() {
        this.config.getOutput().print(this.config.getPropertyHelp());
    }
}

