/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jruby.CompatVersion;
import org.jruby.Finalizable;
import org.jruby.IErrno;
import org.jruby.NativeException;
import org.jruby.Profile;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBinding;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComparable;
import org.jruby.RubyContinuation;
import org.jruby.RubyDir;
import org.jruby.RubyEnumerable;
import org.jruby.RubyException;
import org.jruby.RubyFile;
import org.jruby.RubyFileStat;
import org.jruby.RubyFileTest;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyGC;
import org.jruby.RubyGlobal;
import org.jruby.RubyHash;
import org.jruby.RubyIO;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyInteger;
import org.jruby.RubyKernel;
import org.jruby.RubyLocalJumpError;
import org.jruby.RubyMarshal;
import org.jruby.RubyMatchData;
import org.jruby.RubyMath;
import org.jruby.RubyMethod;
import org.jruby.RubyModule;
import org.jruby.RubyNameError;
import org.jruby.RubyNil;
import org.jruby.RubyNoMethodError;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyObjectSpace;
import org.jruby.RubyPrecision;
import org.jruby.RubyProc;
import org.jruby.RubyProcess;
import org.jruby.RubyRange;
import org.jruby.RubyRegexp;
import org.jruby.RubySignal;
import org.jruby.RubyString;
import org.jruby.RubyStruct;
import org.jruby.RubySymbol;
import org.jruby.RubySystemCallError;
import org.jruby.RubySystemExit;
import org.jruby.RubyThread;
import org.jruby.RubyThreadGroup;
import org.jruby.RubyTime;
import org.jruby.RubyUnboundMethod;
import org.jruby.RubyUndef;
import org.jruby.TopSelfFactory;
import org.jruby.ast.Node;
import org.jruby.ast.RootNode;
import org.jruby.ast.executable.RubiniusRunner;
import org.jruby.ast.executable.Script;
import org.jruby.ast.executable.YARVCompiledRunner;
import org.jruby.common.IRubyWarnings;
import org.jruby.common.RubyWarnings;
import org.jruby.compiler.ASTCompiler;
import org.jruby.compiler.ASTInspector;
import org.jruby.compiler.NotCompilableException;
import org.jruby.compiler.impl.StandardASMCompiler;
import org.jruby.compiler.yarv.StandardYARVCompiler;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.JRubyPOSIXHandler;
import org.jruby.ext.LateLoadingLibrary;
import org.jruby.ext.posix.POSIX;
import org.jruby.ext.posix.POSIXFactory;
import org.jruby.internal.runtime.GlobalVariables;
import org.jruby.internal.runtime.ThreadService;
import org.jruby.internal.runtime.ValueAccessor;
import org.jruby.javasupport.JavaSupport;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.Parser;
import org.jruby.parser.ParserConfiguration;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.CacheMap;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.EventHook;
import org.jruby.runtime.Frame;
import org.jruby.runtime.GlobalVariable;
import org.jruby.runtime.IAccessor;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ObjectSpace;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;
import org.jruby.runtime.load.LoadService;
import org.jruby.util.BuiltinScript;
import org.jruby.util.ByteList;
import org.jruby.util.IOInputStream;
import org.jruby.util.IOOutputStream;
import org.jruby.util.JRubyClassLoader;
import org.jruby.util.JavaNameMangler;
import org.jruby.util.KCode;
import org.jruby.util.SafePropertyAccessor;
import org.jruby.util.SimpleSampler;
import org.jruby.util.collections.WeakHashSet;
import org.jruby.util.io.ChannelDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Ruby {
    private Map<Integer, RubyClass> errnos = new HashMap<Integer, RubyClass>();
    private final CallTraceFuncHook callTraceFuncHook = new CallTraceFuncHook();
    private ThreadLocal<Map<Object, Object>> inspect = new ThreadLocal();
    private CacheMap cacheMap = new CacheMap();
    private ThreadService threadService;
    private Hashtable<Object, Object> runtimeInformation;
    private POSIX posix;
    private int stackTraces = 0;
    private ObjectSpace objectSpace = new ObjectSpace();
    private final RubySymbol.SymbolTable symbolTable = new RubySymbol.SymbolTable(this);
    private Map<Integer, WeakReference<ChannelDescriptor>> descriptors = new ConcurrentHashMap<Integer, WeakReference<ChannelDescriptor>>();
    private long randomSeed = 0L;
    private long randomSeedSequence = 0L;
    private Random random = new Random();
    private List<EventHook> eventHooks = new Vector<EventHook>();
    private boolean hasEventHooks;
    private boolean globalAbortOnExceptionEnabled = false;
    private boolean doNotReverseLookupEnabled = false;
    private volatile boolean objectSpaceEnabled;
    private final Set<Script> jittedMethods = Collections.synchronizedSet(new WeakHashSet());
    private static ThreadLocal<Ruby> currentRuntime = new ThreadLocal();
    public static final boolean RUNTIME_THREADLOCAL = SafePropertyAccessor.getBoolean("jruby.runtime.threadlocal");
    private long globalState = 1L;
    private int safeLevel = -1;
    private IRubyObject undef;
    private IRubyObject topSelf;
    private RubyNil nilObject;
    private RubyBoolean trueObject;
    private RubyBoolean falseObject;
    public final RubyFixnum[] fixnumCache = new RubyFixnum[256];
    private IRubyObject verbose;
    private IRubyObject debug;
    private RubyClass objectClass;
    private RubyClass moduleClass;
    private RubyClass classClass;
    private RubyClass nilClass;
    private RubyClass trueClass;
    private RubyClass falseClass;
    private RubyClass numericClass;
    private RubyClass floatClass;
    private RubyClass integerClass;
    private RubyClass fixnumClass;
    private RubyClass arrayClass;
    private RubyClass hashClass;
    private RubyClass rangeClass;
    private RubyClass stringClass;
    private RubyClass symbolClass;
    private RubyClass procClass;
    private RubyClass bindingClass;
    private RubyClass methodClass;
    private RubyClass unboundMethodClass;
    private RubyClass matchDataClass;
    private RubyClass regexpClass;
    private RubyClass timeClass;
    private RubyClass bignumClass;
    private RubyClass dirClass;
    private RubyClass fileClass;
    private RubyClass fileStatClass;
    private RubyClass ioClass;
    private RubyClass threadClass;
    private RubyClass threadGroupClass;
    private RubyClass continuationClass;
    private RubyClass structClass;
    private RubyClass tmsStruct;
    private RubyClass passwdStruct;
    private RubyClass groupStruct;
    private RubyClass procStatusClass;
    private RubyClass exceptionClass;
    private RubyClass runtimeError;
    private RubyClass ioError;
    private RubyClass scriptError;
    private RubyClass nameError;
    private RubyClass signalException;
    private RubyClass standardError;
    private RubyClass systemCallError;
    private RubyClass rangeError;
    private RubyModule kernelModule;
    private RubyModule comparableModule;
    private RubyModule enumerableModule;
    private RubyModule mathModule;
    private RubyModule marshalModule;
    private RubyModule etcModule;
    private RubyModule fileTestModule;
    private RubyModule gcModule;
    private RubyModule objectSpaceModule;
    private RubyModule processModule;
    private RubyModule procUIDModule;
    private RubyModule procGIDModule;
    private RubyModule procSysModule;
    private RubyModule precisionModule;
    private RubyModule errnoModule;
    private GlobalVariable recordSeparatorVar;
    private String currentDirectory;
    private long startTime = System.currentTimeMillis();
    private RubyInstanceConfig config;
    private InputStream in;
    private PrintStream out;
    private PrintStream err;
    private JavaSupport javaSupport;
    private JRubyClassLoader jrubyClassLoader;
    private static volatile boolean securityRestricted = false;
    private Parser parser = new Parser(this);
    private LoadService loadService;
    private GlobalVariables globalVariables = new GlobalVariables(this);
    private RubyWarnings warnings = new RubyWarnings(this);
    private Stack<RubyProc> atExitBlocks = new Stack();
    private Profile profile;
    private KCode kcode = KCode.NONE;
    private AtomicInteger symbolLastId = new AtomicInteger(128);
    private AtomicInteger moduleLastId = new AtomicInteger(0);
    private Object respondToMethod;
    private Object objectToYamlMethod;
    private Map<Finalizable, Object> finalizers;
    private Map<Finalizable, Object> internalFinalizers;
    private final Object finalizersMutex = new Object();
    private final Object internalFinalizersMutex = new Object();
    private ExecutorService executor;

    public static Ruby newInstance() {
        return Ruby.newInstance(new RubyInstanceConfig());
    }

    public static Ruby newInstance(RubyInstanceConfig rubyInstanceConfig) {
        Ruby ruby = new Ruby(rubyInstanceConfig);
        ruby.init();
        if (RUNTIME_THREADLOCAL) {
            Ruby.setCurrentInstance(ruby);
        }
        return ruby;
    }

    public static Ruby newInstance(InputStream inputStream, PrintStream printStream, PrintStream printStream2) {
        RubyInstanceConfig rubyInstanceConfig = new RubyInstanceConfig();
        rubyInstanceConfig.setInput(inputStream);
        rubyInstanceConfig.setOutput(printStream);
        rubyInstanceConfig.setError(printStream2);
        return Ruby.newInstance(rubyInstanceConfig);
    }

    private Ruby(RubyInstanceConfig rubyInstanceConfig) {
        this.config = rubyInstanceConfig;
        this.threadService = new ThreadService(this);
        if (rubyInstanceConfig.isSamplingEnabled()) {
            SimpleSampler.registerThreadContext(this.threadService.getCurrentContext());
        }
        this.in = rubyInstanceConfig.getInput();
        this.out = rubyInstanceConfig.getOutput();
        this.err = rubyInstanceConfig.getError();
        this.objectSpaceEnabled = rubyInstanceConfig.isObjectSpaceEnabled();
        this.profile = rubyInstanceConfig.getProfile();
        this.currentDirectory = rubyInstanceConfig.getCurrentDirectory();
        this.kcode = rubyInstanceConfig.getKCode();
    }

    public IRubyObject evalScriptlet(String string) {
        ThreadContext threadContext = this.getCurrentContext();
        Node node = this.parseEval(string, "<script>", threadContext.getCurrentScope(), 0);
        try {
            return ASTInterpreter.eval(this, threadContext, node, threadContext.getFrameSelf(), Block.NULL_BLOCK);
        }
        catch (JumpException.ReturnJump returnJump) {
            throw this.newLocalJumpError("return", (IRubyObject)returnJump.getValue(), "unexpected return");
        }
        catch (JumpException.BreakJump breakJump) {
            throw this.newLocalJumpError("break", (IRubyObject)breakJump.getValue(), "unexpected break");
        }
        catch (JumpException.RedoJump redoJump) {
            throw this.newLocalJumpError("redo", (IRubyObject)redoJump.getValue(), "unexpected redo");
        }
    }

    public IRubyObject executeScript(String string, String string2) {
        byte[] byArray;
        try {
            byArray = string.getBytes(KCode.NONE.getKCode());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = string.getBytes();
        }
        Node node = this.parseInline(new ByteArrayInputStream(byArray), string2, null);
        Frame frame = this.getCurrentContext().getCurrentFrame();
        frame.setFile(node.getPosition().getFile());
        frame.setLine(node.getPosition().getStartLine());
        return this.runNormally(node, false);
    }

    public void runFromMain(InputStream inputStream, String string) {
        ValueAccessor valueAccessor = new ValueAccessor(this.newString(string));
        this.getGlobalVariables().define("$PROGRAM_NAME", valueAccessor);
        this.getGlobalVariables().define("$0", valueAccessor);
        for (Map.Entry entry : this.config.getOptionGlobals().entrySet()) {
            Object v = entry.getValue();
            RubyObject rubyObject = v != null ? this.newString(v.toString()) : this.getTrue();
            this.getGlobalVariables().set("$" + entry.getKey().toString(), rubyObject);
        }
        if (this.config.isYARVEnabled()) {
            new YARVCompiledRunner(this, inputStream, string).run();
        } else if (this.config.isRubiniusEnabled()) {
            new RubiniusRunner(this, inputStream, string).run();
        } else {
            Map.Entry entry;
            Node node = this.parseFromMain(inputStream, string);
            entry = this.getCurrentContext().getCurrentFrame();
            ((Frame)((Object)entry)).setFile(node.getPosition().getFile());
            ((Frame)((Object)entry)).setLine(node.getPosition().getStartLine());
            if (this.config.isAssumePrinting() || this.config.isAssumeLoop()) {
                this.runWithGetsLoop(node, this.config.isAssumePrinting(), this.config.isProcessLineEnds(), this.config.isSplit(), this.config.isYARVCompileEnabled());
            } else {
                this.runNormally(node, this.config.isYARVCompileEnabled());
            }
        }
    }

    public Node parseFromMain(InputStream inputStream, String string) {
        if (this.config.isInlineScript()) {
            return this.parseInline(inputStream, string, this.getCurrentContext().getCurrentScope());
        }
        return this.parseFile(inputStream, string, this.getCurrentContext().getCurrentScope());
    }

    public IRubyObject runWithGetsLoop(Node node, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        ThreadContext threadContext = this.getCurrentContext();
        Script script = null;
        YARVCompiledRunner yARVCompiledRunner = null;
        boolean bl5 = this.getInstanceConfig().getCompileMode().shouldPrecompileCLI();
        if (bl5 || !bl4) {
            script = this.tryCompile(node);
            if (bl5 && script == null) {
                return this.getNil();
            }
        } else if (bl4) {
            yARVCompiledRunner = this.tryCompileYarv(node);
        }
        if (bl2) {
            this.getGlobalVariables().set("$\\", this.getGlobalVariables().get("$/"));
        }
        block4: while (RubyKernel.gets(threadContext, this.getTopSelf(), IRubyObject.NULL_ARRAY).isTrue()) {
            while (true) {
                try {
                    if (bl2) {
                        this.getGlobalVariables().get("$_").callMethod(threadContext, "chop!");
                    }
                    if (bl3) {
                        this.getGlobalVariables().set("$F", this.getGlobalVariables().get("$_").callMethod(threadContext, "split"));
                    }
                    if (script != null) {
                        this.runScript(script);
                    } else if (yARVCompiledRunner != null) {
                        this.runYarv(yARVCompiledRunner);
                    } else {
                        this.runInterpreter(node);
                    }
                    if (!bl) continue block4;
                    RubyKernel.print(threadContext, this.getKernel(), new IRubyObject[]{this.getGlobalVariables().get("$_")});
                    continue block4;
                }
                catch (JumpException.RedoJump redoJump) {
                    continue;
                }
                catch (JumpException.NextJump nextJump) {
                    continue block4;
                }
                catch (JumpException.BreakJump breakJump) {
                    return (IRubyObject)breakJump.getValue();
                }
                break;
            }
        }
        return this.getNil();
    }

    public IRubyObject runNormally(Node node, boolean bl) {
        Script script = null;
        YARVCompiledRunner yARVCompiledRunner = null;
        boolean bl2 = this.getInstanceConfig().getCompileMode().shouldPrecompileCLI();
        boolean bl3 = this.getInstanceConfig().getCompileMode().shouldPrecompileAll();
        if (bl2) {
            script = this.tryCompile(node);
            if (bl3 && script == null) {
                System.err.println("Error, could not compile; pass -J-Djruby.jit.logging.verbose=true for more details");
                return this.getNil();
            }
        } else if (bl) {
            yARVCompiledRunner = this.tryCompileYarv(node);
        }
        if (script != null) {
            return this.runScript(script);
        }
        if (yARVCompiledRunner != null) {
            return this.runYarv(yARVCompiledRunner);
        }
        return this.runInterpreter(node);
    }

    private Script tryCompile(Node node) {
        return this.tryCompile(node, new JRubyClassLoader(this.getJRubyClassLoader()));
    }

    private Script tryCompile(Node node, JRubyClassLoader jRubyClassLoader) {
        Script script;
        block11: {
            script = null;
            try {
                String string = node.getPosition().getFile();
                String string2 = JavaNameMangler.mangledFilenameForStartupClasspath(string);
                ASTInspector aSTInspector = new ASTInspector();
                aSTInspector.inspect(node);
                StandardASMCompiler standardASMCompiler = new StandardASMCompiler(string2, string);
                ASTCompiler aSTCompiler = new ASTCompiler();
                aSTCompiler.compileRoot(node, standardASMCompiler, aSTInspector);
                script = (Script)standardASMCompiler.loadClass(jRubyClassLoader).newInstance();
                if (this.config.isJitLogging()) {
                    System.err.println("compiled: " + node.getPosition().getFile());
                }
            }
            catch (NotCompilableException notCompilableException) {
                if (this.config.isJitLoggingVerbose()) {
                    System.err.println("Error -- Not compileable: " + notCompilableException.getMessage());
                    notCompilableException.printStackTrace();
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (this.config.isJitLoggingVerbose()) {
                    System.err.println("Error -- Not compileable: " + classNotFoundException.getMessage());
                    classNotFoundException.printStackTrace();
                }
            }
            catch (InstantiationException instantiationException) {
                if (this.config.isJitLoggingVerbose()) {
                    System.err.println("Error -- Not compileable: " + instantiationException.getMessage());
                    instantiationException.printStackTrace();
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                if (this.config.isJitLoggingVerbose()) {
                    System.err.println("Error -- Not compileable: " + illegalAccessException.getMessage());
                    illegalAccessException.printStackTrace();
                }
            }
            catch (Throwable throwable) {
                if (!this.config.isJitLoggingVerbose()) break block11;
                System.err.println("could not compile: " + node.getPosition().getFile() + " because of: \"" + throwable.getMessage() + "\"");
                throwable.printStackTrace();
            }
        }
        return script;
    }

    private YARVCompiledRunner tryCompileYarv(Node node) {
        try {
            StandardYARVCompiler standardYARVCompiler = new StandardYARVCompiler(this);
            ASTCompiler.getYARVCompiler().compile(node, standardYARVCompiler);
            ISourcePosition iSourcePosition = node.getPosition();
            if (iSourcePosition == null && node instanceof RootNode) {
                iSourcePosition = ((RootNode)node).getBodyNode().getPosition();
            }
            return new YARVCompiledRunner(this, standardYARVCompiler.getInstructionSequence("<main>", iSourcePosition.getFile(), "toplevel"));
        }
        catch (NotCompilableException notCompilableException) {
            System.err.println("Error -- Not compileable: " + notCompilableException.getMessage());
            return null;
        }
        catch (JumpException.ReturnJump returnJump) {
            return null;
        }
    }

    private IRubyObject runScript(Script script) {
        ThreadContext threadContext = this.getCurrentContext();
        try {
            return script.load(threadContext, threadContext.getFrameSelf(), IRubyObject.NULL_ARRAY, Block.NULL_BLOCK);
        }
        catch (JumpException.ReturnJump returnJump) {
            return (IRubyObject)returnJump.getValue();
        }
    }

    private IRubyObject runYarv(YARVCompiledRunner yARVCompiledRunner) {
        try {
            return yARVCompiledRunner.run();
        }
        catch (JumpException.ReturnJump returnJump) {
            return (IRubyObject)returnJump.getValue();
        }
    }

    private IRubyObject runInterpreter(Node node) {
        ThreadContext threadContext = this.getCurrentContext();
        try {
            return ASTInterpreter.eval(this, threadContext, node, this.getTopSelf(), Block.NULL_BLOCK);
        }
        catch (JumpException.ReturnJump returnJump) {
            return (IRubyObject)returnJump.getValue();
        }
    }

    public static Ruby getDefaultInstance() {
        return Ruby.newInstance();
    }

    public static Ruby getCurrentInstance() {
        return currentRuntime.get();
    }

    public static void setCurrentInstance(Ruby ruby) {
        currentRuntime.set(ruby);
    }

    public int allocSymbolId() {
        return this.symbolLastId.incrementAndGet();
    }

    public int allocModuleId() {
        return this.moduleLastId.incrementAndGet();
    }

    public RubyModule getModule(String string) {
        return (RubyModule)this.objectClass.getConstantAt(string);
    }

    public RubyModule fastGetModule(String string) {
        return (RubyModule)this.objectClass.fastGetConstantAt(string);
    }

    public RubyClass getClass(String string) {
        return this.objectClass.getClass(string);
    }

    public RubyClass fastGetClass(String string) {
        return this.objectClass.fastGetClass(string);
    }

    public RubyClass defineClass(String string, RubyClass rubyClass, ObjectAllocator objectAllocator) {
        return this.defineClassUnder(string, rubyClass, objectAllocator, this.objectClass);
    }

    public RubyClass defineClassUnder(String string, RubyClass rubyClass, ObjectAllocator objectAllocator, RubyModule rubyModule) {
        boolean bl;
        IRubyObject iRubyObject = rubyModule.getConstantAt(string);
        if (iRubyObject != null) {
            if (!(iRubyObject instanceof RubyClass)) {
                throw this.newTypeError(string + " is not a class");
            }
            RubyClass rubyClass2 = (RubyClass)iRubyObject;
            if (rubyClass2.getSuperClass().getRealClass() != rubyClass) {
                throw this.newNameError(string + " is already defined", string);
            }
            if (rubyClass2.getAllocator() != objectAllocator) {
                rubyClass2.setAllocator(objectAllocator);
            }
            return rubyClass2;
        }
        boolean bl2 = bl = rubyModule == this.objectClass;
        if (rubyClass == null) {
            String string2 = bl ? string : rubyModule.getName() + "::" + string;
            this.warnings.warn(IRubyWarnings.ID.NO_SUPER_CLASS, "no super class for `" + string2 + "', Object assumed", string2);
            rubyClass = this.objectClass;
        }
        return RubyClass.newClass(this, rubyClass, string, objectAllocator, rubyModule, !bl);
    }

    public RubyModule defineModule(String string) {
        return this.defineModuleUnder(string, this.objectClass);
    }

    public RubyModule defineModuleUnder(String string, RubyModule rubyModule) {
        boolean bl;
        IRubyObject iRubyObject = rubyModule.getConstantAt(string);
        boolean bl2 = bl = rubyModule == this.objectClass;
        if (iRubyObject != null) {
            if (iRubyObject.isModule()) {
                return (RubyModule)iRubyObject;
            }
            if (bl) {
                throw this.newTypeError(iRubyObject.getMetaClass().getName() + " is not a module");
            }
            throw this.newTypeError(rubyModule.getName() + "::" + iRubyObject.getMetaClass().getName() + " is not a module");
        }
        return RubyModule.newModule(this, string, rubyModule, !bl);
    }

    public RubyModule getOrCreateModule(String string) {
        IRubyObject iRubyObject = this.objectClass.getConstantAt(string);
        if (iRubyObject == null) {
            iRubyObject = this.defineModule(string);
        } else {
            if (this.getSafeLevel() >= 4) {
                throw this.newSecurityError("Extending module prohibited.");
            }
            if (!iRubyObject.isModule()) {
                throw this.newTypeError(string + " is not a Module");
            }
        }
        return (RubyModule)iRubyObject;
    }

    public int getSafeLevel() {
        return this.safeLevel;
    }

    public void setSafeLevel(int n) {
        this.safeLevel = n;
    }

    public KCode getKCode() {
        return this.kcode;
    }

    public void setKCode(KCode kCode) {
        this.kcode = kCode;
    }

    public void secure(int n) {
        if (n <= this.safeLevel) {
            throw this.newSecurityError("Insecure operation '" + this.getCurrentContext().getFrameName() + "' at level " + this.safeLevel);
        }
    }

    public void checkSafeString(IRubyObject iRubyObject) {
        if (this.getSafeLevel() > 0 && iRubyObject.isTaint()) {
            ThreadContext threadContext = this.getCurrentContext();
            if (threadContext.getFrameName() != null) {
                throw this.newSecurityError("Insecure operation - " + threadContext.getFrameName());
            }
            throw this.newSecurityError("Insecure operation: -r");
        }
        this.secure(4);
        if (!(iRubyObject instanceof RubyString)) {
            throw this.newTypeError("wrong argument type " + iRubyObject.getMetaClass().getName() + " (expected String)");
        }
    }

    public void defineGlobalConstant(String string, IRubyObject iRubyObject) {
        this.objectClass.defineConstant(string, iRubyObject);
    }

    public boolean isClassDefined(String string) {
        return this.getModule(string) != null;
    }

    private void init() {
        ThreadContext threadContext = this.getCurrentContext();
        this.safeLevel = this.config.getSafeLevel();
        this.loadService = this.config.createLoadService(this);
        this.posix = POSIXFactory.getPOSIX(new JRubyPOSIXHandler(this), RubyInstanceConfig.nativeEnabled);
        this.javaSupport = new JavaSupport(this);
        if (RubyInstanceConfig.POOLING_ENABLED) {
            Executors.newCachedThreadPool();
            this.executor = new ThreadPoolExecutor(RubyInstanceConfig.POOL_MIN, RubyInstanceConfig.POOL_MAX, (long)RubyInstanceConfig.POOL_TTL, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new DaemonThreadFactory());
        }
        this.bootstrap();
        threadContext.prepareTopLevel(this.objectClass, this.topSelf);
        RubyGlobal.createGlobals(this);
        this.getLoadService().init(this.config.loadPaths());
        this.initBuiltins();
        for (String string : this.config.requiredLibraries()) {
            RubyKernel.require(this.getTopSelf(), this.newString(string), Block.NULL_BLOCK);
        }
    }

    private void bootstrap() {
        this.undef = new RubyUndef();
        this.initRoot();
        this.initCore();
        this.initExceptions();
    }

    private void initRoot() {
        this.objectClass = RubyClass.createBootstrapClass(this, "Object", null, RubyObject.OBJECT_ALLOCATOR);
        this.moduleClass = RubyClass.createBootstrapClass(this, "Module", this.objectClass, RubyModule.MODULE_ALLOCATOR);
        this.classClass = RubyClass.createBootstrapClass(this, "Class", this.moduleClass, RubyClass.CLASS_ALLOCATOR);
        this.objectClass.setMetaClass(this.classClass);
        this.moduleClass.setMetaClass(this.classClass);
        this.classClass.setMetaClass(this.classClass);
        RubyClass rubyClass = this.objectClass.makeMetaClass(this.classClass);
        rubyClass = this.moduleClass.makeMetaClass(rubyClass);
        rubyClass = this.classClass.makeMetaClass(rubyClass);
        RubyObject.createObjectClass(this, this.objectClass);
        RubyModule.createModuleClass(this, this.moduleClass);
        RubyClass.createClassClass(this, this.classClass);
        this.objectClass.setConstant("Object", this.objectClass);
        this.objectClass.setConstant("Class", this.classClass);
        this.objectClass.setConstant("Module", this.moduleClass);
        RubyKernel.createKernelModule(this);
        this.objectClass.includeModule(this.kernelModule);
        this.topSelf = TopSelfFactory.createTopSelf(this);
    }

    private void initCore() {
        RubyNil.createNilClass(this);
        RubyBoolean.createFalseClass(this);
        RubyBoolean.createTrueClass(this);
        this.nilObject = new RubyNil(this);
        this.falseObject = new RubyBoolean(this, false);
        this.trueObject = new RubyBoolean(this, true);
        RubyComparable.createComparable(this);
        RubyEnumerable.createEnumerableModule(this);
        RubyString.createStringClass(this);
        RubySymbol.createSymbolClass(this);
        if (this.profile.allowClass("ThreadGroup")) {
            RubyThreadGroup.createThreadGroupClass(this);
        }
        if (this.profile.allowClass("Thread")) {
            RubyThread.createThreadClass(this);
        }
        if (this.profile.allowClass("Exception")) {
            RubyException.createExceptionClass(this);
        }
        if (this.profile.allowModule("Precision")) {
            RubyPrecision.createPrecisionModule(this);
        }
        if (this.profile.allowClass("Numeric")) {
            RubyNumeric.createNumericClass(this);
        }
        if (this.profile.allowClass("Integer")) {
            RubyInteger.createIntegerClass(this);
        }
        if (this.profile.allowClass("Fixnum")) {
            RubyFixnum.createFixnumClass(this);
        }
        if (this.profile.allowClass("Hash")) {
            RubyHash.createHashClass(this);
        }
        if (this.profile.allowClass("Array")) {
            RubyArray.createArrayClass(this);
        }
        if (this.profile.allowClass("Float")) {
            RubyFloat.createFloatClass(this);
        }
        if (this.profile.allowClass("Bignum")) {
            RubyBignum.createBignumClass(this);
        }
        this.ioClass = RubyIO.createIOClass(this);
        if (this.profile.allowClass("Struct")) {
            RubyStruct.createStructClass(this);
        }
        if (this.profile.allowClass("Tms")) {
            this.tmsStruct = RubyStruct.newInstance(this.structClass, new IRubyObject[]{this.newString("Tms"), this.newSymbol("utime"), this.newSymbol("stime"), this.newSymbol("cutime"), this.newSymbol("cstime")}, Block.NULL_BLOCK);
        }
        if (this.profile.allowClass("Binding")) {
            RubyBinding.createBindingClass(this);
        }
        if (this.profile.allowModule("Math")) {
            RubyMath.createMathModule(this);
        }
        if (this.profile.allowClass("Regexp")) {
            RubyRegexp.createRegexpClass(this);
        }
        if (this.profile.allowClass("Range")) {
            RubyRange.createRangeClass(this);
        }
        if (this.profile.allowModule("ObjectSpace")) {
            RubyObjectSpace.createObjectSpaceModule(this);
        }
        if (this.profile.allowModule("GC")) {
            RubyGC.createGCModule(this);
        }
        if (this.profile.allowClass("Proc")) {
            RubyProc.createProcClass(this);
        }
        if (this.profile.allowClass("Method")) {
            RubyMethod.createMethodClass(this);
        }
        if (this.profile.allowClass("MatchData")) {
            RubyMatchData.createMatchDataClass(this);
        }
        if (this.profile.allowModule("Marshal")) {
            RubyMarshal.createMarshalModule(this);
        }
        if (this.profile.allowClass("Dir")) {
            RubyDir.createDirClass(this);
        }
        if (this.profile.allowModule("FileTest")) {
            RubyFileTest.createFileTestModule(this);
        }
        if (this.profile.allowClass("File")) {
            RubyFile.createFileClass(this);
        }
        if (this.profile.allowClass("File::Stat")) {
            RubyFileStat.createFileStatClass(this);
        }
        if (this.profile.allowModule("Process")) {
            RubyProcess.createProcessModule(this);
        }
        if (this.profile.allowClass("Time")) {
            RubyTime.createTimeClass(this);
        }
        if (this.profile.allowClass("UnboundMethod")) {
            RubyUnboundMethod.defineUnboundMethodClass(this);
        }
        if (this.profile.allowClass("Data")) {
            this.defineClass("Data", this.objectClass, this.objectClass.getAllocator());
        }
        if (!Ruby.isSecurityRestricted() && this.profile.allowModule("Signal")) {
            RubySignal.createSignal(this);
        }
        if (this.profile.allowClass("Continuation")) {
            RubyContinuation.createContinuation(this);
        }
    }

    private void initExceptions() {
        this.standardError = this.defineClassIfAllowed("StandardError", this.exceptionClass);
        this.runtimeError = this.defineClassIfAllowed("RuntimeError", this.standardError);
        this.ioError = this.defineClassIfAllowed("IOError", this.standardError);
        this.scriptError = this.defineClassIfAllowed("ScriptError", this.exceptionClass);
        this.rangeError = this.defineClassIfAllowed("RangeError", this.standardError);
        this.signalException = this.defineClassIfAllowed("SignalException", this.exceptionClass);
        if (this.profile.allowClass("NameError")) {
            this.nameError = RubyNameError.createNameErrorClass(this, this.standardError);
        }
        if (this.profile.allowClass("NoMethodError")) {
            RubyNoMethodError.createNoMethodErrorClass(this, this.nameError);
        }
        if (this.profile.allowClass("SystemExit")) {
            RubySystemExit.createSystemExitClass(this, this.exceptionClass);
        }
        if (this.profile.allowClass("LocalJumpError")) {
            RubyLocalJumpError.createLocalJumpErrorClass(this, this.standardError);
        }
        if (this.profile.allowClass("NativeException")) {
            NativeException.createClass(this, this.runtimeError);
        }
        if (this.profile.allowClass("SystemCallError")) {
            this.systemCallError = RubySystemCallError.createSystemCallErrorClass(this, this.standardError);
        }
        this.defineClassIfAllowed("Fatal", this.exceptionClass);
        this.defineClassIfAllowed("Interrupt", this.signalException);
        this.defineClassIfAllowed("TypeError", this.standardError);
        this.defineClassIfAllowed("ArgumentError", this.standardError);
        this.defineClassIfAllowed("IndexError", this.standardError);
        this.defineClassIfAllowed("SyntaxError", this.scriptError);
        this.defineClassIfAllowed("LoadError", this.scriptError);
        this.defineClassIfAllowed("NotImplementedError", this.scriptError);
        this.defineClassIfAllowed("SecurityError", this.standardError);
        this.defineClassIfAllowed("NoMemoryError", this.exceptionClass);
        this.defineClassIfAllowed("RegexpError", this.standardError);
        this.defineClassIfAllowed("EOFError", this.ioError);
        this.defineClassIfAllowed("ThreadError", this.standardError);
        this.defineClassIfAllowed("SystemStackError", this.standardError);
        this.defineClassIfAllowed("ZeroDivisionError", this.standardError);
        this.defineClassIfAllowed("FloatDomainError", this.rangeError);
        this.initErrno();
    }

    private RubyClass defineClassIfAllowed(String string, RubyClass rubyClass) {
        if (rubyClass != null && this.profile.allowClass(string)) {
            return this.defineClass(string, rubyClass, rubyClass.getAllocator());
        }
        return null;
    }

    public RubyClass getErrno(int n) {
        return this.errnos.get(n);
    }

    private void initErrno() {
        if (this.profile.allowModule("Errno")) {
            this.errnoModule = this.defineModule("Errno");
            Field[] fieldArray = IErrno.class.getFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                try {
                    this.createSysErr(fieldArray[i].getInt(IErrno.class), fieldArray[i].getName());
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new RuntimeException("Someone defined a non-public constant in IErrno.java", illegalAccessException);
                }
            }
        }
    }

    private void createSysErr(int n, String string) {
        if (this.profile.allowClass(string)) {
            RubyClass rubyClass = this.errnoModule.defineClassUnder(string, this.systemCallError, this.systemCallError.getAllocator());
            this.errnos.put(n, rubyClass);
            rubyClass.defineConstant("Errno", this.newFixnum(n));
        }
    }

    private void initBuiltins() {
        String[] stringArray;
        this.addLazyBuiltin("java.rb", "java", "org.jruby.javasupport.Java");
        this.addLazyBuiltin("jruby.rb", "jruby", "org.jruby.libraries.JRubyLibrary");
        this.addLazyBuiltin("jruby/ext.rb", "jruby/ext", "org.jruby.RubyJRuby$ExtLibrary");
        this.addLazyBuiltin("iconv.rb", "iconv", "org.jruby.libraries.IConvLibrary");
        this.addLazyBuiltin("nkf.rb", "nkf", "org.jruby.libraries.NKFLibrary");
        this.addLazyBuiltin("stringio.rb", "stringio", "org.jruby.libraries.StringIOLibrary");
        this.addLazyBuiltin("strscan.rb", "strscan", "org.jruby.libraries.StringScannerLibrary");
        this.addLazyBuiltin("zlib.rb", "zlib", "org.jruby.libraries.ZlibLibrary");
        this.addLazyBuiltin("yaml_internal.rb", "yaml_internal", "org.jruby.libraries.YamlLibrary");
        this.addLazyBuiltin("enumerator.rb", "enumerator", "org.jruby.libraries.EnumeratorLibrary");
        this.addLazyBuiltin("generator_internal.rb", "generator_internal", "org.jruby.ext.Generator$Service");
        this.addLazyBuiltin("readline.rb", "readline", "org.jruby.ext.Readline$Service");
        this.addLazyBuiltin("thread.so", "thread", "org.jruby.libraries.ThreadLibrary");
        this.addLazyBuiltin("digest.so", "digest", "org.jruby.libraries.DigestLibrary");
        this.addLazyBuiltin("digest.rb", "digest", "org.jruby.libraries.DigestLibrary");
        this.addLazyBuiltin("digest/md5.rb", "digest/md5", "org.jruby.libraries.DigestLibrary$MD5");
        this.addLazyBuiltin("digest/rmd160.rb", "digest/rmd160", "org.jruby.libraries.DigestLibrary$RMD160");
        this.addLazyBuiltin("digest/sha1.rb", "digest/sha1", "org.jruby.libraries.DigestLibrary$SHA1");
        this.addLazyBuiltin("digest/sha2.rb", "digest/sha2", "org.jruby.libraries.DigestLibrary$SHA2");
        this.addLazyBuiltin("bigdecimal.rb", "bigdecimal", "org.jruby.libraries.BigDecimalLibrary");
        this.addLazyBuiltin("io/wait.so", "io/wait", "org.jruby.libraries.IOWaitLibrary");
        this.addLazyBuiltin("etc.so", "etc", "org.jruby.libraries.EtcLibrary");
        this.addLazyBuiltin("weakref.rb", "weakref", "org.jruby.ext.WeakRef$WeakRefLibrary");
        this.addLazyBuiltin("socket.rb", "socket", "org.jruby.ext.socket.RubySocket$Service");
        this.addLazyBuiltin("rbconfig.rb", "rbconfig", "org.jruby.libraries.RbConfigLibrary");
        if (this.config.getCompatVersion() == CompatVersion.RUBY1_9) {
            this.addLazyBuiltin("fiber.so", "fiber", "org.jruby.libraries.FiberLibrary");
        }
        this.addBuiltinIfAllowed("openssl.so", new Library(){

            public void load(Ruby ruby, boolean bl) throws IOException {
                ruby.getLoadService().require("jruby/openssl/stub");
            }
        });
        for (String string : stringArray = new String[]{"fcntl", "yaml", "yaml/syck", "jsignal"}) {
            this.addBuiltinIfAllowed(string + ".rb", new BuiltinScript(string));
        }
        RubyKernel.autoload(this.topSelf, this.newSymbol("Java"), this.newString("java"));
    }

    private void addLazyBuiltin(String string, String string2, String string3) {
        this.addBuiltinIfAllowed(string, new LateLoadingLibrary(string2, string3, this.getJRubyClassLoader()));
    }

    private void addBuiltinIfAllowed(String string, Library library) {
        if (this.profile.allowBuiltin(string)) {
            this.loadService.addBuiltinLibrary(string, library);
        }
    }

    Object getRespondToMethod() {
        return this.respondToMethod;
    }

    void setRespondToMethod(Object object) {
        this.respondToMethod = object;
    }

    public Object getObjectToYamlMethod() {
        return this.objectToYamlMethod;
    }

    void setObjectToYamlMethod(Object object) {
        this.objectToYamlMethod = object;
    }

    public CacheMap getCacheMap() {
        return this.cacheMap;
    }

    public IRubyObject getTopSelf() {
        return this.topSelf;
    }

    public void setCurrentDirectory(String string) {
        this.currentDirectory = string;
    }

    public String getCurrentDirectory() {
        return this.currentDirectory;
    }

    public IRubyObject getUndef() {
        return this.undef;
    }

    public RubyModule getEtc() {
        return this.etcModule;
    }

    public void setEtc(RubyModule rubyModule) {
        this.etcModule = rubyModule;
    }

    public RubyClass getObject() {
        return this.objectClass;
    }

    public RubyClass getModule() {
        return this.moduleClass;
    }

    public RubyClass getClassClass() {
        return this.classClass;
    }

    public RubyModule getKernel() {
        return this.kernelModule;
    }

    void setKernel(RubyModule rubyModule) {
        this.kernelModule = rubyModule;
    }

    public RubyModule getComparable() {
        return this.comparableModule;
    }

    void setComparable(RubyModule rubyModule) {
        this.comparableModule = rubyModule;
    }

    public RubyClass getNumeric() {
        return this.numericClass;
    }

    void setNumeric(RubyClass rubyClass) {
        this.numericClass = rubyClass;
    }

    public RubyClass getFloat() {
        return this.floatClass;
    }

    void setFloat(RubyClass rubyClass) {
        this.floatClass = rubyClass;
    }

    public RubyClass getInteger() {
        return this.integerClass;
    }

    void setInteger(RubyClass rubyClass) {
        this.integerClass = rubyClass;
    }

    public RubyClass getFixnum() {
        return this.fixnumClass;
    }

    void setFixnum(RubyClass rubyClass) {
        this.fixnumClass = rubyClass;
    }

    public RubyModule getEnumerable() {
        return this.enumerableModule;
    }

    void setEnumerable(RubyModule rubyModule) {
        this.enumerableModule = rubyModule;
    }

    public RubyClass getString() {
        return this.stringClass;
    }

    void setString(RubyClass rubyClass) {
        this.stringClass = rubyClass;
    }

    public RubyClass getSymbol() {
        return this.symbolClass;
    }

    void setSymbol(RubyClass rubyClass) {
        this.symbolClass = rubyClass;
    }

    public RubyClass getArray() {
        return this.arrayClass;
    }

    void setArray(RubyClass rubyClass) {
        this.arrayClass = rubyClass;
    }

    public RubyClass getHash() {
        return this.hashClass;
    }

    void setHash(RubyClass rubyClass) {
        this.hashClass = rubyClass;
    }

    public RubyClass getRange() {
        return this.rangeClass;
    }

    void setRange(RubyClass rubyClass) {
        this.rangeClass = rubyClass;
    }

    public RubyBoolean getTrue() {
        return this.trueObject;
    }

    public RubyBoolean getFalse() {
        return this.falseObject;
    }

    public IRubyObject getNil() {
        return this.nilObject;
    }

    public RubyClass getNilClass() {
        return this.nilClass;
    }

    void setNilClass(RubyClass rubyClass) {
        this.nilClass = rubyClass;
    }

    public RubyClass getTrueClass() {
        return this.trueClass;
    }

    void setTrueClass(RubyClass rubyClass) {
        this.trueClass = rubyClass;
    }

    public RubyClass getFalseClass() {
        return this.falseClass;
    }

    void setFalseClass(RubyClass rubyClass) {
        this.falseClass = rubyClass;
    }

    public RubyClass getProc() {
        return this.procClass;
    }

    void setProc(RubyClass rubyClass) {
        this.procClass = rubyClass;
    }

    public RubyClass getBinding() {
        return this.bindingClass;
    }

    void setBinding(RubyClass rubyClass) {
        this.bindingClass = rubyClass;
    }

    public RubyClass getMethod() {
        return this.methodClass;
    }

    void setMethod(RubyClass rubyClass) {
        this.methodClass = rubyClass;
    }

    public RubyClass getUnboundMethod() {
        return this.unboundMethodClass;
    }

    void setUnboundMethod(RubyClass rubyClass) {
        this.unboundMethodClass = rubyClass;
    }

    public RubyClass getMatchData() {
        return this.matchDataClass;
    }

    void setMatchData(RubyClass rubyClass) {
        this.matchDataClass = rubyClass;
    }

    public RubyClass getRegexp() {
        return this.regexpClass;
    }

    void setRegexp(RubyClass rubyClass) {
        this.regexpClass = rubyClass;
    }

    public RubyClass getTime() {
        return this.timeClass;
    }

    void setTime(RubyClass rubyClass) {
        this.timeClass = rubyClass;
    }

    public RubyModule getMath() {
        return this.mathModule;
    }

    void setMath(RubyModule rubyModule) {
        this.mathModule = rubyModule;
    }

    public RubyModule getMarshal() {
        return this.marshalModule;
    }

    void setMarshal(RubyModule rubyModule) {
        this.marshalModule = rubyModule;
    }

    public RubyClass getBignum() {
        return this.bignumClass;
    }

    void setBignum(RubyClass rubyClass) {
        this.bignumClass = rubyClass;
    }

    public RubyClass getDir() {
        return this.dirClass;
    }

    void setDir(RubyClass rubyClass) {
        this.dirClass = rubyClass;
    }

    public RubyClass getFile() {
        return this.fileClass;
    }

    void setFile(RubyClass rubyClass) {
        this.fileClass = rubyClass;
    }

    public RubyClass getFileStat() {
        return this.fileStatClass;
    }

    void setFileStat(RubyClass rubyClass) {
        this.fileStatClass = rubyClass;
    }

    public RubyModule getFileTest() {
        return this.fileTestModule;
    }

    void setFileTest(RubyModule rubyModule) {
        this.fileTestModule = rubyModule;
    }

    public RubyClass getIO() {
        return this.ioClass;
    }

    void setIO(RubyClass rubyClass) {
        this.ioClass = rubyClass;
    }

    public RubyClass getThread() {
        return this.threadClass;
    }

    void setThread(RubyClass rubyClass) {
        this.threadClass = rubyClass;
    }

    public RubyClass getThreadGroup() {
        return this.threadGroupClass;
    }

    void setThreadGroup(RubyClass rubyClass) {
        this.threadGroupClass = rubyClass;
    }

    public RubyClass getContinuation() {
        return this.continuationClass;
    }

    void setContinuation(RubyClass rubyClass) {
        this.continuationClass = rubyClass;
    }

    public RubyClass getStructClass() {
        return this.structClass;
    }

    void setStructClass(RubyClass rubyClass) {
        this.structClass = rubyClass;
    }

    public IRubyObject getTmsStruct() {
        return this.tmsStruct;
    }

    void setTmsStruct(RubyClass rubyClass) {
        this.tmsStruct = rubyClass;
    }

    public IRubyObject getPasswdStruct() {
        return this.passwdStruct;
    }

    void setPasswdStruct(RubyClass rubyClass) {
        this.passwdStruct = rubyClass;
    }

    public IRubyObject getGroupStruct() {
        return this.groupStruct;
    }

    void setGroupStruct(RubyClass rubyClass) {
        this.groupStruct = rubyClass;
    }

    public RubyModule getGC() {
        return this.gcModule;
    }

    void setGC(RubyModule rubyModule) {
        this.gcModule = rubyModule;
    }

    public RubyModule getObjectSpaceModule() {
        return this.objectSpaceModule;
    }

    void setObjectSpaceModule(RubyModule rubyModule) {
        this.objectSpaceModule = rubyModule;
    }

    public RubyModule getProcess() {
        return this.processModule;
    }

    void setProcess(RubyModule rubyModule) {
        this.processModule = rubyModule;
    }

    public RubyClass getProcStatus() {
        return this.procStatusClass;
    }

    void setProcStatus(RubyClass rubyClass) {
        this.procStatusClass = rubyClass;
    }

    public RubyModule getProcUID() {
        return this.procUIDModule;
    }

    void setProcUID(RubyModule rubyModule) {
        this.procUIDModule = rubyModule;
    }

    public RubyModule getProcGID() {
        return this.procGIDModule;
    }

    void setProcGID(RubyModule rubyModule) {
        this.procGIDModule = rubyModule;
    }

    public RubyModule getProcSysModule() {
        return this.procSysModule;
    }

    void setProcSys(RubyModule rubyModule) {
        this.procSysModule = rubyModule;
    }

    public RubyModule getPrecision() {
        return this.precisionModule;
    }

    void setPrecision(RubyModule rubyModule) {
        this.precisionModule = rubyModule;
    }

    public RubyClass getException() {
        return this.exceptionClass;
    }

    void setException(RubyClass rubyClass) {
        this.exceptionClass = rubyClass;
    }

    public RubyClass getStandardError() {
        return this.standardError;
    }

    public IRubyObject getVerbose() {
        return this.verbose;
    }

    public void setVerbose(IRubyObject iRubyObject) {
        this.verbose = iRubyObject;
    }

    public IRubyObject getDebug() {
        return this.debug;
    }

    public void setDebug(IRubyObject iRubyObject) {
        this.debug = iRubyObject;
    }

    public JavaSupport getJavaSupport() {
        return this.javaSupport;
    }

    public synchronized JRubyClassLoader getJRubyClassLoader() {
        if (!Ruby.isSecurityRestricted() && this.jrubyClassLoader == null) {
            this.jrubyClassLoader = new JRubyClassLoader(this.config.getLoader());
        }
        return this.jrubyClassLoader;
    }

    public void defineVariable(final GlobalVariable globalVariable) {
        this.globalVariables.define(globalVariable.name(), new IAccessor(){

            public IRubyObject getValue() {
                return globalVariable.get();
            }

            public IRubyObject setValue(IRubyObject iRubyObject) {
                return globalVariable.set(iRubyObject);
            }
        });
    }

    public void defineReadonlyVariable(String string, IRubyObject iRubyObject) {
        this.globalVariables.defineReadonly(string, new ValueAccessor(iRubyObject));
    }

    public Node parseFile(InputStream inputStream, String string, DynamicScope dynamicScope) {
        return this.parser.parse(string, inputStream, dynamicScope, new ParserConfiguration(0, false, false, true));
    }

    public Node parseInline(InputStream inputStream, String string, DynamicScope dynamicScope) {
        return this.parser.parse(string, inputStream, dynamicScope, new ParserConfiguration(0, false, true));
    }

    public Node parseEval(String string, String string2, DynamicScope dynamicScope, int n) {
        byte[] byArray;
        try {
            byArray = string.getBytes(KCode.NONE.getKCode());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = string.getBytes();
        }
        return this.parser.parse(string2, new ByteArrayInputStream(byArray), dynamicScope, new ParserConfiguration(n, false));
    }

    public Node parse(String string, String string2, DynamicScope dynamicScope, int n, boolean bl) {
        byte[] byArray;
        try {
            byArray = string.getBytes(KCode.NONE.getKCode());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = string.getBytes();
        }
        return this.parser.parse(string2, new ByteArrayInputStream(byArray), dynamicScope, new ParserConfiguration(n, bl, false));
    }

    public Node parseEval(ByteList byteList, String string, DynamicScope dynamicScope, int n) {
        return this.parser.parse(string, byteList, dynamicScope, new ParserConfiguration(n, false));
    }

    public Node parse(ByteList byteList, String string, DynamicScope dynamicScope, int n, boolean bl) {
        return this.parser.parse(string, byteList, dynamicScope, new ParserConfiguration(n, bl, false));
    }

    public ThreadService getThreadService() {
        return this.threadService;
    }

    public ThreadContext getCurrentContext() {
        return this.threadService.getCurrentContext();
    }

    public LoadService getLoadService() {
        return this.loadService;
    }

    public RubyWarnings getWarnings() {
        return this.warnings;
    }

    public PrintStream getErrorStream() {
        return new PrintStream(new IOOutputStream(this.getGlobalVariables().get("$stderr")));
    }

    public InputStream getInputStream() {
        return new IOInputStream(this.getGlobalVariables().get("$stdin"));
    }

    public PrintStream getOutputStream() {
        return new PrintStream(new IOOutputStream(this.getGlobalVariables().get("$stdout")));
    }

    public RubyModule getClassFromPath(String string) {
        RubyModule rubyModule = this.getObject();
        if (string.length() == 0 || string.charAt(0) == '#') {
            throw this.newTypeError("can't retrieve anonymous class " + string);
        }
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        while (n2 < n3) {
            IRubyObject iRubyObject;
            while (n2 < n3 && string.charAt(n2) != ':') {
                ++n2;
            }
            String string2 = string.substring(n, n2);
            if (n2 < n3 && string.charAt(n2) == ':') {
                if (n2 + 1 < n3 && string.charAt(n2 + 1) != ':') {
                    throw this.newTypeError("undefined class/module " + string.substring(n, n2));
                }
                n = n2 += 2;
            }
            if (!((iRubyObject = rubyModule.getConstant(string2)) instanceof RubyModule)) {
                throw this.newTypeError("" + string + " does not refer to class/module");
            }
            rubyModule = (RubyModule)iRubyObject;
        }
        return rubyModule;
    }

    public void printError(RubyException rubyException) {
        IRubyObject iRubyObject;
        if (rubyException == null || rubyException.isNil()) {
            return;
        }
        ThreadContext threadContext = this.getCurrentContext();
        IRubyObject iRubyObject2 = rubyException.callMethod(threadContext, "backtrace");
        PrintStream printStream = this.getErrorStream();
        if (iRubyObject2.isNil() || !(iRubyObject2 instanceof RubyArray)) {
            if (threadContext.getFile() != null) {
                printStream.print(threadContext.getFile() + ":" + threadContext.getLine());
            } else {
                printStream.print(threadContext.getLine());
            }
        } else if (((RubyArray)iRubyObject2).getLength() == 0) {
            this.printErrorPos(threadContext, printStream);
        } else {
            iRubyObject = ((RubyArray)iRubyObject2).first(IRubyObject.NULL_ARRAY);
            if (iRubyObject.isNil()) {
                this.printErrorPos(threadContext, printStream);
            } else {
                printStream.print(iRubyObject);
            }
        }
        iRubyObject = rubyException.getMetaClass();
        String string = rubyException.toString();
        if (iRubyObject == this.fastGetClass("RuntimeError") && (string == null || string.length() == 0)) {
            printStream.print(": unhandled exception\n");
        } else {
            String string2 = ((RubyModule)iRubyObject).getName();
            if (string.length() == 0) {
                printStream.print(": " + string2 + '\n');
            } else {
                if (string2.startsWith("#")) {
                    string2 = null;
                }
                String string3 = null;
                if (string.indexOf("\n") != -1) {
                    string3 = string.substring(string.indexOf("\n") + 1);
                    string = string.substring(0, string.indexOf("\n"));
                }
                printStream.print(": " + string);
                if (string2 != null) {
                    printStream.print(" (" + string2 + ")\n");
                }
                if (string3 != null) {
                    printStream.print(string3 + '\n');
                }
            }
        }
        rubyException.printBacktrace(printStream);
    }

    private void printErrorPos(ThreadContext threadContext, PrintStream printStream) {
        if (threadContext.getFile() != null) {
            if (threadContext.getFrameName() != null) {
                printStream.print(threadContext.getFile() + ":" + threadContext.getLine());
                printStream.print(":in '" + threadContext.getFrameName() + '\'');
            } else if (threadContext.getLine() != 0) {
                printStream.print(threadContext.getFile() + ":" + threadContext.getLine());
            } else {
                printStream.print(threadContext.getFile());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFile(String string, InputStream inputStream, boolean bl) {
        Object object;
        if (!Ruby.isSecurityRestricted() && ((File)(object = new File(string))).exists() && !((File)object).isAbsolute() && !string.startsWith("./")) {
            string = "./" + string;
        }
        object = null;
        object = bl ? TopSelfFactory.createTopSelf(this) : this.getTopSelf();
        ThreadContext threadContext = this.getCurrentContext();
        try {
            this.secure(4);
            threadContext.preNodeEval(this.objectClass, (IRubyObject)object);
            Node node = this.parseFile(inputStream, string, null);
            ASTInterpreter.eval(this, threadContext, node, (IRubyObject)object, Block.NULL_BLOCK);
        }
        catch (JumpException.ReturnJump returnJump) {
            return;
        }
        finally {
            threadContext.postNodeEval();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compileAndLoadFile(String string, InputStream inputStream, boolean bl) {
        IRubyObject iRubyObject = null;
        iRubyObject = bl ? TopSelfFactory.createTopSelf(this) : this.getTopSelf();
        ThreadContext threadContext = this.getCurrentContext();
        try {
            this.secure(4);
            threadContext.preNodeEval(this.objectClass, iRubyObject);
            Node node = this.parseFile(inputStream, string, null);
            Script script = this.tryCompile(node, new JRubyClassLoader(this.jrubyClassLoader));
            if (script == null) {
                System.err.println("Error, could not compile; pass -J-Djruby.jit.logging.verbose=true for more details");
            }
            this.runScript(script);
        }
        catch (JumpException.ReturnJump returnJump) {
            return;
        }
        finally {
            threadContext.postNodeEval();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadScript(Script script) {
        IRubyObject iRubyObject = this.getTopSelf();
        ThreadContext threadContext = this.getCurrentContext();
        try {
            this.secure(4);
            threadContext.preNodeEval(this.objectClass, iRubyObject);
            script.load(threadContext, iRubyObject, IRubyObject.NULL_ARRAY, Block.NULL_BLOCK);
        }
        catch (JumpException.ReturnJump returnJump) {
            return;
        }
        finally {
            threadContext.postNodeEval();
        }
    }

    public void addEventHook(EventHook eventHook) {
        this.eventHooks.add(eventHook);
        this.hasEventHooks = true;
    }

    public void removeEventHook(EventHook eventHook) {
        this.eventHooks.remove(eventHook);
        this.hasEventHooks = !this.eventHooks.isEmpty();
    }

    public void setTraceFunction(RubyProc rubyProc) {
        this.removeEventHook(this.callTraceFuncHook);
        if (rubyProc == null) {
            return;
        }
        this.callTraceFuncHook.setTraceFunc(rubyProc);
        this.addEventHook(this.callTraceFuncHook);
    }

    public void callEventHooks(ThreadContext threadContext, int n, String string, int n2, String string2, IRubyObject iRubyObject) {
        for (EventHook eventHook : this.eventHooks) {
            if (!eventHook.isInterestedInEvent(n)) continue;
            eventHook.event(threadContext, n, string, n2, string2, iRubyObject);
        }
    }

    public boolean hasEventHooks() {
        return this.hasEventHooks;
    }

    public GlobalVariables getGlobalVariables() {
        return this.globalVariables;
    }

    public void setGlobalVariables(GlobalVariables globalVariables) {
        this.globalVariables = globalVariables;
    }

    public CallbackFactory callbackFactory(Class<?> clazz) {
        return CallbackFactory.createFactory(this, clazz);
    }

    public IRubyObject pushExitBlock(RubyProc rubyProc) {
        this.atExitBlocks.push(rubyProc);
        return rubyProc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInternalFinalizer(Finalizable finalizable) {
        Object object = this.internalFinalizersMutex;
        synchronized (object) {
            if (this.internalFinalizers == null) {
                this.internalFinalizers = new WeakHashMap<Finalizable, Object>();
            }
            this.internalFinalizers.put(finalizable, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFinalizer(Finalizable finalizable) {
        Object object = this.finalizersMutex;
        synchronized (object) {
            if (this.finalizers == null) {
                this.finalizers = new WeakHashMap<Finalizable, Object>();
            }
            this.finalizers.put(finalizable, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInternalFinalizer(Finalizable finalizable) {
        Object object = this.internalFinalizersMutex;
        synchronized (object) {
            if (this.internalFinalizers != null) {
                this.internalFinalizers.remove(finalizable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFinalizer(Finalizable finalizable) {
        Object object = this.finalizersMutex;
        synchronized (object) {
            if (this.finalizers != null) {
                this.finalizers.remove(finalizable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tearDown() {
        Iterator<Finalizable> iterator;
        Object object;
        while (!this.atExitBlocks.empty()) {
            object = this.atExitBlocks.pop();
            ((RubyProc)object).call(((RubyObject)object).getRuntime().getCurrentContext(), IRubyObject.NULL_ARRAY);
        }
        if (this.finalizers != null) {
            object = this.finalizers;
            synchronized (object) {
                iterator = new ArrayList<Finalizable>(this.finalizers.keySet()).iterator();
                while (iterator.hasNext()) {
                    iterator.next().finalize();
                    iterator.remove();
                }
            }
        }
        object = this.internalFinalizersMutex;
        synchronized (object) {
            if (this.internalFinalizers != null) {
                iterator = new ArrayList<Finalizable>(this.internalFinalizers.keySet()).iterator();
                while (iterator.hasNext()) {
                    iterator.next().finalize();
                    iterator.remove();
                }
            }
        }
        this.getThreadService().disposeCurrentThread();
    }

    public RubyArray newEmptyArray() {
        return RubyArray.newEmptyArray(this);
    }

    public RubyArray newArray() {
        return RubyArray.newArray(this);
    }

    public RubyArray newArrayLight() {
        return RubyArray.newArrayLight(this);
    }

    public RubyArray newArray(IRubyObject iRubyObject) {
        return RubyArray.newArray(this, iRubyObject);
    }

    public RubyArray newArray(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return RubyArray.newArray(this, iRubyObject, iRubyObject2);
    }

    public RubyArray newArray(IRubyObject[] iRubyObjectArray) {
        return RubyArray.newArray(this, iRubyObjectArray);
    }

    public RubyArray newArrayNoCopy(IRubyObject[] iRubyObjectArray) {
        return RubyArray.newArrayNoCopy(this, iRubyObjectArray);
    }

    public RubyArray newArrayNoCopyLight(IRubyObject[] iRubyObjectArray) {
        return RubyArray.newArrayNoCopyLight(this, iRubyObjectArray);
    }

    public RubyArray newArray(List<IRubyObject> list) {
        return RubyArray.newArray(this, list);
    }

    public RubyArray newArray(int n) {
        return RubyArray.newArray(this, n);
    }

    public RubyBoolean newBoolean(boolean bl) {
        return RubyBoolean.newBoolean(this, bl);
    }

    public RubyFileStat newFileStat(String string, boolean bl) {
        return RubyFileStat.newFileStat(this, string, bl);
    }

    public RubyFileStat newFileStat(FileDescriptor fileDescriptor) {
        return RubyFileStat.newFileStat(this, fileDescriptor);
    }

    public RubyFixnum newFixnum(long l) {
        return RubyFixnum.newFixnum(this, l);
    }

    public RubyFloat newFloat(double d) {
        return RubyFloat.newFloat(this, d);
    }

    public RubyNumeric newNumeric() {
        return RubyNumeric.newNumeric(this);
    }

    public RubyProc newProc(Block.Type type, Block block) {
        if (type != Block.Type.LAMBDA && block.getProcObject() != null) {
            return block.getProcObject();
        }
        RubyProc rubyProc = RubyProc.newProc(this, type);
        rubyProc.callInit(IRubyObject.NULL_ARRAY, block);
        return rubyProc;
    }

    public RubyBinding newBinding() {
        return RubyBinding.newBinding(this);
    }

    public RubyBinding newBinding(Binding binding) {
        return RubyBinding.newBinding(this, binding);
    }

    public RubyString newString() {
        return RubyString.newString(this, "");
    }

    public RubyString newString(String string) {
        return RubyString.newString(this, string);
    }

    public RubyString newString(ByteList byteList) {
        return RubyString.newString(this, byteList);
    }

    public RubyString newStringShared(ByteList byteList) {
        return RubyString.newStringShared(this, byteList);
    }

    public RubySymbol newSymbol(String string) {
        return this.symbolTable.getSymbol(string);
    }

    public RubySymbol fastNewSymbol(String string) {
        assert (string == string.intern()) : string + " is not interned";
        return this.symbolTable.fastGetSymbol(string);
    }

    public RubyTime newTime(long l) {
        return RubyTime.newTime(this, l);
    }

    public RaiseException newRuntimeError(String string) {
        return this.newRaiseException(this.fastGetClass("RuntimeError"), string);
    }

    public RaiseException newArgumentError(String string) {
        return this.newRaiseException(this.fastGetClass("ArgumentError"), string);
    }

    public RaiseException newArgumentError(int n, int n2) {
        return this.newRaiseException(this.fastGetClass("ArgumentError"), "wrong # of arguments(" + n + " for " + n2 + ")");
    }

    public RaiseException newErrnoEBADFError() {
        return this.newRaiseException(this.fastGetModule("Errno").fastGetClass("EBADF"), "Bad file descriptor");
    }

    public RaiseException newErrnoENOPROTOOPTError() {
        return this.newRaiseException(this.fastGetModule("Errno").fastGetClass("ENOPROTOOPT"), "Protocol not available");
    }

    public RaiseException newErrnoEPIPEError() {
        return this.newRaiseException(this.fastGetModule("Errno").fastGetClass("EPIPE"), "Broken pipe");
    }

    public RaiseException newErrnoECONNREFUSEDError() {
        return this.newRaiseException(this.fastGetModule("Errno").fastGetClass("ECONNREFUSED"), "Connection refused");
    }

    public RaiseException newErrnoEADDRINUSEError() {
        return this.newRaiseException(this.fastGetModule("Errno").fastGetClass("EADDRINUSE"), "Address in use");
    }

    public RaiseException newErrnoEINVALError() {
        return this.newRaiseException(this.fastGetModule("Errno").fastGetClass("EINVAL"), "Invalid file");
    }

    public RaiseException newErrnoENOENTError() {
        return this.newRaiseException(this.fastGetModule("Errno").fastGetClass("ENOENT"), "File not found");
    }

    public RaiseException newErrnoEACCESError(String string) {
        return this.newRaiseException(this.fastGetModule("Errno").fastGetClass("EACCES"), string);
    }

    public RaiseException newErrnoEAGAINError(String string) {
        return this.newRaiseException(this.fastGetModule("Errno").fastGetClass("EAGAIN"), string);
    }

    public RaiseException newErrnoEISDirError() {
        return this.newRaiseException(this.fastGetModule("Errno").fastGetClass("EISDIR"), "Is a directory");
    }

    public RaiseException newErrnoESPIPEError() {
        return this.newRaiseException(this.fastGetModule("Errno").fastGetClass("ESPIPE"), "Illegal seek");
    }

    public RaiseException newErrnoEBADFError(String string) {
        return this.newRaiseException(this.fastGetModule("Errno").fastGetClass("EBADF"), string);
    }

    public RaiseException newErrnoEINVALError(String string) {
        return this.newRaiseException(this.fastGetModule("Errno").fastGetClass("EINVAL"), string);
    }

    public RaiseException newErrnoENOTDIRError(String string) {
        return this.newRaiseException(this.fastGetModule("Errno").fastGetClass("ENOTDIR"), string);
    }

    public RaiseException newErrnoENOENTError(String string) {
        return this.newRaiseException(this.fastGetModule("Errno").fastGetClass("ENOENT"), string);
    }

    public RaiseException newErrnoESPIPEError(String string) {
        return this.newRaiseException(this.fastGetModule("Errno").fastGetClass("ESPIPE"), string);
    }

    public RaiseException newErrnoEEXISTError(String string) {
        return this.newRaiseException(this.fastGetModule("Errno").fastGetClass("EEXIST"), string);
    }

    public RaiseException newErrnoEDOMError(String string) {
        return this.newRaiseException(this.fastGetModule("Errno").fastGetClass("EDOM"), "Domain error - " + string);
    }

    public RaiseException newErrnoECHILDError() {
        return this.newRaiseException(this.fastGetModule("Errno").fastGetClass("ECHILD"), "No child processes");
    }

    public RaiseException newIndexError(String string) {
        return this.newRaiseException(this.fastGetClass("IndexError"), string);
    }

    public RaiseException newSecurityError(String string) {
        return this.newRaiseException(this.fastGetClass("SecurityError"), string);
    }

    public RaiseException newSystemCallError(String string) {
        return this.newRaiseException(this.fastGetClass("SystemCallError"), string);
    }

    public RaiseException newTypeError(String string) {
        return this.newRaiseException(this.fastGetClass("TypeError"), string);
    }

    public RaiseException newThreadError(String string) {
        return this.newRaiseException(this.fastGetClass("ThreadError"), string);
    }

    public RaiseException newSyntaxError(String string) {
        return this.newRaiseException(this.fastGetClass("SyntaxError"), string);
    }

    public RaiseException newRegexpError(String string) {
        return this.newRaiseException(this.fastGetClass("RegexpError"), string);
    }

    public RaiseException newRangeError(String string) {
        return this.newRaiseException(this.fastGetClass("RangeError"), string);
    }

    public RaiseException newNotImplementedError(String string) {
        return this.newRaiseException(this.fastGetClass("NotImplementedError"), string);
    }

    public RaiseException newInvalidEncoding(String string) {
        return this.newRaiseException(this.fastGetClass("Iconv").fastGetClass("InvalidEncoding"), string);
    }

    public RaiseException newNoMethodError(String string, String string2, IRubyObject iRubyObject) {
        return new RaiseException(new RubyNoMethodError(this, this.fastGetClass("NoMethodError"), string, string2, iRubyObject), true);
    }

    public RaiseException newNameError(String string, String string2) {
        return this.newNameError(string, string2, null);
    }

    public RaiseException newNameError(String string, String string2, Throwable throwable) {
        return this.newNameError(string, string2, throwable, true);
    }

    public RaiseException newNameError(String string, String string2, Throwable throwable, boolean bl) {
        if (bl && throwable != null && this.getVerbose().isTrue()) {
            throwable.printStackTrace(this.getErrorStream());
        }
        return new RaiseException(new RubyNameError(this, this.fastGetClass("NameError"), string, string2), true);
    }

    public RaiseException newLocalJumpError(String string, IRubyObject iRubyObject, String string2) {
        return new RaiseException(new RubyLocalJumpError(this, this.fastGetClass("LocalJumpError"), string2, string, iRubyObject), true);
    }

    public RaiseException newRedoLocalJumpError() {
        return new RaiseException(new RubyLocalJumpError(this, this.fastGetClass("LocalJumpError"), "unexpected redo", "redo", this.getNil()), true);
    }

    public RaiseException newLoadError(String string) {
        return this.newRaiseException(this.fastGetClass("LoadError"), string);
    }

    public RaiseException newFrozenError(String string) {
        return this.newRaiseException(this.fastGetClass("TypeError"), "can't modify frozen " + string);
    }

    public RaiseException newSystemStackError(String string) {
        return this.newRaiseException(this.fastGetClass("SystemStackError"), string);
    }

    public RaiseException newSystemExit(int n) {
        return new RaiseException(RubySystemExit.newInstance(this, n));
    }

    public RaiseException newIOError(String string) {
        return this.newRaiseException(this.fastGetClass("IOError"), string);
    }

    public RaiseException newStandardError(String string) {
        return this.newRaiseException(this.fastGetClass("StandardError"), string);
    }

    public RaiseException newIOErrorFromException(IOException iOException) {
        return this.newRaiseException(this.fastGetClass("IOError"), iOException.getMessage());
    }

    public RaiseException newTypeError(IRubyObject iRubyObject, RubyClass rubyClass) {
        return this.newRaiseException(this.fastGetClass("TypeError"), "wrong argument type " + iRubyObject.getMetaClass().getRealClass() + " (expected " + rubyClass + ")");
    }

    public RaiseException newEOFError() {
        return this.newRaiseException(this.fastGetClass("EOFError"), "End of file reached");
    }

    public RaiseException newEOFError(String string) {
        return this.newRaiseException(this.fastGetClass("EOFError"), string);
    }

    public RaiseException newZeroDivisionError() {
        return this.newRaiseException(this.fastGetClass("ZeroDivisionError"), "divided by 0");
    }

    public RaiseException newFloatDomainError(String string) {
        return this.newRaiseException(this.fastGetClass("FloatDomainError"), string);
    }

    private RaiseException newRaiseException(RubyClass rubyClass, String string) {
        RaiseException raiseException = new RaiseException(this, rubyClass, string, true);
        return raiseException;
    }

    public RubySymbol.SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    public void setStackTraces(int n) {
        this.stackTraces = n;
    }

    public int getStackTraces() {
        return this.stackTraces;
    }

    public void setRandomSeed(long l) {
        this.randomSeed = l;
    }

    public long getRandomSeed() {
        return this.randomSeed;
    }

    public Random getRandom() {
        return this.random;
    }

    public ObjectSpace getObjectSpace() {
        return this.objectSpace;
    }

    public Map<Integer, WeakReference<ChannelDescriptor>> getDescriptors() {
        return this.descriptors;
    }

    public long incrementRandomSeedSequence() {
        return this.randomSeedSequence++;
    }

    public InputStream getIn() {
        return this.in;
    }

    public PrintStream getOut() {
        return this.out;
    }

    public PrintStream getErr() {
        return this.err;
    }

    public boolean isGlobalAbortOnExceptionEnabled() {
        return this.globalAbortOnExceptionEnabled;
    }

    public void setGlobalAbortOnExceptionEnabled(boolean bl) {
        this.globalAbortOnExceptionEnabled = bl;
    }

    public boolean isDoNotReverseLookupEnabled() {
        return this.doNotReverseLookupEnabled;
    }

    public void setDoNotReverseLookupEnabled(boolean bl) {
        this.doNotReverseLookupEnabled = bl;
    }

    public void registerInspecting(Object object) {
        Map<Object, Object> map = this.inspect.get();
        if (map == null) {
            map = new IdentityHashMap<Object, Object>();
            this.inspect.set(map);
        }
        map.put(object, null);
    }

    public boolean isInspecting(Object object) {
        Map<Object, Object> map = this.inspect.get();
        return map == null ? false : map.containsKey(object);
    }

    public void unregisterInspecting(Object object) {
        Map<Object, Object> map = this.inspect.get();
        if (map != null) {
            map.remove(object);
        }
    }

    public boolean isObjectSpaceEnabled() {
        return this.objectSpaceEnabled;
    }

    void setObjectSpaceEnabled(boolean bl) {
        this.objectSpaceEnabled = bl;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public Profile getProfile() {
        return this.profile;
    }

    public String getJRubyHome() {
        return this.config.getJRubyHome();
    }

    public void setJRubyHome(String string) {
        this.config.setJRubyHome(string);
    }

    public RubyInstanceConfig getInstanceConfig() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getGlobalState() {
        Ruby ruby = this;
        synchronized (ruby) {
            return this.globalState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incGlobalState() {
        Ruby ruby = this;
        synchronized (ruby) {
            this.globalState = this.globalState + 1L & 0xFFFFFFFF8FFFFFFFL;
        }
    }

    public static boolean isSecurityRestricted() {
        return securityRestricted;
    }

    public static void setSecurityRestricted(boolean bl) {
        securityRestricted = bl;
    }

    public POSIX getPosix() {
        return this.posix;
    }

    public void setRecordSeparatorVar(GlobalVariable globalVariable) {
        this.recordSeparatorVar = globalVariable;
    }

    public GlobalVariable getRecordSeparatorVar() {
        return this.recordSeparatorVar;
    }

    public Set<Script> getJittedMethods() {
        return this.jittedMethods;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    static {
        if (SafePropertyAccessor.isSecurityProtected("jruby.reflection")) {
            securityRestricted = true;
        } else {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                try {
                    securityManager.checkCreateClassLoader();
                }
                catch (SecurityException securityException) {
                    securityRestricted = true;
                }
            }
        }
    }

    public class CallTraceFuncHook
    implements EventHook {
        private RubyProc traceFunc;

        public void setTraceFunc(RubyProc rubyProc) {
            this.traceFunc = rubyProc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void event(ThreadContext threadContext, int n, String string, int n2, String string2, IRubyObject iRubyObject) {
            if (!threadContext.isWithinTrace()) {
                if (string == null) {
                    string = "(ruby)";
                }
                if (iRubyObject == null) {
                    iRubyObject = Ruby.this.getFalse();
                }
                RubyBinding rubyBinding = RubyBinding.newBinding(Ruby.this);
                threadContext.preTrace();
                try {
                    this.traceFunc.call(threadContext, new IRubyObject[]{Ruby.this.newString(EVENT_NAMES[n]), Ruby.this.newString(string), Ruby.this.newFixnum(n2 + 1), string2 != null ? Ruby.this.newSymbol(string2) : Ruby.this.getNil(), rubyBinding, iRubyObject});
                }
                finally {
                    threadContext.postTrace();
                }
            }
        }

        public boolean isInterestedInEvent(int n) {
            return true;
        }
    }

    public static class DaemonThreadFactory
    implements ThreadFactory {
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable);
            thread.setDaemon(true);
            return thread;
        }
    }
}

