/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.math.BigDecimal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyBigDecimal
extends RubyNumeric {
    private static final ObjectAllocator BIGDECIMAL_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new RubyBigDecimal(ruby, rubyClass);
        }
    };
    private BigDecimal value;

    public static RubyClass createBigDecimal(Ruby ruby) {
        RubyClass rubyClass = ruby.defineClass("BigDecimal", ruby.getNumeric(), BIGDECIMAL_ALLOCATOR);
        rubyClass.fastSetConstant("ROUND_DOWN", RubyNumeric.int2fix(ruby, 1L));
        rubyClass.fastSetConstant("SIGN_POSITIVE_INFINITE", RubyNumeric.int2fix(ruby, 3L));
        rubyClass.fastSetConstant("EXCEPTION_OVERFLOW", RubyNumeric.int2fix(ruby, 1L));
        rubyClass.fastSetConstant("SIGN_POSITIVE_ZERO", RubyNumeric.int2fix(ruby, 1L));
        rubyClass.fastSetConstant("EXCEPTION_ALL", RubyNumeric.int2fix(ruby, 255L));
        rubyClass.fastSetConstant("ROUND_CEILING", RubyNumeric.int2fix(ruby, 2L));
        rubyClass.fastSetConstant("ROUND_UP", RubyNumeric.int2fix(ruby, 0L));
        rubyClass.fastSetConstant("SIGN_NEGATIVE_FINITE", RubyNumeric.int2fix(ruby, -2L));
        rubyClass.fastSetConstant("EXCEPTION_UNDERFLOW", RubyNumeric.int2fix(ruby, 4L));
        rubyClass.fastSetConstant("SIGN_NaN", RubyNumeric.int2fix(ruby, 0L));
        rubyClass.fastSetConstant("BASE", RubyNumeric.int2fix(ruby, 10000L));
        rubyClass.fastSetConstant("ROUND_HALF_DOWN", RubyNumeric.int2fix(ruby, 5L));
        rubyClass.fastSetConstant("ROUND_MODE", RubyNumeric.int2fix(ruby, 256L));
        rubyClass.fastSetConstant("SIGN_POSITIVE_FINITE", RubyNumeric.int2fix(ruby, 2L));
        rubyClass.fastSetConstant("EXCEPTION_INFINITY", RubyNumeric.int2fix(ruby, 1L));
        rubyClass.fastSetConstant("ROUND_HALF_EVEN", RubyNumeric.int2fix(ruby, 6L));
        rubyClass.fastSetConstant("ROUND_HALF_UP", RubyNumeric.int2fix(ruby, 4L));
        rubyClass.fastSetConstant("SIGN_NEGATIVE_INFINITE", RubyNumeric.int2fix(ruby, -3L));
        rubyClass.fastSetConstant("EXCEPTION_ZERODIVIDE", RubyNumeric.int2fix(ruby, 1L));
        rubyClass.fastSetConstant("SIGN_NEGATIVE_ZERO", RubyNumeric.int2fix(ruby, -1L));
        rubyClass.fastSetConstant("EXCEPTION_NaN", RubyNumeric.int2fix(ruby, 2L));
        rubyClass.fastSetConstant("ROUND_FLOOR", RubyNumeric.int2fix(ruby, 3L));
        CallbackFactory callbackFactory = ruby.callbackFactory(RubyBigDecimal.class);
        ruby.getKernel().defineModuleFunction("BigDecimal", callbackFactory.getOptSingletonMethod("newBigDecimal"));
        rubyClass.setInternalModuleVariable("vpPrecLimit", RubyFixnum.zero(ruby));
        rubyClass.setInternalModuleVariable("vpExceptionMode", RubyFixnum.zero(ruby));
        rubyClass.setInternalModuleVariable("vpRoundingMode", RubyFixnum.zero(ruby));
        rubyClass.defineAnnotatedMethods(RubyBigDecimal.class);
        rubyClass.dispatcher = callbackFactory.createDispatcher(rubyClass);
        return rubyClass;
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public RubyBigDecimal(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    public RubyBigDecimal(Ruby ruby, BigDecimal bigDecimal) {
        super(ruby, ruby.fastGetClass("BigDecimal"));
        this.value = bigDecimal;
    }

    public static RubyBigDecimal newBigDecimal(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        return RubyBigDecimal.newInstance(iRubyObject.getRuntime().fastGetClass("BigDecimal"), iRubyObjectArray);
    }

    @JRubyMethod(name={"ver"}, meta=true)
    public static IRubyObject ver(IRubyObject iRubyObject) {
        return iRubyObject.getRuntime().newString("1.0.1");
    }

    @JRubyMethod(name={"_dump"}, optional=1, frame=true)
    public IRubyObject dump(IRubyObject[] iRubyObjectArray, Block block) {
        RubyString rubyString = RubyString.newUnicodeString(iRubyObjectArray[0].getRuntime(), "0:");
        RubyString rubyString2 = this.asString();
        return rubyString.append(rubyString2);
    }

    @JRubyMethod(name={"_load"}, required=1, frame=true, meta=true)
    public static RubyBigDecimal load(IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        RubyBigDecimal rubyBigDecimal = (RubyBigDecimal)((RubyClass)iRubyObject).allocate();
        String string = iRubyObject2.convertToString().asJavaString();
        String string2 = string.substring(string.indexOf(":") + 1);
        rubyBigDecimal.value = new BigDecimal(string2);
        return rubyBigDecimal;
    }

    @JRubyMethod(name={"double_fig"}, meta=true)
    public static IRubyObject double_fig(IRubyObject iRubyObject) {
        return iRubyObject.getRuntime().newFixnum(20L);
    }

    @JRubyMethod(name={"limit"}, optional=1, meta=true)
    public static IRubyObject limit(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        IRubyObject iRubyObject2;
        Ruby ruby = iRubyObject.getRuntime();
        RubyModule rubyModule = (RubyModule)iRubyObject;
        IRubyObject iRubyObject3 = rubyModule.searchInternalModuleVariable("vpPrecLimit");
        if (iRubyObjectArray.length > 0 && !(iRubyObject2 = iRubyObjectArray[0]).isNil()) {
            if (!(iRubyObject2 instanceof RubyFixnum)) {
                throw ruby.newTypeError(iRubyObject2, ruby.getFixnum());
            }
            if (0L > ((RubyFixnum)iRubyObject2).getLongValue()) {
                throw ruby.newArgumentError("argument must be positive");
            }
            rubyModule.setInternalModuleVariable("vpPrecLimit", iRubyObject2);
        }
        return iRubyObject3;
    }

    @JRubyMethod(name={"mode"}, required=1, optional=1, meta=true)
    public static IRubyObject mode(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        long l;
        Ruby ruby = iRubyObject.getRuntime();
        RubyClass rubyClass = ruby.fastGetClass("BigDecimal");
        RubyModule rubyModule = (RubyModule)iRubyObject;
        iRubyObjectArray = Arity.scanArgs(ruby, iRubyObjectArray, 1, 1);
        IRubyObject iRubyObject2 = iRubyObjectArray[0];
        IRubyObject iRubyObject3 = iRubyObjectArray[1];
        if (!(iRubyObject2 instanceof RubyFixnum)) {
            throw ruby.newTypeError("wrong argument type " + iRubyObject2.getMetaClass() + " (expected Fixnum)");
        }
        long l2 = ((RubyFixnum)iRubyObject2).getLongValue();
        if ((l2 & (l = ((RubyFixnum)rubyClass.fastGetConstant("EXCEPTION_ALL")).getLongValue())) != 0L) {
            RubyFixnum rubyFixnum;
            if (iRubyObject3.isNil()) {
                return rubyModule.searchInternalModuleVariable("vpExceptionMode");
            }
            if (!iRubyObject3.isNil() && !(iRubyObject3 instanceof RubyBoolean)) {
                throw ruby.newTypeError("second argument must be true or false");
            }
            RubyFixnum rubyFixnum2 = (RubyFixnum)rubyModule.searchInternalModuleVariable("vpExceptionMode");
            RubyFixnum rubyFixnum3 = new RubyFixnum(ruby, rubyFixnum2.getLongValue());
            RubyFixnum rubyFixnum4 = (RubyFixnum)rubyClass.fastGetConstant("EXCEPTION_INFINITY");
            if ((l2 & rubyFixnum4.getLongValue()) != 0L) {
                RubyFixnum rubyFixnum5 = rubyFixnum3 = iRubyObject3.isTrue() ? (RubyFixnum)rubyFixnum2.callCoerced(threadContext, "|", rubyFixnum4) : (RubyFixnum)rubyFixnum2.callCoerced(threadContext, "&", new RubyFixnum(ruby, rubyFixnum4.getLongValue() ^ 0xFFFFFFFFFFFFFFFFL));
            }
            if ((l2 & (rubyFixnum = (RubyFixnum)rubyClass.fastGetConstant("EXCEPTION_NaN")).getLongValue()) != 0L) {
                rubyFixnum3 = iRubyObject3.isTrue() ? (RubyFixnum)rubyFixnum2.callCoerced(threadContext, "|", rubyFixnum) : (RubyFixnum)rubyFixnum2.callCoerced(threadContext, "&", new RubyFixnum(ruby, rubyFixnum.getLongValue() ^ 0xFFFFFFFFFFFFFFFFL));
            }
            rubyModule.setInternalModuleVariable("vpExceptionMode", rubyFixnum3);
            return rubyFixnum3;
        }
        long l3 = ((RubyFixnum)rubyClass.fastGetConstant("ROUND_MODE")).getLongValue();
        if (l2 == l3) {
            if (iRubyObject3.isNil()) {
                return rubyModule.searchInternalModuleVariable("vpRoundingMode");
            }
            if (!(iRubyObject3 instanceof RubyFixnum)) {
                throw ruby.newTypeError("wrong argument type " + iRubyObject2.getMetaClass() + " (expected Fixnum)");
            }
            RubyFixnum rubyFixnum = (RubyFixnum)iRubyObject3;
            if (rubyFixnum != rubyClass.fastGetConstant("ROUND_UP") && rubyFixnum != rubyClass.fastGetConstant("ROUND_DOWN") && rubyFixnum != rubyClass.fastGetConstant("ROUND_FLOOR") && rubyFixnum != rubyClass.fastGetConstant("ROUND_CEILING") && rubyFixnum != rubyClass.fastGetConstant("ROUND_HALF_UP") && rubyFixnum != rubyClass.fastGetConstant("ROUND_HALF_DOWN") && rubyFixnum != rubyClass.fastGetConstant("ROUND_HALF_EVEN")) {
                throw ruby.newTypeError("invalid rounding mode");
            }
            rubyModule.setInternalModuleVariable("vpRoundingMode", rubyFixnum);
            return rubyModule.searchInternalModuleVariable("vpRoundingMode");
        }
        throw ruby.newTypeError("first argument for BigDecimal#mode invalid");
    }

    private RubyBigDecimal getVpValue(IRubyObject iRubyObject, boolean bl) {
        if (iRubyObject instanceof RubyBigDecimal) {
            return (RubyBigDecimal)iRubyObject;
        }
        if (iRubyObject instanceof RubyFixnum || iRubyObject instanceof RubyBignum) {
            String string = iRubyObject.toString();
            return RubyBigDecimal.newInstance(this.getRuntime().fastGetClass("BigDecimal"), new IRubyObject[]{this.getRuntime().newString(string)});
        }
        if (bl) {
            String string;
            if (this.isImmediate()) {
                ThreadContext threadContext = this.getRuntime().getCurrentContext();
                string = RubyString.objAsString(threadContext, this.callMethod(threadContext, "inspect")).toString();
            } else {
                string = this.getMetaClass().getBaseName();
            }
            throw this.getRuntime().newTypeError(string + " can't be coerced into BigDecimal");
        }
        return null;
    }

    @JRubyMethod(name={"new"}, required=1, optional=1, meta=true)
    public static RubyBigDecimal newInstance(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        BigDecimal bigDecimal;
        if (iRubyObjectArray.length == 0) {
            bigDecimal = new BigDecimal(0);
        } else {
            try {
                bigDecimal = new BigDecimal(iRubyObjectArray[0].convertToString().toString());
            }
            catch (NumberFormatException numberFormatException) {
                bigDecimal = new BigDecimal(0);
            }
        }
        return new RubyBigDecimal(iRubyObject.getRuntime(), bigDecimal);
    }

    private RubyBigDecimal setResult() {
        return this.setResult(0);
    }

    private RubyBigDecimal setResult(int n) {
        int n2 = RubyFixnum.fix2int(this.getRuntime().fastGetClass("BigDecimal").searchInternalModuleVariable("vpPrecLimit"));
        int n3 = Math.max(n, n2);
        if (n3 > 0 && this.value.scale() > n3 - this.exp()) {
            this.value = this.value.setScale(n3 - this.exp(), 4);
        }
        return this;
    }

    @JRubyMethod(name={"hash"})
    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(this.value.hashCode());
    }

    @JRubyMethod(name={"%", "modulo"}, required=1)
    public IRubyObject op_mod(IRubyObject iRubyObject) {
        RubyBigDecimal rubyBigDecimal = this.getVpValue(iRubyObject, false);
        return new RubyBigDecimal(this.getRuntime(), this.value.divideAndRemainder(rubyBigDecimal.value)[1]).setResult();
    }

    @JRubyMethod(name={"*"}, required=1)
    public IRubyObject op_mul(ThreadContext threadContext, IRubyObject iRubyObject) {
        RubyBigDecimal rubyBigDecimal = this.getVpValue(iRubyObject, false);
        if (rubyBigDecimal == null) {
            return this.callCoerced(threadContext, "*", iRubyObject);
        }
        return new RubyBigDecimal(this.getRuntime(), this.value.multiply(rubyBigDecimal.value)).setResult();
    }

    @JRubyMethod(name={"mult"}, required=2)
    public IRubyObject mult2(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        RubyBigDecimal rubyBigDecimal = this.getVpValue(iRubyObject, false);
        if (rubyBigDecimal == null) {
            return this.callCoerced(threadContext, "*", iRubyObject);
        }
        return new RubyBigDecimal(this.getRuntime(), this.value.multiply(rubyBigDecimal.value)).setResult();
    }

    @JRubyMethod(name={"**", "power"}, required=1)
    public IRubyObject op_pow(IRubyObject iRubyObject) {
        if (!(iRubyObject instanceof RubyFixnum)) {
            throw this.getRuntime().newTypeError("wrong argument type " + iRubyObject.getMetaClass() + " (expected Fixnum)");
        }
        BigDecimal bigDecimal = this.value;
        int n = RubyNumeric.fix2int(iRubyObject.convertToInteger());
        int n2 = 0;
        if (n < 0) {
            n2 = -1;
            n = -n;
        }
        BigDecimal bigDecimal2 = BigDecimal.ONE;
        while (n > 0) {
            if (n % 2 != 0) {
                bigDecimal2 = bigDecimal2.multiply(bigDecimal);
                --n;
            }
            bigDecimal = bigDecimal.multiply(bigDecimal);
            n /= 2;
        }
        if (n2 == -1) {
            bigDecimal2 = BigDecimal.ONE.divide(bigDecimal2);
        }
        return new RubyBigDecimal(this.getRuntime(), bigDecimal2).setResult();
    }

    @JRubyMethod(name={"+"}, required=1)
    public IRubyObject op_plus(ThreadContext threadContext, IRubyObject iRubyObject) {
        RubyBigDecimal rubyBigDecimal = this.getVpValue(iRubyObject, false);
        if (rubyBigDecimal == null) {
            return this.callCoerced(threadContext, "+", iRubyObject);
        }
        return new RubyBigDecimal(this.getRuntime(), this.value.add(rubyBigDecimal.value)).setResult();
    }

    @JRubyMethod(name={"add"}, required=2)
    public IRubyObject add2(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        RubyBigDecimal rubyBigDecimal = this.getVpValue(iRubyObject, false);
        if (rubyBigDecimal == null) {
            return this.callCoerced(threadContext, "+", iRubyObject);
        }
        return new RubyBigDecimal(this.getRuntime(), this.value.add(rubyBigDecimal.value)).setResult();
    }

    @JRubyMethod(name={"+@"})
    public IRubyObject op_uplus() {
        return this;
    }

    @JRubyMethod(name={"-"}, required=1)
    public IRubyObject op_minus(ThreadContext threadContext, IRubyObject iRubyObject) {
        RubyBigDecimal rubyBigDecimal = this.getVpValue(iRubyObject, false);
        if (rubyBigDecimal == null) {
            return this.callCoerced(threadContext, "-", iRubyObject);
        }
        return new RubyBigDecimal(this.getRuntime(), this.value.subtract(rubyBigDecimal.value)).setResult();
    }

    @JRubyMethod(name={"sub"}, required=2)
    public IRubyObject sub2(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        RubyBigDecimal rubyBigDecimal = this.getVpValue(iRubyObject, false);
        if (rubyBigDecimal == null) {
            return this.callCoerced(threadContext, "-", iRubyObject);
        }
        return new RubyBigDecimal(this.getRuntime(), this.value.subtract(rubyBigDecimal.value)).setResult();
    }

    @JRubyMethod(name={"-@"})
    public IRubyObject op_uminus() {
        return new RubyBigDecimal(this.getRuntime(), this.value.negate());
    }

    @JRubyMethod(name={"/", "div", "quo"}, required=1, optional=1)
    public IRubyObject op_div(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        RubyBigDecimal rubyBigDecimal;
        int n = 0;
        if (iRubyObjectArray.length == 2) {
            n = RubyNumeric.fix2int(iRubyObjectArray[1]);
        }
        if ((rubyBigDecimal = this.getVpValue(iRubyObjectArray[0], false)) == null) {
            return this.callCoerced(threadContext, "/", iRubyObjectArray[0]);
        }
        if (n == 0) {
            return new RubyBigDecimal(this.getRuntime(), this.value.divide(rubyBigDecimal.value, 200, 4)).setResult();
        }
        return new RubyBigDecimal(this.getRuntime(), this.value.divide(rubyBigDecimal.value, 200, 4)).setResult(n);
    }

    private IRubyObject cmp(ThreadContext threadContext, IRubyObject iRubyObject, char c) {
        int n = 0;
        RubyBigDecimal rubyBigDecimal = this.getVpValue(iRubyObject, false);
        if (rubyBigDecimal == null) {
            IRubyObject iRubyObject2 = this.callCoerced(threadContext, "<=>", iRubyObject);
            if (iRubyObject2.isNil()) {
                return this.getRuntime().getNil();
            }
            n = RubyNumeric.fix2int(iRubyObject2);
        } else {
            n = this.value.compareTo(rubyBigDecimal.value);
        }
        switch (c) {
            case '*': {
                return this.getRuntime().newFixnum(n);
            }
            case '=': {
                return n == 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
            }
            case '!': {
                return n != 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
            }
            case 'G': {
                return n >= 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
            }
            case '>': {
                return n > 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
            }
            case 'L': {
                return n <= 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
            }
            case '<': {
                return n < 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
            }
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"<=>"}, required=1)
    public IRubyObject op_cmp(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.cmp(threadContext, iRubyObject, '*');
    }

    @JRubyMethod(name={"eql?"}, required=1)
    public IRubyObject eql_p(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.cmp(threadContext, iRubyObject, '=');
    }

    @JRubyMethod(name={"<"}, required=1)
    public IRubyObject op_lt(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.cmp(threadContext, iRubyObject, '<');
    }

    @JRubyMethod(name={"<="}, required=1)
    public IRubyObject op_le(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.cmp(threadContext, iRubyObject, 'L');
    }

    @JRubyMethod(name={">"}, required=1)
    public IRubyObject op_gt(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.cmp(threadContext, iRubyObject, '>');
    }

    @JRubyMethod(name={">="}, required=1)
    public IRubyObject op_ge(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.cmp(threadContext, iRubyObject, 'G');
    }

    @JRubyMethod(name={"abs"})
    public IRubyObject abs() {
        return new RubyBigDecimal(this.getRuntime(), this.value.abs()).setResult();
    }

    @JRubyMethod(name={"ceil"}, optional=1)
    public IRubyObject ceil(IRubyObject[] iRubyObjectArray) {
        throw new RuntimeException("BigDecimal#ceil is not implemented");
    }

    @JRubyMethod(name={"coerce"}, required=1)
    public IRubyObject coerce(IRubyObject iRubyObject) {
        RubyArray rubyArray = iRubyObject instanceof RubyFloat ? this.getRuntime().newArray(iRubyObject, this.to_f()) : this.getRuntime().newArray(this.getVpValue(iRubyObject, true), this);
        return rubyArray;
    }

    public double getDoubleValue() {
        return this.value.doubleValue();
    }

    public long getLongValue() {
        return this.value.longValue();
    }

    public RubyNumeric multiplyWith(ThreadContext threadContext, RubyInteger rubyInteger) {
        return (RubyNumeric)this.op_mul(threadContext, rubyInteger);
    }

    public RubyNumeric multiplyWith(ThreadContext threadContext, RubyFloat rubyFloat) {
        return (RubyNumeric)this.op_mul(threadContext, rubyFloat);
    }

    public RubyNumeric multiplyWith(ThreadContext threadContext, RubyBignum rubyBignum) {
        return (RubyNumeric)this.op_mul(threadContext, rubyBignum);
    }

    @JRubyMethod(name={"divmod"}, required=1)
    public IRubyObject divmod(IRubyObject iRubyObject) {
        System.err.println("unimplemented: divmod");
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"exponent"})
    public IRubyObject exponent() {
        return this.getRuntime().newFixnum(this.exp());
    }

    private int exp() {
        return this.value.abs().unscaledValue().toString().length() - this.value.abs().scale();
    }

    @JRubyMethod(name={"finite?"})
    public IRubyObject finite_p() {
        System.err.println("unimplemented: finite?");
        return this.getRuntime().getTrue();
    }

    @JRubyMethod(name={"fix"})
    public IRubyObject fix() {
        System.err.println("unimplemented: fix");
        return this;
    }

    @JRubyMethod(name={"floor"}, optional=1)
    public IRubyObject floor(IRubyObject[] iRubyObjectArray) {
        throw new RuntimeException("BigDecimal#floor is not implemented");
    }

    @JRubyMethod(name={"frac"})
    public IRubyObject frac() {
        System.err.println("unimplemented: frac");
        return this;
    }

    @JRubyMethod(name={"infinite?"})
    public IRubyObject infinite_p() {
        System.err.println("unimplemented: infinite?");
        return this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect(ThreadContext threadContext) {
        StringBuffer stringBuffer = new StringBuffer("#<BigDecimal:").append(Integer.toHexString(System.identityHashCode(this))).append(",");
        stringBuffer.append("'").append(this.callMethod(threadContext, MethodIndex.TO_S, "to_s")).append("'").append(",");
        int n = this.value.abs().unscaledValue().toString().length();
        int n2 = n / 4;
        stringBuffer.append(n).append("(").append((n2 + 1) * 4).append(")").append(">");
        return this.getRuntime().newString(stringBuffer.toString());
    }

    @JRubyMethod(name={"nan?"})
    public IRubyObject nan_p() {
        System.err.println("unimplemented: nan?");
        return this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"nonzero?"})
    public IRubyObject nonzero_p() {
        return this.value.signum() != 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"precs"})
    public IRubyObject precs() {
        System.err.println("unimplemented: precs");
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"remainder"}, required=1)
    public IRubyObject remainder(IRubyObject iRubyObject) {
        System.err.println("unimplemented: remainder");
        return this;
    }

    @JRubyMethod(name={"round"}, optional=2)
    public IRubyObject round(IRubyObject[] iRubyObjectArray) {
        int n;
        int n2 = iRubyObjectArray.length > 0 ? RubyBigDecimal.num2int(iRubyObjectArray[0]) : 0;
        int n3 = n = iRubyObjectArray.length > 1 ? this.javaRoundingModeFromRubyRoundingMode(iRubyObjectArray[1]) : 4;
        if (n2 < 0) {
            BigDecimal bigDecimal = this.value.movePointRight(n2);
            BigDecimal bigDecimal2 = bigDecimal.setScale(0, n);
            return new RubyBigDecimal(this.getRuntime(), bigDecimal2.movePointLeft(n2));
        }
        return new RubyBigDecimal(this.getRuntime(), this.value.setScale(n2, n));
    }

    private int javaRoundingModeFromRubyRoundingMode(IRubyObject iRubyObject) {
        return RubyBigDecimal.num2int(iRubyObject);
    }

    @JRubyMethod(name={"sign"})
    public IRubyObject sign() {
        System.err.println("unimplemented: sign");
        return this.getRuntime().newFixnum(this.value.signum());
    }

    @JRubyMethod(name={"split"})
    public IRubyObject split() {
        System.err.println("unimplemented: split");
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"sqrt"}, required=1)
    public IRubyObject sqrt(IRubyObject iRubyObject) {
        System.err.println("unimplemented: sqrt");
        return new RubyBigDecimal(this.getRuntime(), new BigDecimal(Math.sqrt(this.value.doubleValue()))).setResult();
    }

    @JRubyMethod(name={"to_f"})
    public IRubyObject to_f() {
        return RubyFloat.newFloat(this.getRuntime(), this.value.doubleValue());
    }

    @JRubyMethod(name={"to_i"})
    public IRubyObject to_i() {
        return RubyNumeric.int2fix(this.getRuntime(), this.value.longValue());
    }

    @JRubyMethod(name={"to_int"})
    public IRubyObject to_int() {
        return RubyNumeric.int2fix(this.getRuntime(), this.value.longValue());
    }

    private String removeTrailingZeroes(String string) {
        while (string.length() > 0 && string.charAt(string.length() - 1) == '0') {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static boolean formatHasLeadingPlus(String string) {
        return string.startsWith("+");
    }

    public static boolean formatHasLeadingSpace(String string) {
        return string.startsWith(" ");
    }

    public static boolean formatHasFloatingPointNotation(String string) {
        return string.endsWith("F");
    }

    public static int formatFractionalDigitGroups(String string) {
        int n = 0;
        Pattern pattern = Pattern.compile("(\\+| )?(\\d+)(E|F)?");
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches()) {
            n = Integer.parseInt(matcher.group(2));
        }
        return n;
    }

    private boolean hasArg(IRubyObject[] iRubyObjectArray) {
        return iRubyObjectArray.length != 0 && !iRubyObjectArray[0].isNil();
    }

    private String format(IRubyObject[] iRubyObjectArray) {
        return iRubyObjectArray[0].toString();
    }

    private String firstArgument(IRubyObject[] iRubyObjectArray) {
        if (this.hasArg(iRubyObjectArray)) {
            return this.format(iRubyObjectArray);
        }
        return null;
    }

    private boolean posSpace(String string) {
        if (null != string) {
            return RubyBigDecimal.formatHasLeadingSpace(string);
        }
        return false;
    }

    private boolean posSign(String string) {
        if (null != string) {
            return RubyBigDecimal.formatHasLeadingPlus(string) || this.posSpace(string);
        }
        return false;
    }

    private boolean asEngineering(String string) {
        if (null != string) {
            return !RubyBigDecimal.formatHasFloatingPointNotation(string);
        }
        return true;
    }

    private int groups(String string) {
        if (null != string) {
            return RubyBigDecimal.formatFractionalDigitGroups(string);
        }
        return 0;
    }

    private boolean isZero() {
        return this.value.abs().compareTo(BigDecimal.ZERO) == 0;
    }

    private String unscaledValue() {
        return this.value.abs().unscaledValue().toString();
    }

    private IRubyObject engineeringValue(String string) {
        int n = this.exp();
        int n2 = this.value.signum();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n2 == -1 ? "-" : (n2 == 1 ? (this.posSign(string) ? (this.posSpace(string) ? " " : "+") : "") : ""));
        stringBuffer.append("0.");
        if (0 == this.groups(string)) {
            String string2 = this.removeTrailingZeroes(this.unscaledValue());
            if ("".equals(string2)) {
                stringBuffer.append("0");
            } else {
                stringBuffer.append(string2);
            }
        } else {
            String string3 = "";
            for (int i = 0; i < this.unscaledValue().length(); i += this.groups(string)) {
                int n3 = i + this.groups(string);
                if (n3 > this.unscaledValue().length()) {
                    n3 = this.unscaledValue().length();
                }
                stringBuffer.append(string3).append(this.unscaledValue().substring(i, n3));
                string3 = " ";
            }
        }
        stringBuffer.append("E").append(n);
        return this.getRuntime().newString(stringBuffer.toString());
    }

    private IRubyObject floatingPointValue(String string) {
        String[] stringArray = this.value.abs().toString().split("\\.");
        String string2 = "0";
        if (stringArray.length > 0) {
            string2 = stringArray[0];
        }
        String string3 = "0";
        if (stringArray.length > 1) {
            string3 = stringArray[1];
        }
        int n = this.value.signum();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n == -1 ? "-" : (n == 1 ? (this.posSign(string) ? (this.posSpace(string) ? " " : "+") : "") : ""));
        if (this.groups(string) == 0) {
            stringBuffer.append(string2);
            if (null != string3) {
                stringBuffer.append(".").append(string3);
            }
        } else {
            int n2;
            int n3;
            String string4 = "";
            for (n3 = 0; n3 < string2.length(); n3 += this.groups(string)) {
                n2 = n3 + this.groups(string);
                if (n2 > string2.length()) {
                    n2 = string2.length();
                }
                stringBuffer.append(string4).append(string2.substring(n3, n2));
                string4 = " ";
            }
            if (null != string3) {
                stringBuffer.append(".");
                string4 = "";
                for (n3 = 0; n3 < string3.length(); n3 += this.groups(string)) {
                    n2 = n3 + this.groups(string);
                    if (n2 > string3.length()) {
                        n2 = string3.length();
                    }
                    stringBuffer.append(string4).append(string3.substring(n3, n2));
                    string4 = " ";
                }
            }
        }
        return this.getRuntime().newString(stringBuffer.toString());
    }

    @JRubyMethod(name={"to_s"}, optional=1)
    public IRubyObject to_s(IRubyObject[] iRubyObjectArray) {
        String string = this.firstArgument(iRubyObjectArray);
        if (this.isZero()) {
            return this.getRuntime().newString("0.0");
        }
        if (this.asEngineering(string)) {
            return this.engineeringValue(string);
        }
        return this.floatingPointValue(string);
    }

    @JRubyMethod(name={"truncate"}, optional=1)
    public IRubyObject truncate(IRubyObject[] iRubyObjectArray) {
        throw new RuntimeException("BigDecimal#truncate is not implemented");
    }

    @JRubyMethod(name={"zero?"})
    public IRubyObject zero_p() {
        return this.value.signum() == 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }
}

