/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyFixnum;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyComparable {
    public static RubyModule createComparable(Ruby ruby) {
        RubyModule rubyModule = ruby.defineModule("Comparable");
        ruby.setComparable(rubyModule);
        rubyModule.defineAnnotatedMethods(RubyComparable.class);
        return rubyModule;
    }

    public static int cmpint(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        if (iRubyObject.isNil()) {
            RubyComparable.cmperr(iRubyObject2, iRubyObject3);
        }
        if (iRubyObject instanceof RubyFixnum) {
            return RubyNumeric.fix2int((RubyFixnum)iRubyObject);
        }
        if (iRubyObject instanceof RubyBignum) {
            if (((RubyBignum)iRubyObject).getValue().signum() == -1) {
                return 1;
            }
            return -1;
        }
        Ruby ruby = iRubyObject.getRuntime();
        RubyFixnum rubyFixnum = RubyFixnum.zero(ruby);
        if (iRubyObject.callMethod(threadContext, MethodIndex.OP_GT, ">", rubyFixnum).isTrue()) {
            return 1;
        }
        if (iRubyObject.callMethod(threadContext, MethodIndex.OP_LT, "<", rubyFixnum).isTrue()) {
            return -1;
        }
        return 0;
    }

    public static void cmperr(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        IRubyObject iRubyObject3 = iRubyObject2.isImmediate() || !iRubyObject2.isNil() && !iRubyObject2.isTrue() && iRubyObject2 != iRubyObject.getRuntime().getFalse() ? iRubyObject2.inspect() : iRubyObject2.getType();
        throw iRubyObject.getRuntime().newArgumentError("comparison of " + iRubyObject.getType() + " with " + iRubyObject3 + " failed");
    }

    @JRubyMethod(name={"=="}, required=1)
    public static IRubyObject op_equal(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        if (iRubyObject == iRubyObject2) {
            return iRubyObject.getRuntime().getTrue();
        }
        Ruby ruby = iRubyObject.getRuntime();
        IRubyObject iRubyObject3 = null;
        try {
            iRubyObject3 = iRubyObject.callMethod(threadContext, MethodIndex.OP_SPACESHIP, "<=>", iRubyObject2);
        }
        catch (RaiseException raiseException) {
            if (raiseException.getException().kind_of_p(iRubyObject.getRuntime().getStandardError()).isTrue()) {
                return iRubyObject.getRuntime().getNil();
            }
            throw raiseException;
        }
        if (!(iRubyObject3 instanceof RubyInteger)) {
            return ruby.getNil();
        }
        return RubyBoolean.newBoolean(ruby, RubyComparable.cmpint(threadContext, iRubyObject3, iRubyObject, iRubyObject2) == 0);
    }

    @JRubyMethod(name={">"}, required=1)
    public static RubyBoolean op_gt(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        Ruby ruby = iRubyObject.getRuntime();
        IRubyObject iRubyObject3 = iRubyObject.callMethod(threadContext, MethodIndex.OP_SPACESHIP, "<=>", iRubyObject2);
        if (iRubyObject3.isNil()) {
            RubyComparable.cmperr(iRubyObject, iRubyObject2);
        }
        return RubyBoolean.newBoolean(ruby, RubyComparable.cmpint(threadContext, iRubyObject3, iRubyObject, iRubyObject2) > 0);
    }

    @JRubyMethod(name={">="}, required=1)
    public static RubyBoolean op_ge(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        Ruby ruby = iRubyObject.getRuntime();
        IRubyObject iRubyObject3 = iRubyObject.callMethod(threadContext, MethodIndex.OP_SPACESHIP, "<=>", iRubyObject2);
        if (iRubyObject3.isNil()) {
            RubyComparable.cmperr(iRubyObject, iRubyObject2);
        }
        return RubyBoolean.newBoolean(ruby, RubyComparable.cmpint(threadContext, iRubyObject3, iRubyObject, iRubyObject2) >= 0);
    }

    @JRubyMethod(name={"<"}, required=1)
    public static RubyBoolean op_lt(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        Ruby ruby = iRubyObject.getRuntime();
        IRubyObject iRubyObject3 = iRubyObject.callMethod(threadContext, MethodIndex.OP_SPACESHIP, "<=>", iRubyObject2);
        if (iRubyObject3.isNil()) {
            RubyComparable.cmperr(iRubyObject, iRubyObject2);
        }
        return RubyBoolean.newBoolean(ruby, RubyComparable.cmpint(threadContext, iRubyObject3, iRubyObject, iRubyObject2) < 0);
    }

    @JRubyMethod(name={"<="}, required=1)
    public static RubyBoolean op_le(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        Ruby ruby = iRubyObject.getRuntime();
        IRubyObject iRubyObject3 = iRubyObject.callMethod(threadContext, MethodIndex.OP_SPACESHIP, "<=>", iRubyObject2);
        if (iRubyObject3.isNil()) {
            RubyComparable.cmperr(iRubyObject, iRubyObject2);
        }
        return RubyBoolean.newBoolean(ruby, RubyComparable.cmpint(threadContext, iRubyObject3, iRubyObject, iRubyObject2) <= 0);
    }

    @JRubyMethod(name={"between?"}, required=2)
    public static RubyBoolean between_p(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        return iRubyObject.getRuntime().newBoolean(RubyComparable.op_lt(threadContext, iRubyObject, iRubyObject2).isFalse() && RubyComparable.op_gt(threadContext, iRubyObject, iRubyObject3).isFalse());
    }
}

