/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyEnumerable;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockCallback;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyEnumerator
extends RubyObject {
    private IRubyObject object;
    private IRubyObject method;
    private IRubyObject[] methodArgs;
    private static ObjectAllocator ENUMERATOR_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new RubyEnumerator(ruby, rubyClass);
        }
    };

    public static void defineEnumerator(Ruby ruby) {
        RubyModule rubyModule = ruby.getKernel();
        rubyModule.defineAnnotatedMethod(RubyEnumerator.class, "obj_to_enum");
        RubyModule rubyModule2 = ruby.getClassFromPath("Enumerable");
        rubyModule2.defineAnnotatedMethod(RubyEnumerator.class, "each_with_index");
        rubyModule2.defineAnnotatedMethod(RubyEnumerator.class, "each_slice");
        rubyModule2.defineAnnotatedMethod(RubyEnumerator.class, "enum_slice");
        rubyModule2.defineAnnotatedMethod(RubyEnumerator.class, "each_cons");
        rubyModule2.defineAnnotatedMethod(RubyEnumerator.class, "enum_cons");
        RubyClass rubyClass = rubyModule2.defineClassUnder("Enumerator", ruby.getObject(), ENUMERATOR_ALLOCATOR);
        rubyClass.includeModule(rubyModule2);
        rubyClass.defineAnnotatedMethod(RubyEnumerator.class, "initialize");
        rubyClass.defineAnnotatedMethod(RubyEnumerator.class, "each");
    }

    @JRubyMethod(name={"to_enum", "enum_for"}, optional=1, rest=true, frame=true)
    public static IRubyObject obj_to_enum(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        IRubyObject[] iRubyObjectArray2 = new IRubyObject[iRubyObjectArray.length + 1];
        iRubyObjectArray2[0] = iRubyObject;
        System.arraycopy(iRubyObjectArray, 0, iRubyObjectArray2, 1, iRubyObjectArray.length);
        return iRubyObject.getRuntime().getEnumerable().fastGetConstant("Enumerator").callMethod(threadContext, "new", iRubyObjectArray2);
    }

    private RubyEnumerator(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
        this.object = this.method = ruby.getNil();
    }

    @JRubyMethod(name={"initialize"}, required=1, rest=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject[] iRubyObjectArray) {
        this.object = iRubyObjectArray[0];
        IRubyObject iRubyObject = this.method = iRubyObjectArray.length > 1 ? iRubyObjectArray[1] : this.getRuntime().fastNewSymbol("each");
        if (iRubyObjectArray.length > 2) {
            this.methodArgs = new IRubyObject[Math.max(0, iRubyObjectArray.length - 2)];
            System.arraycopy(iRubyObjectArray, 2, this.methodArgs, 0, iRubyObjectArray.length - 2);
        } else {
            this.methodArgs = new IRubyObject[0];
        }
        return this;
    }

    @JRubyMethod(name={"each"}, frame=true)
    public IRubyObject each(ThreadContext threadContext, Block block) {
        return this.object.callMethod(threadContext, this.method.asJavaString(), this.methodArgs, block);
    }

    @JRubyMethod(name={"enum_with_index"})
    public static IRubyObject each_with_index(ThreadContext threadContext, IRubyObject iRubyObject) {
        return iRubyObject.getRuntime().getEnumerable().fastGetConstant("Enumerator").callMethod(threadContext, "new", new IRubyObject[]{iRubyObject, iRubyObject.getRuntime().fastNewSymbol("each_with_index")});
    }

    @JRubyMethod(name={"each_slice"}, required=1, frame=true)
    public static IRubyObject each_slice(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, final Block block) {
        final int n = (int)RubyNumeric.num2long(iRubyObject2);
        if (n <= 0) {
            throw iRubyObject.getRuntime().newArgumentError("invalid slice size");
        }
        final Ruby ruby = iRubyObject.getRuntime();
        final RubyArray[] rubyArrayArray = new RubyArray[]{ruby.newArray(n)};
        RubyEnumerable.callEach(ruby, threadContext, iRubyObject, new BlockCallback(){

            public IRubyObject call(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block2) {
                rubyArrayArray[0].append(iRubyObjectArray[0]);
                if (rubyArrayArray[0].size() == n) {
                    block.yield(threadContext, rubyArrayArray[0]);
                    rubyArrayArray[0] = ruby.newArray(n);
                }
                return ruby.getNil();
            }
        });
        if (rubyArrayArray[0].size() > 0) {
            block.yield(threadContext, rubyArrayArray[0]);
        }
        return iRubyObject.getRuntime().getNil();
    }

    @JRubyMethod(name={"each_cons"}, required=1, frame=true)
    public static IRubyObject each_cons(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, final Block block) {
        final int n = (int)RubyNumeric.num2long(iRubyObject2);
        if (n <= 0) {
            throw iRubyObject.getRuntime().newArgumentError("invalid size");
        }
        final Ruby ruby = iRubyObject.getRuntime();
        final RubyArray rubyArray = ruby.newArray(n);
        RubyEnumerable.callEach(ruby, threadContext, iRubyObject, new BlockCallback(){

            public IRubyObject call(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block2) {
                if (rubyArray.size() == n) {
                    rubyArray.shift();
                }
                rubyArray.append(iRubyObjectArray[0]);
                if (rubyArray.size() == n) {
                    block.yield(threadContext, rubyArray.aryDup());
                }
                return ruby.getNil();
            }
        });
        return ruby.getNil();
    }

    @JRubyMethod(name={"enum_slice"}, required=1)
    public static IRubyObject enum_slice(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return iRubyObject.getRuntime().getEnumerable().fastGetConstant("Enumerator").callMethod(threadContext, "new", new IRubyObject[]{iRubyObject, iRubyObject.getRuntime().fastNewSymbol("each_slice"), iRubyObject2});
    }

    @JRubyMethod(name={"enum_cons"}, required=1)
    public static IRubyObject enum_cons(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return iRubyObject.getRuntime().getEnumerable().fastGetConstant("Enumerator").callMethod(threadContext, "new", new IRubyObject[]{iRubyObject, iRubyObject.getRuntime().fastNewSymbol("each_cons"), iRubyObject2});
    }
}

