/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.FileDescriptor;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.posix.FileStat;
import org.jruby.ext.posix.util.Platform;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.JRubyFile;

public class RubyFileStat
extends RubyObject {
    private static final long serialVersionUID = 1L;
    private JRubyFile file;
    private FileStat stat;
    private static ObjectAllocator ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new RubyFileStat(ruby, rubyClass);
        }
    };

    public static RubyClass createFileStatClass(Ruby ruby) {
        RubyClass rubyClass = ruby.getFile().defineClassUnder("Stat", ruby.getObject(), ALLOCATOR);
        ruby.setFileStat(rubyClass);
        rubyClass.includeModule(ruby.fastGetModule("Comparable"));
        rubyClass.defineAnnotatedMethods(RubyFileStat.class);
        return rubyClass;
    }

    protected RubyFileStat(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    public static RubyFileStat newFileStat(Ruby ruby, String string, boolean bl) {
        RubyFileStat rubyFileStat = new RubyFileStat(ruby, ruby.getFileStat());
        rubyFileStat.setup(string, bl);
        return rubyFileStat;
    }

    public static RubyFileStat newFileStat(Ruby ruby, FileDescriptor fileDescriptor) {
        RubyFileStat rubyFileStat = new RubyFileStat(ruby, ruby.getFileStat());
        rubyFileStat.setup(fileDescriptor);
        return rubyFileStat;
    }

    private void setup(FileDescriptor fileDescriptor) {
        this.stat = this.getRuntime().getPosix().fstat(fileDescriptor);
    }

    private void setup(String string, boolean bl) {
        if (Platform.IS_WINDOWS && string.length() == 2 && string.charAt(1) == ':' && Character.isLetter(string.charAt(0))) {
            string = string + "/";
        }
        this.file = JRubyFile.create(this.getRuntime().getCurrentDirectory(), string);
        this.stat = bl ? this.getRuntime().getPosix().lstat(this.file.getAbsolutePath()) : this.getRuntime().getPosix().stat(this.file.getAbsolutePath());
    }

    @JRubyMethod(name={"initialize"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject iRubyObject, Block block) {
        this.setup(iRubyObject.convertToString().toString(), false);
        return this;
    }

    @JRubyMethod(name={"atime"})
    public IRubyObject atime() {
        return this.getRuntime().newTime(this.stat.atime() * 1000L);
    }

    @JRubyMethod(name={"blksize"})
    public RubyFixnum blksize() {
        return this.getRuntime().newFixnum(this.stat.blockSize());
    }

    @JRubyMethod(name={"blockdev?"})
    public IRubyObject blockdev_p() {
        return this.getRuntime().newBoolean(this.stat.isBlockDev());
    }

    @JRubyMethod(name={"blocks"})
    public IRubyObject blocks() {
        return this.getRuntime().newFixnum(this.stat.blocks());
    }

    @JRubyMethod(name={"chardev?"})
    public IRubyObject chardev_p() {
        return this.getRuntime().newBoolean(this.stat.isCharDev());
    }

    @JRubyMethod(name={"<=>"}, required=1)
    public IRubyObject cmp(IRubyObject iRubyObject) {
        long l;
        long l2;
        if (!(iRubyObject instanceof RubyFileStat)) {
            this.getRuntime().getNil();
        }
        if ((l2 = this.stat.mtime()) == (l = ((RubyFileStat)iRubyObject).stat.mtime())) {
            return this.getRuntime().newFixnum(0L);
        }
        if (l2 < l) {
            return this.getRuntime().newFixnum(-1L);
        }
        return this.getRuntime().newFixnum(1L);
    }

    @JRubyMethod(name={"ctime"})
    public IRubyObject ctime() {
        return this.getRuntime().newTime(this.stat.ctime() * 1000L);
    }

    @JRubyMethod(name={"dev"})
    public IRubyObject dev() {
        return this.getRuntime().newFixnum(this.stat.dev());
    }

    @JRubyMethod(name={"dev_major"})
    public IRubyObject devMajor() {
        return this.getRuntime().newFixnum(this.stat.major(this.stat.dev()));
    }

    @JRubyMethod(name={"dev_minor"})
    public IRubyObject devMinor() {
        return this.getRuntime().newFixnum(this.stat.minor(this.stat.dev()));
    }

    @JRubyMethod(name={"directory?"})
    public RubyBoolean directory_p() {
        return this.getRuntime().newBoolean(this.stat.isDirectory());
    }

    @JRubyMethod(name={"executable?"})
    public IRubyObject executable_p() {
        return this.getRuntime().newBoolean(this.stat.isExecutable());
    }

    @JRubyMethod(name={"executable_real?"})
    public IRubyObject executableReal_p() {
        return this.getRuntime().newBoolean(this.stat.isExecutableReal());
    }

    @JRubyMethod(name={"file?"})
    public RubyBoolean file_p() {
        return this.getRuntime().newBoolean(this.stat.isFile());
    }

    @JRubyMethod(name={"ftype"})
    public RubyString ftype() {
        return this.getRuntime().newString(this.stat.ftype());
    }

    @JRubyMethod(name={"gid"})
    public IRubyObject gid() {
        return this.getRuntime().newFixnum(this.stat.gid());
    }

    @JRubyMethod(name={"grpowned?"})
    public IRubyObject group_owned_p() {
        return this.getRuntime().newBoolean(this.stat.isGroupOwned());
    }

    @JRubyMethod(name={"initialize_copy"}, required=1)
    public IRubyObject initialize_copy(IRubyObject iRubyObject) {
        if (!(iRubyObject instanceof RubyFileStat)) {
            throw this.getRuntime().newTypeError("wrong argument class");
        }
        RubyFileStat rubyFileStat = (RubyFileStat)iRubyObject;
        this.file = rubyFileStat.file;
        this.stat = rubyFileStat.stat;
        return this;
    }

    @JRubyMethod(name={"ino"})
    public IRubyObject ino() {
        return this.getRuntime().newFixnum(this.stat.ino());
    }

    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect() {
        StringBuilder stringBuilder = new StringBuilder("#<");
        stringBuilder.append(this.getMetaClass().getRealClass().getName());
        stringBuilder.append(" ");
        try {
            stringBuilder.append("dev=0").append(Long.toHexString(this.stat.dev())).append(", ");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stringBuilder.append("ino=").append(this.stat.ino()).append(", ");
        }
        catch (Exception exception) {
            // empty catch block
        }
        stringBuilder.append("mode=0").append(Integer.toOctalString(this.stat.mode())).append(", ");
        try {
            stringBuilder.append("nlink=").append(this.stat.nlink()).append(", ");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stringBuilder.append("uid=").append(this.stat.uid()).append(", ");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stringBuilder.append("gid=").append(this.stat.gid()).append(", ");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stringBuilder.append("rdev=0").append(Long.toHexString(this.stat.rdev())).append(", ");
        }
        catch (Exception exception) {
            // empty catch block
        }
        stringBuilder.append("size=").append(this.stat.st_size()).append(", ");
        try {
            stringBuilder.append("blksize=").append(this.stat.blockSize()).append(", ");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stringBuilder.append("blocks=").append(this.stat.blocks()).append(", ");
        }
        catch (Exception exception) {
            // empty catch block
        }
        stringBuilder.append("atime=").append(this.atime()).append(", ");
        stringBuilder.append("mtime=").append(this.mtime()).append(", ");
        stringBuilder.append("ctime=").append(this.ctime()).append(", ");
        stringBuilder.append(">");
        return this.getRuntime().newString(stringBuilder.toString());
    }

    @JRubyMethod(name={"uid"})
    public IRubyObject uid() {
        return this.getRuntime().newFixnum(this.stat.uid());
    }

    @JRubyMethod(name={"mode"})
    public IRubyObject mode() {
        return this.getRuntime().newFixnum(this.stat.mode());
    }

    @JRubyMethod(name={"mtime"})
    public IRubyObject mtime() {
        return this.getRuntime().newTime(this.stat.mtime() * 1000L);
    }

    public IRubyObject mtimeEquals(IRubyObject iRubyObject) {
        return this.getRuntime().newBoolean(this.stat.mtime() == RubyFileStat.newFileStat((Ruby)this.getRuntime(), (String)iRubyObject.convertToString().toString(), (boolean)false).stat.mtime());
    }

    public IRubyObject mtimeGreaterThan(IRubyObject iRubyObject) {
        return this.getRuntime().newBoolean(this.stat.mtime() > RubyFileStat.newFileStat((Ruby)this.getRuntime(), (String)iRubyObject.convertToString().toString(), (boolean)false).stat.mtime());
    }

    public IRubyObject mtimeLessThan(IRubyObject iRubyObject) {
        return this.getRuntime().newBoolean(this.stat.mtime() < RubyFileStat.newFileStat((Ruby)this.getRuntime(), (String)iRubyObject.convertToString().toString(), (boolean)false).stat.mtime());
    }

    @JRubyMethod(name={"nlink"})
    public IRubyObject nlink() {
        return this.getRuntime().newFixnum(this.stat.nlink());
    }

    @JRubyMethod(name={"owned?"})
    public IRubyObject owned_p() {
        return this.getRuntime().newBoolean(this.stat.isOwned());
    }

    @JRubyMethod(name={"pipe?"})
    public IRubyObject pipe_p() {
        return this.getRuntime().newBoolean(this.stat.isNamedPipe());
    }

    @JRubyMethod(name={"rdev"})
    public IRubyObject rdev() {
        return this.getRuntime().newFixnum(this.stat.rdev());
    }

    @JRubyMethod(name={"rdev_major"})
    public IRubyObject rdevMajor() {
        return this.getRuntime().newFixnum(this.stat.major(this.stat.rdev()));
    }

    @JRubyMethod(name={"rdev_minor"})
    public IRubyObject rdevMinor() {
        return this.getRuntime().newFixnum(this.stat.minor(this.stat.rdev()));
    }

    @JRubyMethod(name={"readable?"})
    public IRubyObject readable_p() {
        return this.getRuntime().newBoolean(this.stat.isReadable());
    }

    @JRubyMethod(name={"readable_real?"})
    public IRubyObject readableReal_p() {
        return this.getRuntime().newBoolean(this.stat.isReadableReal());
    }

    @JRubyMethod(name={"setgid?"})
    public IRubyObject setgid_p() {
        return this.getRuntime().newBoolean(this.stat.isSetgid());
    }

    @JRubyMethod(name={"setuid?"})
    public IRubyObject setuid_p() {
        return this.getRuntime().newBoolean(this.stat.isSetuid());
    }

    @JRubyMethod(name={"size"})
    public IRubyObject size() {
        return this.getRuntime().newFixnum(this.stat.st_size());
    }

    @JRubyMethod(name={"size?"})
    public IRubyObject size_p() {
        long l = this.stat.st_size();
        if (l == 0L) {
            return this.getRuntime().getNil();
        }
        return this.getRuntime().newFixnum(l);
    }

    @JRubyMethod(name={"socket?"})
    public IRubyObject socket_p() {
        return this.getRuntime().newBoolean(this.stat.isSocket());
    }

    @JRubyMethod(name={"sticky?"})
    public IRubyObject sticky_p() {
        return this.getRuntime().newBoolean(this.stat.isSticky());
    }

    @JRubyMethod(name={"symlink?"})
    public IRubyObject symlink_p() {
        return this.getRuntime().newBoolean(this.getRuntime().getPosix().lstat(this.file.getAbsolutePath()).isSymlink());
    }

    @JRubyMethod(name={"writable?"})
    public IRubyObject writable_p() {
        return this.getRuntime().newBoolean(this.stat.isWritable());
    }

    @JRubyMethod(name={"writable_real?"})
    public IRubyObject writableReal_p() {
        return this.getRuntime().newBoolean(this.stat.isWritableReal());
    }

    @JRubyMethod(name={"zero?"})
    public IRubyObject zero_p() {
        return this.getRuntime().newBoolean(this.stat.isEmpty());
    }
}

