/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.math.BigInteger;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.Convert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RubyFixnum
extends RubyInteger {
    private final long value;
    private static final int BIT_SIZE = 64;
    public static final long SIGN_BIT = Long.MIN_VALUE;
    public static final long MAX = Long.MAX_VALUE;
    public static final long MIN = Long.MIN_VALUE;
    public static final long MAX_MARSHAL_FIXNUM = 0x3FFFFFFFL;
    public static final long MIN_MARSHAL_FIXNUM = -1073741824L;

    public static RubyClass createFixnumClass(Ruby ruby) {
        RubyClass rubyClass = ruby.defineClass("Fixnum", ruby.getInteger(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        ruby.setFixnum(rubyClass);
        rubyClass.index = 1;
        rubyClass.kindOf = new RubyModule.KindOf(){

            public boolean isKindOf(IRubyObject iRubyObject, RubyModule rubyModule) {
                return iRubyObject instanceof RubyFixnum;
            }
        };
        CallbackFactory callbackFactory = ruby.callbackFactory(RubyFixnum.class);
        rubyClass.includeModule(ruby.getPrecision());
        rubyClass.defineAnnotatedMethods(RubyFixnum.class);
        rubyClass.dispatcher = callbackFactory.createDispatcher(rubyClass);
        for (int i = 0; i < ruby.fixnumCache.length; ++i) {
            ruby.fixnumCache[i] = new RubyFixnum(ruby, rubyClass, i - 128);
        }
        return rubyClass;
    }

    public RubyFixnum(Ruby ruby) {
        this(ruby, 0L);
    }

    public RubyFixnum(Ruby ruby, long l) {
        super(ruby, ruby.getFixnum(), false);
        this.value = l;
    }

    private RubyFixnum(Ruby ruby, RubyClass rubyClass, long l) {
        super(ruby, rubyClass, false);
        this.value = l;
    }

    @Override
    public int getNativeTypeIndex() {
        return 1;
    }

    @Override
    public final boolean eql(IRubyObject iRubyObject) {
        return iRubyObject instanceof RubyFixnum && this.value == ((RubyFixnum)iRubyObject).value;
    }

    @Override
    public boolean isImmediate() {
        return true;
    }

    @Override
    public RubyClass getSingletonClass() {
        throw this.getRuntime().newTypeError("can't define singleton");
    }

    @Override
    public Class<?> getJavaClass() {
        return Long.TYPE;
    }

    @Override
    public double getDoubleValue() {
        return this.value;
    }

    @Override
    public long getLongValue() {
        return this.value;
    }

    public static RubyFixnum newFixnum(Ruby ruby, long l) {
        if (l <= 127L && l >= -128L) {
            return ruby.fixnumCache[(int)l + 128];
        }
        return new RubyFixnum(ruby, l);
    }

    public RubyFixnum newFixnum(long l) {
        return RubyFixnum.newFixnum(this.getRuntime(), l);
    }

    public static RubyFixnum zero(Ruby ruby) {
        return RubyFixnum.newFixnum(ruby, 0L);
    }

    public static RubyFixnum one(Ruby ruby) {
        return RubyFixnum.newFixnum(ruby, 1L);
    }

    public static RubyFixnum minus_one(Ruby ruby) {
        return RubyFixnum.newFixnum(ruby, -1L);
    }

    @Override
    public RubyFixnum hash() {
        return this.newFixnum(this.hashCode());
    }

    @Override
    public final int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof RubyFixnum) {
            RubyFixnum rubyFixnum = (RubyFixnum)object;
            if (rubyFixnum.value == this.value) {
                return true;
            }
        }
        return false;
    }

    @JRubyMethod(optional=1)
    public RubyString to_s(IRubyObject[] iRubyObjectArray) {
        int n;
        int n2 = n = iRubyObjectArray.length == 0 ? 10 : RubyFixnum.num2int(iRubyObjectArray[0]);
        if (n < 2 || n > 36) {
            throw this.getRuntime().newArgumentError("illegal radix " + n);
        }
        return this.getRuntime().newString(Convert.longToByteList(this.value, n));
    }

    @JRubyMethod
    public IRubyObject id2name() {
        RubySymbol rubySymbol = RubySymbol.getSymbolLong(this.getRuntime(), this.value);
        if (rubySymbol != null) {
            return this.getRuntime().newString(rubySymbol.asJavaString());
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject to_sym() {
        RubySymbol rubySymbol = RubySymbol.getSymbolLong(this.getRuntime(), this.value);
        return rubySymbol != null ? rubySymbol : this.getRuntime().getNil();
    }

    @JRubyMethod(name={"-@"})
    public IRubyObject op_uminus() {
        if (this.value == Long.MIN_VALUE) {
            return RubyBignum.newBignum(this.getRuntime(), BigInteger.valueOf(this.value).negate());
        }
        return RubyFixnum.newFixnum(this.getRuntime(), -this.value);
    }

    @JRubyMethod(name={"+"})
    public IRubyObject op_plus(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyFixnum) {
            long l = ((RubyFixnum)iRubyObject).value;
            long l2 = this.value + l;
            if (((this.value ^ l ^ 0xFFFFFFFFFFFFFFFFL) & (this.value ^ l2) & Long.MIN_VALUE) != 0L) {
                return RubyBignum.newBignum(this.getRuntime(), this.value).op_plus(threadContext, iRubyObject);
            }
            return this.newFixnum(l2);
        }
        if (iRubyObject instanceof RubyBignum) {
            return ((RubyBignum)iRubyObject).op_plus(threadContext, this);
        }
        if (iRubyObject instanceof RubyFloat) {
            return this.getRuntime().newFloat((double)this.value + ((RubyFloat)iRubyObject).getDoubleValue());
        }
        return this.coerceBin(threadContext, "+", iRubyObject);
    }

    @JRubyMethod(name={"-"})
    public IRubyObject op_minus(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyFixnum) {
            long l = ((RubyFixnum)iRubyObject).value;
            long l2 = this.value - l;
            if (((this.value ^ (l ^ 0xFFFFFFFFFFFFFFFFL) ^ 0xFFFFFFFFFFFFFFFFL) & (this.value ^ l2) & Long.MIN_VALUE) != 0L) {
                return RubyBignum.newBignum(this.getRuntime(), this.value).op_minus(threadContext, iRubyObject);
            }
            return this.newFixnum(l2);
        }
        if (iRubyObject instanceof RubyBignum) {
            return RubyBignum.newBignum(this.getRuntime(), this.value).op_minus(threadContext, iRubyObject);
        }
        if (iRubyObject instanceof RubyFloat) {
            return this.getRuntime().newFloat((double)this.value - ((RubyFloat)iRubyObject).getDoubleValue());
        }
        return this.coerceBin(threadContext, "-", iRubyObject);
    }

    @JRubyMethod(name={"*"})
    public IRubyObject op_mul(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyFixnum) {
            long l = ((RubyFixnum)iRubyObject).value;
            if (this.value == 0L) {
                return RubyFixnum.zero(this.getRuntime());
            }
            long l2 = this.value * l;
            RubyFixnum rubyFixnum = RubyFixnum.newFixnum(this.getRuntime(), l2);
            if (RubyNumeric.fix2long(rubyFixnum) != l2 || l2 / this.value != l) {
                return (RubyNumeric)RubyBignum.newBignum(this.getRuntime(), this.value).op_mul(threadContext, iRubyObject);
            }
            return rubyFixnum;
        }
        if (iRubyObject instanceof RubyBignum) {
            return ((RubyBignum)iRubyObject).op_mul(threadContext, this);
        }
        if (iRubyObject instanceof RubyFloat) {
            return this.getRuntime().newFloat((double)this.value * ((RubyFloat)iRubyObject).getDoubleValue());
        }
        return this.coerceBin(threadContext, "*", iRubyObject);
    }

    @JRubyMethod(name={"div"})
    public IRubyObject div_div(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.idiv(threadContext, iRubyObject, "div");
    }

    @JRubyMethod(name={"/"})
    public IRubyObject op_div(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.idiv(threadContext, iRubyObject, "/");
    }

    public IRubyObject idiv(ThreadContext threadContext, IRubyObject iRubyObject, String string) {
        if (iRubyObject instanceof RubyFixnum) {
            long l = this.value;
            long l2 = ((RubyFixnum)iRubyObject).value;
            if (l2 == 0L) {
                throw this.getRuntime().newZeroDivisionError();
            }
            long l3 = l / l2;
            long l4 = l % l2;
            if (l4 < 0L && l2 > 0L || l4 > 0L && l2 < 0L) {
                --l3;
            }
            return this.getRuntime().newFixnum(l3);
        }
        return this.coerceBin(threadContext, string, iRubyObject);
    }

    @JRubyMethod(name={"%", "modulo"})
    public IRubyObject op_mod(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyFixnum) {
            long l = this.value;
            long l2 = ((RubyFixnum)iRubyObject).value;
            if (l2 == 0L) {
                throw this.getRuntime().newZeroDivisionError();
            }
            long l3 = l % l2;
            if (l3 < 0L && l2 > 0L || l3 > 0L && l2 < 0L) {
                l3 += l2;
            }
            return this.getRuntime().newFixnum(l3);
        }
        return this.coerceBin(threadContext, "%", iRubyObject);
    }

    @Override
    @JRubyMethod
    public IRubyObject divmod(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyFixnum) {
            long l = this.value;
            long l2 = ((RubyFixnum)iRubyObject).value;
            Ruby ruby = this.getRuntime();
            if (l2 == 0L) {
                throw ruby.newZeroDivisionError();
            }
            long l3 = l / l2;
            long l4 = l % l2;
            if (l4 < 0L && l2 > 0L || l4 > 0L && l2 < 0L) {
                --l3;
                l4 += l2;
            }
            RubyFixnum rubyFixnum = RubyFixnum.newFixnum(this.getRuntime(), l3);
            RubyFixnum rubyFixnum2 = RubyFixnum.newFixnum(this.getRuntime(), l4);
            return RubyArray.newArray(ruby, rubyFixnum, rubyFixnum2);
        }
        return this.coerceBin(threadContext, "divmod", iRubyObject);
    }

    @Override
    @JRubyMethod
    public IRubyObject quo(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyFixnum) {
            return RubyFloat.newFloat(this.getRuntime(), (double)this.value / (double)((RubyFixnum)iRubyObject).value);
        }
        return this.coerceBin(threadContext, "quo", iRubyObject);
    }

    @JRubyMethod(name={"**"})
    public IRubyObject op_pow(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyFixnum) {
            long l = ((RubyFixnum)iRubyObject).value;
            if (l == 0L) {
                return RubyFixnum.one(this.getRuntime());
            }
            if (l == 1L) {
                return this;
            }
            if (l > 0L) {
                return RubyBignum.newBignum(this.getRuntime(), this.value).op_pow(threadContext, iRubyObject);
            }
            return RubyFloat.newFloat(this.getRuntime(), Math.pow(this.value, l));
        }
        if (iRubyObject instanceof RubyFloat) {
            return RubyFloat.newFloat(this.getRuntime(), Math.pow(this.value, ((RubyFloat)iRubyObject).getDoubleValue()));
        }
        return this.coerceBin(threadContext, "**", iRubyObject);
    }

    @JRubyMethod
    public IRubyObject abs() {
        if (this.value < 0L) {
            if (this.value == Long.MIN_VALUE) {
                return RubyBignum.newBignum(this.getRuntime(), BigInteger.valueOf(this.value).negate());
            }
            return RubyFixnum.newFixnum(this.getRuntime(), -this.value);
        }
        return this;
    }

    @Override
    @JRubyMethod(name={"=="})
    public IRubyObject op_equal(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyFixnum) {
            return RubyBoolean.newBoolean(this.getRuntime(), this.value == ((RubyFixnum)iRubyObject).value);
        }
        return super.op_num_equal(threadContext, iRubyObject);
    }

    @JRubyMethod(name={"<=>"})
    public IRubyObject op_cmp(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyFixnum) {
            long l = ((RubyFixnum)iRubyObject).value;
            if (this.value == l) {
                return RubyFixnum.zero(this.getRuntime());
            }
            if (this.value > l) {
                return RubyFixnum.one(this.getRuntime());
            }
            return RubyFixnum.minus_one(this.getRuntime());
        }
        return this.coerceCmp(threadContext, "<=>", iRubyObject);
    }

    @JRubyMethod(name={">"})
    public IRubyObject op_gt(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyFixnum) {
            return RubyBoolean.newBoolean(this.getRuntime(), this.value > ((RubyFixnum)iRubyObject).value);
        }
        return this.coerceRelOp(threadContext, ">", iRubyObject);
    }

    @JRubyMethod(name={">="})
    public IRubyObject op_ge(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyFixnum) {
            return RubyBoolean.newBoolean(this.getRuntime(), this.value >= ((RubyFixnum)iRubyObject).value);
        }
        return this.coerceRelOp(threadContext, ">=", iRubyObject);
    }

    @JRubyMethod(name={"<"})
    public IRubyObject op_lt(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyFixnum) {
            return RubyBoolean.newBoolean(this.getRuntime(), this.value < ((RubyFixnum)iRubyObject).value);
        }
        return this.coerceRelOp(threadContext, "<", iRubyObject);
    }

    @JRubyMethod(name={"<="})
    public IRubyObject op_le(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyFixnum) {
            return RubyBoolean.newBoolean(this.getRuntime(), this.value <= ((RubyFixnum)iRubyObject).value);
        }
        return this.coerceRelOp(threadContext, "<=", iRubyObject);
    }

    @JRubyMethod(name={"~"})
    public IRubyObject op_neg() {
        return this.newFixnum(this.value ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @JRubyMethod(name={"&"})
    public IRubyObject op_and(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyFixnum) {
            return this.newFixnum(this.value & ((RubyFixnum)iRubyObject).value);
        }
        if (iRubyObject instanceof RubyBignum) {
            return ((RubyBignum)iRubyObject).op_and(threadContext, this);
        }
        return this.newFixnum(this.value & RubyFixnum.num2long(iRubyObject));
    }

    @JRubyMethod(name={"|"})
    public IRubyObject op_or(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyFixnum) {
            return this.newFixnum(this.value | ((RubyFixnum)iRubyObject).value);
        }
        if (iRubyObject instanceof RubyBignum) {
            return ((RubyBignum)iRubyObject).op_or(threadContext, this);
        }
        return this.newFixnum(this.value | RubyFixnum.num2long(iRubyObject));
    }

    @JRubyMethod(name={"^"})
    public IRubyObject op_xor(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyFixnum) {
            return this.newFixnum(this.value ^ ((RubyFixnum)iRubyObject).value);
        }
        if (iRubyObject instanceof RubyBignum) {
            return ((RubyBignum)iRubyObject).op_xor(threadContext, this);
        }
        return this.newFixnum(this.value ^ RubyFixnum.num2long(iRubyObject));
    }

    @JRubyMethod(name={"[]"})
    public IRubyObject op_aref(IRubyObject iRubyObject) {
        long l;
        if (iRubyObject instanceof RubyBignum) {
            RubyBignum rubyBignum = (RubyBignum)iRubyObject;
            RubyInteger rubyInteger = RubyBignum.bignorm(this.getRuntime(), rubyBignum.getValue());
            if (!(rubyInteger instanceof RubyFixnum)) {
                if (rubyBignum.getValue().signum() == 0 || this.value >= 0L) {
                    return RubyFixnum.zero(this.getRuntime());
                }
                return RubyFixnum.one(this.getRuntime());
            }
        }
        if ((l = RubyFixnum.num2long(iRubyObject)) < 0L) {
            return RubyFixnum.zero(this.getRuntime());
        }
        if (63L < l) {
            if (this.value < 0L) {
                return RubyFixnum.one(this.getRuntime());
            }
            return RubyFixnum.zero(this.getRuntime());
        }
        return (this.value & 1L << (int)l) == 0L ? RubyFixnum.zero(this.getRuntime()) : RubyFixnum.one(this.getRuntime());
    }

    @JRubyMethod(name={"<<"})
    public IRubyObject op_lshift(IRubyObject iRubyObject) {
        long l = RubyFixnum.num2long(iRubyObject);
        if (l < 0L) {
            return this.op_rshift(RubyFixnum.newFixnum(this.getRuntime(), -l));
        }
        if (l == 0L) {
            return this;
        }
        if (l > 63L || (-1L << (int)(64L - l - 1L) & this.value) != 0L) {
            return RubyBignum.newBignum(this.getRuntime(), this.value).op_lshift(iRubyObject);
        }
        return this.newFixnum(this.value << (int)l);
    }

    @JRubyMethod(name={">>"})
    public IRubyObject op_rshift(IRubyObject iRubyObject) {
        long l = RubyFixnum.num2long(iRubyObject);
        if (l < 0L) {
            return this.op_lshift(RubyFixnum.newFixnum(this.getRuntime(), -l));
        }
        if (l == 0L) {
            return this;
        }
        if (l >= 63L) {
            if (this.value < 0L) {
                return RubyFixnum.minus_one(this.getRuntime());
            }
            return RubyFixnum.zero(this.getRuntime());
        }
        return this.newFixnum(this.value >> (int)l);
    }

    @JRubyMethod
    public IRubyObject to_f() {
        return RubyFloat.newFloat(this.getRuntime(), this.value);
    }

    @JRubyMethod
    public IRubyObject size() {
        return this.newFixnum(8L);
    }

    @JRubyMethod(name={"zero?"})
    public IRubyObject zero_p() {
        return RubyBoolean.newBoolean(this.getRuntime(), this.value == 0L);
    }

    @Override
    @JRubyMethod
    public IRubyObject id() {
        if (this.value <= 0x3FFFFFFFFFFFFFFFL && this.value >= -4611686018427387904L) {
            return this.newFixnum(2L * this.value + 1L);
        }
        return super.id();
    }

    @Override
    public IRubyObject taint() {
        return this;
    }

    @Override
    public IRubyObject freeze() {
        return this;
    }

    @Override
    public String asJavaString() {
        this.getRuntime().getWarnings().warn(IRubyWarnings.ID.FIXNUMS_NOT_SYMBOLS, "do not use Fixnums as Symbols", new Object[0]);
        RubySymbol rubySymbol = RubySymbol.getSymbolLong(this.getRuntime(), this.value);
        if (rubySymbol == null) {
            throw this.getRuntime().newArgumentError("" + this.value + " is not a symbol");
        }
        return rubySymbol.asJavaString();
    }

    public static RubyFixnum unmarshalFrom(UnmarshalStream unmarshalStream) throws IOException {
        return unmarshalStream.getRuntime().newFixnum(unmarshalStream.unmarshalInt());
    }

    @JRubyMethod(meta=true)
    public static IRubyObject induced_from(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return RubyNumeric.num2fix(iRubyObject2);
    }
}

