/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyGC {
    public static RubyModule createGCModule(Ruby ruby) {
        RubyModule rubyModule = ruby.defineModule("GC");
        ruby.setGC(rubyModule);
        rubyModule.defineAnnotatedMethods(RubyGC.class);
        return rubyModule;
    }

    @JRubyMethod(meta=true)
    public static IRubyObject start(IRubyObject iRubyObject) {
        System.gc();
        return iRubyObject.getRuntime().getNil();
    }

    @JRubyMethod
    public static IRubyObject garbage_collect(IRubyObject iRubyObject) {
        System.gc();
        return iRubyObject.getRuntime().getNil();
    }

    @JRubyMethod(meta=true)
    public static IRubyObject enable(IRubyObject iRubyObject) {
        iRubyObject.getRuntime().getWarnings().warn(IRubyWarnings.ID.EMPTY_IMPLEMENTATION, "GC.enable will not work on JRuby", "GC.enable");
        return iRubyObject.getRuntime().getNil();
    }

    @JRubyMethod(meta=true)
    public static IRubyObject disable(IRubyObject iRubyObject) {
        iRubyObject.getRuntime().getWarnings().warn(IRubyWarnings.ID.EMPTY_IMPLEMENTATION, "GC.disable will not work on JRuby", "GC.disable");
        return iRubyObject.getRuntime().getNil();
    }
}

