/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.RDoc;
import org.jruby.common.IRubyWarnings;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;

@RDoc(doc="A <code>Hash</code> is a collection of key-value pairs. It is\nsimilar to an <code>Array</code>, except that indexing is done via\narbitrary keys of any object type, not an integer index. The order\nin which you traverse a hash by either key or value may seem\narbitrary, and will generally not be in the insertion order.\n   \nHashes have a <em>default value</em> that is returned when accessing\nkeys that do not exist in the hash. By default, that value is\n<code>nil</code>.\n\n<code>Hash</code> uses <code>key.eql?</code> to test keys for equality.\nIf you need to use instances of your own classes as keys in a <code>Hash</code>,\nit is recommended that you define both the <code>eql?</code> and <code>hash</code>\nmethods. The <code>hash</code> method must have the property that \n<code>a.eql?(b)</code> implies <code>a.hash == b.hash</code>.\n\n  class MyClass\n    attr_reader :str\n    def initialize(str)\n      @str = str\n    end\n    def eql?(o)\n      o.is_a?(MyClass) && str == o.str\n    end\n    def hash\n      @str.hash\n    end\n  end\n  \n  a = MyClass.new(\"some string\")\n  b = MyClass.new(\"some string\")\n  a.eql? b  #=> true\n  \n  h = {}\n  \n  h[a] = 1\n  h[a]      #=> 1\n  h[b]      #=> 1\n  \n  h[b] = 2\n  h[a]      #=> 2\n  h[b]      #=> \n2", name="Hash")
public class RubyHash
extends RubyObject
implements Map {
    private static final ObjectAllocator HASH_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new RubyHash(ruby, rubyClass);
        }
    };
    private RubyHashEntry[] table;
    private int size = 0;
    private int threshold;
    private static final int PROCDEFAULT_HASH_F = 1024;
    private IRubyObject ifNone;
    private static final int[] MRI_PRIMES = new int[]{11, 19, 37, 67, 131, 283, 521, 1033, 2053, 4099, 8219, 16427, 32771, 65581, 131101, 262147, 524309, 0x100007, 0x200011, 0x40000F, 0x800009, 16777259, 0x2000023, 0x400000F, 134217757, 0x10000003, 0x2000000B, 0x40000055, 0};
    private static final int JAVASOFT_INITIAL_CAPACITY = 8;
    private static final int MRI_INITIAL_CAPACITY = MRI_PRIMES[0];
    private static final int INITIAL_THRESHOLD = 6;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final RubyHashEntry NO_ENTRY = new RubyHashEntry();
    private int generation = 0;
    private final RubyHashEntry head = new RubyHashEntry();
    private static final int HASH_SIGN_BIT_MASK = Integer.MAX_VALUE;
    private static final int MIN_CAPA = 8;
    private static final int ST_DEFAULT_MAX_DENSITY = 5;
    private static boolean MRI_HASH = true;
    private static boolean MRI_HASH_RESIZE = true;
    public static long collisions = 0L;
    private static final EntryMatchType MATCH_KEY = new EntryMatchType(){

        public boolean matches(RubyHashEntry rubyHashEntry, Object object) {
            IRubyObject iRubyObject = rubyHashEntry.key;
            return object == iRubyObject || ((IRubyObject)object).eql(iRubyObject);
        }
    };
    private static final EntryMatchType MATCH_ENTRY = new EntryMatchType(){

        public boolean matches(RubyHashEntry rubyHashEntry, Object object) {
            return rubyHashEntry.equals(object);
        }
    };
    private static final boolean EQUAL_CHECK_DEFAULT_VALUE = false;
    private static final EntryView DIRECT_KEY_VIEW = new EntryView(){

        public Object convertEntry(Ruby ruby, RubyHashEntry rubyHashEntry) {
            return rubyHashEntry.key;
        }

        public boolean contains(RubyHash rubyHash, Object object) {
            if (!(object instanceof IRubyObject)) {
                return false;
            }
            return rubyHash.internalGet((IRubyObject)object) != null;
        }

        public boolean remove(RubyHash rubyHash, Object object) {
            if (!(object instanceof IRubyObject)) {
                return false;
            }
            return rubyHash.internalDelete((IRubyObject)object) != NO_ENTRY;
        }
    };
    private static final EntryView KEY_VIEW = new EntryView(){

        public Object convertEntry(Ruby ruby, RubyHashEntry rubyHashEntry) {
            return JavaUtil.convertRubyToJava(rubyHashEntry.key, Object.class);
        }

        public boolean contains(RubyHash rubyHash, Object object) {
            return rubyHash.containsKey(object);
        }

        public boolean remove(RubyHash rubyHash, Object object) {
            return rubyHash.remove(object) != null;
        }
    };
    private static final EntryView DIRECT_VALUE_VIEW = new EntryView(){

        public Object convertEntry(Ruby ruby, RubyHashEntry rubyHashEntry) {
            return rubyHashEntry.value;
        }

        public boolean contains(RubyHash rubyHash, Object object) {
            if (!(object instanceof IRubyObject)) {
                return false;
            }
            IRubyObject iRubyObject = (IRubyObject)object;
            return rubyHash.hasValue(iRubyObject.getRuntime().getCurrentContext(), iRubyObject);
        }

        public boolean remove(RubyHash rubyHash, Object object) {
            if (!(object instanceof IRubyObject)) {
                return false;
            }
            IRubyObject iRubyObject = (IRubyObject)object;
            IRubyObject iRubyObject2 = rubyHash.internalIndex(iRubyObject.getRuntime().getCurrentContext(), iRubyObject);
            if (iRubyObject2 == null) {
                return false;
            }
            return rubyHash.internalDelete(iRubyObject2) != NO_ENTRY;
        }
    };
    private final EntryView VALUE_VIEW;
    private final EntryView DIRECT_ENTRY_VIEW;
    private final EntryView ENTRY_VIEW;

    public static RubyClass createHashClass(Ruby ruby) {
        RubyClass rubyClass = ruby.defineClass("Hash", ruby.getObject(), HASH_ALLOCATOR);
        ruby.setHash(rubyClass);
        rubyClass.index = 10;
        rubyClass.kindOf = new RubyModule.KindOf(){

            public boolean isKindOf(IRubyObject iRubyObject, RubyModule rubyModule) {
                return iRubyObject instanceof RubyHash;
            }
        };
        CallbackFactory callbackFactory = ruby.callbackFactory(RubyHash.class);
        rubyClass.includeModule(ruby.getEnumerable());
        rubyClass.defineAnnotatedMethods(RubyHash.class);
        rubyClass.dispatcher = callbackFactory.createDispatcher(rubyClass);
        return rubyClass;
    }

    public int getNativeTypeIndex() {
        return 10;
    }

    @JRubyMethod(name={"[]"}, rest=true, frame=true, meta=true)
    public static IRubyObject create(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        RubyClass rubyClass = (RubyClass)iRubyObject;
        if (iRubyObjectArray.length == 1 && iRubyObjectArray[0] instanceof RubyHash) {
            RubyHash rubyHash = (RubyHash)iRubyObjectArray[0];
            return new RubyHash(iRubyObject.getRuntime(), rubyClass, rubyHash);
        }
        if ((iRubyObjectArray.length & 1) != 0) {
            throw iRubyObject.getRuntime().newArgumentError("odd number of args for Hash");
        }
        RubyHash rubyHash = (RubyHash)rubyClass.allocate();
        for (int i = 0; i < iRubyObjectArray.length; i += 2) {
            rubyHash.op_aset(threadContext, iRubyObjectArray[i], iRubyObjectArray[i + 1]);
        }
        return rubyHash;
    }

    public static final RubyHash newHash(Ruby ruby) {
        return new RubyHash(ruby);
    }

    public static final RubyHash newHash(Ruby ruby, Map map, IRubyObject iRubyObject) {
        assert (iRubyObject != null);
        return new RubyHash(ruby, map, iRubyObject);
    }

    private RubyHash(Ruby ruby, RubyClass rubyClass, RubyHash rubyHash) {
        super(ruby, rubyClass);
        this.head.prevAdded = (this.head.nextAdded = this.head);
        this.VALUE_VIEW = new EntryView(){

            public Object convertEntry(Ruby ruby, RubyHashEntry rubyHashEntry) {
                return JavaUtil.convertRubyToJava(rubyHashEntry.value, Object.class);
            }

            public boolean contains(RubyHash rubyHash, Object object) {
                return rubyHash.containsValue(object);
            }

            public boolean remove(RubyHash rubyHash, Object object) {
                IRubyObject iRubyObject = JavaUtil.convertJavaToRuby(rubyHash.getRuntime(), object);
                IRubyObject iRubyObject2 = rubyHash.internalIndex(rubyHash.getRuntime().getCurrentContext(), iRubyObject);
                if (iRubyObject2 == null) {
                    return false;
                }
                return rubyHash.internalDelete(iRubyObject2) != NO_ENTRY;
            }
        };
        this.DIRECT_ENTRY_VIEW = new EntryView(){

            public Object convertEntry(Ruby ruby, RubyHashEntry rubyHashEntry) {
                return rubyHashEntry;
            }

            public boolean contains(RubyHash rubyHash, Object object) {
                if (!(object instanceof RubyHashEntry)) {
                    return false;
                }
                RubyHashEntry rubyHashEntry = (RubyHashEntry)object;
                RubyHashEntry rubyHashEntry2 = RubyHash.this.internalGetEntry(rubyHashEntry.key);
                return rubyHashEntry2 != NO_ENTRY && rubyHashEntry.equals(rubyHashEntry2);
            }

            public boolean remove(RubyHash rubyHash, Object object) {
                if (!(object instanceof RubyHashEntry)) {
                    return false;
                }
                return rubyHash.internalDeleteEntry((RubyHashEntry)object) != NO_ENTRY;
            }
        };
        this.ENTRY_VIEW = new EntryView(){

            public Object convertEntry(Ruby ruby, RubyHashEntry rubyHashEntry) {
                return new ConvertingEntry(ruby, rubyHashEntry);
            }

            public boolean contains(RubyHash rubyHash, Object object) {
                if (!(object instanceof ConvertingEntry)) {
                    return false;
                }
                ConvertingEntry convertingEntry = (ConvertingEntry)object;
                RubyHashEntry rubyHashEntry = rubyHash.internalGetEntry(convertingEntry.entry.key);
                return rubyHashEntry != NO_ENTRY && convertingEntry.entry.equals(rubyHashEntry);
            }

            public boolean remove(RubyHash rubyHash, Object object) {
                if (!(object instanceof ConvertingEntry)) {
                    return false;
                }
                ConvertingEntry convertingEntry = (ConvertingEntry)object;
                return rubyHash.internalDeleteEntry(convertingEntry.entry) != NO_ENTRY;
            }
        };
        this.ifNone = ruby.getNil();
        this.threshold = 6;
        this.table = rubyHash.internalCopyTable(this.head);
        this.size = rubyHash.size;
    }

    public RubyHash(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
        this.head.prevAdded = (this.head.nextAdded = this.head);
        this.VALUE_VIEW = new /* invalid duplicate definition of identical inner class */;
        this.DIRECT_ENTRY_VIEW = new /* invalid duplicate definition of identical inner class */;
        this.ENTRY_VIEW = new /* invalid duplicate definition of identical inner class */;
        this.ifNone = ruby.getNil();
        this.alloc();
    }

    public RubyHash(Ruby ruby) {
        this(ruby, ruby.getNil());
    }

    public RubyHash(Ruby ruby, IRubyObject iRubyObject) {
        super(ruby, ruby.getHash());
        this.head.prevAdded = (this.head.nextAdded = this.head);
        this.VALUE_VIEW = new /* invalid duplicate definition of identical inner class */;
        this.DIRECT_ENTRY_VIEW = new /* invalid duplicate definition of identical inner class */;
        this.ENTRY_VIEW = new /* invalid duplicate definition of identical inner class */;
        this.ifNone = iRubyObject;
        this.alloc();
    }

    RubyHash(Ruby ruby, boolean bl) {
        super(ruby, ruby.getHash(), bl);
        this.head.prevAdded = (this.head.nextAdded = this.head);
        this.VALUE_VIEW = new /* invalid duplicate definition of identical inner class */;
        this.DIRECT_ENTRY_VIEW = new /* invalid duplicate definition of identical inner class */;
        this.ENTRY_VIEW = new /* invalid duplicate definition of identical inner class */;
        this.alloc();
    }

    public RubyHash(Ruby ruby, Map map, IRubyObject iRubyObject) {
        super(ruby, ruby.getHash());
        this.head.prevAdded = (this.head.nextAdded = this.head);
        this.VALUE_VIEW = new /* invalid duplicate definition of identical inner class */;
        this.DIRECT_ENTRY_VIEW = new /* invalid duplicate definition of identical inner class */;
        this.ENTRY_VIEW = new /* invalid duplicate definition of identical inner class */;
        this.ifNone = iRubyObject;
        this.alloc();
        for (Map.Entry entry : map.entrySet()) {
            this.internalPut((IRubyObject)entry.getKey(), (IRubyObject)entry.getValue());
        }
    }

    private final void alloc() {
        this.threshold = 6;
        ++this.generation;
        this.head.nextAdded = (this.head.prevAdded = this.head);
        this.table = new RubyHashEntry[MRI_HASH_RESIZE ? MRI_INITIAL_CAPACITY : 8];
    }

    private static int JavaSoftHashValue(int n) {
        n ^= n >>> 20 ^ n >>> 12;
        return n ^ n >>> 7 ^ n >>> 4;
    }

    private static int JavaSoftBucketIndex(int n, int n2) {
        return n & n2 - 1;
    }

    private static int MRIHashValue(int n) {
        return n & Integer.MAX_VALUE;
    }

    private static int MRIBucketIndex(int n, int n2) {
        return n % n2;
    }

    private final void resize(int n) {
        RubyHashEntry[] rubyHashEntryArray = this.table;
        RubyHashEntry[] rubyHashEntryArray2 = new RubyHashEntry[n];
        for (int i = 0; i < rubyHashEntryArray.length; ++i) {
            RubyHashEntry rubyHashEntry = rubyHashEntryArray[i];
            rubyHashEntryArray[i] = null;
            while (rubyHashEntry != null) {
                RubyHashEntry rubyHashEntry2 = rubyHashEntry.next;
                int n2 = RubyHash.bucketIndex(rubyHashEntry.hash, n);
                rubyHashEntry.next = rubyHashEntryArray2[n2];
                rubyHashEntryArray2[n2] = rubyHashEntry;
                rubyHashEntry = rubyHashEntry2;
            }
        }
        this.table = rubyHashEntryArray2;
    }

    private final void JavaSoftCheckResize() {
        if (this.size > this.threshold) {
            int n = this.table.length;
            if (n == 0x40000000) {
                this.threshold = Integer.MAX_VALUE;
                return;
            }
            int n2 = this.table.length << 1;
            this.resize(n2);
            this.threshold = n2 - (n2 >> 2);
        }
    }

    private final void MRICheckResize() {
        if (this.size / this.table.length > 5) {
            int n = this.table.length + 1;
            int n2 = 0;
            int n3 = 8;
            while (n2 < MRI_PRIMES.length) {
                if (n3 > n) {
                    this.resize(MRI_PRIMES[n2]);
                    return;
                }
                ++n2;
                n3 <<= 1;
            }
            return;
        }
    }

    private static int hashValue(int n) {
        return MRI_HASH ? RubyHash.MRIHashValue(n) : RubyHash.JavaSoftHashValue(n);
    }

    private static int bucketIndex(int n, int n2) {
        return MRI_HASH ? RubyHash.MRIBucketIndex(n, n2) : RubyHash.JavaSoftBucketIndex(n, n2);
    }

    private void checkResize() {
        if (MRI_HASH_RESIZE) {
            this.MRICheckResize();
        } else {
            this.JavaSoftCheckResize();
        }
    }

    private final void internalPut(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        this.internalPut(iRubyObject, iRubyObject2, true);
    }

    private final void internalPut(IRubyObject iRubyObject, IRubyObject iRubyObject2, boolean bl) {
        this.checkResize();
        int n = RubyHash.hashValue(iRubyObject.hashCode());
        int n2 = RubyHash.bucketIndex(n, this.table.length);
        if (bl) {
            RubyHashEntry rubyHashEntry = this.table[n2];
            while (rubyHashEntry != null) {
                IRubyObject iRubyObject3;
                if (rubyHashEntry.hash == n && ((iRubyObject3 = rubyHashEntry.key) == iRubyObject || iRubyObject.eql(iRubyObject3))) {
                    rubyHashEntry.value = iRubyObject2;
                    return;
                }
                rubyHashEntry = rubyHashEntry.next;
            }
        }
        this.table[n2] = new RubyHashEntry(n, iRubyObject, iRubyObject2, this.table[n2], this.head);
        ++this.size;
    }

    private final IRubyObject internalGet(IRubyObject iRubyObject) {
        return this.internalGetEntry(iRubyObject).value;
    }

    private final RubyHashEntry internalGetEntry(IRubyObject iRubyObject) {
        int n = RubyHash.hashValue(iRubyObject.hashCode());
        RubyHashEntry rubyHashEntry = this.table[RubyHash.bucketIndex(n, this.table.length)];
        while (rubyHashEntry != null) {
            IRubyObject iRubyObject2;
            if (rubyHashEntry.hash == n && ((iRubyObject2 = rubyHashEntry.key) == iRubyObject || iRubyObject.eql(iRubyObject2))) {
                return rubyHashEntry;
            }
            rubyHashEntry = rubyHashEntry.next;
        }
        return NO_ENTRY;
    }

    private final RubyHashEntry internalDelete(IRubyObject iRubyObject) {
        return this.internalDelete(RubyHash.hashValue(iRubyObject.hashCode()), MATCH_KEY, iRubyObject);
    }

    private final RubyHashEntry internalDeleteEntry(RubyHashEntry rubyHashEntry) {
        return this.internalDelete(RubyHash.hashValue(rubyHashEntry.key.hashCode()), MATCH_ENTRY, rubyHashEntry);
    }

    private final RubyHashEntry internalDelete(int n, EntryMatchType entryMatchType, Object object) {
        int n2 = RubyHash.bucketIndex(n, this.table.length);
        RubyHashEntry rubyHashEntry = this.table[n2];
        if (rubyHashEntry != null) {
            RubyHashEntry rubyHashEntry2 = null;
            while (rubyHashEntry != null) {
                if (rubyHashEntry.hash == n && entryMatchType.matches(rubyHashEntry, object)) {
                    if (rubyHashEntry2 != null) {
                        rubyHashEntry2.next = rubyHashEntry.next;
                    } else {
                        this.table[n2] = rubyHashEntry.next;
                    }
                    rubyHashEntry.detach();
                    --this.size;
                    return rubyHashEntry;
                }
                rubyHashEntry2 = rubyHashEntry;
                rubyHashEntry = rubyHashEntry.next;
            }
        }
        return NO_ENTRY;
    }

    private final RubyHashEntry[] internalCopyTable(RubyHashEntry rubyHashEntry) {
        RubyHashEntry[] rubyHashEntryArray = new RubyHashEntry[this.table.length];
        RubyHashEntry rubyHashEntry2 = this.head.nextAdded;
        while (rubyHashEntry2 != this.head) {
            int n = RubyHash.bucketIndex(rubyHashEntry2.hash, this.table.length);
            rubyHashEntryArray[n] = new RubyHashEntry(rubyHashEntry2.hash, rubyHashEntry2.key, rubyHashEntry2.value, rubyHashEntryArray[n], rubyHashEntry);
            rubyHashEntry2 = rubyHashEntry2.nextAdded;
        }
        return rubyHashEntryArray;
    }

    public void visitAll(Visitor visitor) {
        int n = this.generation;
        RubyHashEntry rubyHashEntry = this.head.nextAdded;
        while (rubyHashEntry != this.head) {
            if (n != this.generation) {
                n = this.generation;
                rubyHashEntry = this.head.nextAdded;
                if (rubyHashEntry == this.head) break;
            }
            if (rubyHashEntry.isLive()) {
                visitor.visit(rubyHashEntry.key, rubyHashEntry.value);
            }
            rubyHashEntry = rubyHashEntry.nextAdded;
        }
    }

    @JRubyMethod(name={"initialize"}, optional=1, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject[] iRubyObjectArray, Block block) {
        this.modify();
        if (block.isGiven()) {
            if (iRubyObjectArray.length > 0) {
                throw this.getRuntime().newArgumentError("wrong number of arguments");
            }
            this.ifNone = this.getRuntime().newProc(Block.Type.PROC, block);
            this.flags |= 0x400;
        } else {
            Arity.checkArgumentCount(this.getRuntime(), iRubyObjectArray, 0, 1);
            if (iRubyObjectArray.length == 1) {
                this.ifNone = iRubyObjectArray[0];
            }
        }
        return this;
    }

    @JRubyMethod(name={"default"}, optional=1, frame=true)
    public IRubyObject default_value_get(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        if ((this.flags & 0x400) != 0) {
            if (iRubyObjectArray.length == 0) {
                return this.getRuntime().getNil();
            }
            return this.ifNone.callMethod(threadContext, "call", new IRubyObject[]{this, iRubyObjectArray[0]});
        }
        return this.ifNone;
    }

    @JRubyMethod(name={"default="}, required=1)
    public IRubyObject default_value_set(IRubyObject iRubyObject) {
        this.modify();
        this.ifNone = iRubyObject;
        this.flags &= 0xFFFFFBFF;
        return this.ifNone;
    }

    @JRubyMethod(name={"default_proc"}, frame=true)
    public IRubyObject default_proc() {
        return (this.flags & 0x400) != 0 ? this.ifNone : this.getRuntime().getNil();
    }

    public void modify() {
        this.testFrozen("hash");
        if (this.isTaint() && this.getRuntime().getSafeLevel() >= 4) {
            throw this.getRuntime().newSecurityError("Insecure: can't modify hash");
        }
    }

    public IRubyObject inspectHash(final ThreadContext threadContext) {
        Ruby ruby = this.getRuntime();
        final StringBuffer stringBuffer = new StringBuffer("{");
        final boolean[] blArray = new boolean[]{true};
        this.visitAll(new Visitor(){

            public void visit(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
                if (!blArray[0]) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(iRubyObject.callMethod(threadContext, "inspect")).append("=>");
                stringBuffer.append(iRubyObject2.callMethod(threadContext, "inspect"));
                blArray[0] = false;
            }
        });
        stringBuffer.append("}");
        return ruby.newString(stringBuffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect(ThreadContext threadContext) {
        if (this.size == 0) {
            return this.getRuntime().newString("{}");
        }
        if (this.getRuntime().isInspecting(this)) {
            return this.getRuntime().newString("{...}");
        }
        try {
            this.getRuntime().registerInspecting(this);
            IRubyObject iRubyObject = this.inspectHash(threadContext);
            return iRubyObject;
        }
        finally {
            this.getRuntime().unregisterInspecting(this);
        }
    }

    @JRubyMethod(name={"size", "length"})
    public RubyFixnum rb_size() {
        return this.getRuntime().newFixnum(this.size);
    }

    @JRubyMethod(name={"empty?"})
    public RubyBoolean empty_p() {
        return this.size == 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"to_a"})
    public RubyArray to_a() {
        final Ruby ruby = this.getRuntime();
        final RubyArray rubyArray = RubyArray.newArray(ruby, this.size);
        this.visitAll(new Visitor(){

            public void visit(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
                rubyArray.append(RubyArray.newArray(ruby, iRubyObject, iRubyObject2));
            }
        });
        rubyArray.setTaint(this.isTaint());
        return rubyArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s() {
        if (this.getRuntime().isInspecting(this)) {
            return this.getRuntime().newString("{...}");
        }
        try {
            this.getRuntime().registerInspecting(this);
            IRubyObject iRubyObject = this.to_a().to_s();
            return iRubyObject;
        }
        finally {
            this.getRuntime().unregisterInspecting(this);
        }
    }

    @JRubyMethod(name={"rehash"})
    public RubyHash rehash() {
        this.modify();
        RubyHashEntry[] rubyHashEntryArray = this.table;
        RubyHashEntry[] rubyHashEntryArray2 = new RubyHashEntry[rubyHashEntryArray.length];
        for (int i = 0; i < rubyHashEntryArray.length; ++i) {
            RubyHashEntry rubyHashEntry = rubyHashEntryArray[i];
            rubyHashEntryArray[i] = null;
            while (rubyHashEntry != null) {
                RubyHashEntry rubyHashEntry2 = rubyHashEntry.next;
                rubyHashEntry.hash = rubyHashEntry.key.hashCode();
                int n = RubyHash.bucketIndex(rubyHashEntry.hash, rubyHashEntryArray2.length);
                rubyHashEntry.next = rubyHashEntryArray2[n];
                rubyHashEntryArray2[n] = rubyHashEntry;
                rubyHashEntry = rubyHashEntry2;
            }
        }
        this.table = rubyHashEntryArray2;
        return this;
    }

    @JRubyMethod(name={"to_hash"})
    public RubyHash to_hash() {
        return this;
    }

    public RubyHash convertToHash() {
        return this;
    }

    public final void fastASet(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        this.internalPut(iRubyObject, iRubyObject2);
    }

    @Deprecated
    public IRubyObject op_aset(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return this.op_aset(this.getRuntime().getCurrentContext(), iRubyObject, iRubyObject2);
    }

    @JRubyMethod(name={"[]=", "store"}, required=2)
    public IRubyObject op_aset(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        this.modify();
        if (!(iRubyObject instanceof RubyString)) {
            this.internalPut(iRubyObject, iRubyObject2);
        } else {
            RubyHashEntry rubyHashEntry = this.internalGetEntry(iRubyObject);
            if (rubyHashEntry != NO_ENTRY) {
                rubyHashEntry.value = iRubyObject2;
            } else {
                RubyString rubyString = (RubyString)iRubyObject;
                if (!rubyString.isFrozen()) {
                    rubyString = rubyString.strDup(rubyString.getMetaClass().getRealClass());
                    rubyString.setFrozen(true);
                }
                this.internalPut(rubyString, iRubyObject2, false);
            }
        }
        return iRubyObject2;
    }

    public IRubyObject aset(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return this.op_aset(this.getRuntime().getCurrentContext(), iRubyObject, iRubyObject2);
    }

    public IRubyObject aref(IRubyObject iRubyObject) {
        return this.op_aref(this.getRuntime().getCurrentContext(), iRubyObject);
    }

    public final IRubyObject fastARef(IRubyObject iRubyObject) {
        return this.internalGet(iRubyObject);
    }

    @JRubyMethod(name={"[]"}, required=1)
    public IRubyObject op_aref(ThreadContext threadContext, IRubyObject iRubyObject) {
        IRubyObject iRubyObject2 = this.internalGet(iRubyObject);
        return iRubyObject2 == null ? this.callMethod(threadContext, MethodIndex.DEFAULT, "default", iRubyObject) : iRubyObject2;
    }

    @JRubyMethod(name={"fetch"}, required=1, optional=1, frame=true)
    public IRubyObject fetch(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block) {
        IRubyObject iRubyObject;
        if (iRubyObjectArray.length == 2 && block.isGiven()) {
            this.getRuntime().getWarnings().warn(IRubyWarnings.ID.BLOCK_BEATS_DEFAULT_VALUE, "block supersedes default value argument", new Object[0]);
        }
        if ((iRubyObject = this.internalGet(iRubyObjectArray[0])) == null) {
            if (block.isGiven()) {
                return block.yield(threadContext, iRubyObjectArray[0]);
            }
            if (iRubyObjectArray.length == 1) {
                throw this.getRuntime().newIndexError("key not found");
            }
            return iRubyObjectArray[1];
        }
        return iRubyObject;
    }

    @JRubyMethod(name={"has_key?", "key?", "include?", "member?"}, required=1)
    public RubyBoolean has_key_p(IRubyObject iRubyObject) {
        return this.internalGetEntry(iRubyObject) == NO_ENTRY ? this.getRuntime().getFalse() : this.getRuntime().getTrue();
    }

    private boolean hasValue(final ThreadContext threadContext, final IRubyObject iRubyObject) {
        try {
            this.visitAll(new Visitor(){

                public void visit(IRubyObject iRubyObject3, IRubyObject iRubyObject2) {
                    if (RubyObject.equalInternal(threadContext, iRubyObject2, iRubyObject).isTrue()) {
                        throw new Found();
                    }
                }
            });
            return false;
        }
        catch (Found found) {
            return true;
        }
    }

    @JRubyMethod(name={"has_value?", "value?"}, required=1)
    public RubyBoolean has_value_p(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.getRuntime().newBoolean(this.hasValue(threadContext, iRubyObject));
    }

    @JRubyMethod(name={"each"}, frame=true)
    public RubyHash each(final ThreadContext threadContext, final Block block) {
        final Ruby ruby = this.getRuntime();
        this.visitAll(new Visitor(){

            public void visit(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
                block.yield(threadContext, RubyArray.newArray(ruby, iRubyObject, iRubyObject2), null, null, false);
            }
        });
        return this;
    }

    @JRubyMethod(name={"each_pair"}, frame=true)
    public RubyHash each_pair(final ThreadContext threadContext, final Block block) {
        final Ruby ruby = this.getRuntime();
        this.visitAll(new Visitor(){

            public void visit(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
                block.yield(threadContext, RubyArray.newArray(ruby, iRubyObject, iRubyObject2), null, null, true);
            }
        });
        return this;
    }

    @JRubyMethod(name={"each_value"}, frame=true)
    public RubyHash each_value(final ThreadContext threadContext, final Block block) {
        this.visitAll(new Visitor(){

            public void visit(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
                block.yield(threadContext, iRubyObject2);
            }
        });
        return this;
    }

    @JRubyMethod(name={"each_key"}, frame=true)
    public RubyHash each_key(final ThreadContext threadContext, final Block block) {
        this.visitAll(new Visitor(){

            public void visit(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
                block.yield(threadContext, iRubyObject);
            }
        });
        return this;
    }

    @JRubyMethod(name={"sort"}, frame=true)
    public RubyArray sort(Block block) {
        return this.to_a().sort_bang(block);
    }

    @JRubyMethod(name={"index"}, required=1)
    public IRubyObject index(ThreadContext threadContext, IRubyObject iRubyObject) {
        IRubyObject iRubyObject2 = this.internalIndex(threadContext, iRubyObject);
        if (iRubyObject2 != null) {
            return iRubyObject2;
        }
        return this.getRuntime().getNil();
    }

    private IRubyObject internalIndex(final ThreadContext threadContext, final IRubyObject iRubyObject) {
        try {
            this.visitAll(new Visitor(){

                public void visit(IRubyObject iRubyObject3, IRubyObject iRubyObject2) {
                    if (RubyObject.equalInternal(threadContext, iRubyObject2, iRubyObject).isTrue()) {
                        throw new FoundKey(iRubyObject3);
                    }
                }
            });
            return null;
        }
        catch (FoundKey foundKey) {
            return foundKey.key;
        }
    }

    @JRubyMethod(name={"indexes", "indices"}, rest=true)
    public RubyArray indices(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        return this.values_at(threadContext, iRubyObjectArray);
    }

    @JRubyMethod(name={"keys"})
    public RubyArray keys() {
        Ruby ruby = this.getRuntime();
        final RubyArray rubyArray = RubyArray.newArray(ruby, this.size);
        this.visitAll(new Visitor(){

            public void visit(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
                rubyArray.append(iRubyObject);
            }
        });
        return rubyArray;
    }

    @JRubyMethod(name={"values"})
    @RDoc(callSeq="hsh.values    => array", doc="Returns a new array populated with the values from <i>hsh</i>. See\nalso <code>Hash#keys</code>.\n   \n   h = { \"a\" => 100, \"b\" => 200, \"c\" => 300 }\n   h.values   #=> [100, 200, 300]\n")
    public RubyArray rb_values() {
        final RubyArray rubyArray = RubyArray.newArray(this.getRuntime(), this.size);
        this.visitAll(new Visitor(){

            public void visit(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
                rubyArray.append(iRubyObject2);
            }
        });
        return rubyArray;
    }

    @JRubyMethod(name={"=="}, required=1)
    public IRubyObject op_equal(final ThreadContext threadContext, IRubyObject iRubyObject) {
        if (this == iRubyObject) {
            return this.getRuntime().getTrue();
        }
        if (!(iRubyObject instanceof RubyHash)) {
            if (!iRubyObject.respondsTo("to_hash")) {
                return this.getRuntime().getFalse();
            }
            return RubyHash.equalInternal(threadContext, iRubyObject, this);
        }
        final RubyHash rubyHash = (RubyHash)iRubyObject;
        if (this.size != rubyHash.size) {
            return this.getRuntime().getFalse();
        }
        Ruby ruby = this.getRuntime();
        try {
            this.visitAll(new Visitor(){

                public void visit(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
                    IRubyObject iRubyObject3 = rubyHash.internalGet(iRubyObject);
                    if (iRubyObject3 == null || !RubyObject.equalInternal(threadContext, iRubyObject2, iRubyObject3).isTrue()) {
                        throw new Mismatch();
                    }
                }
            });
            return ruby.getTrue();
        }
        catch (Mismatch mismatch) {
            return ruby.getFalse();
        }
    }

    @JRubyMethod(name={"shift"})
    public IRubyObject shift(ThreadContext threadContext) {
        this.modify();
        RubyHashEntry rubyHashEntry = this.head.nextAdded;
        if (rubyHashEntry != this.head) {
            RubyArray rubyArray = RubyArray.newArray(this.getRuntime(), rubyHashEntry.key, rubyHashEntry.value);
            this.internalDeleteEntry(rubyHashEntry);
            return rubyArray;
        }
        if ((this.flags & 0x400) != 0) {
            return this.ifNone.callMethod(threadContext, "call", new IRubyObject[]{this, this.getRuntime().getNil()});
        }
        return this.ifNone;
    }

    public final boolean fastDelete(IRubyObject iRubyObject) {
        return this.internalDelete(iRubyObject) != NO_ENTRY;
    }

    @JRubyMethod(name={"delete"}, required=1, frame=true)
    public IRubyObject delete(ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        this.modify();
        RubyHashEntry rubyHashEntry = this.internalDelete(iRubyObject);
        if (rubyHashEntry != NO_ENTRY) {
            return rubyHashEntry.value;
        }
        if (block.isGiven()) {
            return block.yield(threadContext, iRubyObject);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"select"}, frame=true)
    public IRubyObject select(final ThreadContext threadContext, final Block block) {
        final RubyArray rubyArray = this.getRuntime().newArray();
        final Ruby ruby = this.getRuntime();
        this.visitAll(new Visitor(){

            public void visit(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
                if (block.yield(threadContext, ruby.newArray(iRubyObject, iRubyObject2), null, null, true).isTrue()) {
                    rubyArray.append(ruby.newArray(iRubyObject, iRubyObject2));
                }
            }
        });
        return rubyArray;
    }

    @JRubyMethod(name={"delete_if"}, frame=true)
    public RubyHash delete_if(final ThreadContext threadContext, final Block block) {
        this.modify();
        final Ruby ruby = this.getRuntime();
        final RubyHash rubyHash = this;
        this.visitAll(new Visitor(){

            public void visit(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
                if (block.yield(threadContext, RubyArray.newArray(ruby, iRubyObject, iRubyObject2), null, null, true).isTrue()) {
                    rubyHash.delete(threadContext, iRubyObject, block);
                }
            }
        });
        return this;
    }

    @JRubyMethod(name={"reject"}, frame=true)
    public RubyHash reject(ThreadContext threadContext, Block block) {
        return ((RubyHash)this.dup()).delete_if(threadContext, block);
    }

    @JRubyMethod(name={"reject!"}, frame=true)
    public IRubyObject reject_bang(ThreadContext threadContext, Block block) {
        int n = this.size;
        this.delete_if(threadContext, block);
        if (n == this.size) {
            return this.getRuntime().getNil();
        }
        return this;
    }

    @JRubyMethod(name={"clear"})
    public RubyHash rb_clear() {
        this.modify();
        if (this.size > 0) {
            this.alloc();
            this.size = 0;
        }
        return this;
    }

    @JRubyMethod(name={"invert"})
    public RubyHash invert(final ThreadContext threadContext) {
        final RubyHash rubyHash = RubyHash.newHash(this.getRuntime());
        this.visitAll(new Visitor(){

            public void visit(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
                rubyHash.op_aset(threadContext, iRubyObject2, iRubyObject);
            }
        });
        return rubyHash;
    }

    @JRubyMethod(name={"merge!", "update"}, required=1, frame=true)
    public RubyHash merge_bang(final ThreadContext threadContext, IRubyObject iRubyObject, final Block block) {
        this.modify();
        final Ruby ruby = this.getRuntime();
        RubyHash rubyHash = iRubyObject.convertToHash();
        final RubyHash rubyHash2 = this;
        rubyHash.visitAll(new Visitor(){

            public void visit(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
                IRubyObject iRubyObject3;
                if (block.isGiven() && (iRubyObject3 = rubyHash2.internalGet(iRubyObject)) != null) {
                    iRubyObject2 = block.yield(threadContext, RubyArray.newArrayNoCopy(ruby, new IRubyObject[]{iRubyObject, iRubyObject3, iRubyObject2}));
                }
                rubyHash2.op_aset(threadContext, iRubyObject, iRubyObject2);
            }
        });
        return this;
    }

    @JRubyMethod(name={"merge"}, required=1, frame=true)
    public RubyHash merge(ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        return ((RubyHash)this.dup()).merge_bang(threadContext, iRubyObject, block);
    }

    @JRubyMethod(name={"initialize_copy"}, required=1, visibility=Visibility.PRIVATE)
    public RubyHash initialize_copy(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.replace(threadContext, iRubyObject);
    }

    @JRubyMethod(name={"replace"}, required=1)
    public RubyHash replace(final ThreadContext threadContext, IRubyObject iRubyObject) {
        RubyHash rubyHash = iRubyObject.convertToHash();
        if (this == rubyHash) {
            return this;
        }
        this.rb_clear();
        final RubyHash rubyHash2 = this;
        rubyHash.visitAll(new Visitor(){

            public void visit(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
                rubyHash2.op_aset(threadContext, iRubyObject, iRubyObject2);
            }
        });
        this.ifNone = rubyHash.ifNone;
        this.flags = (rubyHash.flags & 0x400) != 0 ? (this.flags |= 0x400) : (this.flags &= 0xFFFFFBFF);
        return this;
    }

    @JRubyMethod(name={"values_at"}, rest=true)
    public RubyArray values_at(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        RubyArray rubyArray = RubyArray.newArray(this.getRuntime(), iRubyObjectArray.length);
        for (int i = 0; i < iRubyObjectArray.length; ++i) {
            rubyArray.append(this.op_aref(threadContext, iRubyObjectArray[i]));
        }
        return rubyArray;
    }

    public boolean hasDefaultProc() {
        return (this.flags & 0x400) != 0;
    }

    public IRubyObject getIfNone() {
        return this.ifNone;
    }

    public static void marshalTo(RubyHash rubyHash, final MarshalStream marshalStream) throws IOException {
        marshalStream.registerLinkTarget(rubyHash);
        marshalStream.writeInt(rubyHash.size);
        try {
            rubyHash.visitAll(new Visitor(){

                public void visit(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
                    try {
                        marshalStream.dumpObject(iRubyObject);
                        marshalStream.dumpObject(iRubyObject2);
                    }
                    catch (IOException iOException) {
                        throw new VisitorIOException(iOException);
                    }
                }
            });
        }
        catch (VisitorIOException visitorIOException) {
            throw (IOException)visitorIOException.getCause();
        }
        if (!rubyHash.ifNone.isNil()) {
            marshalStream.dumpObject(rubyHash.ifNone);
        }
    }

    public static RubyHash unmarshalFrom(UnmarshalStream unmarshalStream, boolean bl) throws IOException {
        RubyHash rubyHash = RubyHash.newHash(unmarshalStream.getRuntime());
        unmarshalStream.registerLinkTarget(rubyHash);
        int n = unmarshalStream.unmarshalInt();
        ThreadContext threadContext = unmarshalStream.getRuntime().getCurrentContext();
        for (int i = 0; i < n; ++i) {
            rubyHash.op_aset(threadContext, unmarshalStream.unmarshalObject(), unmarshalStream.unmarshalObject());
        }
        if (bl) {
            rubyHash.default_value_set(unmarshalStream.unmarshalObject());
        }
        return rubyHash;
    }

    public Class getJavaClass() {
        return Map.class;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean containsKey(Object object) {
        return this.internalGet(JavaUtil.convertJavaToRuby(this.getRuntime(), object)) != null;
    }

    public boolean containsValue(Object object) {
        return this.hasValue(this.getRuntime().getCurrentContext(), JavaUtil.convertJavaToRuby(this.getRuntime(), object));
    }

    public Object get(Object object) {
        return JavaUtil.convertRubyToJava(this.internalGet(JavaUtil.convertJavaToRuby(this.getRuntime(), object)));
    }

    public Object put(Object object, Object object2) {
        this.internalPut(JavaUtil.convertJavaToRuby(this.getRuntime(), object), JavaUtil.convertJavaToRuby(this.getRuntime(), object2));
        return object2;
    }

    public Object remove(Object object) {
        IRubyObject iRubyObject = JavaUtil.convertJavaToRuby(this.getRuntime(), object);
        return this.internalDelete(iRubyObject).value;
    }

    public void putAll(Map map) {
        Ruby ruby = this.getRuntime();
        for (Object k : map.keySet()) {
            this.internalPut(JavaUtil.convertJavaToRuby(ruby, k), JavaUtil.convertJavaToRuby(ruby, map.get(k)));
        }
    }

    public void clear() {
        this.rb_clear();
    }

    public boolean equals(Object object) {
        if (!(object instanceof RubyHash)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        return this.op_equal(this.getRuntime().getCurrentContext(), (RubyHash)object).isTrue();
    }

    public Set keySet() {
        return new BaseSet(KEY_VIEW);
    }

    public Set directKeySet() {
        return new BaseSet(DIRECT_KEY_VIEW);
    }

    public Collection values() {
        return new BaseCollection(this.VALUE_VIEW);
    }

    public Collection directValues() {
        return new BaseCollection(DIRECT_VALUE_VIEW);
    }

    public Set entrySet() {
        return new BaseSet(this.ENTRY_VIEW);
    }

    public Set directEntrySet() {
        return new BaseSet(this.DIRECT_ENTRY_VIEW);
    }

    private static class ConvertingEntry
    implements Map.Entry {
        private final RubyHashEntry entry;
        private final Ruby runtime;

        public ConvertingEntry(Ruby ruby, RubyHashEntry rubyHashEntry) {
            this.entry = rubyHashEntry;
            this.runtime = ruby;
        }

        public Object getKey() {
            return JavaUtil.convertRubyToJava(this.entry.key, Object.class);
        }

        public Object getValue() {
            return JavaUtil.convertRubyToJava(this.entry.value, Object.class);
        }

        public Object setValue(Object object) {
            return this.entry.setValue(JavaUtil.convertJavaToRuby(this.runtime, object));
        }

        public boolean equals(Object object) {
            if (!(object instanceof ConvertingEntry)) {
                return false;
            }
            ConvertingEntry convertingEntry = (ConvertingEntry)object;
            return this.entry.equals(convertingEntry.entry);
        }

        public int hashCode() {
            return this.entry.hashCode();
        }
    }

    private static abstract class EntryView {
        private EntryView() {
        }

        public abstract Object convertEntry(Ruby var1, RubyHashEntry var2);

        public abstract boolean contains(RubyHash var1, Object var2);

        public abstract boolean remove(RubyHash var1, Object var2);
    }

    private class BaseIterator
    implements Iterator {
        private final EntryView view;
        private RubyHashEntry entry;
        private boolean peeking;
        private int startGeneration;

        public BaseIterator(EntryView entryView) {
            this.view = entryView;
            this.entry = RubyHash.this.head;
            this.startGeneration = RubyHash.this.generation;
        }

        private void advance(boolean bl) {
            if (!this.peeking) {
                do {
                    if (this.startGeneration != RubyHash.this.generation) {
                        this.startGeneration = RubyHash.this.generation;
                        this.entry = RubyHash.this.head;
                    }
                    this.entry = this.entry.nextAdded;
                } while (this.entry != RubyHash.this.head && !this.entry.isLive());
            }
            this.peeking = !bl;
        }

        public Object next() {
            this.advance(true);
            if (this.entry == RubyHash.this.head) {
                this.peeking = true;
                throw new NoSuchElementException();
            }
            return this.view.convertEntry(RubyHash.this.getRuntime(), this.entry);
        }

        public boolean hasNext() {
            this.advance(false);
            return this.entry != RubyHash.this.head;
        }

        public void remove() {
            if (this.entry == RubyHash.this.head) {
                throw new IllegalStateException("Iterator out of range");
            }
            RubyHash.this.internalDeleteEntry(this.entry);
        }
    }

    private class BaseCollection
    extends AbstractCollection {
        final EntryView view;

        public BaseCollection(EntryView entryView) {
            this.view = entryView;
        }

        public Iterator iterator() {
            return new BaseIterator(this.view);
        }

        public boolean contains(Object object) {
            return this.view.contains(RubyHash.this, object);
        }

        public void clear() {
            RubyHash.this.clear();
        }

        public int size() {
            return RubyHash.this.size;
        }

        public boolean remove(Object object) {
            return this.view.remove(RubyHash.this, object);
        }
    }

    private class BaseSet
    extends AbstractSet {
        final EntryView view;

        public BaseSet(EntryView entryView) {
            this.view = entryView;
        }

        public Iterator iterator() {
            return new BaseIterator(this.view);
        }

        public boolean contains(Object object) {
            return this.view.contains(RubyHash.this, object);
        }

        public void clear() {
            RubyHash.this.clear();
        }

        public int size() {
            return RubyHash.this.size;
        }

        public boolean remove(Object object) {
            return this.view.remove(RubyHash.this, object);
        }
    }

    private static class VisitorIOException
    extends RuntimeException {
        VisitorIOException(Throwable throwable) {
            super(throwable);
        }
    }

    private static class Mismatch
    extends RuntimeException {
        private Mismatch() {
        }
    }

    private static class FoundKey
    extends RuntimeException {
        public IRubyObject key;

        FoundKey(IRubyObject iRubyObject) {
            this.key = iRubyObject;
        }
    }

    private class Found
    extends RuntimeException {
        private Found() {
        }
    }

    public static abstract class Visitor {
        public abstract void visit(IRubyObject var1, IRubyObject var2);
    }

    private static abstract class EntryMatchType {
        private EntryMatchType() {
        }

        public abstract boolean matches(RubyHashEntry var1, Object var2);
    }

    static final class RubyHashEntry
    implements Map.Entry {
        private IRubyObject key;
        private IRubyObject value;
        private RubyHashEntry next;
        private RubyHashEntry prevAdded;
        private RubyHashEntry nextAdded;
        private int hash;

        RubyHashEntry() {
            this.key = RubyObject.NEVER;
        }

        RubyHashEntry(int n, IRubyObject iRubyObject, IRubyObject iRubyObject2, RubyHashEntry rubyHashEntry, RubyHashEntry rubyHashEntry2) {
            this.key = iRubyObject;
            this.value = iRubyObject2;
            this.next = rubyHashEntry;
            this.hash = n;
            this.prevAdded = rubyHashEntry2.prevAdded;
            this.nextAdded = rubyHashEntry2;
            this.nextAdded.prevAdded = this;
            this.prevAdded.nextAdded = this;
        }

        public void detach() {
            if (this.prevAdded != null) {
                this.prevAdded.nextAdded = this.nextAdded;
                this.nextAdded.prevAdded = this.prevAdded;
                this.prevAdded = null;
            }
        }

        public boolean isLive() {
            return this.prevAdded != null;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getJavaifiedKey() {
            return JavaUtil.convertRubyToJava(this.key);
        }

        public Object getValue() {
            return this.value;
        }

        public Object getJavaifiedValue() {
            return JavaUtil.convertRubyToJava(this.value);
        }

        public Object setValue(Object object) {
            IRubyObject iRubyObject = this.value;
            if (!(object instanceof IRubyObject)) {
                throw new UnsupportedOperationException("directEntrySet() doesn't support setValue for non IRubyObject instance entries, convert them manually or use entrySet() instead");
            }
            this.value = (IRubyObject)object;
            return iRubyObject;
        }

        public boolean equals(Object object) {
            if (!(object instanceof RubyHashEntry)) {
                return false;
            }
            RubyHashEntry rubyHashEntry = (RubyHashEntry)object;
            return !(this.key != rubyHashEntry.key && !this.key.eql(rubyHashEntry.key) || this.value != rubyHashEntry.value && !this.value.equals(rubyHashEntry.value));
        }

        public int hashCode() {
            return this.key.hashCode() ^ this.value.hashCode();
        }
    }
}

