/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.ast.Node;
import org.jruby.ast.RootNode;
import org.jruby.compiler.ASTCompiler;
import org.jruby.compiler.ASTInspector;
import org.jruby.compiler.impl.StandardASMCompiler;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CompiledBlock;
import org.jruby.runtime.InterpretedBlock;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.util.TraceClassVisitor;

public class RubyJRuby {
    public static RubyModule createJRuby(Ruby ruby) {
        ThreadContext threadContext = ruby.getCurrentContext();
        ruby.getKernel().callMethod(threadContext, "require", ruby.newString("java"));
        RubyModule rubyModule = ruby.defineModule("JRuby");
        rubyModule.defineAnnotatedMethods(RubyJRuby.class);
        RubyClass rubyClass = rubyModule.defineClassUnder("CompiledScript", ruby.getObject(), ruby.getObject().getAllocator());
        rubyClass.attr_accessor(threadContext, new IRubyObject[]{ruby.newSymbol("name"), ruby.newSymbol("class_name"), ruby.newSymbol("original_script"), ruby.newSymbol("code")});
        rubyClass.defineAnnotatedMethods(JRubyCompiledScript.class);
        return rubyModule;
    }

    public static RubyModule createJRubyExt(Ruby ruby) {
        ruby.getKernel().callMethod(ruby.getCurrentContext(), "require", ruby.newString("java"));
        RubyModule rubyModule = ruby.getOrCreateModule("JRuby").defineModuleUnder("Extensions");
        rubyModule.defineAnnotatedMethods(JRubyExtensions.class);
        ruby.getObject().includeModule(rubyModule);
        return rubyModule;
    }

    @JRubyMethod(name={"runtime"}, frame=true, module=true)
    public static IRubyObject runtime(IRubyObject iRubyObject, Block block) {
        return Java.java_to_ruby(iRubyObject, JavaObject.wrap(iRubyObject.getRuntime(), iRubyObject.getRuntime()), Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"objectspace"}, frame=true, module=true)
    public static IRubyObject getObjectSpaceEnabled(IRubyObject iRubyObject, Block block) {
        Ruby ruby = iRubyObject.getRuntime();
        return RubyBoolean.newBoolean(ruby, ruby.isObjectSpaceEnabled());
    }

    @JRubyMethod(name={"objectspace="}, required=1, frame=true, module=true)
    public static IRubyObject setObjectSpaceEnabled(IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        Ruby ruby = iRubyObject.getRuntime();
        ruby.setObjectSpaceEnabled(iRubyObject2.isTrue());
        return ruby.getNil();
    }

    @JRubyMethod(name={"parse", "ast_for"}, optional=3, frame=true, module=true)
    public static IRubyObject parse(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        if (block.isGiven()) {
            if (block.getBody() instanceof CompiledBlock) {
                throw new RuntimeException("Cannot compile an already compiled block. Use -J-Djruby.jit.enabled=false to avoid this problem.");
            }
            Arity.checkArgumentCount(iRubyObject.getRuntime(), iRubyObjectArray, 0, 0);
            return Java.java_to_ruby(iRubyObject, JavaObject.wrap(iRubyObject.getRuntime(), ((InterpretedBlock)block.getBody()).getIterNode().getBodyNode()), Block.NULL_BLOCK);
        }
        Arity.checkArgumentCount(iRubyObject.getRuntime(), iRubyObjectArray, 1, 3);
        String string = "-";
        boolean bl = false;
        RubyString rubyString = iRubyObjectArray[0].convertToString();
        if (iRubyObjectArray.length > 1) {
            string = iRubyObjectArray[1].convertToString().toString();
            if (iRubyObjectArray.length > 2) {
                bl = iRubyObjectArray[2].isTrue();
            }
        }
        return Java.java_to_ruby(iRubyObject, JavaObject.wrap(iRubyObject.getRuntime(), iRubyObject.getRuntime().parse(rubyString.getByteList(), string, null, 0, bl)), Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"compile"}, optional=3, frame=true, module=true)
    public static IRubyObject compile(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        String string;
        Node node;
        Object object;
        RubyString rubyString = iRubyObject.getRuntime().newString("");
        if (block.isGiven()) {
            Arity.checkArgumentCount(iRubyObject.getRuntime(), iRubyObjectArray, 0, 0);
            if (block.getBody() instanceof CompiledBlock) {
                throw new RuntimeException("Cannot compile an already compiled block. Use -J-Djruby.jit.enabled=false to avoid this problem.");
            }
            object = ((InterpretedBlock)block.getBody()).getIterNode().getBodyNode();
            node = new RootNode(((Node)object).getPosition(), block.getBinding().getDynamicScope(), (Node)object);
            string = "__block_" + node.getPosition().getFile();
        } else {
            Arity.checkArgumentCount(iRubyObject.getRuntime(), iRubyObjectArray, 1, 3);
            string = "-";
            boolean bl = false;
            rubyString = iRubyObjectArray[0].convertToString();
            if (iRubyObjectArray.length > 1) {
                string = iRubyObjectArray[1].convertToString().toString();
                if (iRubyObjectArray.length > 2) {
                    bl = iRubyObjectArray[2].isTrue();
                }
            }
            node = iRubyObject.getRuntime().parse(rubyString.getByteList(), string, null, 0, bl);
        }
        object = string.equals("-e") ? "__dash_e__" : string.replace('\\', '/').replaceAll(".rb", "").replaceAll("-", "_dash_");
        ASTInspector aSTInspector = new ASTInspector();
        aSTInspector.inspect(node);
        StandardASMCompiler standardASMCompiler = new StandardASMCompiler((String)object, string);
        ASTCompiler aSTCompiler = new ASTCompiler();
        aSTCompiler.compileRoot(node, standardASMCompiler, aSTInspector);
        byte[] byArray = standardASMCompiler.getClassByteArray();
        IRubyObject iRubyObject2 = ((RubyModule)iRubyObject).fastGetConstant("CompiledScript").callMethod(iRubyObject.getRuntime().getCurrentContext(), "new");
        iRubyObject2.callMethod(iRubyObject.getRuntime().getCurrentContext(), "name=", iRubyObject.getRuntime().newString(string));
        iRubyObject2.callMethod(iRubyObject.getRuntime().getCurrentContext(), "class_name=", iRubyObject.getRuntime().newString((String)object));
        iRubyObject2.callMethod(iRubyObject.getRuntime().getCurrentContext(), "original_script=", rubyString);
        iRubyObject2.callMethod(iRubyObject.getRuntime().getCurrentContext(), "code=", Java.java_to_ruby(iRubyObject, JavaObject.wrap(iRubyObject.getRuntime(), byArray), Block.NULL_BLOCK));
        return iRubyObject2;
    }

    @JRubyMethod(name={"reference"}, required=1, module=true)
    public static IRubyObject reference(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return Java.wrap(iRubyObject.getRuntime().getJavaSupport().getJavaUtilitiesModule(), (IRubyObject)JavaObject.wrap(iRubyObject.getRuntime(), iRubyObject2));
    }

    public static class JRubyExtensions {
        @JRubyMethod(name={"steal_method"}, required=2, module=true)
        public static IRubyObject steal_method(IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
            RubyModule rubyModule = null;
            rubyModule = iRubyObject instanceof RubyModule ? (RubyModule)iRubyObject : iRubyObject.getSingletonClass();
            String string = iRubyObject3.toString();
            if (!(iRubyObject2 instanceof RubyModule)) {
                throw iRubyObject.getRuntime().newArgumentError("First argument must be a module/class");
            }
            DynamicMethod dynamicMethod = ((RubyModule)iRubyObject2).searchMethod(string);
            if (dynamicMethod == null || dynamicMethod.isUndefined()) {
                throw iRubyObject.getRuntime().newArgumentError("No such method " + string + " on " + iRubyObject2);
            }
            rubyModule.addMethod(string, dynamicMethod);
            return iRubyObject.getRuntime().getNil();
        }

        @JRubyMethod(name={"steal_methods"}, required=1, rest=true, module=true)
        public static IRubyObject steal_methods(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
            IRubyObject iRubyObject2 = iRubyObjectArray[0];
            for (int i = 1; i < iRubyObjectArray.length; ++i) {
                JRubyExtensions.steal_method(iRubyObject, iRubyObject2, iRubyObjectArray[i]);
            }
            return iRubyObject.getRuntime().getNil();
        }
    }

    public static class JRubyCompiledScript {
        @JRubyMethod(name={"to_s"})
        public static IRubyObject compiled_script_to_s(IRubyObject iRubyObject) {
            return iRubyObject.getInstanceVariables().fastGetInstanceVariable("@original_script");
        }

        @JRubyMethod(name={"inspect"})
        public static IRubyObject compiled_script_inspect(IRubyObject iRubyObject) {
            return iRubyObject.getRuntime().newString("#<JRuby::CompiledScript " + iRubyObject.getInstanceVariables().fastGetInstanceVariable("@name") + ">");
        }

        @JRubyMethod(name={"inspect_bytecode"})
        public static IRubyObject compiled_script_inspect_bytecode(IRubyObject iRubyObject) {
            StringWriter stringWriter = new StringWriter();
            ClassReader classReader = new ClassReader((byte[])JavaUtil.convertRubyToJava(iRubyObject.getInstanceVariables().fastGetInstanceVariable("@code"), byte[].class));
            TraceClassVisitor traceClassVisitor = new TraceClassVisitor(new PrintWriter(stringWriter));
            classReader.accept((ClassVisitor)traceClassVisitor, 2);
            return iRubyObject.getRuntime().newString(stringWriter.toString());
        }
    }

    public static class ExtLibrary
    implements Library {
        public void load(Ruby ruby, boolean bl) throws IOException {
            RubyJRuby.createJRubyExt(ruby);
        }
    }
}

