/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jruby.Ruby;
import org.jruby.RubyFixnum;
import org.jruby.RubyIO;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.ByteList;
import org.jruby.util.IOInputStream;
import org.jruby.util.IOOutputStream;

public class RubyMarshal {
    public static RubyModule createMarshalModule(Ruby ruby) {
        RubyModule rubyModule = ruby.defineModule("Marshal");
        ruby.setMarshal(rubyModule);
        rubyModule.defineAnnotatedMethods(RubyMarshal.class);
        rubyModule.defineConstant("MAJOR_VERSION", ruby.newFixnum(4L));
        rubyModule.defineConstant("MINOR_VERSION", ruby.newFixnum(8L));
        return rubyModule;
    }

    @JRubyMethod(name={"dump"}, required=1, optional=2, frame=true, module=true)
    public static IRubyObject dump(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        if (iRubyObjectArray.length < 1) {
            throw iRubyObject.getRuntime().newArgumentError("wrong # of arguments(at least 1)");
        }
        IRubyObject iRubyObject2 = iRubyObjectArray[0];
        IRubyObject iRubyObject3 = null;
        int n = -1;
        if (iRubyObjectArray.length >= 2) {
            if (iRubyObjectArray[1].respondsTo("write")) {
                iRubyObject3 = iRubyObjectArray[1];
            } else if (iRubyObjectArray[1] instanceof RubyFixnum) {
                n = (int)((RubyFixnum)iRubyObjectArray[1]).getLongValue();
            } else {
                throw iRubyObject.getRuntime().newTypeError("Instance of IO needed");
            }
            if (iRubyObjectArray.length == 3) {
                n = (int)((RubyFixnum)iRubyObjectArray[2]).getLongValue();
            }
        }
        try {
            if (iRubyObject3 != null) {
                RubyMarshal.dumpToStream(iRubyObject2, RubyMarshal.outputStream(iRubyObject3), n);
                return iRubyObject3;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            RubyMarshal.dumpToStream(iRubyObject2, byteArrayOutputStream, n);
            return RubyString.newString(iRubyObject.getRuntime(), new ByteList(byteArrayOutputStream.toByteArray(), false));
        }
        catch (IOException iOException) {
            throw iRubyObject.getRuntime().newIOErrorFromException(iOException);
        }
    }

    private static OutputStream outputStream(IRubyObject iRubyObject) {
        RubyMarshal.setBinmodeIfPossible(iRubyObject);
        if (iRubyObject instanceof RubyIO) {
            return ((RubyIO)iRubyObject).getOutStream();
        }
        return new IOOutputStream(iRubyObject);
    }

    private static void setBinmodeIfPossible(IRubyObject iRubyObject) {
        if (iRubyObject.respondsTo("binmode")) {
            iRubyObject.callMethod(iRubyObject.getRuntime().getCurrentContext(), "binmode");
        }
    }

    @JRubyMethod(name={"load", "restore"}, required=1, optional=1, frame=true, module=true)
    public static IRubyObject load(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        try {
            Object object;
            InputStream inputStream;
            if (iRubyObjectArray.length < 1) {
                throw iRubyObject.getRuntime().newArgumentError("wrong number of arguments (0 for 1)");
            }
            if (iRubyObjectArray.length > 2) {
                throw iRubyObject.getRuntime().newArgumentError("wrong number of arguments (" + iRubyObjectArray.length + " for 2)");
            }
            IRubyObject iRubyObject2 = null;
            IRubyObject iRubyObject3 = null;
            switch (iRubyObjectArray.length) {
                case 2: {
                    iRubyObject3 = iRubyObjectArray[1];
                }
                case 1: {
                    iRubyObject2 = iRubyObjectArray[0];
                }
            }
            if (iRubyObject2 != null && iRubyObject2.respondsTo("read")) {
                inputStream = RubyMarshal.inputStream(iRubyObject2);
            } else if (iRubyObject2 != null && iRubyObject2.respondsTo("to_str")) {
                object = (RubyString)RuntimeHelpers.invoke(threadContext, iRubyObject2, MethodIndex.TO_STR, "to_str", IRubyObject.NULL_ARRAY);
                ByteList byteList = ((RubyString)object).getByteList();
                inputStream = new ByteArrayInputStream(byteList.unsafeBytes(), byteList.begin(), byteList.length());
            } else {
                throw iRubyObject.getRuntime().newTypeError("instance of IO needed");
            }
            object = new UnmarshalStream(iRubyObject.getRuntime(), inputStream, iRubyObject3);
            return ((UnmarshalStream)object).unmarshalObject();
        }
        catch (EOFException eOFException) {
            throw iRubyObject.getRuntime().newEOFError();
        }
        catch (IOException iOException) {
            throw iRubyObject.getRuntime().newIOErrorFromException(iOException);
        }
    }

    private static InputStream inputStream(IRubyObject iRubyObject) {
        RubyMarshal.setBinmodeIfPossible(iRubyObject);
        if (iRubyObject instanceof RubyIO) {
            return ((RubyIO)iRubyObject).getInStream();
        }
        return new IOInputStream(iRubyObject);
    }

    private static void dumpToStream(IRubyObject iRubyObject, OutputStream outputStream, int n) throws IOException {
        MarshalStream marshalStream = new MarshalStream(iRubyObject.getRuntime(), outputStream, n);
        marshalStream.dumpObject(iRubyObject);
    }
}

