/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubyUnboundMethod;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.JumpException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.MethodBlock;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyMethod
extends RubyObject {
    protected RubyModule implementationModule;
    protected String methodName;
    protected RubyModule originModule;
    protected String originName;
    protected DynamicMethod method;
    protected IRubyObject receiver;

    protected RubyMethod(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    public static RubyClass createMethodClass(Ruby ruby) {
        RubyClass rubyClass = ruby.defineClass("Method", ruby.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        ruby.setMethod(rubyClass);
        rubyClass.defineAnnotatedMethods(RubyMethod.class);
        return rubyClass;
    }

    public static RubyMethod newMethod(RubyModule rubyModule, String string, RubyModule rubyModule2, String string2, DynamicMethod dynamicMethod, IRubyObject iRubyObject) {
        Ruby ruby = rubyModule.getRuntime();
        RubyMethod rubyMethod = new RubyMethod(ruby, ruby.getMethod());
        rubyMethod.implementationModule = rubyModule;
        rubyMethod.methodName = string;
        rubyMethod.originModule = rubyModule2;
        rubyMethod.originName = string2;
        rubyMethod.method = dynamicMethod.getRealMethod();
        rubyMethod.receiver = iRubyObject;
        return rubyMethod;
    }

    @JRubyMethod(name={"call", "[]"}, rest=true, frame=true)
    public IRubyObject call(IRubyObject[] iRubyObjectArray, Block block) {
        assert (iRubyObjectArray != null);
        ThreadContext threadContext = this.getRuntime().getCurrentContext();
        this.method.getArity().checkArity(this.getRuntime(), iRubyObjectArray);
        return this.method.call(threadContext, this.receiver, this.implementationModule, this.methodName, iRubyObjectArray, block);
    }

    @JRubyMethod(name={"arity"})
    public RubyFixnum arity() {
        return this.getRuntime().newFixnum(this.method.getArity().getValue());
    }

    @JRubyMethod(name={"=="}, required=1)
    public RubyBoolean op_equal(IRubyObject iRubyObject) {
        if (!(iRubyObject instanceof RubyMethod)) {
            return this.getRuntime().getFalse();
        }
        RubyMethod rubyMethod = (RubyMethod)iRubyObject;
        return this.getRuntime().newBoolean(this.implementationModule == rubyMethod.implementationModule && this.originModule == rubyMethod.originModule && this.receiver == rubyMethod.receiver && this.method.getRealMethod() == rubyMethod.method.getRealMethod());
    }

    @JRubyMethod(name={"clone"})
    public RubyMethod rbClone() {
        return RubyMethod.newMethod(this.implementationModule, this.methodName, this.originModule, this.originName, this.method, this.receiver);
    }

    @JRubyMethod(name={"to_proc"}, frame=true)
    public IRubyObject to_proc(Block block) {
        CallbackFactory callbackFactory = this.getRuntime().callbackFactory(RubyMethod.class);
        Ruby ruby = this.getRuntime();
        ThreadContext threadContext = ruby.getCurrentContext();
        Block block2 = MethodBlock.createMethodBlock(threadContext, threadContext.getCurrentScope(), callbackFactory.getBlockMethod("bmcall"), this, ruby.getTopSelf());
        while (true) {
            try {
                return callbackFactory.getSingletonMethod("mproc").execute(this.getRuntime().getNil(), IRubyObject.NULL_ARRAY, block2);
            }
            catch (JumpException.BreakJump breakJump) {
                return (IRubyObject)breakJump.getValue();
            }
            catch (JumpException.ReturnJump returnJump) {
                return (IRubyObject)returnJump.getValue();
            }
            catch (JumpException.RetryJump retryJump) {
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject mproc(IRubyObject iRubyObject, Block block) {
        Ruby ruby = iRubyObject.getRuntime();
        ThreadContext threadContext = ruby.getCurrentContext();
        threadContext.preMproc();
        try {
            RubyProc rubyProc = RubyKernel.proc(iRubyObject, block);
            Object var6_5 = null;
            threadContext.postMproc();
            return rubyProc;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            threadContext.postMproc();
            throw throwable;
        }
    }

    public static IRubyObject bmcall(IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3, Block block) {
        if (iRubyObject instanceof RubyArray) {
            return ((RubyMethod)iRubyObject2).call(((RubyArray)iRubyObject).toJavaArray(), Block.NULL_BLOCK);
        }
        return ((RubyMethod)iRubyObject2).call(new IRubyObject[]{iRubyObject}, Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"unbind"}, frame=true)
    public RubyUnboundMethod unbind(Block block) {
        RubyUnboundMethod rubyUnboundMethod = RubyUnboundMethod.newUnboundMethod(this.implementationModule, this.methodName, this.originModule, this.originName, this.method);
        rubyUnboundMethod.infectBy(this);
        return rubyUnboundMethod;
    }

    @JRubyMethod(name={"inspect", "to_s"})
    public IRubyObject inspect() {
        IRubyObject iRubyObject;
        StringBuilder stringBuilder = new StringBuilder("#<");
        int n = 35;
        stringBuilder.append(this.getMetaClass().getRealClass().getName()).append(": ");
        if (this.implementationModule.isSingleton()) {
            iRubyObject = ((MetaClass)this.originModule).getAttached();
            if (this.receiver == null) {
                stringBuilder.append(this.implementationModule.inspect().toString());
            } else if (this.receiver == iRubyObject) {
                stringBuilder.append(iRubyObject.inspect().toString());
                n = 46;
            } else {
                stringBuilder.append(this.receiver.inspect().toString());
                stringBuilder.append('(').append(iRubyObject.inspect().toString()).append(')');
                n = 46;
            }
        } else {
            stringBuilder.append(this.originModule.getName());
            if (this.implementationModule != this.originModule) {
                stringBuilder.append('(').append(this.implementationModule.getName()).append(')');
            }
        }
        stringBuilder.append((char)n).append(this.methodName).append('>');
        iRubyObject = this.getRuntime().newString(stringBuilder.toString());
        ((RubyObject)iRubyObject).setTaint(this.isTaint());
        return iRubyObject;
    }
}

