/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyNameError
extends RubyException {
    private IRubyObject name;
    private static ObjectAllocator NAMEERROR_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new RubyNameError(ruby, rubyClass);
        }
    };

    public static RubyClass createNameErrorClass(Ruby ruby, RubyClass rubyClass) {
        RubyClass rubyClass2 = ruby.defineClass("NameError", rubyClass, NAMEERROR_ALLOCATOR);
        rubyClass2.defineAnnotatedMethods(RubyNameError.class);
        return rubyClass2;
    }

    protected RubyNameError(Ruby ruby, RubyClass rubyClass) {
        this(ruby, rubyClass, rubyClass.getName());
    }

    public RubyNameError(Ruby ruby, RubyClass rubyClass, String string) {
        this(ruby, rubyClass, string, null);
    }

    public RubyNameError(Ruby ruby, RubyClass rubyClass, String string, String string2) {
        super(ruby, rubyClass, string);
        this.name = string2 == null ? ruby.getNil() : ruby.newString(string2);
    }

    @JRubyMethod(name={"exception"}, rest=true, meta=true)
    public static RubyException newRubyNameError(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        RubyClass rubyClass = (RubyClass)iRubyObject;
        RubyException rubyException = (RubyException)rubyClass.allocate();
        rubyException.callInit(iRubyObjectArray, Block.NULL_BLOCK);
        return rubyException;
    }

    @JRubyMethod(name={"initialize"}, optional=2, frame=true)
    public IRubyObject initialize(IRubyObject[] iRubyObjectArray, Block block) {
        if (iRubyObjectArray.length > 1) {
            this.name = iRubyObjectArray[iRubyObjectArray.length - 1];
            int n = iRubyObjectArray.length > 2 ? iRubyObjectArray.length - 2 : iRubyObjectArray.length - 1;
            IRubyObject[] iRubyObjectArray2 = new IRubyObject[n];
            System.arraycopy(iRubyObjectArray, 0, iRubyObjectArray2, 0, n);
            iRubyObjectArray = iRubyObjectArray2;
        } else {
            this.name = this.getRuntime().getNil();
        }
        super.initialize(iRubyObjectArray, block);
        return this;
    }

    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s() {
        if (this.message.isNil()) {
            return this.getRuntime().newString(this.message.getMetaClass().getName());
        }
        RubyString rubyString = this.message.convertToString();
        if (rubyString != this.message) {
            this.message = rubyString;
        }
        if (this.isTaint()) {
            this.message.setTaint(true);
        }
        return this.message;
    }

    @JRubyMethod(name={"name"})
    public IRubyObject name() {
        return this.name;
    }
}

