/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.math.BigInteger;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComparable;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.Convert;

public class RubyNumeric
extends RubyObject {
    protected static final ObjectAllocator NUMERIC_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new RubyNumeric(ruby, rubyClass);
        }
    };
    public static double DBL_EPSILON = 2.220446049250313E-16;

    public static RubyClass createNumericClass(Ruby ruby) {
        RubyClass rubyClass = ruby.defineClass("Numeric", ruby.getObject(), NUMERIC_ALLOCATOR);
        ruby.setNumeric(rubyClass);
        CallbackFactory callbackFactory = ruby.callbackFactory(RubyNumeric.class);
        rubyClass.kindOf = new RubyModule.KindOf(){

            public boolean isKindOf(IRubyObject iRubyObject, RubyModule rubyModule) {
                return iRubyObject instanceof RubyNumeric;
            }
        };
        rubyClass.includeModule(ruby.getComparable());
        rubyClass.defineAnnotatedMethods(RubyNumeric.class);
        rubyClass.dispatcher = callbackFactory.createDispatcher(rubyClass);
        return rubyClass;
    }

    public RubyNumeric(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    public RubyNumeric(Ruby ruby, RubyClass rubyClass, boolean bl) {
        super(ruby, rubyClass, bl);
    }

    public double getDoubleValue() {
        return 0.0;
    }

    public long getLongValue() {
        return 0L;
    }

    public static RubyNumeric newNumeric(Ruby ruby) {
        return new RubyNumeric(ruby, ruby.getNumeric());
    }

    public static int num2int(IRubyObject iRubyObject) {
        long l = RubyNumeric.num2long(iRubyObject);
        RubyNumeric.checkInt(iRubyObject, l);
        return (int)l;
    }

    public static void checkInt(IRubyObject iRubyObject, long l) {
        String string;
        if (l < Integer.MIN_VALUE) {
            string = "small";
        } else if (l > Integer.MAX_VALUE) {
            string = "big";
        } else {
            return;
        }
        throw iRubyObject.getRuntime().newRangeError("integer " + l + " too " + string + " to convert to `int'");
    }

    public static byte num2chr(IRubyObject iRubyObject) {
        String string;
        if (iRubyObject instanceof RubyString && (string = ((RubyString)iRubyObject).toString()) != null && string.length() > 0) {
            return (byte)string.charAt(0);
        }
        return (byte)RubyNumeric.num2int(iRubyObject);
    }

    public static long num2long(IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyFixnum) {
            return ((RubyFixnum)iRubyObject).getLongValue();
        }
        if (iRubyObject.isNil()) {
            throw iRubyObject.getRuntime().newTypeError("no implicit conversion from nil to integer");
        }
        if (iRubyObject instanceof RubyFloat) {
            double d = ((RubyFloat)iRubyObject).getDoubleValue();
            if (d <= 9.223372036854776E18 && d >= -9.223372036854776E18) {
                return (long)d;
            }
            throw iRubyObject.getRuntime().newRangeError("float " + d + " out of range of integer");
        }
        if (iRubyObject instanceof RubyBignum) {
            return RubyBignum.big2long((RubyBignum)iRubyObject);
        }
        return iRubyObject.convertToInteger().getLongValue();
    }

    public static IRubyObject dbl2num(Ruby ruby, double d) {
        if (Double.isInfinite(d)) {
            throw ruby.newFloatDomainError(d < 0.0 ? "-Infinity" : "Infinity");
        }
        if (Double.isNaN(d)) {
            throw ruby.newFloatDomainError("NaN");
        }
        if (d >= 9.223372036854776E18 || d < -9.223372036854776E18) {
            return RubyBignum.newBignum(ruby, d);
        }
        return RubyFixnum.newFixnum(ruby, (long)d);
    }

    public static double num2dbl(IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyFloat) {
            return ((RubyFloat)iRubyObject).getDoubleValue();
        }
        if (iRubyObject instanceof RubyString) {
            throw iRubyObject.getRuntime().newTypeError("no implicit conversion to float from string");
        }
        if (iRubyObject == iRubyObject.getRuntime().getNil()) {
            throw iRubyObject.getRuntime().newTypeError("no implicit conversion to float from nil");
        }
        return iRubyObject.convertToFloat().getDoubleValue();
    }

    public static IRubyObject dbl_cmp(Ruby ruby, double d, double d2) {
        if (Double.isNaN(d) || Double.isNaN(d2)) {
            return ruby.getNil();
        }
        if (d > d2) {
            return RubyFixnum.one(ruby);
        }
        if (d < d2) {
            return RubyFixnum.minus_one(ruby);
        }
        return RubyFixnum.zero(ruby);
    }

    public static long fix2long(IRubyObject iRubyObject) {
        return ((RubyFixnum)iRubyObject).getLongValue();
    }

    public static int fix2int(IRubyObject iRubyObject) {
        long l = iRubyObject instanceof RubyFixnum ? RubyNumeric.fix2long(iRubyObject) : RubyNumeric.num2long(iRubyObject);
        RubyNumeric.checkInt(iRubyObject, l);
        return (int)l;
    }

    public static RubyInteger str2inum(Ruby ruby, RubyString rubyString, int n) {
        return RubyNumeric.str2inum(ruby, rubyString, n, false);
    }

    public static RubyNumeric int2fix(Ruby ruby, long l) {
        return RubyFixnum.newFixnum(ruby, l);
    }

    public static IRubyObject num2fix(IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyFixnum) {
            return iRubyObject;
        }
        if (iRubyObject instanceof RubyBignum) {
            throw iRubyObject.getRuntime().newRangeError("integer " + iRubyObject + " out of range of fixnum");
        }
        return RubyFixnum.newFixnum(iRubyObject.getRuntime(), RubyNumeric.num2long(iRubyObject));
    }

    public static RubyInteger str2inum(Ruby ruby, RubyString rubyString, int n, boolean bl) {
        if (n != 0 && (n < 2 || n > 36)) {
            throw ruby.newArgumentError("illegal radix " + n);
        }
        ByteList byteList = rubyString.getByteList();
        try {
            return ruby.newFixnum(Convert.byteListToLong(byteList, n, bl));
        }
        catch (InvalidIntegerException invalidIntegerException) {
            if (bl) {
                throw ruby.newArgumentError("invalid value for Integer: " + rubyString.callMethod(ruby.getCurrentContext(), "inspect").toString());
            }
            return RubyFixnum.zero(ruby);
        }
        catch (NumberTooLargeException numberTooLargeException) {
            try {
                BigInteger bigInteger = Convert.byteListToBigInteger(byteList, n, bl);
                return new RubyBignum(ruby, bigInteger);
            }
            catch (InvalidIntegerException invalidIntegerException) {
                if (bl) {
                    throw ruby.newArgumentError("invalid value for Integer: " + rubyString.callMethod(ruby.getCurrentContext(), "inspect").toString());
                }
                return RubyFixnum.zero(ruby);
            }
        }
    }

    public static RubyFloat str2fnum(Ruby ruby, RubyString rubyString) {
        return RubyNumeric.str2fnum(ruby, rubyString, false);
    }

    public static RubyFloat str2fnum(Ruby ruby, RubyString rubyString, boolean bl) {
        try {
            return new RubyFloat(ruby, Convert.byteListToDouble(rubyString.getByteList(), bl));
        }
        catch (NumberFormatException numberFormatException) {
            if (bl) {
                throw ruby.newArgumentError("invalid value for Float(): " + rubyString.callMethod(ruby.getCurrentContext(), "inspect").toString());
            }
            return new RubyFloat(ruby, 0.0);
        }
    }

    protected IRubyObject[] getCoerced(ThreadContext threadContext, IRubyObject iRubyObject, boolean bl) {
        IRubyObject iRubyObject2;
        try {
            iRubyObject2 = iRubyObject.callMethod(threadContext, "coerce", this);
        }
        catch (RaiseException raiseException) {
            if (bl) {
                throw this.getRuntime().newTypeError(iRubyObject.getMetaClass().getName() + " can't be coerced into " + this.getMetaClass().getName());
            }
            return null;
        }
        if (!(iRubyObject2 instanceof RubyArray) || ((RubyArray)iRubyObject2).getLength() != 2) {
            throw this.getRuntime().newTypeError("coerce must return [x, y]");
        }
        return ((RubyArray)iRubyObject2).toJavaArray();
    }

    protected IRubyObject callCoerced(ThreadContext threadContext, String string, IRubyObject iRubyObject, boolean bl) {
        IRubyObject[] iRubyObjectArray = this.getCoerced(threadContext, iRubyObject, bl);
        if (iRubyObjectArray == null) {
            return this.getRuntime().getNil();
        }
        return iRubyObjectArray[0].callMethod(threadContext, string, iRubyObjectArray[1]);
    }

    protected IRubyObject callCoerced(ThreadContext threadContext, String string, IRubyObject iRubyObject) {
        IRubyObject[] iRubyObjectArray = this.getCoerced(threadContext, iRubyObject, false);
        if (iRubyObjectArray == null) {
            return this.getRuntime().getNil();
        }
        return iRubyObjectArray[0].callMethod(threadContext, string, iRubyObjectArray[1]);
    }

    protected final IRubyObject coerceBody(ThreadContext threadContext, IRubyObject iRubyObject) {
        return iRubyObject.callMethod(threadContext, "coerce", this);
    }

    protected final RubyArray doCoerce(ThreadContext threadContext, IRubyObject iRubyObject, boolean bl) {
        IRubyObject iRubyObject2;
        try {
            iRubyObject2 = this.coerceBody(threadContext, iRubyObject);
        }
        catch (RaiseException raiseException) {
            if (bl) {
                throw this.getRuntime().newTypeError(iRubyObject.getMetaClass().getName() + " can't be coerced into " + this.getMetaClass().getName());
            }
            return null;
        }
        if (!(iRubyObject2 instanceof RubyArray) || ((RubyArray)iRubyObject2).getLength() != 2) {
            throw this.getRuntime().newTypeError("coerce must return [x, y]");
        }
        return (RubyArray)iRubyObject2;
    }

    protected final IRubyObject coerceBin(ThreadContext threadContext, String string, IRubyObject iRubyObject) {
        RubyArray rubyArray = this.doCoerce(threadContext, iRubyObject, true);
        return rubyArray.eltInternal(0).callMethod(threadContext, string, rubyArray.eltInternal(1));
    }

    protected final IRubyObject coerceCmp(ThreadContext threadContext, String string, IRubyObject iRubyObject) {
        RubyArray rubyArray = this.doCoerce(threadContext, iRubyObject, false);
        if (rubyArray == null) {
            return this.getRuntime().getNil();
        }
        return rubyArray.eltInternal(0).callMethod(threadContext, string, rubyArray.eltInternal(1));
    }

    protected final IRubyObject coerceRelOp(ThreadContext threadContext, String string, IRubyObject iRubyObject) {
        IRubyObject iRubyObject2;
        RubyArray rubyArray = this.doCoerce(threadContext, iRubyObject, false);
        if (rubyArray != null && !(iRubyObject2 = rubyArray.eltInternal(0).callMethod(threadContext, string, rubyArray.eltInternal(1))).isNil()) {
            return iRubyObject2;
        }
        RubyComparable.cmperr(this, iRubyObject);
        return null;
    }

    public RubyNumeric asNumeric() {
        return this;
    }

    @JRubyMethod(name={"singleton_method_added"}, required=1)
    public IRubyObject sadded(IRubyObject iRubyObject) {
        throw this.getRuntime().newTypeError("can't define singleton method " + iRubyObject + " for " + this.getType().getName());
    }

    @JRubyMethod(name={"initialize_copy"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject iRubyObject) {
        throw this.getRuntime().newTypeError("can't copy " + this.getType().getName());
    }

    @JRubyMethod(name={"coerce"}, required=1)
    public IRubyObject coerce(IRubyObject iRubyObject) {
        if (this.getMetaClass() == iRubyObject.getMetaClass()) {
            return this.getRuntime().newArray(iRubyObject, this);
        }
        return this.getRuntime().newArray(RubyKernel.new_float(this, iRubyObject), RubyKernel.new_float(this, this));
    }

    @JRubyMethod(name={"+@"})
    public IRubyObject op_uplus() {
        return this;
    }

    @JRubyMethod(name={"-@"})
    public IRubyObject op_uminus(ThreadContext threadContext) {
        RubyFixnum rubyFixnum = RubyFixnum.zero(this.getRuntime());
        RubyArray rubyArray = rubyFixnum.doCoerce(threadContext, this, true);
        return rubyArray.eltInternal(0).callMethod(threadContext, MethodIndex.OP_MINUS, "-", rubyArray.eltInternal(1));
    }

    @JRubyMethod(name={"<=>"}, required=1)
    public IRubyObject op_cmp(IRubyObject iRubyObject) {
        if (this == iRubyObject) {
            return RubyFixnum.zero(this.getRuntime());
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"eql?"}, required=1)
    public IRubyObject eql_p(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (this.getMetaClass() != iRubyObject.getMetaClass()) {
            return this.getRuntime().getFalse();
        }
        return this.op_equal(threadContext, iRubyObject);
    }

    @JRubyMethod(name={"quo"}, required=1)
    public IRubyObject quo(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.callMethod(threadContext, "/", iRubyObject);
    }

    @JRubyMethod(name={"div"}, required=1)
    public IRubyObject div(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.callMethod(threadContext, "/", iRubyObject).convertToFloat().floor();
    }

    @JRubyMethod(name={"divmod"}, required=1)
    public IRubyObject divmod(ThreadContext threadContext, IRubyObject iRubyObject) {
        return RubyArray.newArray(this.getRuntime(), this.div(threadContext, iRubyObject), this.modulo(threadContext, iRubyObject));
    }

    @JRubyMethod(name={"modulo"}, required=1)
    public IRubyObject modulo(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.callMethod(threadContext, "%", iRubyObject);
    }

    @JRubyMethod(name={"remainder"}, required=1)
    public IRubyObject remainder(ThreadContext threadContext, IRubyObject iRubyObject) {
        IRubyObject iRubyObject2 = this.callMethod(threadContext, "%", iRubyObject);
        RubyNumeric rubyNumeric = this;
        RubyFixnum rubyFixnum = RubyFixnum.zero(this.getRuntime());
        if (iRubyObject2.op_equal(threadContext, rubyFixnum).isTrue()) {
            return iRubyObject2;
        }
        if (rubyNumeric.callMethod(threadContext, MethodIndex.OP_LT, "<", rubyFixnum).isTrue() && iRubyObject.callMethod(threadContext, MethodIndex.OP_GT, ">", rubyFixnum).isTrue() || rubyNumeric.callMethod(threadContext, MethodIndex.OP_GT, ">", rubyFixnum).isTrue() && iRubyObject.callMethod(threadContext, MethodIndex.OP_LT, "<", rubyFixnum).isTrue()) {
            return iRubyObject2.callMethod(threadContext, MethodIndex.OP_MINUS, "-", iRubyObject);
        }
        return iRubyObject2;
    }

    @JRubyMethod(name={"abs"})
    public IRubyObject abs(ThreadContext threadContext) {
        if (this.callMethod(threadContext, MethodIndex.OP_LT, "<", RubyFixnum.zero(this.getRuntime())).isTrue()) {
            return (RubyNumeric)this.callMethod(threadContext, "-@");
        }
        return this;
    }

    @JRubyMethod(name={"to_int"})
    public IRubyObject to_int(ThreadContext threadContext) {
        return RuntimeHelpers.invoke(threadContext, (IRubyObject)this, MethodIndex.TO_I, "to_i", IRubyObject.NULL_ARRAY);
    }

    @JRubyMethod(name={"integer?"})
    public IRubyObject integer_p() {
        return this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"zero?"})
    public IRubyObject zero_p(ThreadContext threadContext) {
        return this.op_equal(threadContext, RubyFixnum.zero(this.getRuntime())).isTrue() ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"nonzero?"})
    public IRubyObject nonzero_p(ThreadContext threadContext) {
        if (this.callMethod(threadContext, "zero?").isTrue()) {
            return this.getRuntime().getNil();
        }
        return this;
    }

    @JRubyMethod(name={"floor"})
    public IRubyObject floor() {
        return this.convertToFloat().floor();
    }

    @JRubyMethod(name={"ceil"})
    public IRubyObject ceil() {
        return this.convertToFloat().ceil();
    }

    @JRubyMethod(name={"round"})
    public IRubyObject round() {
        return this.convertToFloat().round();
    }

    @JRubyMethod(name={"truncate"})
    public IRubyObject truncate() {
        return this.convertToFloat().truncate();
    }

    @JRubyMethod(name={"step"}, required=1, optional=1, frame=true)
    public IRubyObject step(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block) {
        IRubyObject iRubyObject;
        IRubyObject iRubyObject2;
        if (iRubyObjectArray.length == 1) {
            iRubyObject2 = iRubyObjectArray[0];
            iRubyObject = RubyFixnum.one(this.getRuntime());
        } else if (iRubyObjectArray.length == 2) {
            iRubyObject2 = iRubyObjectArray[0];
            iRubyObject = iRubyObjectArray[1];
        } else {
            throw this.getRuntime().newTypeError("wrong number of arguments");
        }
        if (this instanceof RubyFixnum && iRubyObject2 instanceof RubyFixnum && iRubyObject instanceof RubyFixnum) {
            long l = this.getLongValue();
            long l2 = ((RubyFixnum)iRubyObject2).getLongValue();
            long l3 = ((RubyFixnum)iRubyObject).getLongValue();
            if (l3 == 0L) {
                throw this.getRuntime().newArgumentError("step cannot be 0");
            }
            if (l3 > 0L) {
                for (long i = l; i <= l2; i += l3) {
                    block.yield(threadContext, RubyFixnum.newFixnum(this.getRuntime(), i));
                }
            } else {
                for (long i = l; i >= l2; i += l3) {
                    block.yield(threadContext, RubyFixnum.newFixnum(this.getRuntime(), i));
                }
            }
        } else if (this instanceof RubyFloat || iRubyObject2 instanceof RubyFloat || iRubyObject instanceof RubyFloat) {
            double d = RubyNumeric.num2dbl(this);
            double d2 = RubyNumeric.num2dbl(iRubyObject2);
            double d3 = RubyNumeric.num2dbl(iRubyObject);
            if (d3 == 0.0) {
                throw this.getRuntime().newArgumentError("step cannot be 0");
            }
            double d4 = (d2 - d) / d3;
            double d5 = (Math.abs(d) + Math.abs(d2) + Math.abs(d2 - d)) / Math.abs(d3) * DBL_EPSILON;
            if (d5 > 0.5) {
                d5 = 0.5;
            }
            d4 = Math.floor(d4 + d5) + 1.0;
            for (double d6 = 0.0; d6 < d4; d6 += 1.0) {
                block.yield(threadContext, RubyFloat.newFloat(this.getRuntime(), d6 * d3 + d));
            }
        } else {
            RubyNumeric rubyNumeric = this;
            int n = ((RubyBoolean)iRubyObject.callMethod(threadContext, MethodIndex.OP_GT, ">", RubyFixnum.zero(this.getRuntime()))).isTrue() ? MethodIndex.OP_GT : MethodIndex.OP_LT;
            String string = MethodIndex.NAMES.get(n);
            while (!rubyNumeric.callMethod(threadContext, n, string, iRubyObject2).isTrue()) {
                block.yield(threadContext, rubyNumeric);
                rubyNumeric = (RubyNumeric)rubyNumeric.callMethod(threadContext, MethodIndex.OP_PLUS, "+", iRubyObject);
            }
        }
        return this;
    }

    protected final IRubyObject op_num_equal(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (this == iRubyObject) {
            return this.getRuntime().getTrue();
        }
        return iRubyObject.callMethod(threadContext, MethodIndex.EQUALEQUAL, "==", this);
    }

    public static class NumberTooLargeException
    extends NumberFormatException {
        private static final long serialVersionUID = -1835120694982699449L;

        public NumberTooLargeException() {
        }

        public NumberTooLargeException(String string) {
            super(string);
        }

        public Throwable fillInStackTrace() {
            return this;
        }
    }

    public static class InvalidIntegerException
    extends NumberFormatException {
        private static final long serialVersionUID = 55019452543252148L;

        public InvalidIntegerException() {
        }

        public InvalidIntegerException(String string) {
            super(string);
        }

        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

