/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.JumpException;
import org.jruby.internal.runtime.JumpTarget;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyProc
extends RubyObject
implements JumpTarget {
    private Block block = Block.NULL_BLOCK;
    private Block.Type type;
    private String file;
    private int line;
    private static ObjectAllocator PROC_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            RubyProc rubyProc = RubyProc.newProc(ruby, Block.Type.PROC);
            rubyProc.setMetaClass(rubyClass);
            return rubyProc;
        }
    };

    public RubyProc(Ruby ruby, RubyClass rubyClass, Block.Type type) {
        super(ruby, rubyClass);
        this.type = type;
    }

    public static RubyClass createProcClass(Ruby ruby) {
        RubyClass rubyClass = ruby.defineClass("Proc", ruby.getObject(), PROC_ALLOCATOR);
        ruby.setProc(rubyClass);
        rubyClass.defineAnnotatedMethods(RubyProc.class);
        return rubyClass;
    }

    public Block getBlock() {
        return this.block;
    }

    public static RubyProc newProc(Ruby ruby, Block.Type type) {
        return new RubyProc(ruby, ruby.getProc(), type);
    }

    public static RubyProc newProc(Ruby ruby, Block block, Block.Type type) {
        RubyProc rubyProc = new RubyProc(ruby, ruby.getProc(), type);
        rubyProc.callInit(NULL_ARRAY, block);
        return rubyProc;
    }

    @JRubyMethod(name={"new"}, rest=true, frame=true, meta=true)
    public static IRubyObject newInstance(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        Ruby ruby = iRubyObject.getRuntime();
        if (!block.isGiven()) {
            block = threadContext.getPreviousFrame().getBlock();
        }
        if (block.isGiven() && block.getProcObject() != null) {
            return block.getProcObject();
        }
        IRubyObject iRubyObject2 = ((RubyClass)iRubyObject).allocate();
        iRubyObject2.callMethod(threadContext, "initialize", iRubyObjectArray, block);
        return iRubyObject2;
    }

    @JRubyMethod(name={"initialize"}, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext threadContext, Block block) {
        if (!block.isGiven()) {
            throw this.getRuntime().newArgumentError("tried to create Proc object without a block");
        }
        if (this.type != Block.Type.LAMBDA || block == null) {
            // empty if block
        }
        this.block = block.cloneBlock();
        this.block.type = this.type;
        this.block.setProcObject(this);
        this.file = threadContext.getFile();
        this.line = threadContext.getLine();
        return this;
    }

    @JRubyMethod(name={"clone"})
    public IRubyObject rbClone() {
        RubyProc rubyProc = new RubyProc(this.getRuntime(), this.getRuntime().getProc(), this.type);
        rubyProc.block = this.getBlock();
        rubyProc.file = this.file;
        rubyProc.line = this.line;
        return rubyProc;
    }

    @JRubyMethod(name={"dup"})
    public IRubyObject dup() {
        RubyProc rubyProc = new RubyProc(this.getRuntime(), this.getRuntime().getProc(), this.type);
        rubyProc.block = this.getBlock();
        rubyProc.file = this.file;
        rubyProc.line = this.line;
        return rubyProc;
    }

    @JRubyMethod(name={"=="}, required=1)
    public IRubyObject op_equal(IRubyObject iRubyObject) {
        if (!(iRubyObject instanceof RubyProc)) {
            return this.getRuntime().getFalse();
        }
        if (this == iRubyObject || this.block == ((RubyProc)iRubyObject).block) {
            return this.getRuntime().newBoolean(true);
        }
        return this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s() {
        return RubyString.newString(this.getRuntime(), "#<Proc:0x" + Integer.toString(this.block.hashCode(), 16) + "@" + this.file + ":" + (this.line + 1) + ">");
    }

    @JRubyMethod(name={"binding"})
    public IRubyObject binding() {
        return this.getRuntime().newBinding(this.block.getBinding());
    }

    public IRubyObject call(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        return this.call(threadContext, iRubyObjectArray, null, Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"call", "[]"}, rest=true, frame=true)
    public IRubyObject call(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block) {
        return this.call(threadContext, iRubyObjectArray, null, Block.NULL_BLOCK);
    }

    public IRubyObject call(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, IRubyObject iRubyObject, Block block) {
        assert (iRubyObjectArray != null);
        Ruby ruby = this.getRuntime();
        try {
            Block block2 = this.block.cloneBlock();
            if (iRubyObject != null) {
                block2.getBinding().setSelf(iRubyObject);
            }
            if (block2.type == Block.Type.LAMBDA) {
                block2.getBinding().getFrame().setJumpTarget(this);
            }
            return block2.call(threadContext, iRubyObjectArray);
        }
        catch (JumpException.BreakJump breakJump) {
            if (this.block.type == Block.Type.LAMBDA) {
                return (IRubyObject)breakJump.getValue();
            }
            throw ruby.newLocalJumpError("break", (IRubyObject)breakJump.getValue(), "break from proc-closure");
        }
        catch (JumpException.ReturnJump returnJump) {
            JumpTarget jumpTarget = returnJump.getTarget();
            if (jumpTarget == this || this.block.type == Block.Type.LAMBDA) {
                return (IRubyObject)returnJump.getValue();
            }
            if (jumpTarget == null) {
                if (this.type == Block.Type.THREAD) {
                    throw ruby.newThreadError("return can't jump across threads");
                }
                throw ruby.newLocalJumpError("return", (IRubyObject)returnJump.getValue(), "unexpected return");
            }
            throw returnJump;
        }
        catch (JumpException.RetryJump retryJump) {
            throw ruby.newLocalJumpError("retry", (IRubyObject)retryJump.getValue(), "retry not supported outside rescue");
        }
    }

    @JRubyMethod(name={"arity"})
    public RubyFixnum arity() {
        return this.getRuntime().newFixnum(this.block.arity().getValue());
    }

    @JRubyMethod(name={"to_proc"})
    public RubyProc to_proc() {
        return this;
    }
}

