/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComparable;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ObjectMarshal;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.Variable;
import org.jruby.runtime.component.VariableEntry;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;

public class RubyRange
extends RubyObject {
    private IRubyObject begin;
    private IRubyObject end;
    private boolean isExclusive;
    private static ObjectAllocator RANGE_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new RubyRange(ruby, rubyClass);
        }
    };
    private static final ObjectMarshal RANGE_MARSHAL = new ObjectMarshal(){

        public void marshalTo(Ruby ruby, Object object, RubyClass rubyClass, MarshalStream marshalStream) throws IOException {
            RubyRange rubyRange = (RubyRange)object;
            marshalStream.registerLinkTarget(rubyRange);
            List<Variable<IRubyObject>> list = rubyRange.getVariableList();
            list.add(new VariableEntry<IRubyObject>("begin", rubyRange.begin));
            list.add(new VariableEntry<IRubyObject>("end", rubyRange.end));
            list.add(new VariableEntry<RubyBoolean>("excl", rubyRange.isExclusive ? ruby.getTrue() : ruby.getFalse()));
            marshalStream.dumpVariables(list);
        }

        public Object unmarshalFrom(Ruby ruby, RubyClass rubyClass, UnmarshalStream unmarshalStream) throws IOException {
            RubyRange rubyRange = (RubyRange)rubyClass.allocate();
            unmarshalStream.registerLinkTarget(rubyRange);
            unmarshalStream.defaultVariablesUnmarshal(rubyRange);
            rubyRange.begin = rubyRange.removeInternalVariable("begin");
            rubyRange.end = rubyRange.removeInternalVariable("end");
            rubyRange.isExclusive = rubyRange.removeInternalVariable("excl").isTrue();
            return rubyRange;
        }
    };
    private static byte[] DOTDOTDOT = "...".getBytes();
    private static byte[] DOTDOT = "..".getBytes();

    public RubyRange(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
        this.begin = this.end = ruby.getNil();
    }

    public void init(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, RubyBoolean rubyBoolean) {
        if (!(iRubyObject instanceof RubyFixnum) || !(iRubyObject2 instanceof RubyFixnum)) {
            try {
                IRubyObject iRubyObject3 = iRubyObject.callMethod(threadContext, MethodIndex.OP_SPACESHIP, "<=>", iRubyObject2);
                if (iRubyObject3.isNil()) {
                    throw this.getRuntime().newArgumentError("bad value for range");
                }
            }
            catch (RaiseException raiseException) {
                throw this.getRuntime().newArgumentError("bad value for range");
            }
        }
        this.begin = iRubyObject;
        this.end = iRubyObject2;
        this.isExclusive = rubyBoolean.isTrue();
    }

    protected void copySpecialInstanceVariables(IRubyObject iRubyObject) {
        RubyRange rubyRange = (RubyRange)iRubyObject;
        rubyRange.begin = this.begin;
        rubyRange.end = this.end;
        rubyRange.isExclusive = this.isExclusive;
    }

    public static RubyClass createRangeClass(Ruby ruby) {
        RubyClass rubyClass = ruby.defineClass("Range", ruby.getObject(), RANGE_ALLOCATOR);
        ruby.setRange(rubyClass);
        rubyClass.kindOf = new RubyModule.KindOf(){

            public boolean isKindOf(IRubyObject iRubyObject, RubyModule rubyModule) {
                return iRubyObject instanceof RubyRange;
            }
        };
        rubyClass.setMarshal(RANGE_MARSHAL);
        CallbackFactory callbackFactory = ruby.callbackFactory(RubyRange.class);
        rubyClass.includeModule(ruby.getEnumerable());
        rubyClass.defineAnnotatedMethods(RubyRange.class);
        rubyClass.dispatcher = callbackFactory.createDispatcher(rubyClass);
        return rubyClass;
    }

    public long[] getBeginLength(long l, boolean bl, boolean bl2) {
        long l2 = RubyNumeric.num2long(this.begin);
        long l3 = RubyNumeric.num2long(this.end);
        if (!this.isExclusive) {
            ++l3;
        }
        if (l2 < 0L && (l2 += l) < 0L) {
            if (bl2) {
                throw this.getRuntime().newRangeError(this.inspect().toString() + " out of range.");
            }
            return null;
        }
        if (bl && l2 > l) {
            if (bl2) {
                throw this.getRuntime().newRangeError(this.inspect().toString() + " out of range.");
            }
            return null;
        }
        if (bl && l3 > l) {
            l3 = l;
        }
        if (l3 < 0L || !this.isExclusive && l3 == 0L) {
            l3 += l;
        }
        return new long[]{l2, Math.max(l3 - l2, 0L)};
    }

    public long[] begLen(long l, int n) {
        long l2 = RubyNumeric.num2long(this.begin);
        long l3 = RubyNumeric.num2long(this.end);
        if (l2 < 0L && (l2 += l) < 0L) {
            if (n != 0) {
                throw this.getRuntime().newRangeError(l2 + ".." + (this.isExclusive ? "." : "") + l3 + " out of range");
            }
            return null;
        }
        if (n == 0 || n == 2) {
            if (l2 > l) {
                if (n != 0) {
                    throw this.getRuntime().newRangeError(l2 + ".." + (this.isExclusive ? "." : "") + l3 + " out of range");
                }
                return null;
            }
            if (l3 > l) {
                l3 = l;
            }
        }
        if (l3 < 0L) {
            l3 += l;
        }
        if (!this.isExclusive) {
            ++l3;
        }
        if ((l = l3 - l2) < 0L) {
            l = 0L;
        }
        return new long[]{l2, l};
    }

    public static RubyRange newRange(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, boolean bl) {
        RubyRange rubyRange = new RubyRange(ruby, ruby.getRange());
        rubyRange.init(threadContext, iRubyObject, iRubyObject2, bl ? ruby.getTrue() : ruby.getFalse());
        return rubyRange;
    }

    @JRubyMethod(name={"initialize"}, required=2, optional=1, frame=true)
    public IRubyObject initialize(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block) {
        if (iRubyObjectArray.length == 3) {
            this.init(threadContext, iRubyObjectArray[0], iRubyObjectArray[1], iRubyObjectArray[2].isTrue() ? this.getRuntime().getTrue() : this.getRuntime().getFalse());
        } else if (iRubyObjectArray.length == 2) {
            this.init(threadContext, iRubyObjectArray[0], iRubyObjectArray[1], this.getRuntime().getFalse());
        } else {
            throw this.getRuntime().newArgumentError("Wrong arguments. (anObject, anObject, aBoolean = false) expected");
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"first", "begin"})
    public IRubyObject first() {
        return this.begin;
    }

    @JRubyMethod(name={"last", "end"})
    public IRubyObject last() {
        return this.end;
    }

    @JRubyMethod(name={"hash"})
    public RubyFixnum hash(ThreadContext threadContext) {
        long l = this.isExclusive ? 1 : 0;
        long l2 = ((RubyFixnum)this.begin.callMethod(threadContext, MethodIndex.HASH, "hash")).getLongValue();
        long l3 = ((RubyFixnum)this.end.callMethod(threadContext, MethodIndex.HASH, "hash")).getLongValue();
        long l4 = l;
        l4 ^= l2 << 1;
        l4 ^= l3 << 9;
        return this.getRuntime().newFixnum(l4 ^= l << 24);
    }

    @JRubyMethod(name={"inspect"}, frame=true)
    public IRubyObject inspect(ThreadContext threadContext, Block block) {
        RubyString rubyString = RubyString.objAsString(threadContext, this.begin.callMethod(threadContext, "inspect")).strDup();
        RubyString rubyString2 = RubyString.objAsString(threadContext, this.end.callMethod(threadContext, "inspect"));
        rubyString.cat(this.isExclusive ? DOTDOTDOT : DOTDOT);
        rubyString.concat(rubyString2);
        rubyString.infectBy(rubyString2);
        return rubyString;
    }

    @JRubyMethod(name={"to_s"}, frame=true)
    public IRubyObject to_s(ThreadContext threadContext, Block block) {
        RubyString rubyString = RubyString.objAsString(threadContext, this.begin).strDup();
        RubyString rubyString2 = RubyString.objAsString(threadContext, this.end);
        rubyString.cat(this.isExclusive ? DOTDOTDOT : DOTDOT);
        rubyString.concat(rubyString2);
        rubyString.infectBy(rubyString2);
        return rubyString;
    }

    @JRubyMethod(name={"exclude_end?"})
    public RubyBoolean exclude_end_p() {
        return this.getRuntime().newBoolean(this.isExclusive);
    }

    @JRubyMethod(name={"length"}, frame=true)
    public RubyFixnum length(ThreadContext threadContext, Block block) {
        long l = 0L;
        if (this.begin.callMethod(threadContext, MethodIndex.OP_GT, ">", this.end).isTrue()) {
            return this.getRuntime().newFixnum(0L);
        }
        if (this.begin instanceof RubyFixnum && this.end instanceof RubyFixnum) {
            l = ((RubyNumeric)this.end).getLongValue() - ((RubyNumeric)this.begin).getLongValue();
            if (!this.isExclusive) {
                ++l;
            }
        } else {
            int n;
            IRubyObject iRubyObject = this.begin;
            int n2 = n = this.isExclusive ? MethodIndex.OP_LT : MethodIndex.OP_LE;
            while (iRubyObject.callMethod(threadContext, n, MethodIndex.NAMES.get(n), this.end).isTrue()) {
                ++l;
                if (iRubyObject.equals(this.end)) break;
                iRubyObject = iRubyObject.callMethod(threadContext, "succ");
            }
        }
        return this.getRuntime().newFixnum(l);
    }

    @JRubyMethod(name={"=="}, required=1, frame=true)
    public IRubyObject op_equal(ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        if (this == iRubyObject) {
            return this.getRuntime().getTrue();
        }
        if (!(iRubyObject instanceof RubyRange)) {
            return this.getRuntime().getFalse();
        }
        RubyRange rubyRange = (RubyRange)iRubyObject;
        boolean bl = this.begin.op_equal(threadContext, rubyRange.begin).isTrue() && this.end.op_equal(threadContext, rubyRange.end).isTrue() && this.isExclusive == rubyRange.isExclusive;
        return this.getRuntime().newBoolean(bl);
    }

    @JRubyMethod(name={"eql?"}, required=1)
    public IRubyObject eql_p(IRubyObject iRubyObject) {
        if (this == iRubyObject) {
            return this.getRuntime().getTrue();
        }
        if (!(iRubyObject instanceof RubyRange)) {
            return this.getRuntime().getFalse();
        }
        RubyRange rubyRange = (RubyRange)iRubyObject;
        if (!this.begin.equals(rubyRange.begin) || !this.end.equals(rubyRange.end) || this.isExclusive != rubyRange.isExclusive) {
            return this.getRuntime().getFalse();
        }
        return this.getRuntime().getTrue();
    }

    @JRubyMethod(name={"each"}, frame=true)
    public IRubyObject each(ThreadContext threadContext, Block block) {
        if (!this.begin.respondsTo("succ")) {
            throw this.getRuntime().newTypeError("can't iterate from " + this.begin.getMetaClass().getName());
        }
        if (this.begin instanceof RubyFixnum && this.end instanceof RubyFixnum) {
            long l = ((RubyNumeric)this.end).getLongValue();
            long l2 = ((RubyNumeric)this.begin).getLongValue();
            if (!this.isExclusive) {
                ++l;
            }
            while (l2 < l) {
                block.yield(threadContext, this.getRuntime().newFixnum(l2));
                ++l2;
            }
        } else if (this.begin instanceof RubyString) {
            ((RubyString)this.begin).upto(threadContext, this.end, this.isExclusive, block);
        } else if (this.getRuntime().getNumeric().isInstance(this.begin)) {
            if (!this.isExclusive) {
                this.end = this.end.callMethod(threadContext, MethodIndex.OP_PLUS, "+", RubyFixnum.one(this.getRuntime()));
            }
            while (this.begin.callMethod(threadContext, MethodIndex.OP_SPACESHIP, "<=>", this.end).convertToInteger().getLongValue() < 0L) {
                block.yield(threadContext, this.begin);
                this.begin = this.begin.callMethod(threadContext, MethodIndex.OP_PLUS, "+", RubyFixnum.one(this.getRuntime()));
            }
        } else {
            IRubyObject iRubyObject = this.begin;
            if (this.isExclusive) {
                while (iRubyObject.callMethod(threadContext, MethodIndex.OP_SPACESHIP, "<=>", this.end).convertToInteger().getLongValue() < 0L && !iRubyObject.equals(this.end)) {
                    block.yield(threadContext, iRubyObject);
                    iRubyObject = iRubyObject.callMethod(threadContext, "succ");
                }
            } else {
                while (iRubyObject.callMethod(threadContext, MethodIndex.OP_SPACESHIP, "<=>", this.end).convertToInteger().getLongValue() <= 0L) {
                    block.yield(threadContext, iRubyObject);
                    if (!iRubyObject.equals(this.end)) {
                        iRubyObject = iRubyObject.callMethod(threadContext, "succ");
                        continue;
                    }
                    break;
                }
            }
        }
        return this;
    }

    @JRubyMethod(name={"step"}, optional=1, frame=true)
    public IRubyObject step(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block) {
        IRubyObject iRubyObject = this.begin;
        int n = this.isExclusive ? MethodIndex.OP_LT : MethodIndex.OP_LE;
        double d = 1.0;
        if (iRubyObjectArray.length != 0) {
            d = Double.parseDouble(iRubyObjectArray[0].toString());
        }
        if (d == 0.0) {
            throw this.getRuntime().newArgumentError("step can't be 0");
        }
        if (d < 0.0) {
            throw this.getRuntime().newArgumentError("step can't be negative");
        }
        if (this.begin instanceof RubyFloat && this.end instanceof RubyFloat) {
            RubyFloat rubyFloat = this.getRuntime().newFloat(d);
            while (iRubyObject.callMethod(threadContext, n, MethodIndex.NAMES.get(n), this.end).isTrue()) {
                block.yield(threadContext, iRubyObject);
                iRubyObject = iRubyObject.callMethod(threadContext, MethodIndex.OP_PLUS, "+", rubyFloat);
            }
        } else if (this.begin instanceof RubyNumeric && this.end instanceof RubyNumeric) {
            if ((d = Math.floor(d)) == 0.0) {
                throw this.getRuntime().newArgumentError("step can't be 0");
            }
            RubyFixnum rubyFixnum = this.getRuntime().newFixnum(Double.valueOf(d).longValue());
            while (iRubyObject.callMethod(threadContext, n, MethodIndex.NAMES.get(n), this.end).isTrue()) {
                block.yield(threadContext, iRubyObject);
                iRubyObject = iRubyObject.callMethod(threadContext, MethodIndex.OP_PLUS, "+", rubyFixnum);
            }
        } else if (this.begin instanceof RubyString && this.end instanceof RubyString) {
            boolean bl;
            RubyString rubyString = this.isExclusive ? (RubyString)this.end : (RubyString)this.end.callMethod(threadContext, "succ");
            boolean bl2 = bl = this.isExclusive && iRubyObject.callMethod(threadContext, MethodIndex.EQUALEQUAL, "==", this.end).isTrue();
            block2: while (!bl) {
                block.yield(threadContext, iRubyObject);
                int n2 = 0;
                while ((double)n2 < d) {
                    if ((iRubyObject = iRubyObject.callMethod(threadContext, "succ")).callMethod(threadContext, MethodIndex.EQUALEQUAL, "==", rubyString).isTrue()) {
                        bl = true;
                        continue block2;
                    }
                    ++n2;
                }
            }
        } else {
            if (!this.begin.respondsTo("succ")) {
                throw this.getRuntime().newTypeError("can't iterate from " + this.begin.getMetaClass().getName());
            }
            while (iRubyObject.callMethod(threadContext, n, MethodIndex.NAMES.get(n), this.end).isTrue()) {
                block.yield(threadContext, iRubyObject);
                int n3 = 0;
                while ((double)n3 < d) {
                    iRubyObject = iRubyObject.callMethod(threadContext, "succ");
                    ++n3;
                }
            }
        }
        return this;
    }

    private boolean r_lt(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        IRubyObject iRubyObject3 = iRubyObject.callMethod(threadContext, MethodIndex.OP_SPACESHIP, "<=>", iRubyObject2);
        if (iRubyObject3.isNil()) {
            return false;
        }
        return RubyComparable.cmpint(threadContext, iRubyObject3, iRubyObject, iRubyObject2) < 0;
    }

    private boolean r_le(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        IRubyObject iRubyObject3 = iRubyObject.callMethod(threadContext, MethodIndex.OP_SPACESHIP, "<=>", iRubyObject2);
        if (iRubyObject3.isNil()) {
            return false;
        }
        return RubyComparable.cmpint(threadContext, iRubyObject3, iRubyObject, iRubyObject2) <= 0;
    }

    @JRubyMethod(name={"include?", "member?", "==="}, required=1, frame=true)
    public RubyBoolean include_p(ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        RubyBoolean rubyBoolean = this.getRuntime().getFalse();
        if (this.r_le(threadContext, this.begin, iRubyObject)) {
            if (this.isExclusive) {
                if (this.r_lt(threadContext, iRubyObject, this.end)) {
                    rubyBoolean = this.getRuntime().getTrue();
                }
            } else if (this.r_le(threadContext, iRubyObject, this.end)) {
                rubyBoolean = this.getRuntime().getTrue();
            }
        }
        return rubyBoolean;
    }
}

