/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.HashMap;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.RubyThread;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyThreadGroup
extends RubyObject {
    private Map<Integer, IRubyObject> rubyThreadList = new HashMap<Integer, IRubyObject>();
    private boolean enclosed = false;

    public static RubyClass createThreadGroupClass(Ruby ruby) {
        RubyClass rubyClass = ruby.defineClass("ThreadGroup", ruby.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        ruby.setThreadGroup(rubyClass);
        rubyClass.defineAnnotatedMethods(RubyThreadGroup.class);
        RubyThreadGroup rubyThreadGroup = new RubyThreadGroup(ruby, rubyClass);
        rubyClass.defineConstant("Default", rubyThreadGroup);
        return rubyClass;
    }

    @JRubyMethod(name={"new"}, frame=true, meta=true)
    public static IRubyObject newInstance(IRubyObject iRubyObject, Block block) {
        return new RubyThreadGroup(iRubyObject.getRuntime(), (RubyClass)iRubyObject);
    }

    @JRubyMethod(name={"add"}, required=1, frame=true)
    public synchronized IRubyObject add(IRubyObject iRubyObject, Block block) {
        if (!(iRubyObject instanceof RubyThread)) {
            throw this.getRuntime().newTypeError(iRubyObject, this.getRuntime().getThread());
        }
        if (this.isFrozen()) {
            throw this.getRuntime().newTypeError("can't add to frozen ThreadGroup");
        }
        RubyThread rubyThread = (RubyThread)iRubyObject;
        if (rubyThread.group() != this.getRuntime().getNil()) {
            RubyThreadGroup rubyThreadGroup = (RubyThreadGroup)rubyThread.group();
            rubyThreadGroup.rubyThreadList.remove(new Integer(System.identityHashCode(iRubyObject)));
        }
        rubyThread.setThreadGroup(this);
        this.rubyThreadList.put(new Integer(System.identityHashCode(iRubyObject)), iRubyObject);
        return this;
    }

    public synchronized void remove(RubyThread rubyThread) {
        rubyThread.setThreadGroup(null);
        this.rubyThreadList.remove(new Integer(System.identityHashCode(rubyThread)));
    }

    @JRubyMethod(name={"enclose"}, frame=true)
    public IRubyObject enclose(Block block) {
        this.enclosed = true;
        return this;
    }

    @JRubyMethod(name={"enclosed?"}, frame=true)
    public IRubyObject enclosed_p(Block block) {
        return new RubyBoolean(this.getRuntime(), this.enclosed);
    }

    @JRubyMethod(name={"list"}, frame=true)
    public synchronized IRubyObject list(Block block) {
        return this.getRuntime().newArrayNoCopy(this.rubyThreadList.values().toArray(new IRubyObject[this.rubyThreadList.size()]));
    }

    private RubyThreadGroup(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }
}

