/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Block;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.IOInputStream;
import org.jruby.util.IOOutputStream;
import org.jruby.yaml.JRubyConstructor;
import org.jruby.yaml.JRubyRepresenter;
import org.jruby.yaml.JRubySerializer;
import org.jvyamlb.ComposerImpl;
import org.jvyamlb.EmitterImpl;
import org.jvyamlb.ParserImpl;
import org.jvyamlb.ResolverImpl;
import org.jvyamlb.ScannerImpl;
import org.jvyamlb.YAML;
import org.jvyamlb.YAMLConfig;
import org.jvyamlb.YAMLException;

public class RubyYAML {
    private static final Pattern AFTER_NEWLINE = Pattern.compile("\n.+", 32);

    public static RubyModule createYAMLModule(Ruby ruby) {
        RubyModule rubyModule = ruby.defineModule("YAML");
        rubyModule.defineAnnotatedMethods(RubyYAML.class);
        RubyClass rubyClass = ruby.getObject();
        RubyClass rubyClass2 = ruby.getClassClass();
        RubyClass rubyClass3 = ruby.getHash();
        RubyClass rubyClass4 = ruby.getArray();
        RubyClass rubyClass5 = ruby.getStructClass();
        RubyClass rubyClass6 = ruby.getException();
        RubyClass rubyClass7 = ruby.getString();
        RubyClass rubyClass8 = ruby.getSymbol();
        RubyClass rubyClass9 = ruby.getRange();
        RubyClass rubyClass10 = ruby.getRegexp();
        RubyClass rubyClass11 = ruby.getTime();
        RubyClass rubyClass12 = ruby.fastGetClass("Date");
        RubyClass rubyClass13 = ruby.getFixnum();
        RubyClass rubyClass14 = ruby.getBignum();
        RubyClass rubyClass15 = ruby.getFloat();
        RubyClass rubyClass16 = ruby.getTrueClass();
        RubyClass rubyClass17 = ruby.getFalseClass();
        RubyClass rubyClass18 = ruby.getNilClass();
        rubyClass2.defineAnnotatedMethods(YAMLClassMethods.class);
        rubyClass.defineAnnotatedMethods(YAMLObjectMethods.class);
        rubyClass3.defineAnnotatedMethods(YAMLHashMethods.class);
        rubyClass4.defineAnnotatedMethods(YAMLArrayMethods.class);
        rubyClass5.defineAnnotatedMethods(YAMLStructMethods.class);
        rubyClass6.defineAnnotatedMethods(YAMLExceptionMethods.class);
        rubyClass7.defineAnnotatedMethods(YAMLStringMethods.class);
        rubyClass8.defineAnnotatedMethods(YAMLSymbolMethods.class);
        rubyClass9.defineAnnotatedMethods(YAMLRangeMethods.class);
        rubyClass10.defineAnnotatedMethods(YAMLRegexpMethods.class);
        rubyClass11.defineAnnotatedMethods(YAMLTimeMethods.class);
        rubyClass12.defineAnnotatedMethods(YAMLDateMethods.class);
        rubyClass14.defineAnnotatedMethods(YAMLNumericMethods.class);
        rubyClass13.defineAnnotatedMethods(YAMLNumericMethods.class);
        rubyClass15.defineAnnotatedMethods(YAMLNumericMethods.class);
        rubyClass16.defineAnnotatedMethods(YAMLTrueMethods.class);
        rubyClass17.defineAnnotatedMethods(YAMLFalseMethods.class);
        rubyClass18.defineAnnotatedMethods(YAMLNilMethods.class);
        ruby.setObjectToYamlMethod(ruby.getObject().searchMethod("to_yaml"));
        return rubyModule;
    }

    @JRubyMethod(name={"dump"}, required=1, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject dump(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        IRubyObject iRubyObject2 = iRubyObjectArray[0];
        RubyArray rubyArray = iRubyObject.getRuntime().newArray(iRubyObject2);
        if (iRubyObjectArray.length > 1) {
            return iRubyObject.callMethod(iRubyObject.getRuntime().getCurrentContext(), "dump_all", new IRubyObject[]{rubyArray, iRubyObjectArray[1]});
        }
        return iRubyObject.callMethod(iRubyObject.getRuntime().getCurrentContext(), "dump_all", rubyArray);
    }

    @JRubyMethod(name={"dump_all"}, required=1, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject dump_all(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        ThreadContext threadContext = iRubyObject.getRuntime().getCurrentContext();
        RubyArray rubyArray = (RubyArray)iRubyObjectArray[0];
        IRubyObject iRubyObject2 = null;
        IRubyObject iRubyObject3 = null;
        if (iRubyObjectArray.length == 2 && iRubyObjectArray[1] != null && !iRubyObjectArray[1].isNil()) {
            iRubyObject2 = iRubyObjectArray[1];
        }
        YAMLConfig yAMLConfig = YAML.config().version("1.0");
        IOOutputStream iOOutputStream = null;
        if (null == iRubyObject2) {
            iRubyObject.getRuntime().getKernel().callMethod(threadContext, "require", iRubyObject.getRuntime().newString("stringio"));
            iRubyObject3 = iRubyObject.getRuntime().fastGetClass("StringIO").callMethod(threadContext, "new");
            iOOutputStream = new IOOutputStream(iRubyObject3);
        } else {
            iOOutputStream = new IOOutputStream(iRubyObject2);
        }
        JRubySerializer jRubySerializer = new JRubySerializer(new EmitterImpl(iOOutputStream, yAMLConfig), new ResolverImpl(), yAMLConfig);
        try {
            jRubySerializer.open();
            JRubyRepresenter jRubyRepresenter = new JRubyRepresenter(jRubySerializer, yAMLConfig);
            Iterator iterator = rubyArray.getList().iterator();
            while (iterator.hasNext()) {
                jRubyRepresenter.represent(iterator.next());
            }
            jRubySerializer.close();
        }
        catch (IOException iOException) {
            throw iRubyObject.getRuntime().newIOErrorFromException(iOException);
        }
        if (null == iRubyObject2) {
            iRubyObject3.callMethod(threadContext, "rewind");
            return iRubyObject3.callMethod(threadContext, "read");
        }
        return iRubyObject2;
    }

    @JRubyMethod(name={"load"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject load(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        IRubyObject iRubyObject3 = RubyYAML.check_yaml_port(iRubyObject2);
        ScannerImpl scannerImpl = null;
        try {
            scannerImpl = iRubyObject3 instanceof RubyString ? new ScannerImpl(((RubyString)iRubyObject3).getByteList()) : new ScannerImpl(new IOInputStream(iRubyObject3));
            JRubyConstructor jRubyConstructor = new JRubyConstructor(iRubyObject, new ComposerImpl(new ParserImpl(scannerImpl, YAML.config().version("1.0")), new ResolverImpl()));
            if (jRubyConstructor.checkData()) {
                return JavaEmbedUtils.javaToRuby(iRubyObject.getRuntime(), jRubyConstructor.getData());
            }
            return iRubyObject.getRuntime().getNil();
        }
        catch (YAMLException yAMLException) {
            if (iRubyObject.getRuntime().getDebug().isTrue()) {
                yAMLException.printStackTrace();
            }
            throw iRubyObject.getRuntime().newArgumentError(yAMLException.getMessage());
        }
    }

    @JRubyMethod(name={"load_file"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject load_file(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        ThreadContext threadContext = iRubyObject.getRuntime().getCurrentContext();
        IRubyObject iRubyObject3 = iRubyObject.getRuntime().getFile().callMethod(threadContext, "open", new IRubyObject[]{iRubyObject2, iRubyObject.getRuntime().newString("r")});
        IRubyObject iRubyObject4 = iRubyObject.callMethod(threadContext, "load", iRubyObject3);
        iRubyObject3.callMethod(threadContext, "close");
        return iRubyObject4;
    }

    @JRubyMethod(name={"each_document"}, required=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject each_document(IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        ThreadContext threadContext = iRubyObject.getRuntime().getCurrentContext();
        IRubyObject iRubyObject3 = iRubyObject2;
        ScannerImpl scannerImpl = null;
        try {
            scannerImpl = iRubyObject3 instanceof RubyString ? new ScannerImpl(((RubyString)iRubyObject3).getByteList()) : new ScannerImpl(new IOInputStream(iRubyObject3));
            JRubyConstructor jRubyConstructor = new JRubyConstructor(iRubyObject, new ComposerImpl(new ParserImpl(scannerImpl, YAML.config().version("1.0")), new ResolverImpl()));
            while (jRubyConstructor.checkData()) {
                block.yield(threadContext, JavaEmbedUtils.javaToRuby(iRubyObject.getRuntime(), jRubyConstructor.getData()));
            }
            return iRubyObject.getRuntime().getNil();
        }
        catch (YAMLException yAMLException) {
            if (iRubyObject.getRuntime().getDebug().isTrue()) {
                yAMLException.printStackTrace();
            }
            throw iRubyObject.getRuntime().newArgumentError(yAMLException.getMessage());
        }
    }

    @JRubyMethod(name={"load_documents"}, required=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject load_documents(IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        ThreadContext threadContext = iRubyObject.getRuntime().getCurrentContext();
        IRubyObject iRubyObject3 = RubyYAML.check_yaml_port(iRubyObject2);
        ScannerImpl scannerImpl = null;
        try {
            scannerImpl = iRubyObject3 instanceof RubyString ? new ScannerImpl(((RubyString)iRubyObject3).getByteList()) : new ScannerImpl(new IOInputStream(iRubyObject3));
            JRubyConstructor jRubyConstructor = new JRubyConstructor(iRubyObject, new ComposerImpl(new ParserImpl(scannerImpl, YAML.config().version("1.0")), new ResolverImpl()));
            while (jRubyConstructor.checkData()) {
                block.yield(threadContext, JavaEmbedUtils.javaToRuby(iRubyObject.getRuntime(), jRubyConstructor.getData()));
            }
            return iRubyObject.getRuntime().getNil();
        }
        catch (YAMLException yAMLException) {
            if (iRubyObject.getRuntime().getDebug().isTrue()) {
                yAMLException.printStackTrace();
            }
            throw iRubyObject.getRuntime().newArgumentError(yAMLException.getMessage());
        }
    }

    @JRubyMethod(name={"load_stream"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject load_stream(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        ThreadContext threadContext = iRubyObject.getRuntime().getCurrentContext();
        IRubyObject iRubyObject3 = iRubyObject.getRuntime().getNil();
        IRubyObject iRubyObject4 = iRubyObject2;
        ScannerImpl scannerImpl = null;
        try {
            scannerImpl = iRubyObject4 instanceof RubyString ? new ScannerImpl(((RubyString)iRubyObject4).getByteList()) : new ScannerImpl(new IOInputStream(iRubyObject4));
            JRubyConstructor jRubyConstructor = new JRubyConstructor(iRubyObject, new ComposerImpl(new ParserImpl(scannerImpl, YAML.config().version("1.0")), new ResolverImpl()));
            while (jRubyConstructor.checkData()) {
                if (iRubyObject3.isNil()) {
                    iRubyObject3 = iRubyObject.getRuntime().fastGetModule("YAML").fastGetClass("Stream").callMethod(threadContext, "new", iRubyObject3);
                }
                iRubyObject3.callMethod(threadContext, "add", JavaEmbedUtils.javaToRuby(iRubyObject.getRuntime(), jRubyConstructor.getData()));
            }
            return iRubyObject3;
        }
        catch (YAMLException yAMLException) {
            if (iRubyObject.getRuntime().getDebug().isTrue()) {
                yAMLException.printStackTrace();
            }
            throw iRubyObject.getRuntime().newArgumentError(yAMLException.getMessage());
        }
    }

    @JRubyMethod(name={"dump_stream"}, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject dump_stream(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        ThreadContext threadContext = iRubyObject.getRuntime().getCurrentContext();
        IRubyObject iRubyObject2 = iRubyObject.getRuntime().fastGetModule("YAML").fastGetClass("Stream").callMethod(threadContext, "new");
        int n = iRubyObjectArray.length;
        for (int i = 0; i < n; ++i) {
            iRubyObject2.callMethod(threadContext, "add", iRubyObjectArray[i]);
        }
        return iRubyObject2.callMethod(threadContext, "emit");
    }

    @JRubyMethod(name={"quick_emit_node"}, required=1, rest=true, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject quick_emit_node(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        return block.yield(iRubyObject.getRuntime().getCurrentContext(), iRubyObjectArray[0]);
    }

    @JRubyMethod(name={"quick_emit_node"}, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject quick_emit(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        return iRubyObject.getRuntime().getNil();
    }

    @JRubyMethod(name={"tagurize"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject tagurize(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return iRubyObject2.callMethod(iRubyObject.getRuntime().getCurrentContext(), "taguri");
    }

    private static IRubyObject check_yaml_port(IRubyObject iRubyObject) {
        if (!(iRubyObject instanceof RubyString)) {
            if (iRubyObject.respondsTo("read")) {
                if (iRubyObject.respondsTo("binmode")) {
                    ThreadContext threadContext = iRubyObject.getRuntime().getCurrentContext();
                    iRubyObject.callMethod(threadContext, "binmode");
                }
            } else {
                throw iRubyObject.getRuntime().newTypeError("instance of IO needed");
            }
        }
        return iRubyObject;
    }

    public static class YAMLNilMethods {
        @JRubyMethod(name={"to_yaml_node"}, required=1)
        public static IRubyObject nil_to_yaml_node(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            ThreadContext threadContext = iRubyObject.getRuntime().getCurrentContext();
            return iRubyObject2.callMethod(threadContext, "scalar", new IRubyObject[]{iRubyObject.callMethod(threadContext, "taguri"), iRubyObject.getRuntime().newString(""), iRubyObject.callMethod(threadContext, "to_yaml_style")});
        }
    }

    public static class YAMLFalseMethods {
        @JRubyMethod(name={"to_yaml_node"}, required=1)
        public static IRubyObject false_to_yaml_node(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            ThreadContext threadContext = iRubyObject.getRuntime().getCurrentContext();
            return iRubyObject2.callMethod(threadContext, "scalar", new IRubyObject[]{iRubyObject.callMethod(threadContext, "taguri"), iRubyObject.callMethod(threadContext, MethodIndex.TO_S, "to_s"), iRubyObject.callMethod(threadContext, "to_yaml_style")});
        }

        @JRubyMethod(name={"taguri"})
        public static IRubyObject false_taguri(IRubyObject iRubyObject) {
            return iRubyObject.getRuntime().newString("tag:yaml.org,2002:bool");
        }
    }

    public static class YAMLTrueMethods {
        @JRubyMethod(name={"to_yaml_node"}, required=1)
        public static IRubyObject true_to_yaml_node(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            ThreadContext threadContext = iRubyObject.getRuntime().getCurrentContext();
            return iRubyObject2.callMethod(threadContext, "scalar", new IRubyObject[]{iRubyObject.callMethod(threadContext, "taguri"), iRubyObject.callMethod(threadContext, MethodIndex.TO_S, "to_s"), iRubyObject.callMethod(threadContext, "to_yaml_style")});
        }

        @JRubyMethod(name={"taguri"})
        public static IRubyObject true_taguri(IRubyObject iRubyObject) {
            return iRubyObject.getRuntime().newString("tag:yaml.org,2002:bool");
        }
    }

    public static class YAMLDateMethods {
        @JRubyMethod(name={"to_yaml_node"}, required=1)
        public static IRubyObject date_to_yaml_node(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            ThreadContext threadContext = iRubyObject.getRuntime().getCurrentContext();
            return iRubyObject2.callMethod(threadContext, "scalar", new IRubyObject[]{iRubyObject.callMethod(threadContext, "taguri"), iRubyObject.callMethod(threadContext, MethodIndex.TO_S, "to_s"), iRubyObject.callMethod(threadContext, "to_yaml_style")});
        }
    }

    public static class YAMLTimeMethods {
        @JRubyMethod(name={"to_yaml_node"}, required=1)
        public static IRubyObject time_to_yaml_node(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            IRubyObject iRubyObject3;
            ThreadContext threadContext = iRubyObject.getRuntime().getCurrentContext();
            IRubyObject iRubyObject4 = iRubyObject.getRuntime().newString("Z");
            RubyString rubyString = iRubyObject.getRuntime().newString("-");
            if (!(iRubyObject = iRubyObject.dup()).callMethod(threadContext, "utc?").isTrue()) {
                IRubyObject iRubyObject5;
                iRubyObject3 = iRubyObject.callMethod(threadContext, "utc");
                IRubyObject iRubyObject6 = iRubyObject.getRuntime().getTime().callMethod(threadContext, "utc", new IRubyObject[]{iRubyObject.callMethod(threadContext, "year"), iRubyObject.callMethod(threadContext, "month"), iRubyObject.callMethod(threadContext, "day"), iRubyObject.callMethod(threadContext, "hour"), iRubyObject.callMethod(threadContext, "min"), iRubyObject.callMethod(threadContext, "sec"), iRubyObject.callMethod(threadContext, "usec")});
                IRubyObject iRubyObject7 = iRubyObject6.callMethod(threadContext, MethodIndex.OP_MINUS, "-", iRubyObject3);
                if (iRubyObject7.callMethod(threadContext, MethodIndex.OP_LT, "<", RubyFixnum.zero(iRubyObject.getRuntime())).isTrue()) {
                    rubyString = iRubyObject.getRuntime().newString("-");
                    iRubyObject5 = RubyFixnum.zero(iRubyObject.getRuntime()).callMethod(threadContext, MethodIndex.OP_MINUS, "-", iRubyObject7);
                } else {
                    rubyString = iRubyObject.getRuntime().newString("+");
                    iRubyObject5 = iRubyObject7;
                }
                IRubyObject iRubyObject8 = iRubyObject5.callMethod(threadContext, "/", iRubyObject.getRuntime().newFixnum(60L)).callMethod(threadContext, "round");
                iRubyObject4 = iRubyObject.getRuntime().newString("%s%02d:%02d").callMethod(threadContext, "%", iRubyObject.getRuntime().newArrayNoCopy(new IRubyObject[]{rubyString, iRubyObject8.callMethod(threadContext, "/", iRubyObject.getRuntime().newFixnum(60L)), iRubyObject8.callMethod(threadContext, "%", iRubyObject.getRuntime().newFixnum(60L))}));
            }
            iRubyObject3 = iRubyObject.callMethod(threadContext, "strftime", iRubyObject.getRuntime().newString("%Y-%m-%d %H:%M:%S"));
            if (iRubyObject.callMethod(threadContext, "usec").callMethod(threadContext, "nonzero?").isTrue()) {
                iRubyObject3 = iRubyObject3.callMethod(threadContext, MethodIndex.OP_PLUS, "+", iRubyObject.getRuntime().newString(".%06d").callMethod(threadContext, "%", iRubyObject.getRuntime().newArray(iRubyObject.callMethod(threadContext, "usec"))));
            }
            iRubyObject3 = iRubyObject3.callMethod(threadContext, MethodIndex.OP_PLUS, "+", iRubyObject.getRuntime().newString(" %s").callMethod(threadContext, "%", iRubyObject.getRuntime().newArray(iRubyObject4)));
            return iRubyObject2.callMethod(threadContext, "scalar", new IRubyObject[]{iRubyObject.callMethod(threadContext, "taguri"), iRubyObject3, iRubyObject.callMethod(threadContext, "to_yaml_style")});
        }
    }

    public static class YAMLRegexpMethods {
        @JRubyMethod(name={"to_yaml_node"}, required=1)
        public static IRubyObject regexp_to_yaml_node(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            ThreadContext threadContext = iRubyObject.getRuntime().getCurrentContext();
            return iRubyObject2.callMethod(threadContext, "scalar", new IRubyObject[]{iRubyObject.callMethod(threadContext, "taguri"), iRubyObject.callMethod(threadContext, "inspect"), iRubyObject.callMethod(threadContext, "to_yaml_style")});
        }
    }

    public static class YAMLRangeMethods {
        @JRubyMethod(name={"to_yaml_node"}, required=1)
        public static IRubyObject range_to_yaml_node(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            ThreadContext threadContext = iRubyObject.getRuntime().getCurrentContext();
            RubyHash rubyHash = new RubyHash(iRubyObject.getRuntime());
            rubyHash.put(iRubyObject.getRuntime().newString("begin"), iRubyObject.callMethod(threadContext, "begin"));
            rubyHash.put(iRubyObject.getRuntime().newString("end"), iRubyObject.callMethod(threadContext, "end"));
            rubyHash.put(iRubyObject.getRuntime().newString("excl"), iRubyObject.callMethod(threadContext, "exclude_end?"));
            Iterator iterator = ((RubyArray)iRubyObject.callMethod(threadContext, "to_yaml_properties")).getList().iterator();
            while (iterator.hasNext()) {
                String string = iterator.next().toString();
                rubyHash.put(iRubyObject.getRuntime().newString(string.substring(1)), iRubyObject.callMethod(threadContext, "instance_variable_get", iRubyObject.getRuntime().newString(string)));
            }
            return iRubyObject2.callMethod(threadContext, "map", new IRubyObject[]{iRubyObject.callMethod(threadContext, "taguri"), rubyHash, iRubyObject.callMethod(threadContext, "to_yaml_style")});
        }
    }

    public static class YAMLNumericMethods {
        @JRubyMethod(name={"to_yaml_node"}, required=1)
        public static IRubyObject numeric_to_yaml_node(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            ThreadContext threadContext = iRubyObject.getRuntime().getCurrentContext();
            String string = iRubyObject.toString();
            if ("Infinity".equals(string)) {
                string = ".Inf";
            } else if ("-Infinity".equals(string)) {
                string = "-.Inf";
            } else if ("NaN".equals(string)) {
                string = ".NaN";
            }
            return iRubyObject2.callMethod(threadContext, "scalar", new IRubyObject[]{iRubyObject.callMethod(threadContext, "taguri"), iRubyObject.getRuntime().newString(string), iRubyObject.callMethod(threadContext, "to_yaml_style")});
        }
    }

    public static class YAMLSymbolMethods {
        @JRubyMethod(name={"to_yaml_node"}, required=1)
        public static IRubyObject symbol_to_yaml_node(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            ThreadContext threadContext = iRubyObject.getRuntime().getCurrentContext();
            return iRubyObject2.callMethod(threadContext, "scalar", new IRubyObject[]{iRubyObject.callMethod(threadContext, "taguri"), iRubyObject.callMethod(threadContext, "inspect"), iRubyObject.callMethod(threadContext, "to_yaml_style")});
        }

        @JRubyMethod(name={"taguri"})
        public static IRubyObject symbol_taguri(IRubyObject iRubyObject) {
            return iRubyObject.getRuntime().newString("tag:yaml.org,2002:str");
        }
    }

    public static class YAMLStringMethods {
        @JRubyMethod(name={"is_complex_yaml?"})
        public static IRubyObject string_is_complex(IRubyObject iRubyObject) {
            ThreadContext threadContext = iRubyObject.getRuntime().getCurrentContext();
            return iRubyObject.callMethod(threadContext, "to_yaml_style").isTrue() || ((List)((Object)iRubyObject.callMethod(threadContext, "to_yaml_properties"))).isEmpty() || AFTER_NEWLINE.matcher(iRubyObject.toString()).find() ? iRubyObject.getRuntime().getTrue() : iRubyObject.getRuntime().getFalse();
        }

        @JRubyMethod(name={"is_binary_data?"})
        public static IRubyObject string_is_binary(IRubyObject iRubyObject) {
            ThreadContext threadContext = iRubyObject.getRuntime().getCurrentContext();
            if (iRubyObject.callMethod(threadContext, MethodIndex.EMPTY_P, "empty?").isTrue()) {
                return iRubyObject.getRuntime().getNil();
            }
            return iRubyObject.toString().indexOf(0) != -1 ? iRubyObject.getRuntime().getTrue() : iRubyObject.getRuntime().getFalse();
        }

        private static JRubyRepresenter into(IRubyObject iRubyObject) {
            IRubyObject iRubyObject2 = iRubyObject.getInstanceVariables().fastGetInstanceVariable("@java_object");
            if (iRubyObject2 != null) {
                return (JRubyRepresenter)((JavaObject)iRubyObject2).getValue();
            }
            return null;
        }

        @JRubyMethod(name={"to_yaml_node"}, required=1)
        public static IRubyObject string_to_yaml_node(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            ThreadContext threadContext = iRubyObject.getRuntime().getCurrentContext();
            Ruby ruby = iRubyObject.getRuntime();
            if (iRubyObject.callMethod(threadContext, "is_binary_data?").isTrue()) {
                return iRubyObject2.callMethod(threadContext, "scalar", new IRubyObject[]{ruby.newString("tag:yaml.org,2002:binary"), ruby.newArray(iRubyObject).callMethod(threadContext, "pack", ruby.newString("m")), ruby.newString("|")});
            }
            if (((List)((Object)iRubyObject.callMethod(threadContext, "to_yaml_properties"))).isEmpty()) {
                JRubyRepresenter jRubyRepresenter = YAMLStringMethods.into(iRubyObject2);
                if (jRubyRepresenter != null) {
                    try {
                        return JavaUtil.convertJavaToRuby(ruby, jRubyRepresenter.scalar(iRubyObject.callMethod(threadContext, "taguri").toString(), iRubyObject.convertToString().getByteList(), iRubyObject.toString().startsWith(":") ? "\"" : iRubyObject.callMethod(threadContext, "to_yaml_style").toString()));
                    }
                    catch (IOException iOException) {
                        throw ruby.newIOErrorFromException(iOException);
                    }
                }
                return iRubyObject2.callMethod(threadContext, "scalar", new IRubyObject[]{iRubyObject.callMethod(threadContext, "taguri"), iRubyObject, iRubyObject.toString().startsWith(":") ? ruby.newString("\"") : iRubyObject.callMethod(threadContext, "to_yaml_style")});
            }
            RubyHash rubyHash = new RubyHash(iRubyObject.getRuntime());
            rubyHash.put(iRubyObject.getRuntime().newString("str"), ruby.newString(iRubyObject.toString()));
            Iterator iterator = ((RubyArray)iRubyObject.callMethod(threadContext, "to_yaml_properties")).getList().iterator();
            while (iterator.hasNext()) {
                String string = iterator.next().toString();
                rubyHash.put(iRubyObject.getRuntime().newString(string.substring(1)), iRubyObject.callMethod(threadContext, "instance_variable_get", iRubyObject.getRuntime().newString(string)));
            }
            return iRubyObject2.callMethod(threadContext, "map", new IRubyObject[]{iRubyObject.callMethod(threadContext, "taguri"), rubyHash, iRubyObject.callMethod(threadContext, "to_yaml_style")});
        }
    }

    public static class YAMLExceptionMethods {
        @JRubyMethod(name={"to_yaml_node"}, required=1)
        public static IRubyObject exception_to_yaml_node(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            ThreadContext threadContext = iRubyObject.getRuntime().getCurrentContext();
            RubyHash rubyHash = new RubyHash(iRubyObject.getRuntime());
            rubyHash.put(iRubyObject.getRuntime().newString("message"), iRubyObject.callMethod(threadContext, "message"));
            Iterator iterator = ((RubyArray)iRubyObject.callMethod(threadContext, "to_yaml_properties")).getList().iterator();
            while (iterator.hasNext()) {
                String string = iterator.next().toString();
                rubyHash.put(iRubyObject.getRuntime().newString(string.substring(1)), iRubyObject.callMethod(threadContext, "instance_variable_get", iRubyObject.getRuntime().newString(string)));
            }
            return iRubyObject2.callMethod(threadContext, "map", new IRubyObject[]{iRubyObject.callMethod(threadContext, "taguri"), rubyHash, iRubyObject.callMethod(threadContext, "to_yaml_style")});
        }

        @JRubyMethod(name={"taguri"})
        public static IRubyObject exception_taguri(IRubyObject iRubyObject) {
            return iRubyObject.getRuntime().newString("!ruby/exception:" + iRubyObject.getType().getName());
        }
    }

    public static class YAMLStructMethods {
        @JRubyMethod(name={"to_yaml_node"}, required=1)
        public static IRubyObject struct_to_yaml_node(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            Object object;
            ThreadContext threadContext = iRubyObject.getRuntime().getCurrentContext();
            RubyHash rubyHash = new RubyHash(iRubyObject.getRuntime());
            Iterator iterator = ((RubyArray)iRubyObject.callMethod(threadContext, "members")).getList().iterator();
            while (iterator.hasNext()) {
                object = iRubyObject.getRuntime().newString(iterator.next().toString());
                rubyHash.put(object, iRubyObject.callMethod(threadContext, MethodIndex.AREF, "[]", (IRubyObject)object));
            }
            iterator = ((RubyArray)iRubyObject.callMethod(threadContext, "to_yaml_properties")).getList().iterator();
            while (iterator.hasNext()) {
                object = iterator.next().toString();
                rubyHash.put(iRubyObject.getRuntime().newString(((String)object).substring(1)), iRubyObject.callMethod(threadContext, "instance_variable_get", iRubyObject.getRuntime().newString((String)object)));
            }
            return iRubyObject2.callMethod(threadContext, "map", new IRubyObject[]{iRubyObject.callMethod(threadContext, "taguri"), rubyHash, iRubyObject.callMethod(threadContext, "to_yaml_style")});
        }

        @JRubyMethod(name={"taguri"})
        public static IRubyObject struct_taguri(IRubyObject iRubyObject) {
            return iRubyObject.getRuntime().newString("!ruby/struct:" + iRubyObject.getType().getName());
        }
    }

    public static class YAMLArrayMethods {
        @JRubyMethod(name={"to_yaml_node"}, required=1)
        public static IRubyObject array_to_yaml_node(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            ThreadContext threadContext = iRubyObject.getRuntime().getCurrentContext();
            return iRubyObject2.callMethod(threadContext, "seq", new IRubyObject[]{iRubyObject.callMethod(threadContext, "taguri"), iRubyObject, iRubyObject.callMethod(threadContext, "to_yaml_style")});
        }
    }

    public static class YAMLClassMethods {
        @JRubyMethod(name={"to_yaml"}, rest=true)
        public static IRubyObject class_to_yaml(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
            throw iRubyObject.getRuntime().newTypeError("can't dump anonymous class " + iRubyObject.getType().getName());
        }
    }

    public static class YAMLObjectMethods {
        @JRubyMethod(name={"to_yaml_properties"})
        public static IRubyObject obj_to_yaml_properties(IRubyObject iRubyObject) {
            ThreadContext threadContext = iRubyObject.getRuntime().getCurrentContext();
            return iRubyObject.callMethod(threadContext, "instance_variables").callMethod(threadContext, "sort");
        }

        @JRubyMethod(name={"to_yaml_style"})
        public static IRubyObject obj_to_yaml_style(IRubyObject iRubyObject) {
            return iRubyObject.getRuntime().getNil();
        }

        @JRubyMethod(name={"to_yaml_node"}, required=1)
        public static IRubyObject obj_to_yaml_node(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            ThreadContext threadContext = iRubyObject.getRuntime().getCurrentContext();
            RubyHash rubyHash = new RubyHash(iRubyObject.getRuntime());
            RubyArray rubyArray = (RubyArray)iRubyObject.callMethod(threadContext, "to_yaml_properties");
            Iterator iterator = rubyArray.getList().iterator();
            while (iterator.hasNext()) {
                String string = iterator.next().toString();
                rubyHash.put(iRubyObject.getRuntime().newString(string.substring(1)), iRubyObject.callMethod(threadContext, "instance_variable_get", iRubyObject.getRuntime().newString(string)));
            }
            return iRubyObject2.callMethod(threadContext, "map", new IRubyObject[]{iRubyObject.callMethod(threadContext, "taguri"), rubyHash, iRubyObject.callMethod(threadContext, "to_yaml_style")});
        }

        @JRubyMethod(name={"to_yaml"}, rest=true)
        public static IRubyObject obj_to_yaml(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
            ThreadContext threadContext = iRubyObject.getRuntime().getCurrentContext();
            return iRubyObject.getRuntime().fastGetModule("YAML").callMethod(threadContext, "dump", iRubyObject);
        }

        @JRubyMethod(name={"taguri"})
        public static IRubyObject obj_taguri(IRubyObject iRubyObject) {
            return iRubyObject.getRuntime().newString("!ruby/object:" + iRubyObject.getType().getName());
        }
    }

    public static class YAMLHashMethods {
        @JRubyMethod(name={"to_yaml_node"}, required=1)
        public static IRubyObject hash_to_yaml_node(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            ThreadContext threadContext = iRubyObject.getRuntime().getCurrentContext();
            return iRubyObject2.callMethod(threadContext, "map", new IRubyObject[]{iRubyObject.callMethod(threadContext, "taguri"), iRubyObject, iRubyObject.callMethod(threadContext, "to_yaml_style")});
        }
    }
}

