/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.IArgumentNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttrAssignNode
extends Node
implements INameNode,
IArgumentNode {
    private final Node receiverNode;
    private String name;
    private Node argsNode;

    public AttrAssignNode(ISourcePosition iSourcePosition, Node node, String string, Node node2) {
        super(iSourcePosition, NodeType.ATTRASSIGNNODE);
        this.receiverNode = node;
        this.name = string;
        this.argsNode = node2;
        if (node2 instanceof ArrayNode) {
            ((ArrayNode)node2).setLightweight(true);
        }
    }

    @Override
    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitAttrAssignNode(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Node getReceiverNode() {
        return this.receiverNode;
    }

    @Override
    public Node getArgsNode() {
        return this.argsNode;
    }

    @Override
    public void setArgsNode(Node node) {
        this.argsNode = node;
        if (node instanceof ArrayNode) {
            ((ArrayNode)node).setLightweight(true);
        }
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.receiverNode, this.argsNode);
    }
}

