/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast.executable;

import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyBignum;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.ast.executable.YARVInstructions;
import org.jruby.common.IRubyWarnings;
import org.jruby.internal.runtime.methods.WrapperMethod;
import org.jruby.internal.runtime.methods.YARVMethod;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.parser.LocalStaticScope;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.CallType;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class YARVMachine {
    private static final boolean TAILCALL_OPT = Boolean.getBoolean("jruby.tailcall.enabled");
    public static final YARVMachine INSTANCE = new YARVMachine();
    IRubyObject[] stack = new IRubyObject[8192];
    int stackTop = 0;

    public static int instruction(String string) {
        return YARVInstructions.instruction(string);
    }

    private void push(IRubyObject iRubyObject) {
        this.stack[this.stackTop] = iRubyObject;
        ++this.stackTop;
    }

    private void swap() {
        this.stack[this.stackTop + 1] = this.stack[this.stackTop];
        this.stack[this.stackTop] = this.stack[this.stackTop - 1];
        this.stack[this.stackTop - 1] = this.stack[this.stackTop + 1];
    }

    private void dupn(int n) {
        System.arraycopy(this.stack, this.stackTop - n, this.stack, this.stackTop, n);
        this.stackTop += n;
    }

    private IRubyObject peek() {
        return this.stack[this.stackTop];
    }

    private IRubyObject pop() {
        return this.stack[--this.stackTop];
    }

    private IRubyObject[] popArray(IRubyObject[] iRubyObjectArray) {
        this.stackTop -= iRubyObjectArray.length;
        System.arraycopy(this.stack, this.stackTop, iRubyObjectArray, 0, iRubyObjectArray.length);
        return iRubyObjectArray;
    }

    private void setn(int n, IRubyObject iRubyObject) {
        this.stack[this.stackTop - n] = iRubyObject;
    }

    private void topn(int n) {
        this.push(this.stack[this.stackTop - n]);
    }

    public void set(IRubyObject iRubyObject) {
        this.stack[this.stackTop] = iRubyObject;
    }

    public void unimplemented(int n) {
        System.err.println("Not implemented, YARVMachine." + YARVInstructions.name(n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject exec(ThreadContext threadContext, StaticScope staticScope, Instruction[] instructionArray) {
        try {
            RubyClass rubyClass = threadContext.getRuntime().getObject();
            threadContext.preScopedBody(DynamicScope.newDynamicScope(staticScope));
            IRubyObject iRubyObject = this.exec(threadContext, rubyClass, instructionArray);
            return iRubyObject;
        }
        finally {
            threadContext.postScopedBody();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public IRubyObject exec(ThreadContext threadContext, IRubyObject iRubyObject, Instruction[] instructionArray) {
        Ruby ruby = threadContext.getRuntime();
        int n = this.stackTop;
        int n2 = 0;
        block56: while (n2 < instructionArray.length) {
            switch (instructionArray[n2].bytecode) {
                case 0: {
                    break;
                }
                case 13: {
                    this.push(ruby.getGlobalVariables().get(instructionArray[n2].s_op0));
                    break;
                }
                case 14: {
                    ruby.getGlobalVariables().set(instructionArray[n2].s_op0, this.pop());
                    break;
                }
                case 1: {
                    this.push(threadContext.getCurrentScope().getValue((int)instructionArray[n2].l_op0, 0));
                    break;
                }
                case 2: {
                    threadContext.getCurrentScope().setValue((int)instructionArray[n2].l_op0, this.pop(), 0);
                    break;
                }
                case 7: {
                    this.push(iRubyObject.getInstanceVariables().fastGetInstanceVariable(instructionArray[n2].s_op0));
                    break;
                }
                case 8: {
                    iRubyObject.getInstanceVariables().fastSetInstanceVariable(instructionArray[n2].s_op0, this.pop());
                    break;
                }
                case 9: {
                    RubyModule rubyModule = threadContext.getRubyClass();
                    Object object = instructionArray[n2].s_op0;
                    if (rubyModule == null) {
                        this.push(iRubyObject.getMetaClass().fastGetClassVar((String)object));
                        break;
                    }
                    if (!rubyModule.isSingleton()) {
                        this.push(rubyModule.fastGetClassVar((String)object));
                        break;
                    }
                    RubyModule rubyModule2 = (RubyModule)((MetaClass)rubyModule).getAttached();
                    if (rubyModule2 != null) {
                        this.push(rubyModule2.fastGetClassVar((String)object));
                        break;
                    }
                    this.push(ruby.getNil());
                    break;
                }
                case 10: {
                    RubyModule rubyModule = threadContext.getCurrentScope().getStaticScope().getModule();
                    if (rubyModule == null) {
                        rubyModule = iRubyObject.getMetaClass();
                    } else if (rubyModule.isSingleton()) {
                        rubyModule = (RubyModule)((MetaClass)rubyModule).getAttached();
                    }
                    rubyModule.fastSetClassVar(instructionArray[n2].s_op0, this.pop());
                    break;
                }
                case 11: {
                    this.push(threadContext.getConstant(instructionArray[n2].s_op0));
                    break;
                }
                case 12: {
                    RubyModule rubyModule = threadContext.getCurrentScope().getStaticScope().getModule();
                    rubyModule.fastSetConstant(instructionArray[n2].s_op0, this.pop());
                    ruby.incGlobalState();
                    break;
                }
                case 15: {
                    this.push(threadContext.getRuntime().getNil());
                    break;
                }
                case 16: {
                    this.push(iRubyObject);
                    break;
                }
                case 18: {
                    this.push(instructionArray[n2].o_op0);
                    break;
                }
                case 19: {
                    this.push(threadContext.getRuntime().newString(instructionArray[n2].s_op0));
                    break;
                }
                case 20: {
                    Object object = new StringBuffer();
                    int n3 = 0;
                    while ((long)n3 < instructionArray[n2].l_op0) {
                        ((StringBuffer)object).append(this.pop().toString());
                        ++n3;
                    }
                    this.push(ruby.newString(((StringBuffer)object).toString()));
                    break;
                }
                case 21: {
                    Object object = this.peek();
                    if (object instanceof RubyString) break;
                    this.set(object.callMethod(threadContext, MethodIndex.TO_S, "to_s"));
                    break;
                }
                case 23: {
                    this.push(ruby.newArrayNoCopy(this.popArray(new IRubyObject[(int)instructionArray[n2].l_op0])));
                    break;
                }
                case 24: {
                    this.push(instructionArray[n2].o_op0.dup());
                    break;
                }
                case 29: {
                    int n4 = (int)instructionArray[n2].l_op0;
                    RubyHash rubyHash = RubyHash.newHash(ruby);
                    for (int i = n4; i > 0; i -= 2) {
                        IRubyObject iRubyObject2 = this.pop();
                        IRubyObject iRubyObject3 = this.pop();
                        rubyHash.op_aset(threadContext, iRubyObject3, iRubyObject2);
                    }
                    this.push(rubyHash);
                    break;
                }
                case 31: {
                    this.push(this.peek().isTrue() ? ruby.getFalse() : ruby.getTrue());
                    break;
                }
                case 32: {
                    this.pop();
                    break;
                }
                case 33: {
                    this.push(this.peek());
                    break;
                }
                case 34: {
                    this.dupn((int)instructionArray[n2].l_op0);
                    break;
                }
                case 35: {
                    this.swap();
                    break;
                }
                case 37: {
                    this.topn((int)instructionArray[n2].l_op0);
                    break;
                }
                case 38: {
                    this.setn((int)instructionArray[n2].l_op0, this.peek());
                    break;
                }
                case 39: {
                    this.stackTop = n;
                    break;
                }
                case 40: {
                    Object object;
                    RubyModule rubyModule = threadContext.getRubyClass();
                    if (rubyModule == null) {
                        throw ruby.newTypeError("No class to add method.");
                    }
                    String string = instructionArray[n2].iseq_op.name;
                    if (rubyModule == ruby.getObject() && string == "initialize") {
                        ruby.getWarnings().warn(IRubyWarnings.ID.REDEFINING_DANGEROUS, "redefining Object#initialize may cause infinite loop", "Object#initialize");
                    }
                    Visibility visibility = threadContext.getCurrentVisibility();
                    if (string == "initialize" || visibility == Visibility.MODULE_FUNCTION) {
                        visibility = Visibility.PRIVATE;
                    }
                    if (rubyModule.isSingleton()) {
                        object = ((MetaClass)rubyModule).getAttached();
                        if (object instanceof RubyFixnum) throw ruby.newTypeError("can't define singleton method \"" + string + "\" for " + object.getType());
                        if (object instanceof RubySymbol) {
                            throw ruby.newTypeError("can't define singleton method \"" + string + "\" for " + object.getType());
                        }
                    }
                    object = new LocalStaticScope(null);
                    ((StaticScope)object).setVariables(instructionArray[n2].iseq_op.locals);
                    YARVMethod yARVMethod = new YARVMethod(rubyModule, instructionArray[n2].iseq_op, (StaticScope)object, visibility);
                    rubyModule.addMethod(string, yARVMethod);
                    if (threadContext.getCurrentVisibility() == Visibility.MODULE_FUNCTION) {
                        RubyClass rubyClass = rubyModule.getSingletonClass();
                        rubyClass.addMethod(string, new WrapperMethod((RubyModule)rubyClass, yARVMethod, Visibility.PUBLIC));
                        rubyModule.callMethod(threadContext, "singleton_method_added", ruby.fastNewSymbol(string));
                    }
                    if (rubyModule.isSingleton()) {
                        ((MetaClass)rubyModule).getAttached().callMethod(threadContext, "singleton_method_added", ruby.fastNewSymbol(string));
                    } else {
                        rubyModule.callMethod(threadContext, "method_added", ruby.fastNewSymbol(string));
                    }
                    this.push(ruby.getNil());
                    ruby.incGlobalState();
                    break;
                }
                case 47: {
                    n2 = this.send(ruby, threadContext, iRubyObject, instructionArray, n, n2);
                    break;
                }
                case 50: {
                    return this.pop();
                }
                case 53: {
                    n2 = (int)instructionArray[n2].l_op0;
                    continue block56;
                }
                case 54: {
                    n2 = this.pop().isTrue() ? (int)instructionArray[n2].l_op0 : n2 + 1;
                    continue block56;
                }
                case 55: {
                    n2 = !this.pop().isTrue() ? (int)instructionArray[n2].l_op0 : n2 + 1;
                    continue block56;
                }
                case 56: {
                    if (instructionArray[n2].l_op1 != ruby.getGlobalState()) break;
                    this.push(instructionArray[n2].o_op0);
                    n2 = (int)instructionArray[n2].l_op0;
                    continue block56;
                }
                case 57: {
                    if (instructionArray[n2].l_op1 <= 0L) break;
                    this.push(instructionArray[n2].o_op0);
                    n2 = (int)instructionArray[n2].l_op0;
                    continue block56;
                }
                case 58: {
                    int n5 = (int)instructionArray[n2].l_op0;
                    instructionArray[n5].o_op0 = this.peek();
                    instructionArray[n5].l_op1 = ruby.getGlobalState();
                    break;
                }
                case 61: {
                    this.op_plus(ruby, threadContext, this.pop(), this.pop());
                    break;
                }
                case 62: {
                    this.op_minus(ruby, threadContext, this.pop(), this.pop());
                    break;
                }
                case 63: {
                    IRubyObject iRubyObject4 = this.pop();
                    this.push(this.pop().callMethod(threadContext, MethodIndex.OP_TIMES, "*", iRubyObject4));
                    break;
                }
                case 64: {
                    IRubyObject iRubyObject4 = this.pop();
                    this.push(this.pop().callMethod(threadContext, "/", iRubyObject4));
                    break;
                }
                case 65: {
                    IRubyObject iRubyObject4 = this.pop();
                    this.push(this.pop().callMethod(threadContext, "%", iRubyObject4));
                    break;
                }
                case 66: {
                    IRubyObject iRubyObject4 = this.pop();
                    this.push(this.pop().callMethod(threadContext, MethodIndex.EQUALEQUAL, "==", iRubyObject4));
                    break;
                }
                case 67: {
                    this.op_lt(ruby, threadContext, this.pop(), this.pop());
                    break;
                }
                case 68: {
                    IRubyObject iRubyObject4 = this.pop();
                    this.push(this.pop().callMethod(threadContext, MethodIndex.OP_LE, "<=", iRubyObject4));
                    break;
                }
                case 69: {
                    IRubyObject iRubyObject4 = this.pop();
                    this.push(this.pop().callMethod(threadContext, MethodIndex.OP_LSHIFT, "<<", iRubyObject4));
                    break;
                }
                case 70: {
                    IRubyObject iRubyObject4 = this.pop();
                    this.push(this.pop().callMethod(threadContext, MethodIndex.AREF, "[]", iRubyObject4));
                    break;
                }
                case 71: {
                    IRubyObject iRubyObject5 = this.pop();
                    IRubyObject iRubyObject4 = this.pop();
                    this.push(RuntimeHelpers.invoke(threadContext, this.pop(), MethodIndex.ASET, "[]=", new IRubyObject[]{iRubyObject4, iRubyObject5}));
                    break;
                }
                case 72: {
                    this.push(this.pop().callMethod(threadContext, "length"));
                    break;
                }
                case 73: {
                    this.push(this.pop().callMethod(threadContext, "succ"));
                    break;
                }
                case 74: {
                    this.push(instructionArray[n2].o_op0.callMethod(threadContext, "=~", this.peek()));
                    break;
                }
                case 75: {
                    IRubyObject iRubyObject4 = this.pop();
                    this.push(this.pop().callMethod(threadContext, "=~", iRubyObject4));
                    break;
                }
                case 78: {
                    this.push(ruby.newFixnum(42L));
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 17: 
                case 22: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 30: 
                case 36: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 51: 
                case 52: 
                case 59: 
                case 60: 
                case 76: 
                case 77: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: {
                    this.unimplemented(instructionArray[n2].bytecode);
                }
            }
            ++n2;
        }
        return this.pop();
    }

    private void op_plus(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        if (iRubyObject instanceof RubyFixnum && iRubyObject2 instanceof RubyFixnum) {
            long l;
            long l2;
            long l3 = ((RubyFixnum)iRubyObject2).getLongValue();
            if (((l3 ^ (l2 = ((RubyFixnum)iRubyObject).getLongValue()) ^ 0xFFFFFFFFFFFFFFFFL) & (l3 ^ (l = l3 + l2)) & Long.MIN_VALUE) != 0L) {
                this.push(RubyBignum.newBignum(ruby, l3).op_plus(threadContext, iRubyObject));
            }
            this.push(ruby.newFixnum(l));
        } else {
            this.push(iRubyObject2.callMethod(threadContext, MethodIndex.OP_PLUS, "+", iRubyObject));
        }
    }

    private void op_minus(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        if (iRubyObject instanceof RubyFixnum && iRubyObject2 instanceof RubyFixnum) {
            long l;
            long l2;
            long l3 = ((RubyFixnum)iRubyObject2).getLongValue();
            if (((l3 ^ (l2 = ((RubyFixnum)iRubyObject).getLongValue()) ^ 0xFFFFFFFFFFFFFFFFL) & (l3 ^ (l = l3 - l2)) & Long.MIN_VALUE) != 0L) {
                this.push(RubyBignum.newBignum(ruby, l3).op_minus(threadContext, iRubyObject));
            }
            this.push(ruby.newFixnum(l));
        } else {
            this.push(iRubyObject2.callMethod(threadContext, MethodIndex.OP_MINUS, "-", iRubyObject));
        }
    }

    private void op_lt(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        if (iRubyObject instanceof RubyFixnum && iRubyObject2 instanceof RubyFixnum) {
            long l;
            long l2 = ((RubyFixnum)iRubyObject2).getLongValue();
            this.push(ruby.newBoolean(l2 < (l = ((RubyFixnum)iRubyObject).getLongValue())));
        } else {
            this.push(iRubyObject2.callMethod(threadContext, MethodIndex.OP_LT, "<", iRubyObject));
        }
    }

    private int send(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Instruction[] instructionArray, int n, int n2) {
        CallType callType;
        IRubyObject iRubyObject2;
        IRubyObject[] iRubyObjectArray;
        Instruction instruction = instructionArray[n2];
        String string = instruction.s_op0;
        int n3 = instruction.i_op1;
        int n4 = instruction.i_op3;
        if (n3 == 0) {
            iRubyObjectArray = IRubyObject.NULL_ARRAY;
        } else {
            iRubyObjectArray = new IRubyObject[n3];
            this.popArray(iRubyObjectArray);
        }
        if ((n4 & 0x10) == 0) {
            if ((n4 & 8) == 0) {
                iRubyObject2 = this.pop();
                callType = CallType.NORMAL;
            } else {
                this.pop();
                iRubyObject2 = iRubyObject;
                callType = CallType.FUNCTIONAL;
            }
        } else {
            this.pop();
            iRubyObject2 = iRubyObject;
            callType = CallType.VARIABLE;
        }
        if (instruction.callAdapter == null) {
            instruction.callAdapter = new CallSite.InlineCachingCallSite(string.intern(), callType);
        }
        if (TAILCALL_OPT && (instructionArray[n2 + 1].bytecode == 50 || (n4 & 0x20) == 32) && iRubyObject2 == iRubyObject && string.equals(threadContext.getFrameName())) {
            this.stackTop = n;
            n2 = -1;
            for (int i = 0; i < iRubyObjectArray.length; ++i) {
                threadContext.getCurrentScope().getValues()[i] = iRubyObjectArray[i];
            }
        } else {
            this.push(instruction.callAdapter.call(threadContext, iRubyObject2, iRubyObjectArray));
        }
        return n2;
    }

    public static class Instruction {
        public int bytecode;
        public int line_no;
        public String s_op0;
        public IRubyObject o_op0;
        public Object _tmp;
        public long l_op0;
        public long l_op1;
        public int i_op1;
        public InstructionSequence iseq_op;
        public Instruction[] ins_op;
        public int i_op3;
        public int index;
        public int methodIndex = -1;
        public CallSite callAdapter;

        public Instruction(int n) {
            this.bytecode = n;
        }

        public Instruction(int n, String string) {
            this.bytecode = n;
            this.s_op0 = string.intern();
        }

        public Instruction(int n, String string, InstructionSequence instructionSequence) {
            this.bytecode = n;
            this.s_op0 = string.intern();
            this.iseq_op = instructionSequence;
        }

        public Instruction(int n, long l) {
            this.bytecode = n;
            this.l_op0 = l;
        }

        public Instruction(int n, IRubyObject iRubyObject) {
            this.bytecode = n;
            this.o_op0 = iRubyObject;
        }

        public Instruction(int n, String string, int n2, Instruction[] instructionArray, int n3) {
            this.bytecode = n;
            this.s_op0 = string;
            this.i_op1 = n2;
            this.ins_op = instructionArray;
            this.i_op3 = n3;
        }

        public String toString() {
            return "[:" + YARVInstructions.name(this.bytecode) + ", " + (this.s_op0 != null ? this.s_op0 : (this.o_op0 != null ? this.o_op0.toString() : "" + this.l_op0)) + "]";
        }
    }

    public static class InstructionSequence {
        public String magic = "YARVInstructionSimpledataFormat";
        public int major = 1;
        public int minor = 1;
        public int format_type = 1;
        public Object misc;
        public String name;
        public String filename;
        public Object[] line;
        public String type;
        public String[] locals;
        public int args_argc;
        public int args_arg_opts;
        public String[] args_opt_labels;
        public int args_rest;
        public int args_block;
        public Object[] exception;
        public Instruction[] body;

        public InstructionSequence(Ruby ruby, String string, String string2, String string3) {
            this.misc = ruby.getNil();
            this.name = string;
            this.filename = string2;
            this.line = new Object[0];
            this.type = string3;
            this.locals = new String[0];
            this.args_argc = 0;
            this.args_arg_opts = 0;
            this.exception = new Object[0];
        }
    }
}

