/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.impl;

import org.jruby.compiler.CompilerCallback;
import org.jruby.compiler.NotCompilableException;
import org.jruby.compiler.impl.AbstractVariableCompiler;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.compiler.impl.StandardASMCompiler;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.CodegenUtils;

public class StackBasedVariableCompiler
extends AbstractVariableCompiler {
    private int scopeIndex;
    private int baseVariableIndex;

    public StackBasedVariableCompiler(StandardASMCompiler.AbstractMethodCompiler abstractMethodCompiler, SkinnyMethodAdapter skinnyMethodAdapter, int n, int n2, int n3, int n4) {
        super(abstractMethodCompiler, skinnyMethodAdapter, n2, n3, n4);
        this.baseVariableIndex = n4;
        this.scopeIndex = n;
    }

    public void beginMethod(CompilerCallback compilerCallback, StaticScope staticScope) {
        if (staticScope.getNumberOfVariables() > 0) {
            this.methodCompiler.loadNil();
            for (int i = 0; i < staticScope.getNumberOfVariables(); ++i) {
                this.assignLocalVariable(i);
            }
            this.method.pop();
            this.tempVariableIndex += staticScope.getNumberOfVariables();
        }
        if (compilerCallback != null) {
            compilerCallback.call(this.methodCompiler);
        }
    }

    public void beginClass(CompilerCallback compilerCallback, StaticScope staticScope) {
        throw new NotCompilableException("ERROR: stack-based variables should not be compiling class bodies");
    }

    public void beginClosure(CompilerCallback compilerCallback, StaticScope staticScope) {
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.invokeThreadContext("getCurrentScope", CodegenUtils.sig(DynamicScope.class));
        this.method.astore(this.scopeIndex);
        if (staticScope != null) {
            this.methodCompiler.loadNil();
            for (int i = 0; i < staticScope.getNumberOfVariables(); ++i) {
                this.assignLocalVariable(i);
            }
            this.method.pop();
            this.tempVariableIndex += staticScope.getNumberOfVariables();
        }
        if (compilerCallback != null) {
            this.method.aload(this.argsIndex);
            this.method.ldc(new Integer(0));
            this.method.arrayload();
            compilerCallback.call(this.methodCompiler);
            this.method.pop();
        }
    }

    public void assignLocalVariable(int n) {
        this.method.dup();
        this.method.astore(this.baseVariableIndex + n);
    }

    public void assignLocalVariable(int n, int n2) {
        if (n2 == 0) {
            this.assignLocalVariable(n);
        } else {
            this.method.dup();
            this.method.aload(this.scopeIndex);
            this.method.swap();
            this.method.ldc(new Integer(n));
            this.method.swap();
            this.method.ldc(new Integer(n2));
            this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValue", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(Integer.TYPE, IRubyObject.class, Integer.TYPE)));
        }
    }

    public void retrieveLocalVariable(int n) {
        this.method.aload(this.baseVariableIndex + n);
    }

    public void retrieveLocalVariable(int n, int n2) {
        if (n2 == 0) {
            this.retrieveLocalVariable(n);
        } else {
            this.method.aload(this.scopeIndex);
            this.method.ldc(new Integer(n));
            this.method.ldc(new Integer(n2));
            this.methodCompiler.loadNil();
            this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValueOrNil", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(Integer.TYPE, Integer.TYPE, IRubyObject.class)));
        }
    }
}

