/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.yarv;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import org.jruby.Ruby;
import org.jruby.ast.AndNode;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.BlockNode;
import org.jruby.ast.BlockPassNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.ConstNode;
import org.jruby.ast.DefnNode;
import org.jruby.ast.FixnumNode;
import org.jruby.ast.HashNode;
import org.jruby.ast.IArgumentNode;
import org.jruby.ast.IfNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.LocalVarNode;
import org.jruby.ast.NewlineNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.NotNode;
import org.jruby.ast.OrNode;
import org.jruby.ast.RootNode;
import org.jruby.ast.StrNode;
import org.jruby.ast.UntilNode;
import org.jruby.ast.VCallNode;
import org.jruby.ast.WhileNode;
import org.jruby.ast.executable.YARVInstructions;
import org.jruby.ast.executable.YARVMachine;
import org.jruby.ast.types.ILiteralNode;
import org.jruby.ast.types.INameNode;
import org.jruby.runtime.builtin.IRubyObject;

public class StandardYARVCompiler {
    private YARVMachine.InstructionSequence iseq;
    private Ruby runtime;
    private int last_line = -1;
    private LinkAnchor current_iseq;
    private String[] locals = new String[0];
    private static final int COMPILE_OK = 1;
    private int label_no = 0;

    private Label NEW_LABEL(int n) {
        Label label = new Label(n, this.label_no);
        ++this.label_no;
        return label;
    }

    private static void ADD_LABEL(LinkAnchor linkAnchor, LinkElement linkElement) {
        linkAnchor.add(linkElement);
    }

    private static void ADD_ELEM(LinkAnchor linkAnchor, LinkElement linkElement) {
        linkAnchor.add(linkElement);
    }

    private static LinkElement POP_ELEMENT(LinkAnchor linkAnchor) {
        return linkAnchor.pop();
    }

    private static boolean LIST_SIZE_ZERO(LinkAnchor linkAnchor) {
        return linkAnchor.isEmpty();
    }

    private static void APPEND_LIST(LinkAnchor linkAnchor, LinkAnchor linkAnchor2) {
        linkAnchor.append(linkAnchor2);
    }

    private static void ADD_SEQ(LinkAnchor linkAnchor, LinkAnchor linkAnchor2) {
        linkAnchor.append(linkAnchor2);
    }

    private int debug_compile(String string, int n) {
        this.debugs(string);
        return n;
    }

    private int COMPILE(LinkAnchor linkAnchor, String string, Node node) {
        return this.debug_compile("== " + string, this.iseq_compile_each(linkAnchor, node, false));
    }

    private int COMPILE(LinkAnchor linkAnchor, String string, Node node, boolean bl) {
        return this.debug_compile("== " + string, this.iseq_compile_each(linkAnchor, node, bl));
    }

    private int COMPILE_POPED(LinkAnchor linkAnchor, String string, Node node) {
        return this.debug_compile("== " + string, this.iseq_compile_each(linkAnchor, node, true));
    }

    private LinkAnchor DECL_ANCHOR() {
        return new LinkAnchor();
    }

    public StandardYARVCompiler(Ruby ruby) {
        this.runtime = ruby;
    }

    private void debugs(String string) {
        System.err.println(string);
    }

    public void compile(Node node) {
        this.iseq_compile(null, node);
    }

    public void compile(Node node, Compiler compiler) {
        this.compile(node);
    }

    public void iseq_compile(IRubyObject iRubyObject, Node node) {
        LinkAnchor linkAnchor = this.DECL_ANCHOR();
        this.debugs("[compile step 1 (traverse each node)]");
        while (node.nodeId == NodeType.NEWLINENODE) {
            node = ((NewlineNode)node).getNextNode();
        }
        this.COMPILE(linkAnchor, "top level node", node);
        this.ADD_INSN(linkAnchor, this.last_line, 50);
        this.current_iseq = linkAnchor;
    }

    private int nd_line(Node node) {
        if (node.getPosition() != null) {
            return node.getPosition().getEndLine();
        }
        return this.last_line;
    }

    private String nd_file(Node node) {
        if (node.getPosition() != null) {
            return node.getPosition().getFile();
        }
        return null;
    }

    private int iseq_compile_each(LinkAnchor linkAnchor, Node node, boolean bl) {
        if (node == null) {
            if (!bl) {
                this.debugs("NODE_NIL(implicit)");
                this.ADD_INSN(linkAnchor, 0, 15);
                return 1;
            }
            return 1;
        }
        this.last_line = this.nd_line(node);
        LinkAnchor linkAnchor2 = null;
        LinkAnchor linkAnchor3 = null;
        block25: while (true) {
            switch (node.nodeId) {
                case BLOCKNODE: {
                    List<Node> list = ((BlockNode)node).childNodes();
                    int n = list.size();
                    for (int i = 0; i < n; ++i) {
                        boolean bl2 = i + 1 != n || bl;
                        this.COMPILE(linkAnchor, "BLOCK body", list.get(i), bl2);
                    }
                    break block25;
                }
                case NEWLINENODE: {
                    node = ((NewlineNode)node).getNextNode();
                    continue block25;
                }
                case ROOTNODE: {
                    this.locals = ((RootNode)node).getStaticScope().getAllNamesInScope();
                    node = ((RootNode)node).getBodyNode();
                    continue block25;
                }
                case DEFNNODE: {
                    String[] stringArray;
                    StandardYARVCompiler standardYARVCompiler = new StandardYARVCompiler(this.runtime);
                    standardYARVCompiler.compile(((DefnNode)node).getBodyNode());
                    YARVMachine.InstructionSequence instructionSequence = standardYARVCompiler.getInstructionSequence(((DefnNode)node).getName(), this.nd_file(node), "method");
                    ArrayList<String> arrayList = new ArrayList<String>();
                    ListNode listNode = ((DefnNode)node).getArgsNode().getArgs();
                    if (listNode != null) {
                        for (int i = 0; i < listNode.size(); ++i) {
                            stringArray = (String[])listNode.get(i);
                            arrayList.add(stringArray.getName());
                        }
                    }
                    instructionSequence.args_argc = arrayList.size();
                    String[] stringArray2 = instructionSequence.locals;
                    stringArray = new String[stringArray2.length + arrayList.size()];
                    System.arraycopy(stringArray2, 0, stringArray, arrayList.size(), stringArray2.length);
                    for (int i = 0; i < arrayList.size(); ++i) {
                        stringArray[i] = (String)arrayList.get(i);
                    }
                    instructionSequence.locals = stringArray;
                    this.ADD_INSN(linkAnchor, this.nd_line(node), 15);
                    this.ADD_INSN3(linkAnchor, this.nd_line(node), 40, ((DefnNode)node).getName(), instructionSequence, 0L);
                    if (bl) break block25;
                    this.ADD_INSN(linkAnchor, this.nd_line(node), 15);
                    break block25;
                }
                case STRNODE: {
                    if (bl) break block25;
                    this.ADD_INSN1(linkAnchor, this.nd_line(node), 19, ((StrNode)node).getValue().toString());
                    break block25;
                }
                case CONSTNODE: {
                    this.ADD_INSN(linkAnchor, this.nd_line(node), 15);
                    this.ADD_INSN1(linkAnchor, this.nd_line(node), 11, ((ConstNode)node).getName());
                    if (!bl) break block25;
                    this.ADD_INSN(linkAnchor, this.nd_line(node), 32);
                    break block25;
                }
                case LOCALASGNNODE: {
                    int n = ((LocalAsgnNode)node).getIndex() - 2;
                    this.debugs("lvar: " + n);
                    this.COMPILE(linkAnchor, "lvalue", ((LocalAsgnNode)node).getValueNode());
                    if (!bl) {
                        this.ADD_INSN(linkAnchor, this.nd_line(node), 33);
                    }
                    this.ADD_INSN1(linkAnchor, this.nd_line(node), 2, n);
                    break block25;
                }
                case LOCALVARNODE: {
                    if (bl) break block25;
                    int n = ((LocalVarNode)node).getIndex() - 2;
                    this.debugs("idx: " + n);
                    this.ADD_INSN1(linkAnchor, this.nd_line(node), 1, n);
                    break block25;
                }
                case IFNODE: {
                    LinkAnchor linkAnchor4 = this.DECL_ANCHOR();
                    LinkAnchor linkAnchor5 = this.DECL_ANCHOR();
                    LinkAnchor linkAnchor6 = this.DECL_ANCHOR();
                    Label label = this.NEW_LABEL(this.nd_line(node));
                    Label label2 = this.NEW_LABEL(this.nd_line(node));
                    Label label3 = this.NEW_LABEL(this.nd_line(node));
                    this.compile_branch_condition(linkAnchor4, ((IfNode)node).getCondition(), label, label2);
                    this.COMPILE(linkAnchor5, "then", ((IfNode)node).getThenBody(), bl);
                    this.COMPILE(linkAnchor6, "else", ((IfNode)node).getElseBody(), bl);
                    StandardYARVCompiler.ADD_SEQ(linkAnchor, linkAnchor4);
                    StandardYARVCompiler.ADD_LABEL(linkAnchor, label);
                    StandardYARVCompiler.ADD_SEQ(linkAnchor, linkAnchor5);
                    this.ADD_INSNL(linkAnchor, this.nd_line(node), 53, label3);
                    StandardYARVCompiler.ADD_LABEL(linkAnchor, label2);
                    StandardYARVCompiler.ADD_SEQ(linkAnchor, linkAnchor6);
                    StandardYARVCompiler.ADD_LABEL(linkAnchor, label3);
                    break block25;
                }
                case VCALLNODE: 
                case FCALLNODE: 
                case CALLNODE: {
                    Object object;
                    linkAnchor2 = this.DECL_ANCHOR();
                    linkAnchor3 = this.DECL_ANCHOR();
                    if (node.nodeId == NodeType.CALLNODE) {
                        this.COMPILE(linkAnchor2, "recv", ((CallNode)node).getReceiverNode());
                    } else {
                        this.ADD_CALL_RECEIVER(linkAnchor2, this.nd_line(node));
                    }
                    int n = 0;
                    int n2 = 0;
                    if (!(node instanceof VCallNode)) {
                        object = this.setup_arg(linkAnchor3, (IArgumentNode)((Object)node));
                        n = object[0];
                        n2 = object[1];
                    } else {
                        n = 0;
                    }
                    StandardYARVCompiler.ADD_SEQ(linkAnchor, linkAnchor2);
                    StandardYARVCompiler.ADD_SEQ(linkAnchor, linkAnchor3);
                    switch (node.nodeId) {
                        case VCALLNODE: {
                            n2 |= 0x10;
                        }
                        case FCALLNODE: {
                            n2 |= 8;
                        }
                    }
                    object = this.ADD_SEND_R(linkAnchor, this.nd_line(node), ((INameNode)((Object)node)).getName(), n, null, n2);
                    if ((n2 & 8) == 0) {
                        if (((INameNode)((Object)node)).getName().equals("<")) {
                            this.insn_set_specialized_instruction((YARVMachine.Instruction)object, 67);
                        } else if (((INameNode)((Object)node)).getName().equals("+")) {
                            this.insn_set_specialized_instruction((YARVMachine.Instruction)object, 61);
                        } else if (((INameNode)((Object)node)).getName().equals("-")) {
                            this.insn_set_specialized_instruction((YARVMachine.Instruction)object, 62);
                        }
                    }
                    if (!bl) break block25;
                    this.ADD_INSN(linkAnchor, this.nd_line(node), 32);
                    break block25;
                }
                case ARRAYNODE: {
                    this.compile_array(linkAnchor, node, true);
                    if (!bl) break block25;
                    this.ADD_INSN(linkAnchor, this.nd_line(node), 32);
                    break block25;
                }
                case ZARRAYNODE: {
                    if (bl) break block25;
                    this.ADD_INSN1(linkAnchor, this.nd_line(node), 23, 0L);
                    break block25;
                }
                case HASHNODE: {
                    LinkAnchor linkAnchor7 = this.DECL_ANCHOR();
                    long l = 0L;
                    ListNode listNode = ((HashNode)node).getListNode();
                    if (((Node)listNode).childNodes().size() > 0) {
                        this.compile_array(linkAnchor7, listNode, false);
                        l = ((Insn)StandardYARVCompiler.POP_ELEMENT((LinkAnchor)linkAnchor7)).i.l_op0;
                        StandardYARVCompiler.ADD_SEQ(linkAnchor, linkAnchor7);
                    }
                    this.ADD_INSN1(linkAnchor, this.nd_line(node), 29, l);
                    if (!bl) break block25;
                    this.ADD_INSN(linkAnchor, this.nd_line(node), 32);
                    break block25;
                }
                case FIXNUMNODE: {
                    FixnumNode fixnumNode = (FixnumNode)node;
                    if (bl) break block25;
                    this.ADD_INSN1(linkAnchor, this.nd_line(node), 18, fixnumNode.getFixnum(this.runtime));
                    break block25;
                }
                case WHILENODE: 
                case UNTILNODE: {
                    Label label = this.NEW_LABEL(this.nd_line(node));
                    Label label4 = this.NEW_LABEL(this.nd_line(node));
                    Label label5 = this.NEW_LABEL(this.nd_line(node));
                    Label label6 = this.NEW_LABEL(this.nd_line(node));
                    StandardYARVCompiler.ADD_LABEL(linkAnchor, label4);
                    Node node2 = null;
                    if (node instanceof WhileNode) {
                        node2 = ((WhileNode)node).getBodyNode();
                    } else if (node instanceof UntilNode) {
                        node2 = ((UntilNode)node).getBodyNode();
                    }
                    this.COMPILE_POPED(linkAnchor, "while body", node2);
                    StandardYARVCompiler.ADD_LABEL(linkAnchor, label);
                    if (node instanceof WhileNode) {
                        this.compile_branch_condition(linkAnchor, ((WhileNode)node).getConditionNode(), label4, label6);
                    } else if (node instanceof UntilNode) {
                        this.compile_branch_condition(linkAnchor, ((UntilNode)node).getConditionNode(), label6, label4);
                    } else {
                        this.ADD_CALL_RECEIVER(linkAnchor, this.nd_line(node));
                        this.ADD_INSNL(linkAnchor, this.nd_line(node), 54, label4);
                    }
                    StandardYARVCompiler.ADD_LABEL(linkAnchor, label6);
                    this.ADD_INSN(linkAnchor, this.nd_line(node), 15);
                    StandardYARVCompiler.ADD_LABEL(linkAnchor, label5);
                    if (!bl) break block25;
                    this.ADD_INSN(linkAnchor, this.nd_line(node), 32);
                    break block25;
                }
                case SELFNODE: {
                    if (bl) break block25;
                    this.ADD_INSN(linkAnchor, this.nd_line(node), 16);
                    break block25;
                }
                case NILNODE: {
                    if (bl) break block25;
                    this.ADD_INSN(linkAnchor, this.nd_line(node), 15);
                    break block25;
                }
                case TRUENODE: {
                    if (bl) break block25;
                    this.ADD_INSN1(linkAnchor, this.nd_line(node), 18, this.runtime.getTrue());
                    break block25;
                }
                case FALSENODE: {
                    if (bl) break block25;
                    this.ADD_INSN1(linkAnchor, this.nd_line(node), 18, this.runtime.getFalse());
                    break block25;
                }
                default: {
                    this.debugs(" ... doesn't handle node: " + node);
                    break block25;
                }
            }
            break;
        }
        return 1;
    }

    private int compile_branch_condition(LinkAnchor linkAnchor, Node node, Label label, Label label2) {
        switch (node.nodeId) {
            case NOTNODE: {
                this.compile_branch_condition(linkAnchor, ((NotNode)node).getConditionNode(), label2, label);
                break;
            }
            case ANDNODE: {
                Label label3 = this.NEW_LABEL(this.nd_line(node));
                this.compile_branch_condition(linkAnchor, ((AndNode)node).getFirstNode(), label3, label2);
                StandardYARVCompiler.ADD_LABEL(linkAnchor, label3);
                this.compile_branch_condition(linkAnchor, ((AndNode)node).getSecondNode(), label, label2);
                break;
            }
            case ORNODE: {
                Label label4 = this.NEW_LABEL(this.nd_line(node));
                this.compile_branch_condition(linkAnchor, ((OrNode)node).getFirstNode(), label, label4);
                StandardYARVCompiler.ADD_LABEL(linkAnchor, label4);
                this.compile_branch_condition(linkAnchor, ((OrNode)node).getSecondNode(), label, label2);
                break;
            }
            case STRNODE: 
            case TRUENODE: {
                this.ADD_INSNL(linkAnchor, this.nd_line(node), 53, label);
                break;
            }
            case NILNODE: 
            case FALSENODE: {
                this.ADD_INSNL(linkAnchor, this.nd_line(node), 53, label2);
                break;
            }
            default: {
                this.COMPILE(linkAnchor, "branch condition", node);
                this.ADD_INSNL(linkAnchor, this.nd_line(node), 55, label2);
                this.ADD_INSNL(linkAnchor, this.nd_line(node), 53, label);
            }
        }
        return 1;
    }

    private int compile_array(LinkAnchor linkAnchor, Node node, boolean bl) {
        Node node22 = node;
        int n = ((ArrayNode)node22).size();
        int n2 = this.nd_line(node22);
        LinkAnchor linkAnchor2 = this.DECL_ANCHOR();
        List<Node> list = node22.childNodes();
        for (Node node22 : list) {
            if (bl && !(node22 instanceof ILiteralNode)) {
                bl = false;
            }
            this.COMPILE(linkAnchor2, "array element", node22);
        }
        if (bl) {
            ArrayList arrayList = new ArrayList();
            block4: for (Node node22 : list) {
                switch (node22.nodeId) {
                    case FIXNUMNODE: {
                        arrayList.add(((FixnumNode)node22).getFixnum(this.runtime));
                        continue block4;
                    }
                }
                this.debugs(" ... doesn't handle array literal node: " + node22);
            }
            this.ADD_INSN1(linkAnchor, this.nd_line(node), 24, this.runtime.newArray(arrayList));
        } else {
            this.ADD_INSN1(linkAnchor2, n2, 23, n);
            StandardYARVCompiler.APPEND_LIST(linkAnchor, linkAnchor2);
        }
        return n;
    }

    private int[] setup_arg(LinkAnchor linkAnchor, IArgumentNode iArgumentNode) {
        int[] nArray = new int[]{0, 0};
        Node node = iArgumentNode.getArgsNode();
        LinkAnchor linkAnchor2 = this.DECL_ANCHOR();
        LinkAnchor linkAnchor3 = this.DECL_ANCHOR();
        boolean bl = false;
        if (node != null) {
            if (node instanceof BlockPassNode) {
                BlockPassNode blockPassNode = (BlockPassNode)node;
                this.COMPILE(linkAnchor2, "block", blockPassNode.getBodyNode());
                bl = true;
                node = blockPassNode.getArgsNode();
            }
            switch (node.nodeId) {
                case SPLATNODE: {
                    break;
                }
                case ARGSCATNODE: {
                    break;
                }
                case ARGSPUSHNODE: {
                    break;
                }
                default: {
                    nArray[0] = this.compile_array(linkAnchor, node, false);
                    StandardYARVCompiler.POP_ELEMENT(linkAnchor);
                }
            }
        }
        if (!StandardYARVCompiler.LIST_SIZE_ZERO(linkAnchor3)) {
            StandardYARVCompiler.ADD_SEQ(linkAnchor, linkAnchor3);
        }
        if (bl) {
            StandardYARVCompiler.ADD_SEQ(linkAnchor, linkAnchor2);
        }
        return nArray;
    }

    private Insn new_insn(YARVMachine.Instruction instruction) {
        Insn insn = new Insn();
        insn.i = instruction;
        insn.next = null;
        return insn;
    }

    private void insn_set_specialized_instruction(YARVMachine.Instruction instruction, int n) {
        instruction.bytecode = n;
    }

    private void ADD_CALL_RECEIVER(LinkAnchor linkAnchor, int n) {
        this.ADD_INSN(linkAnchor, n, 15);
    }

    private void ADD_INSN(LinkAnchor linkAnchor, int n, int n2) {
        YARVMachine.Instruction instruction = new YARVMachine.Instruction(n2);
        instruction.line_no = n;
        this.debugs("ADD_INSN(" + n + ", " + YARVInstructions.name(n2) + ")");
        StandardYARVCompiler.ADD_ELEM(linkAnchor, this.new_insn(instruction));
    }

    private YARVMachine.Instruction ADD_SEND_R(LinkAnchor linkAnchor, int n, String string, int n2, Object object, int n3) {
        YARVMachine.Instruction instruction = new YARVMachine.Instruction(47);
        instruction.line_no = n;
        instruction.s_op0 = string;
        instruction.i_op1 = n2;
        instruction.i_op3 = n3;
        this.debugs("ADD_SEND_R(" + n + ", " + YARVInstructions.name(47) + ", " + string + ", " + n2 + ", " + n3 + ")");
        StandardYARVCompiler.ADD_ELEM(linkAnchor, this.new_insn(instruction));
        return instruction;
    }

    private void ADD_INSN1(LinkAnchor linkAnchor, int n, int n2, IRubyObject iRubyObject) {
        YARVMachine.Instruction instruction = new YARVMachine.Instruction(n2);
        instruction.line_no = n;
        instruction.o_op0 = iRubyObject;
        this.debugs("ADD_INSN1(" + n + ", " + YARVInstructions.name(n2) + ", " + iRubyObject + ")");
        StandardYARVCompiler.ADD_ELEM(linkAnchor, this.new_insn(instruction));
    }

    private void ADD_INSN1(LinkAnchor linkAnchor, int n, int n2, long l) {
        YARVMachine.Instruction instruction = new YARVMachine.Instruction(n2);
        instruction.line_no = n;
        instruction.l_op0 = l;
        this.debugs("ADD_INSN1(" + n + ", " + YARVInstructions.name(n2) + ", " + l + ")");
        StandardYARVCompiler.ADD_ELEM(linkAnchor, this.new_insn(instruction));
    }

    private void ADD_INSNL(LinkAnchor linkAnchor, int n, int n2, Label label) {
        YARVMachine.Instruction instruction = new YARVMachine.Instruction(n2);
        instruction.line_no = n;
        instruction._tmp = label;
        this.debugs("ADD_INSNL(" + n + ", " + YARVInstructions.name(n2) + ", " + label + ")");
        StandardYARVCompiler.ADD_ELEM(linkAnchor, this.new_insn(instruction));
    }

    private void ADD_INSN1(LinkAnchor linkAnchor, int n, int n2, String string) {
        YARVMachine.Instruction instruction = new YARVMachine.Instruction(n2);
        instruction.line_no = n;
        instruction.s_op0 = string;
        this.debugs("ADD_INSN1(" + n + ", " + YARVInstructions.name(n2) + ", " + string + ")");
        StandardYARVCompiler.ADD_ELEM(linkAnchor, this.new_insn(instruction));
    }

    private void ADD_INSN3(LinkAnchor linkAnchor, int n, int n2, String string, YARVMachine.InstructionSequence instructionSequence, long l) {
        YARVMachine.Instruction instruction = new YARVMachine.Instruction(n2);
        instruction.line_no = n;
        instruction.s_op0 = string;
        instruction.iseq_op = instructionSequence;
        instruction.l_op0 = l;
        this.debugs("ADD_INSN3(" + n + ", " + YARVInstructions.name(n2) + ", " + string + ", " + instructionSequence + ", " + l + ")");
        StandardYARVCompiler.ADD_ELEM(linkAnchor, this.new_insn(instruction));
    }

    public YARVMachine.InstructionSequence getInstructionSequence(String string, String string2, String string3) {
        this.iseq = new YARVMachine.InstructionSequence(this.runtime, string, string2, string3);
        ArrayList<YARVMachine.Instruction> arrayList = new ArrayList<YARVMachine.Instruction>();
        IdentityHashMap<Insn, Object> identityHashMap = new IdentityHashMap<Insn, Object>();
        IdentityHashMap<Object, Integer> identityHashMap2 = new IdentityHashMap<Object, Integer>();
        int n = 0;
        Object object = this.current_iseq;
        while (object != null) {
            if (object instanceof Insn) {
                Insn insn = (Insn)object;
                if (this.isJump(insn.i.bytecode)) {
                    identityHashMap.put(insn, insn.i._tmp);
                }
                arrayList.add(insn.i);
                ++n;
            } else if (object instanceof Label) {
                identityHashMap2.put(object, new Integer(n + 1));
            }
            object = ((LinkElement)object).next;
        }
        for (Insn insn : identityHashMap.keySet()) {
            insn.i.l_op0 = (Integer)identityHashMap2.get(identityHashMap.get(insn)) - 1;
            insn.i._tmp = null;
        }
        this.debugs("instructions: " + arrayList);
        this.iseq.body = arrayList.toArray(new YARVMachine.Instruction[arrayList.size()]);
        this.iseq.locals = this.locals;
        return this.iseq;
    }

    private boolean isJump(int n) {
        return n == 53 || n == 54 || n == 55 || n == 56 || n == 58;
    }

    private static class Insn
    extends LinkElement {
        YARVMachine.Instruction i;

        private Insn() {
        }
    }

    private static class Label
    extends LinkElement {
        int id;

        public Label(int n, int n2) {
            this.next = null;
            this.id = n2;
        }
    }

    private static class LinkAnchor
    extends LinkElement {
        LinkElement last = this;

        public void add(LinkElement linkElement) {
            linkElement.prev = this.last;
            this.last.next = linkElement;
            this.last = linkElement;
            this.verify_list("add");
        }

        public void append(LinkAnchor linkAnchor) {
            if (linkAnchor.next != null) {
                this.last.next = linkAnchor.next;
                linkAnchor.next.prev = this.last;
                this.last = linkAnchor.last;
            }
            this.verify_list("append");
        }

        public void insert(LinkAnchor linkAnchor) {
            if (linkAnchor.next != null) {
                LinkElement linkElement = this.next;
                this.next = linkAnchor.next;
                this.next.prev = this;
                linkAnchor.last.next = linkElement;
                if (linkElement != null) {
                    linkElement.prev = linkAnchor.last;
                } else {
                    this.last = linkAnchor.last;
                }
            }
            this.verify_list("append");
        }

        public boolean isEmpty() {
            return this.next == null;
        }

        public LinkElement pop() {
            LinkElement linkElement = this.last;
            this.last = this.last.prev;
            this.last.next = null;
            this.verify_list("pop");
            return linkElement;
        }

        public LinkElement shift() {
            LinkElement linkElement = this.next;
            if (null != linkElement) {
                this.next = linkElement.next;
            }
            return linkElement;
        }

        public int size() {
            int n = 0;
            LinkElement linkElement = this.next;
            while (linkElement != null) {
                ++n;
                linkElement = linkElement.next;
            }
            return n;
        }

        private void verify_list(String string) {
            int n = 0;
            LinkElement linkElement = this;
            LinkElement linkElement2 = this.next;
            while (linkElement2 != null) {
                if (linkElement != linkElement2.prev) {
                    ++n;
                }
                linkElement = linkElement2;
                linkElement2 = linkElement2.next;
            }
            if (this.last != linkElement && this.last != null) {
                n |= 0x70000;
            }
            if (n != 0) {
                throw new RuntimeException("list verify error: " + Integer.toString(n, 16) + " (" + string + ")");
            }
        }

        public LinkElement first() {
            return null;
        }
    }

    private static abstract class LinkElement {
        public LinkElement next;
        public LinkElement prev;

        private LinkElement() {
        }

        public void insert(LinkElement linkElement) {
            linkElement.prev = this.prev;
            linkElement.next = this;
            this.prev = linkElement;
            if (linkElement.prev != null) {
                linkElement.prev.next = linkElement;
            }
        }

        public void remove() {
            this.prev.next = this.next;
            if (this.next != null) {
                this.next.prev = this.prev;
            }
        }

        public void replace(LinkElement linkElement) {
            linkElement.prev = this.prev;
            linkElement.next = this.next;
            if (this.prev != null) {
                this.prev.next = linkElement;
            }
            if (this.next != null) {
                this.next.prev = linkElement;
            }
        }
    }
}

