/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.evaluator;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyModule;
import org.jruby.ast.AttrAssignNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.ClassVarAsgnNode;
import org.jruby.ast.ClassVarDeclNode;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.ConstDeclNode;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.GlobalAsgnNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.common.IRubyWarnings;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class AssignmentVisitor {
    public static IRubyObject assign(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Node node, IRubyObject iRubyObject2, Block block, boolean bl) {
        IRubyObject iRubyObject3 = null;
        switch (node.nodeId) {
            case ATTRASSIGNNODE: {
                AssignmentVisitor.attrAssignNode(ruby, threadContext, iRubyObject, node, iRubyObject2, block);
                break;
            }
            case CALLNODE: {
                AssignmentVisitor.callNode(ruby, threadContext, iRubyObject, node, iRubyObject2, block);
                break;
            }
            case CLASSVARASGNNODE: {
                AssignmentVisitor.classVarAsgnNode(threadContext, node, iRubyObject2);
                break;
            }
            case CLASSVARDECLNODE: {
                AssignmentVisitor.classVarDeclNode(ruby, threadContext, node, iRubyObject2);
                break;
            }
            case CONSTDECLNODE: {
                AssignmentVisitor.constDeclNode(ruby, threadContext, iRubyObject, node, iRubyObject2, block);
                break;
            }
            case DASGNNODE: {
                AssignmentVisitor.dasgnNode(threadContext, node, iRubyObject2);
                break;
            }
            case GLOBALASGNNODE: {
                AssignmentVisitor.globalAsgnNode(ruby, node, iRubyObject2);
                break;
            }
            case INSTASGNNODE: {
                AssignmentVisitor.instAsgnNode(iRubyObject, node, iRubyObject2);
                break;
            }
            case LOCALASGNNODE: {
                AssignmentVisitor.localAsgnNode(threadContext, node, iRubyObject2);
                break;
            }
            case MULTIPLEASGNNODE: {
                iRubyObject3 = AssignmentVisitor.multipleAsgnNode(ruby, threadContext, iRubyObject, node, iRubyObject2, bl);
                break;
            }
            default: {
                throw new RuntimeException("Invalid node encountered in interpreter: \"" + node.getClass().getName() + "\", please report this at www.jruby.org");
            }
        }
        return iRubyObject3;
    }

    private static void attrAssignNode(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Node node, IRubyObject iRubyObject2, Block block) {
        CallType callType;
        AttrAssignNode attrAssignNode = (AttrAssignNode)node;
        IRubyObject iRubyObject3 = ASTInterpreter.eval(ruby, threadContext, attrAssignNode.getReceiverNode(), iRubyObject, block);
        CallType callType2 = callType = iRubyObject3 == iRubyObject ? CallType.VARIABLE : CallType.NORMAL;
        if (attrAssignNode.getArgsNode() == null) {
            RuntimeHelpers.invoke(threadContext, iRubyObject3, attrAssignNode.getName(), new IRubyObject[]{iRubyObject2}, callType, Block.NULL_BLOCK);
        } else {
            RubyArray rubyArray = (RubyArray)ASTInterpreter.eval(ruby, threadContext, attrAssignNode.getArgsNode(), iRubyObject, block);
            rubyArray.append(iRubyObject2);
            RuntimeHelpers.invoke(threadContext, iRubyObject3, attrAssignNode.getName(), rubyArray.toJavaArray(), callType, Block.NULL_BLOCK);
        }
    }

    private static void callNode(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Node node, IRubyObject iRubyObject2, Block block) {
        CallNode callNode = (CallNode)node;
        IRubyObject iRubyObject3 = ASTInterpreter.eval(ruby, threadContext, callNode.getReceiverNode(), iRubyObject, block);
        if (callNode.getArgsNode() == null) {
            RuntimeHelpers.invoke(threadContext, iRubyObject3, callNode.getName(), new IRubyObject[]{iRubyObject2}, CallType.NORMAL, Block.NULL_BLOCK);
        } else {
            RubyArray rubyArray = (RubyArray)ASTInterpreter.eval(ruby, threadContext, callNode.getArgsNode(), iRubyObject, block);
            rubyArray.append(iRubyObject2);
            RuntimeHelpers.invoke(threadContext, iRubyObject3, callNode.getName(), rubyArray.toJavaArray(), CallType.NORMAL, Block.NULL_BLOCK);
        }
    }

    private static void classVarAsgnNode(ThreadContext threadContext, Node node, IRubyObject iRubyObject) {
        ClassVarAsgnNode classVarAsgnNode = (ClassVarAsgnNode)node;
        RubyModule rubyModule = ASTInterpreter.getClassVariableBase(threadContext, threadContext.getRuntime());
        rubyModule.fastSetClassVar(classVarAsgnNode.getName(), iRubyObject);
    }

    private static void classVarDeclNode(Ruby ruby, ThreadContext threadContext, Node node, IRubyObject iRubyObject) {
        ClassVarDeclNode classVarDeclNode = (ClassVarDeclNode)node;
        if (ruby.getVerbose().isTrue() && threadContext.getRubyClass().isSingleton()) {
            ruby.getWarnings().warn(IRubyWarnings.ID.DECLARING_SCLASS_VARIABLE, classVarDeclNode.getPosition(), "Declaring singleton class variable.", new Object[0]);
        }
        RubyModule rubyModule = ASTInterpreter.getClassVariableBase(threadContext, threadContext.getRuntime());
        rubyModule.fastSetClassVar(classVarDeclNode.getName(), iRubyObject);
    }

    private static void constDeclNode(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Node node, IRubyObject iRubyObject2, Block block) {
        IRubyObject iRubyObject3;
        ConstDeclNode constDeclNode = (ConstDeclNode)node;
        Node node2 = constDeclNode.getConstNode();
        if (node2 == null) {
            iRubyObject3 = threadContext.getCurrentScope().getStaticScope().getModule();
            if (iRubyObject3 == null) {
                throw ruby.newTypeError("no class/module to define constant");
            }
        } else {
            iRubyObject3 = node2 instanceof Colon2Node ? ASTInterpreter.eval(ruby, threadContext, ((Colon2Node)constDeclNode.getConstNode()).getLeftNode(), iRubyObject, block) : ruby.getObject();
        }
        iRubyObject3.fastSetConstant(constDeclNode.getName(), iRubyObject2);
    }

    private static void dasgnNode(ThreadContext threadContext, Node node, IRubyObject iRubyObject) {
        DAsgnNode dAsgnNode = (DAsgnNode)node;
        threadContext.getCurrentScope().setValue(dAsgnNode.getIndex(), iRubyObject, dAsgnNode.getDepth());
    }

    private static void globalAsgnNode(Ruby ruby, Node node, IRubyObject iRubyObject) {
        GlobalAsgnNode globalAsgnNode = (GlobalAsgnNode)node;
        ruby.getGlobalVariables().set(globalAsgnNode.getName(), iRubyObject);
    }

    private static void instAsgnNode(IRubyObject iRubyObject, Node node, IRubyObject iRubyObject2) {
        InstAsgnNode instAsgnNode = (InstAsgnNode)node;
        iRubyObject.getInstanceVariables().fastSetInstanceVariable(instAsgnNode.getName(), iRubyObject2);
    }

    private static void localAsgnNode(ThreadContext threadContext, Node node, IRubyObject iRubyObject) {
        LocalAsgnNode localAsgnNode = (LocalAsgnNode)node;
        threadContext.getCurrentScope().setValue(localAsgnNode.getIndex(), iRubyObject, localAsgnNode.getDepth());
    }

    public static IRubyObject multiAssign(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, MultipleAsgnNode multipleAsgnNode, RubyArray rubyArray, boolean bl) {
        Node node;
        int n;
        int n2 = rubyArray.getLength();
        int n3 = multipleAsgnNode.getHeadNode() == null ? 0 : multipleAsgnNode.getHeadNode().size();
        for (n = 0; n < n2 && n < n3; ++n) {
            node = multipleAsgnNode.getHeadNode().get(n);
            AssignmentVisitor.assign(ruby, threadContext, iRubyObject, node, rubyArray.eltInternal(n), Block.NULL_BLOCK, bl);
        }
        if (bl && n < n3) {
            throw ruby.newArgumentError("Wrong # of arguments (" + n2 + " for " + n3 + ")");
        }
        node = multipleAsgnNode.getArgsNode();
        if (node != null) {
            if (node.nodeId != NodeType.STARNODE) {
                if (n3 < n2) {
                    AssignmentVisitor.assign(ruby, threadContext, iRubyObject, node, rubyArray.subseqLight(n3, n2), Block.NULL_BLOCK, bl);
                } else {
                    AssignmentVisitor.assign(ruby, threadContext, iRubyObject, node, RubyArray.newArrayLight(ruby, 0L), Block.NULL_BLOCK, bl);
                }
            }
        } else if (bl && n2 < n3) {
            throw ruby.newArgumentError("Wrong # of arguments (" + n2 + " for " + n3 + ")");
        }
        while (n < n3) {
            AssignmentVisitor.assign(ruby, threadContext, iRubyObject, multipleAsgnNode.getHeadNode().get(n++), ruby.getNil(), Block.NULL_BLOCK, bl);
        }
        return rubyArray;
    }

    private static IRubyObject multipleAsgnNode(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Node node, IRubyObject iRubyObject2, boolean bl) {
        MultipleAsgnNode multipleAsgnNode = (MultipleAsgnNode)node;
        if (!(iRubyObject2 instanceof RubyArray)) {
            iRubyObject2 = ArgsUtil.convertToRubyArray(ruby, iRubyObject2, multipleAsgnNode.getHeadNode() != null);
        }
        IRubyObject iRubyObject3 = AssignmentVisitor.multiAssign(ruby, threadContext, iRubyObject, multipleAsgnNode, (RubyArray)iRubyObject2, bl);
        return iRubyObject3;
    }
}

