/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext;

import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyHash;
import org.jruby.common.IRubyWarnings;
import org.jruby.ext.posix.POSIX;
import org.jruby.ext.posix.POSIXHandler;

public class JRubyPOSIXHandler
implements POSIXHandler {
    Ruby runtime;
    private boolean isVerbose;

    public JRubyPOSIXHandler(Ruby ruby) {
        this.runtime = ruby;
        this.isVerbose = false;
        try {
            this.isVerbose = Boolean.getBoolean("jruby.native.verbose");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public void error(POSIX.ERRORS eRRORS, String string) {
        switch (eRRORS) {
            case ENOENT: {
                throw this.runtime.newErrnoENOENTError("No such file or directory - " + string);
            }
        }
    }

    public void unimplementedError(String string) {
        throw this.runtime.newNotImplementedError(string + " unsupported on this platform");
    }

    public void warn(POSIXHandler.WARNING_ID wARNING_ID, String string, Object ... objectArray) {
        IRubyWarnings.ID iD = wARNING_ID == POSIXHandler.WARNING_ID.DUMMY_VALUE_USED ? IRubyWarnings.ID.DUMMY_VALUE_USED : IRubyWarnings.ID.MISCELLANEOUS;
        this.runtime.getWarnings().warn(iD, string, objectArray);
    }

    public boolean isVerbose() {
        return this.isVerbose;
    }

    public File getCurrentWorkingDirectory() {
        return new File(this.runtime.getCurrentDirectory());
    }

    public String[] getEnv() {
        RubyHash rubyHash = (RubyHash)this.runtime.getObject().fastGetConstant("ENV");
        int n = 0;
        String[] stringArray = new String[rubyHash.size()];
        for (Map.Entry entry : rubyHash.directEntrySet()) {
            stringArray[n] = entry.getKey().toString() + "=" + entry.getValue().toString();
            ++n;
        }
        return stringArray;
    }

    public PrintStream getErrorStream() {
        return this.runtime.getErrorStream();
    }

    public InputStream getInputStream() {
        return this.runtime.getInputStream();
    }

    public int getPID() {
        return this.runtime.hashCode();
    }

    public PrintStream getOutputStream() {
        return this.runtime.getOutputStream();
    }
}

