/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext;

import java.io.IOException;
import java.lang.ref.WeakReference;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyKernel;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;

public class WeakRef
extends RubyObject {
    private WeakReference<IRubyObject> ref;
    private static final ObjectAllocator WEAKREF_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new WeakRef(ruby, rubyClass);
        }
    };

    public WeakRef(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    @JRubyMethod(name={"__getobj__"})
    public IRubyObject getobj() {
        IRubyObject iRubyObject = (IRubyObject)this.ref.get();
        if (iRubyObject == null) {
            throw this.newRefError("Illegal Reference - probably recycled");
        }
        return iRubyObject;
    }

    @JRubyMethod(name={"new"}, required=1, meta=true)
    public static IRubyObject newInstance(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        WeakRef weakRef = (WeakRef)((RubyClass)iRubyObject).allocate();
        weakRef.callInit(new IRubyObject[]{iRubyObject2}, Block.NULL_BLOCK);
        return weakRef;
    }

    @JRubyMethod(name={"initialize"}, required=1, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject iRubyObject) {
        this.ref = new WeakReference<IRubyObject>(iRubyObject);
        return this.callSuper(this.getRuntime().getCurrentContext(), new IRubyObject[]{iRubyObject}, Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"weakref_alive?"})
    public IRubyObject weakref_alive_p() {
        return this.ref.get() != null ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    private RaiseException newRefError(String string) {
        RubyException rubyException = (RubyException)this.getRuntime().getClass("RefError").newInstance(this.getRuntime().getCurrentContext(), new IRubyObject[]{this.getRuntime().newString(string)}, Block.NULL_BLOCK);
        return new RaiseException(rubyException);
    }

    public static class WeakRefLibrary
    implements Library {
        public void load(Ruby ruby, boolean bl) throws IOException {
            RubyKernel.require(ruby.getKernel(), ruby.newString("delegate"), Block.NULL_BLOCK);
            RubyClass rubyClass = (RubyClass)ruby.getClassFromPath("Delegator");
            RubyClass rubyClass2 = ruby.defineClass("WeakRef", rubyClass, WEAKREF_ALLOCATOR);
            rubyClass2.defineAnnotatedMethods(WeakRef.class);
            ruby.defineClass("RefError", ruby.getStandardError(), ruby.getStandardError().getAllocator());
        }
    }
}

