/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.posix;

import com.sun.jna.NativeLibrary;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.jruby.ext.posix.FileStat;
import org.jruby.ext.posix.Group;
import org.jruby.ext.posix.JavaLibCHelper;
import org.jruby.ext.posix.LibC;
import org.jruby.ext.posix.POSIX;
import org.jruby.ext.posix.POSIXHandler;
import org.jruby.ext.posix.Passwd;

public abstract class BaseNativePOSIX
implements POSIX {
    protected String libraryName;
    protected LibC libc;
    protected POSIXHandler handler;
    protected JavaLibCHelper helper;

    public BaseNativePOSIX(String string, LibC libC, POSIXHandler pOSIXHandler) {
        this.libc = libC;
        this.handler = pOSIXHandler;
        this.libraryName = string;
        this.helper = new JavaLibCHelper(pOSIXHandler);
    }

    public int chmod(String string, int n) {
        return this.libc.chmod(string, n);
    }

    public int chown(String string, int n, int n2) {
        return this.libc.chown(string, n, n2);
    }

    public FileStat fstat(FileDescriptor fileDescriptor) {
        FileStat fileStat = this.allocateStat();
        int n = this.helper.getfd(fileDescriptor);
        if (this.libc.fstat(n, fileStat) < 0) {
            this.handler.error(POSIX.ERRORS.ENOENT, "" + n);
        }
        return fileStat;
    }

    public int getegid() {
        return this.libc.getegid();
    }

    public int geteuid() {
        return this.libc.geteuid();
    }

    public int getgid() {
        return this.libc.getgid();
    }

    public String getlogin() {
        return this.libc.getlogin();
    }

    public int getpgid() {
        return this.libc.getpgid();
    }

    public int getpgrp() {
        return this.libc.getpgrp();
    }

    public int getpid() {
        return this.libc.getpid();
    }

    public int getppid() {
        return this.libc.getppid();
    }

    public Passwd getpwent() {
        return this.libc.getpwent();
    }

    public Passwd getpwuid(int n) {
        return this.libc.getpwuid(n);
    }

    public Passwd getpwnam(String string) {
        return this.libc.getpwnam(string);
    }

    public Group getgrent() {
        return this.libc.getgrent();
    }

    public Group getgrgid(int n) {
        return this.libc.getgrgid(n);
    }

    public Group getgrnam(String string) {
        return this.libc.getgrnam(string);
    }

    public int setpwent() {
        return this.libc.setpwent();
    }

    public int endpwent() {
        return this.libc.endpwent();
    }

    public int setgrent() {
        return this.libc.setgrent();
    }

    public int endgrent() {
        return this.libc.endgrent();
    }

    public int getuid() {
        return this.libc.getuid();
    }

    public int setegid(int n) {
        return this.libc.setegid(n);
    }

    public int seteuid(int n) {
        return this.libc.seteuid(n);
    }

    public int setgid(int n) {
        return this.libc.setgid(n);
    }

    public int getfd(FileDescriptor fileDescriptor) {
        return this.helper.getfd(fileDescriptor);
    }

    public int getpgid(int n) {
        return this.libc.getpgid(n);
    }

    public int setpgid(int n, int n2) {
        return this.libc.setpgid(n, n2);
    }

    public int setpgrp(int n, int n2) {
        return this.libc.setpgrp(n, n2);
    }

    public int setsid() {
        return this.libc.setsid();
    }

    public int setuid(int n) {
        return this.libc.setuid(n);
    }

    public int kill(int n, int n2) {
        return this.libc.kill(n, n2);
    }

    public int lchmod(String string, int n) {
        return this.libc.lchmod(string, n);
    }

    public int lchown(String string, int n, int n2) {
        return this.libc.lchown(string, n, n2);
    }

    public int link(String string, String string2) {
        return this.libc.link(string, string2);
    }

    public FileStat lstat(String string) {
        FileStat fileStat = this.allocateStat();
        if (this.libc.lstat(string, fileStat) < 0) {
            this.handler.error(POSIX.ERRORS.ENOENT, string);
        }
        return fileStat;
    }

    public int mkdir(String string, int n) {
        return this.libc.mkdir(string, n);
    }

    public FileStat stat(String string) {
        FileStat fileStat = this.allocateStat();
        if (this.libc.stat(string, fileStat) < 0) {
            this.handler.error(POSIX.ERRORS.ENOENT, string);
        }
        return fileStat;
    }

    public int symlink(String string, String string2) {
        return this.libc.symlink(string, string2);
    }

    public String readlink(String string) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(256);
        int n = this.libc.readlink(string, byteBuffer, byteBuffer.capacity());
        if (n == -1) {
            return null;
        }
        byteBuffer.position(0);
        byteBuffer.limit(n);
        return Charset.forName("ASCII").decode(byteBuffer).toString();
    }

    public int umask(int n) {
        return this.libc.umask(n);
    }

    public int fork() {
        return this.libc.fork();
    }

    public int waitpid(int n, int[] nArray, int n2) {
        return this.libc.waitpid(n, nArray, n);
    }

    public int wait(int[] nArray) {
        return this.libc.wait(nArray);
    }

    public int getpriority(int n, int n2) {
        return this.libc.getpriority(n, n2);
    }

    public int setpriority(int n, int n2, int n3) {
        return this.libc.setpriority(n, n2, n3);
    }

    public boolean isatty(FileDescriptor fileDescriptor) {
        return this.libc.isatty(this.helper.getfd(fileDescriptor)) != 0;
    }

    public abstract FileStat allocateStat();

    protected boolean hasMethod(String string) {
        try {
            NativeLibrary.getInstance((String)this.libraryName).getFunction(string);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            return false;
        }
        return true;
    }
}

