/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.posix;

import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.jruby.ext.posix.FileStat;
import org.jruby.ext.posix.Group;
import org.jruby.ext.posix.JavaFileStat;
import org.jruby.ext.posix.JavaLibCHelper;
import org.jruby.ext.posix.POSIX;
import org.jruby.ext.posix.POSIXHandler;
import org.jruby.ext.posix.Passwd;

public class JavaPOSIX
implements POSIX {
    POSIXHandler handler;
    JavaLibCHelper helper;

    public JavaPOSIX(POSIXHandler pOSIXHandler) {
        this.handler = pOSIXHandler;
        this.helper = new JavaLibCHelper(pOSIXHandler);
    }

    public FileStat allocateStat() {
        return new JavaFileStat(this, this.handler);
    }

    public int chmod(String string, int n) {
        return this.helper.chmod(string, n);
    }

    public int chown(String string, int n, int n2) {
        return this.helper.chown(string, n, n2);
    }

    public FileStat fstat(FileDescriptor fileDescriptor) {
        this.handler.unimplementedError("fstat unimplemented");
        return null;
    }

    public int getegid() {
        return this.unimplementedInt("getegid");
    }

    public int geteuid() {
        return this.unimplementedInt("geteuid");
    }

    public int getgid() {
        return this.unimplementedInt("getgid");
    }

    public String getlogin() {
        return this.helper.getlogin();
    }

    public int getpgid() {
        return this.unimplementedInt("getpgid");
    }

    public int getpgrp() {
        return this.unimplementedInt("getpgrp");
    }

    public int getpid() {
        return this.helper.getpid();
    }

    public int getppid() {
        return this.unimplementedInt("getppid");
    }

    public Passwd getpwent() {
        return this.helper.getpwent();
    }

    public Passwd getpwuid(int n) {
        this.handler.unimplementedError("getpwuid unimplemented");
        return null;
    }

    public Group getgrgid(int n) {
        this.handler.unimplementedError("getgrgid unimplemented");
        return null;
    }

    public Passwd getpwnam(String string) {
        this.handler.unimplementedError("getpwnam unimplemented");
        return null;
    }

    public Group getgrnam(String string) {
        this.handler.unimplementedError("getgrnam unimplemented");
        return null;
    }

    public Group getgrent() {
        this.handler.unimplementedError("getgrent unimplemented");
        return null;
    }

    public int setpwent() {
        return this.helper.setpwent();
    }

    public int endpwent() {
        return this.helper.endpwent();
    }

    public int setgrent() {
        return this.unimplementedInt("setgrent");
    }

    public int endgrent() {
        return this.unimplementedInt("endgrent");
    }

    public int getuid() {
        return this.unimplementedInt("getuid");
    }

    public int fork() {
        return -1;
    }

    public boolean isatty(FileDescriptor fileDescriptor) {
        return fileDescriptor == FileDescriptor.in || fileDescriptor == FileDescriptor.out || fileDescriptor == FileDescriptor.err;
    }

    public int kill(int n, int n2) {
        return this.unimplementedInt("kill");
    }

    public int lchmod(String string, int n) {
        return this.unimplementedInt("lchmod");
    }

    public int lchown(String string, int n, int n2) {
        return this.unimplementedInt("lchown");
    }

    public int link(String string, String string2) {
        return this.helper.link(string, string2);
    }

    public FileStat lstat(String string) {
        FileStat fileStat = this.allocateStat();
        if (this.helper.lstat(string, fileStat) < 0) {
            this.handler.error(POSIX.ERRORS.ENOENT, string);
        }
        return fileStat;
    }

    public int mkdir(String string, int n) {
        return this.helper.mkdir(string, n);
    }

    public String readlink(String string) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(256);
        int n = this.helper.readlink(string, byteBuffer, byteBuffer.capacity());
        if (n == -1) {
            return null;
        }
        byteBuffer.position(0);
        byteBuffer.limit(n);
        return Charset.forName("ASCII").decode(byteBuffer).toString();
    }

    public FileStat stat(String string) {
        FileStat fileStat = this.allocateStat();
        if (this.helper.stat(string, fileStat) < 0) {
            this.handler.error(POSIX.ERRORS.ENOENT, string);
        }
        return fileStat;
    }

    public int symlink(String string, String string2) {
        return this.helper.symlink(string, string2);
    }

    public int setegid(int n) {
        return this.unimplementedInt("setegid");
    }

    public int seteuid(int n) {
        return this.unimplementedInt("seteuid");
    }

    public int setgid(int n) {
        return this.unimplementedInt("setgid");
    }

    public int getpgid(int n) {
        return this.unimplementedInt("getpgid");
    }

    public int setpgid(int n, int n2) {
        return this.unimplementedInt("setpgid");
    }

    public int setpgrp(int n, int n2) {
        return this.unimplementedInt("setpgrp");
    }

    public int setsid() {
        return this.unimplementedInt("setsid");
    }

    public int setuid(int n) {
        return this.unimplementedInt("setuid");
    }

    public int umask(int n) {
        return 0;
    }

    public int wait(int[] nArray) {
        return this.unimplementedInt("wait");
    }

    public int waitpid(int n, int[] nArray, int n2) {
        return this.unimplementedInt("waitpid");
    }

    public int getpriority(int n, int n2) {
        return this.unimplementedInt("getpriority");
    }

    public int setpriority(int n, int n2, int n3) {
        return this.unimplementedInt("setpriority");
    }

    private int unimplementedInt(String string) {
        this.handler.unimplementedError(string);
        return -1;
    }
}

