/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JavaMethodDescriptor;
import org.jruby.compiler.ASTInspector;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.CompiledMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.MethodFactory;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JRubyClassLoader;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.util.CheckClassAdapter;

public class InvocationMethodFactory
extends MethodFactory
implements Opcodes {
    private static final String COMPILED_SUPER_CLASS = CodegenUtils.p(CompiledMethod.class);
    private static final String COMPILED_CALL_SIG = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject[].class));
    private static final String COMPILED_CALL_SIG_BLOCK = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject[].class, Block.class));
    private static final String COMPILED_CALL_SIG_ZERO_BLOCK = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, Block.class));
    private static final String COMPILED_CALL_SIG_ZERO = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class));
    private static final String COMPILED_CALL_SIG_ONE_BLOCK = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject.class, Block.class));
    private static final String COMPILED_CALL_SIG_ONE = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject.class));
    private static final String COMPILED_CALL_SIG_TWO_BLOCK = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject.class, IRubyObject.class, Block.class));
    private static final String COMPILED_CALL_SIG_TWO = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject.class, IRubyObject.class));
    private static final String COMPILED_CALL_SIG_THREE_BLOCK = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class));
    private static final String COMPILED_CALL_SIG_THREE = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
    private static final String COMPILED_SUPER_SIG = CodegenUtils.sig(Void.TYPE, RubyModule.class, Arity.class, Visibility.class, StaticScope.class, Object.class, CallConfiguration.class);
    private static final String JAVA_SUPER_SIG = CodegenUtils.sig(Void.TYPE, CodegenUtils.params(RubyModule.class, Visibility.class));
    private static final String JAVA_INDEXED_SUPER_SIG = CodegenUtils.sig(Void.TYPE, CodegenUtils.params(RubyModule.class, Visibility.class, Integer.TYPE));
    public static final int THIS_INDEX = 0;
    public static final int THREADCONTEXT_INDEX = 1;
    public static final int RECEIVER_INDEX = 2;
    public static final int CLASS_INDEX = 3;
    public static final int NAME_INDEX = 4;
    public static final int ARGS_INDEX = 5;
    public static final int BLOCK_INDEX = 6;
    private JRubyClassLoader classLoader;

    public InvocationMethodFactory(ClassLoader classLoader) {
        this.classLoader = classLoader instanceof JRubyClassLoader ? (JRubyClassLoader)classLoader : new JRubyClassLoader(classLoader);
    }

    public DynamicMethod getCompiledMethod(RubyModule rubyModule, String string, Arity arity, Visibility visibility, StaticScope staticScope, Object object, CallConfiguration callConfiguration) {
        String string2 = COMPILED_SUPER_CLASS;
        Class<?> clazz = object.getClass();
        String string3 = clazz.getName() + "Invoker" + string + arity;
        JRubyClassLoader jRubyClassLoader = this.classLoader;
        synchronized (jRubyClassLoader) {
            Class clazz2 = this.tryClass(rubyModule.getRuntime(), string3);
            try {
                if (clazz2 == null) {
                    String string4 = CodegenUtils.p(clazz);
                    String string5 = string4 + "Invoker" + string + arity;
                    ClassWriter classWriter = this.createCompiledCtor(string5, string2);
                    SkinnyMethodAdapter skinnyMethodAdapter = new SkinnyMethodAdapter(classWriter.visitMethod(1, "call", COMPILED_CALL_SIG_BLOCK, null, null));
                    skinnyMethodAdapter.visitCode();
                    Label label = new Label();
                    skinnyMethodAdapter.visitLineNumber(0, label);
                    if (!callConfiguration.isNoop()) {
                        this.invokeCallConfigPre(skinnyMethodAdapter, COMPILED_SUPER_CLASS, -1, true);
                    }
                    skinnyMethodAdapter.aconst_null();
                    skinnyMethodAdapter.astore(8);
                    Label label2 = new Label();
                    Label label3 = new Label();
                    Label label4 = new Label();
                    Label label5 = new Label();
                    Label label6 = new Label();
                    Label label7 = new Label();
                    skinnyMethodAdapter.trycatch(label2, label3, label5, CodegenUtils.p(JumpException.ReturnJump.class));
                    skinnyMethodAdapter.trycatch(label2, label3, label6, CodegenUtils.p(JumpException.RedoJump.class));
                    skinnyMethodAdapter.trycatch(label2, label3, label4, null);
                    skinnyMethodAdapter.trycatch(label5, label4, label4, null);
                    skinnyMethodAdapter.label(label2);
                    skinnyMethodAdapter.aload(0);
                    skinnyMethodAdapter.getfield(string5, "$scriptObject", CodegenUtils.ci(Object.class));
                    skinnyMethodAdapter.checkcast(string4);
                    skinnyMethodAdapter.aload(1);
                    skinnyMethodAdapter.aload(2);
                    skinnyMethodAdapter.aload(5);
                    skinnyMethodAdapter.aload(6);
                    skinnyMethodAdapter.invokevirtual(string4, string, CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject[].class, Block.class)));
                    skinnyMethodAdapter.astore(8);
                    skinnyMethodAdapter.label(label3);
                    skinnyMethodAdapter.label(label7);
                    if (!callConfiguration.isNoop()) {
                        this.invokeCallConfigPost(skinnyMethodAdapter, COMPILED_SUPER_CLASS);
                    }
                    skinnyMethodAdapter.aload(8);
                    skinnyMethodAdapter.visitInsn(176);
                    this.handleReturn(label5, skinnyMethodAdapter, label4, label7, COMPILED_SUPER_CLASS);
                    this.handleRedo(label6, skinnyMethodAdapter, label4);
                    skinnyMethodAdapter.label(label4);
                    if (!callConfiguration.isNoop()) {
                        this.invokeCallConfigPost(skinnyMethodAdapter, COMPILED_SUPER_CLASS);
                    }
                    skinnyMethodAdapter.athrow();
                    clazz2 = this.endCall(rubyModule.getRuntime(), classWriter, skinnyMethodAdapter, string3);
                }
                return (DynamicMethod)clazz2.getConstructor(RubyModule.class, Arity.class, Visibility.class, StaticScope.class, Object.class, CallConfiguration.class).newInstance(new Object[]{rubyModule, arity, visibility, staticScope, object, callConfiguration});
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw rubyModule.getRuntime().newLoadError(exception.getMessage());
            }
        }
    }

    public DynamicMethod getAnnotatedMethod(RubyModule rubyModule, Method method) {
        JavaMethodDescriptor javaMethodDescriptor = new JavaMethodDescriptor(method);
        Class<?> clazz = method.getDeclaringClass();
        String string = CodegenUtils.p(clazz);
        String string2 = method.getName();
        String string3 = "Invoker$" + string2 + (javaMethodDescriptor.isStatic ? "_s" : "") + "_method_" + javaMethodDescriptor.required + "_" + javaMethodDescriptor.optional;
        String string4 = clazz.getName() + string3;
        String string5 = string + string3;
        JRubyClassLoader jRubyClassLoader = this.classLoader;
        synchronized (jRubyClassLoader) {
            Class clazz2 = this.tryClass(rubyModule.getRuntime(), string4);
            try {
                if (clazz2 == null) {
                    int n = -1;
                    if (javaMethodDescriptor.optional == 0 && !javaMethodDescriptor.rest) {
                        if (javaMethodDescriptor.required == 0) {
                            n = javaMethodDescriptor.actualRequired <= 3 ? javaMethodDescriptor.actualRequired : -1;
                        } else if (javaMethodDescriptor.required >= 0 && javaMethodDescriptor.required <= 3) {
                            n = javaMethodDescriptor.required;
                        }
                    }
                    boolean bl = javaMethodDescriptor.parameters.length == 0 ? false : javaMethodDescriptor.parameters[javaMethodDescriptor.parameters.length - 1] == Block.class;
                    String string6 = CodegenUtils.p(this.selectSuperClass(n, bl));
                    ClassWriter classWriter = this.createJavaMethodCtor(string5, string6);
                    SkinnyMethodAdapter skinnyMethodAdapter = null;
                    skinnyMethodAdapter = this.beginMethod(classWriter, "call", n, bl);
                    skinnyMethodAdapter.visitCode();
                    Label label = new Label();
                    skinnyMethodAdapter.visitLineNumber(0, label);
                    this.createAnnotatedMethodInvocation(javaMethodDescriptor, skinnyMethodAdapter, string6, n, bl);
                    this.endMethod(skinnyMethodAdapter);
                    clazz2 = this.endClass(rubyModule.getRuntime(), classWriter, string4);
                }
                JavaMethod javaMethod = (JavaMethod)clazz2.getConstructor(RubyModule.class, Visibility.class).newInstance(new Object[]{rubyModule, javaMethodDescriptor.anno.visibility()});
                javaMethod.setArity(Arity.fromAnnotation(javaMethodDescriptor.anno, javaMethodDescriptor.parameters, javaMethodDescriptor.isStatic));
                javaMethod.setJavaName(string2);
                javaMethod.setArgumentTypes(javaMethodDescriptor.parameters);
                javaMethod.setSingleton(javaMethodDescriptor.isStatic);
                javaMethod.setCallConfig(CallConfiguration.getCallConfigByAnno(javaMethodDescriptor.anno));
                return javaMethod;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw rubyModule.getRuntime().newLoadError(exception.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void defineIndexedAnnotatedMethods(RubyModule rubyModule, Class clazz, MethodFactory.MethodDefiningCallback methodDefiningCallback) {
        String string = CodegenUtils.p(clazz);
        String string2 = CodegenUtils.p(JavaMethod.class);
        String string3 = clazz.getName() + "Invoker";
        String string4 = string + "Invoker";
        JRubyClassLoader jRubyClassLoader = this.classLoader;
        synchronized (jRubyClassLoader) {
            Class clazz2 = this.tryClass(rubyModule.getRuntime(), string3);
            try {
                Object object;
                Object object2;
                ArrayList<Method> arrayList = new ArrayList<Method>();
                Method[] methodArray = clazz.getDeclaredMethods();
                for (Method object32 : methodArray) {
                    object2 = object32.getAnnotation(JRubyMethod.class);
                    if (object2 == null) continue;
                    arrayList.add(object32);
                }
                ArrayList arrayList2 = new ArrayList(arrayList);
                Collections.sort(arrayList2, new Comparator<Method>(){

                    @Override
                    public int compare(Method method, Method method2) {
                        return method.getName().compareTo(method2.getName());
                    }
                });
                HashMap hashMap = new HashMap();
                for (int i = 0; i < arrayList2.size(); ++i) {
                    hashMap.put(arrayList2.get(i), i);
                }
                if (clazz2 == null) {
                    int n;
                    ClassWriter classWriter = this.createIndexedJavaMethodCtor(string4, string2);
                    Object var15_20 = null;
                    SkinnyMethodAdapter skinnyMethodAdapter = new SkinnyMethodAdapter(classWriter.visitMethod(1, "call", COMPILED_CALL_SIG_BLOCK, null, null));
                    skinnyMethodAdapter.visitCode();
                    object2 = new Label();
                    skinnyMethodAdapter.visitLineNumber(0, (Label)object2);
                    Label label = new Label();
                    object = new Label[arrayList2.size()];
                    for (n = 0; n < ((Label[])object).length; ++n) {
                        object[n] = new Label();
                    }
                    skinnyMethodAdapter.aload(0);
                    skinnyMethodAdapter.getfield(string4, "methodIndex", CodegenUtils.ci(Integer.TYPE));
                    skinnyMethodAdapter.tableswitch(0, ((Label[])object).length - 1, label, (Label[])object);
                    for (n = 0; n < arrayList2.size(); ++n) {
                        skinnyMethodAdapter.label((Label)object[n]);
                        String string5 = this.getAnnotatedMethodForIndex(classWriter, (Method)arrayList2.get(n), n, string2);
                        skinnyMethodAdapter.aload(0);
                        skinnyMethodAdapter.aload(1);
                        skinnyMethodAdapter.aload(2);
                        skinnyMethodAdapter.aload(3);
                        skinnyMethodAdapter.aload(4);
                        skinnyMethodAdapter.aload(5);
                        skinnyMethodAdapter.aload(6);
                        skinnyMethodAdapter.invokevirtual(string4, string5, COMPILED_CALL_SIG_BLOCK);
                        skinnyMethodAdapter.areturn();
                    }
                    skinnyMethodAdapter.label(label);
                    skinnyMethodAdapter.aload(1);
                    skinnyMethodAdapter.invokevirtual(CodegenUtils.p(ThreadContext.class), "getRuntime", CodegenUtils.sig(Ruby.class));
                    skinnyMethodAdapter.ldc("Error: fell off switched invoker for class: " + rubyModule.getBaseName());
                    skinnyMethodAdapter.invokevirtual(CodegenUtils.p(Ruby.class), "newRuntimeError", CodegenUtils.sig(RaiseException.class, String.class));
                    skinnyMethodAdapter.athrow();
                    clazz2 = this.endCall(rubyModule.getRuntime(), classWriter, skinnyMethodAdapter, string3);
                }
                for (int i = 0; i < arrayList.size(); ++i) {
                    Method method = (Method)arrayList.get(i);
                    object2 = method.getAnnotation(JRubyMethod.class);
                    if (object2.frame()) {
                        for (String string5 : object2.name()) {
                            ASTInspector.FRAME_AWARE_METHODS.add(string5);
                        }
                    }
                    int n = (Integer)hashMap.get(method);
                    object = (JavaMethod)clazz2.getConstructor(RubyModule.class, Visibility.class, Integer.TYPE).newInstance(new Object[]{rubyModule, object2.visibility(), n});
                    ((JavaMethod)object).setArity(Arity.fromAnnotation((JRubyMethod)object2));
                    ((JavaMethod)object).setJavaName(method.getName());
                    ((JavaMethod)object).setArgumentTypes(method.getParameterTypes());
                    ((JavaMethod)object).setSingleton(Modifier.isStatic(method.getModifiers()));
                    ((DynamicMethod)object).setCallConfig(CallConfiguration.getCallConfigByAnno((JRubyMethod)object2));
                    methodDefiningCallback.define(rubyModule, method, (DynamicMethod)object);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw rubyModule.getRuntime().newLoadError(exception.getMessage());
            }
        }
    }

    private void checkArity(JRubyMethod jRubyMethod, SkinnyMethodAdapter skinnyMethodAdapter, int n) {
        Label label = new Label();
        Label label2 = new Label();
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return;
            }
        }
        if (jRubyMethod.rest()) {
            if (jRubyMethod.required() > 0) {
                skinnyMethodAdapter.aload(5);
                skinnyMethodAdapter.arraylength();
                skinnyMethodAdapter.ldc(jRubyMethod.required());
                skinnyMethodAdapter.if_icmplt(label);
            }
        } else if (jRubyMethod.optional() > 0) {
            if (jRubyMethod.required() > 0) {
                skinnyMethodAdapter.aload(5);
                skinnyMethodAdapter.arraylength();
                skinnyMethodAdapter.ldc(jRubyMethod.required());
                skinnyMethodAdapter.if_icmplt(label);
            }
            skinnyMethodAdapter.aload(5);
            skinnyMethodAdapter.arraylength();
            skinnyMethodAdapter.ldc(jRubyMethod.required() + jRubyMethod.optional());
            skinnyMethodAdapter.if_icmpgt(label);
        } else {
            skinnyMethodAdapter.aload(5);
            skinnyMethodAdapter.arraylength();
            skinnyMethodAdapter.ldc(jRubyMethod.required());
            skinnyMethodAdapter.if_icmpne(label);
        }
        skinnyMethodAdapter.go_to(label2);
        skinnyMethodAdapter.label(label);
        skinnyMethodAdapter.aload(1);
        skinnyMethodAdapter.invokevirtual(CodegenUtils.p(ThreadContext.class), "getRuntime", CodegenUtils.sig(Ruby.class));
        skinnyMethodAdapter.aload(5);
        skinnyMethodAdapter.ldc(jRubyMethod.required());
        skinnyMethodAdapter.ldc(jRubyMethod.required() + jRubyMethod.optional());
        skinnyMethodAdapter.invokestatic(CodegenUtils.p(Arity.class), "checkArgumentCount", CodegenUtils.sig(Integer.TYPE, Ruby.class, IRubyObject[].class, Integer.TYPE, Integer.TYPE));
        skinnyMethodAdapter.pop();
        skinnyMethodAdapter.label(label2);
    }

    private ClassWriter createCompiledCtor(String string, String string2) throws Exception {
        ClassWriter classWriter = new ClassWriter(1);
        classWriter.visit(48, 33, string, null, string2, null);
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "<init>", COMPILED_SUPER_SIG, null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitVarInsn(25, 2);
        methodVisitor.visitVarInsn(25, 3);
        methodVisitor.visitVarInsn(25, 4);
        methodVisitor.visitVarInsn(25, 5);
        methodVisitor.visitVarInsn(25, 6);
        methodVisitor.visitMethodInsn(183, string2, "<init>", COMPILED_SUPER_SIG);
        Label label = new Label();
        methodVisitor.visitLineNumber(0, label);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
        return classWriter;
    }

    private ClassWriter createJavaMethodCtor(String string, String string2) throws Exception {
        ClassWriter classWriter = new ClassWriter(1);
        classWriter.visit(48, 33, string, null, string2, null);
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "<init>", JAVA_SUPER_SIG, null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitVarInsn(25, 2);
        methodVisitor.visitMethodInsn(183, string2, "<init>", JAVA_SUPER_SIG);
        Label label = new Label();
        methodVisitor.visitLineNumber(0, label);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
        return classWriter;
    }

    private ClassWriter createIndexedJavaMethodCtor(String string, String string2) throws Exception {
        ClassWriter classWriter = new ClassWriter(1);
        classWriter.visit(48, 33, string, null, string2, null);
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "<init>", JAVA_INDEXED_SUPER_SIG, null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitVarInsn(25, 2);
        methodVisitor.visitVarInsn(21, 3);
        methodVisitor.visitMethodInsn(183, string2, "<init>", JAVA_INDEXED_SUPER_SIG);
        Label label = new Label();
        methodVisitor.visitLineNumber(0, label);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
        return classWriter;
    }

    private void handleRedo(Label label, SkinnyMethodAdapter skinnyMethodAdapter, Label label2) {
        skinnyMethodAdapter.label(label);
        skinnyMethodAdapter.pop();
        skinnyMethodAdapter.aload(1);
        skinnyMethodAdapter.invokevirtual(CodegenUtils.p(ThreadContext.class), "getRuntime", CodegenUtils.sig(Ruby.class));
        skinnyMethodAdapter.invokevirtual(CodegenUtils.p(Ruby.class), "newRedoLocalJumpError", CodegenUtils.sig(RaiseException.class));
        skinnyMethodAdapter.go_to(label2);
    }

    private void handleReturn(Label label, SkinnyMethodAdapter skinnyMethodAdapter, Label label2, Label label3, String string) {
        skinnyMethodAdapter.label(label);
        skinnyMethodAdapter.aload(0);
        skinnyMethodAdapter.swap();
        skinnyMethodAdapter.invokevirtual(string, "handleReturnJump", CodegenUtils.sig(IRubyObject.class, JumpException.ReturnJump.class));
        skinnyMethodAdapter.astore(8);
        skinnyMethodAdapter.go_to(label3);
    }

    private void invokeCallConfigPost(SkinnyMethodAdapter skinnyMethodAdapter, String string) {
        skinnyMethodAdapter.aload(0);
        skinnyMethodAdapter.aload(1);
        skinnyMethodAdapter.invokevirtual(string, "post", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(ThreadContext.class)));
    }

    private void invokeCallConfigPre(SkinnyMethodAdapter skinnyMethodAdapter, String string, int n, boolean bl) {
        skinnyMethodAdapter.aload(0);
        skinnyMethodAdapter.aload(1);
        skinnyMethodAdapter.aload(2);
        skinnyMethodAdapter.aload(4);
        this.loadArgumentsForPre(skinnyMethodAdapter, n);
        this.loadBlockForPre(skinnyMethodAdapter, n, bl);
        skinnyMethodAdapter.invokevirtual(string, "pre", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(ThreadContext.class, IRubyObject.class, String.class, IRubyObject[].class, Block.class)));
    }

    private void loadArgumentsForPre(SkinnyMethodAdapter skinnyMethodAdapter, int n) {
        switch (n) {
            default: {
                skinnyMethodAdapter.aload(5);
                break;
            }
            case 0: {
                skinnyMethodAdapter.getstatic(CodegenUtils.p(IRubyObject.class), "NULL_ARRAY", CodegenUtils.ci(IRubyObject[].class));
                break;
            }
            case 1: {
                skinnyMethodAdapter.aload(5);
                skinnyMethodAdapter.invokestatic(CodegenUtils.p(RuntimeHelpers.class), "constructObjectArray", CodegenUtils.sig(IRubyObject[].class, IRubyObject.class));
                break;
            }
            case 2: {
                skinnyMethodAdapter.aload(5);
                skinnyMethodAdapter.aload(6);
                skinnyMethodAdapter.invokestatic(CodegenUtils.p(RuntimeHelpers.class), "constructObjectArray", CodegenUtils.sig(IRubyObject[].class, IRubyObject.class, IRubyObject.class));
                break;
            }
            case 3: {
                skinnyMethodAdapter.aload(5);
                skinnyMethodAdapter.aload(6);
                skinnyMethodAdapter.aload(7);
                skinnyMethodAdapter.invokestatic(CodegenUtils.p(RuntimeHelpers.class), "constructObjectArray", CodegenUtils.sig(IRubyObject[].class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
            }
        }
    }

    private void loadArguments(SkinnyMethodAdapter skinnyMethodAdapter, JRubyMethod jRubyMethod, int n) {
        switch (n) {
            default: {
                skinnyMethodAdapter.aload(5);
                break;
            }
            case 0: {
                break;
            }
            case 1: {
                skinnyMethodAdapter.aload(5);
                break;
            }
            case 2: {
                skinnyMethodAdapter.aload(5);
                skinnyMethodAdapter.aload(6);
                break;
            }
            case 3: {
                skinnyMethodAdapter.aload(5);
                skinnyMethodAdapter.aload(6);
                skinnyMethodAdapter.aload(7);
            }
        }
    }

    private void loadBlockForPre(SkinnyMethodAdapter skinnyMethodAdapter, int n, boolean bl) {
        switch (n) {
            default: {
                if (bl) {
                    skinnyMethodAdapter.visitVarInsn(25, 6);
                    break;
                }
                skinnyMethodAdapter.getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
                break;
            }
            case 0: {
                if (bl) {
                    skinnyMethodAdapter.visitVarInsn(25, 5);
                    break;
                }
                skinnyMethodAdapter.getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
                break;
            }
            case 1: {
                if (bl) {
                    skinnyMethodAdapter.visitVarInsn(25, 6);
                    break;
                }
                skinnyMethodAdapter.getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
                break;
            }
            case 2: {
                if (bl) {
                    skinnyMethodAdapter.visitVarInsn(25, 7);
                    break;
                }
                skinnyMethodAdapter.getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
                break;
            }
            case 3: {
                if (bl) {
                    skinnyMethodAdapter.visitVarInsn(25, 8);
                    break;
                }
                skinnyMethodAdapter.getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
            }
        }
    }

    private void loadBlock(SkinnyMethodAdapter skinnyMethodAdapter, int n, boolean bl) {
        switch (n) {
            default: {
                if (!bl) break;
                skinnyMethodAdapter.visitVarInsn(25, 6);
                break;
            }
            case 0: {
                if (!bl) break;
                skinnyMethodAdapter.visitVarInsn(25, 5);
                break;
            }
            case 1: {
                if (!bl) break;
                skinnyMethodAdapter.visitVarInsn(25, 6);
                break;
            }
            case 2: {
                if (!bl) break;
                skinnyMethodAdapter.visitVarInsn(25, 7);
                break;
            }
            case 3: {
                if (!bl) break;
                skinnyMethodAdapter.visitVarInsn(25, 8);
            }
        }
    }

    private void loadReceiver(String string, Class[] classArray, Method method, SkinnyMethodAdapter skinnyMethodAdapter) {
        if (Modifier.isStatic(method.getModifiers())) {
            if (classArray.length > 1 && classArray[0] == ThreadContext.class) {
                skinnyMethodAdapter.aload(1);
            }
            skinnyMethodAdapter.aload(2);
        } else {
            skinnyMethodAdapter.aload(2);
            skinnyMethodAdapter.checkcast(string);
            if (classArray.length > 0 && classArray[0] == ThreadContext.class) {
                skinnyMethodAdapter.aload(1);
            }
        }
    }

    private Class tryClass(Ruby ruby, String string) {
        try {
            if (this.classLoader == null) {
                return Class.forName(string, true, ruby.getJRubyClassLoader());
            }
            return this.classLoader.loadClass(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected Class endCall(Ruby ruby, ClassWriter classWriter, MethodVisitor methodVisitor, String string) {
        this.endMethod(methodVisitor);
        return this.endClass(ruby, classWriter, string);
    }

    protected void endMethod(MethodVisitor methodVisitor) {
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    protected Class endClass(Ruby ruby, ClassWriter classWriter, String string) {
        classWriter.visitEnd();
        byte[] byArray = classWriter.toByteArray();
        CheckClassAdapter.verify((ClassReader)new ClassReader(byArray), (boolean)false, (PrintWriter)new PrintWriter(System.err));
        if (this.classLoader == null) {
            this.classLoader = ruby.getJRubyClassLoader();
        }
        return this.classLoader.defineClass(string, byArray);
    }

    private void loadArguments(MethodVisitor methodVisitor, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.loadArgument(methodVisitor, n, i);
        }
    }

    private void loadArgument(MethodVisitor methodVisitor, int n, int n2) {
        methodVisitor.visitVarInsn(25, n);
        methodVisitor.visitLdcInsn(new Integer(n2));
        methodVisitor.visitInsn(50);
    }

    private SkinnyMethodAdapter beginMethod(ClassWriter classWriter, String string, int n, boolean bl) {
        switch (n) {
            default: {
                if (bl) {
                    return new SkinnyMethodAdapter(classWriter.visitMethod(1, string, COMPILED_CALL_SIG_BLOCK, null, null));
                }
                return new SkinnyMethodAdapter(classWriter.visitMethod(1, string, COMPILED_CALL_SIG, null, null));
            }
            case 0: {
                if (bl) {
                    return new SkinnyMethodAdapter(classWriter.visitMethod(1, string, COMPILED_CALL_SIG_ZERO_BLOCK, null, null));
                }
                return new SkinnyMethodAdapter(classWriter.visitMethod(1, string, COMPILED_CALL_SIG_ZERO, null, null));
            }
            case 1: {
                if (bl) {
                    return new SkinnyMethodAdapter(classWriter.visitMethod(1, string, COMPILED_CALL_SIG_ONE_BLOCK, null, null));
                }
                return new SkinnyMethodAdapter(classWriter.visitMethod(1, string, COMPILED_CALL_SIG_ONE, null, null));
            }
            case 2: {
                if (bl) {
                    return new SkinnyMethodAdapter(classWriter.visitMethod(1, string, COMPILED_CALL_SIG_TWO_BLOCK, null, null));
                }
                return new SkinnyMethodAdapter(classWriter.visitMethod(1, string, COMPILED_CALL_SIG_TWO, null, null));
            }
            case 3: 
        }
        if (bl) {
            return new SkinnyMethodAdapter(classWriter.visitMethod(1, string, COMPILED_CALL_SIG_THREE_BLOCK, null, null));
        }
        return new SkinnyMethodAdapter(classWriter.visitMethod(1, string, COMPILED_CALL_SIG_THREE, null, null));
    }

    private Class selectSuperClass(int n, boolean bl) {
        switch (n) {
            default: {
                if (bl) {
                    return JavaMethod.class;
                }
                return JavaMethod.JavaMethodNoBlock.class;
            }
            case 0: {
                if (bl) {
                    return JavaMethod.JavaMethodZeroBlock.class;
                }
                return JavaMethod.JavaMethodZero.class;
            }
            case 1: {
                if (bl) {
                    return JavaMethod.JavaMethodOneBlock.class;
                }
                return JavaMethod.JavaMethodOne.class;
            }
            case 2: {
                if (bl) {
                    return JavaMethod.JavaMethodTwoBlock.class;
                }
                return JavaMethod.JavaMethodTwo.class;
            }
            case 3: 
        }
        if (bl) {
            return JavaMethod.JavaMethodThreeBlock.class;
        }
        return JavaMethod.JavaMethodThree.class;
    }

    private String getAnnotatedMethodForIndex(ClassWriter classWriter, Method method, int n, String string) {
        String string2 = "call" + n + "_" + method.getName();
        SkinnyMethodAdapter skinnyMethodAdapter = new SkinnyMethodAdapter(classWriter.visitMethod(1, string2, COMPILED_CALL_SIG_BLOCK, null, null));
        skinnyMethodAdapter.visitCode();
        Label label = new Label();
        skinnyMethodAdapter.visitLineNumber(0, label);
        this.createAnnotatedMethodInvocation(new JavaMethodDescriptor(method), skinnyMethodAdapter, string, -1, true);
        this.endMethod(skinnyMethodAdapter);
        return string2;
    }

    private void createAnnotatedMethodInvocation(JavaMethodDescriptor javaMethodDescriptor, SkinnyMethodAdapter skinnyMethodAdapter, String string, int n, boolean bl) {
        String string2 = CodegenUtils.p(javaMethodDescriptor.method.getDeclaringClass());
        String string3 = javaMethodDescriptor.method.getName();
        Class<?> clazz = javaMethodDescriptor.method.getReturnType();
        this.checkArity(javaMethodDescriptor.anno, skinnyMethodAdapter, n);
        CallConfiguration callConfiguration = CallConfiguration.getCallConfigByAnno(javaMethodDescriptor.anno);
        if (!callConfiguration.isNoop()) {
            this.invokeCallConfigPre(skinnyMethodAdapter, string, n, bl);
        }
        Label label = new Label();
        Label label2 = new Label();
        Label label3 = new Label();
        Label label4 = new Label();
        Label label5 = new Label();
        Label label6 = new Label();
        if (!callConfiguration.isNoop() || bl) {
            skinnyMethodAdapter.trycatch(label, label2, label4, CodegenUtils.p(JumpException.ReturnJump.class));
            skinnyMethodAdapter.trycatch(label, label2, label5, CodegenUtils.p(JumpException.RedoJump.class));
            skinnyMethodAdapter.trycatch(label, label2, label3, null);
            skinnyMethodAdapter.trycatch(label4, label3, label3, null);
        }
        skinnyMethodAdapter.label(label);
        this.loadReceiver(string2, javaMethodDescriptor.parameters, javaMethodDescriptor.method, skinnyMethodAdapter);
        this.loadArguments(skinnyMethodAdapter, javaMethodDescriptor.anno, n);
        this.loadBlock(skinnyMethodAdapter, n, bl);
        if (Modifier.isStatic(javaMethodDescriptor.method.getModifiers())) {
            skinnyMethodAdapter.invokestatic(string2, string3, CodegenUtils.sig(clazz, javaMethodDescriptor.parameters));
        } else {
            skinnyMethodAdapter.invokevirtual(string2, string3, CodegenUtils.sig(clazz, javaMethodDescriptor.parameters));
        }
        if (!callConfiguration.isNoop() || bl) {
            skinnyMethodAdapter.astore(8);
            skinnyMethodAdapter.label(label2);
            skinnyMethodAdapter.label(label6);
            if (!callConfiguration.isNoop()) {
                this.invokeCallConfigPost(skinnyMethodAdapter, string);
            }
            skinnyMethodAdapter.aload(8);
        }
        skinnyMethodAdapter.visitInsn(176);
        if (!callConfiguration.isNoop() || bl) {
            this.handleReturn(label4, skinnyMethodAdapter, label3, label6, string);
            this.handleRedo(label5, skinnyMethodAdapter, label3);
            skinnyMethodAdapter.label(label3);
            if (!callConfiguration.isNoop()) {
                this.invokeCallConfigPost(skinnyMethodAdapter, string);
            }
            skinnyMethodAdapter.athrow();
        }
    }
}

