/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import java.util.ArrayList;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyModule;
import org.jruby.ast.executable.YARVMachine;
import org.jruby.exceptions.JumpException;
import org.jruby.internal.runtime.JumpTarget;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Frame;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class YARVMethod
extends DynamicMethod
implements JumpTarget {
    private YARVMachine.InstructionSequence iseq;
    private StaticScope staticScope;
    private Arity arity;

    public YARVMethod(RubyModule rubyModule, YARVMachine.InstructionSequence instructionSequence, StaticScope staticScope, Visibility visibility) {
        super(rubyModule, visibility, CallConfiguration.FRAME_AND_SCOPE);
        boolean bl;
        this.staticScope = staticScope;
        this.iseq = instructionSequence;
        boolean bl2 = instructionSequence.args_arg_opts > 0 || instructionSequence.args_rest > 0;
        boolean bl3 = bl = instructionSequence.args_argc > 0;
        this.arity = !bl && !bl2 ? Arity.noArguments() : (bl && !bl2 ? Arity.fixed(instructionSequence.args_argc) : (bl2 && !bl ? Arity.optional() : Arity.required(instructionSequence.args_argc)));
    }

    public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray, Block block) {
        IRubyObject iRubyObject2;
        assert (iRubyObjectArray != null);
        Ruby ruby = threadContext.getRuntime();
        this.callConfig.pre(threadContext, iRubyObject, rubyModule, this.getArity(), string, iRubyObjectArray, block, this.staticScope, this);
        try {
            this.prepareArguments(threadContext, ruby, iRubyObjectArray);
            this.getArity().checkArity(ruby, iRubyObjectArray);
            if (ruby.hasEventHooks()) {
                this.traceCall(threadContext, ruby, string);
            }
            DynamicScope dynamicScope = threadContext.getCurrentScope();
            dynamicScope.setArgValues(iRubyObjectArray, iRubyObjectArray.length);
            iRubyObject2 = YARVMachine.INSTANCE.exec(threadContext, iRubyObject, this.iseq.body);
            Object var11_12 = null;
        }
        catch (JumpException.ReturnJump returnJump) {
            block10: {
                try {
                    if (returnJump.getTarget() != this) break block10;
                    IRubyObject iRubyObject3 = (IRubyObject)returnJump.getValue();
                    Object var11_13 = null;
                    if (ruby.hasEventHooks()) {
                        this.traceReturn(threadContext, ruby, string);
                    }
                    this.callConfig.post(threadContext);
                    return iRubyObject3;
                }
                catch (Throwable throwable) {
                    Object var11_14 = null;
                    if (ruby.hasEventHooks()) {
                        this.traceReturn(threadContext, ruby, string);
                    }
                    this.callConfig.post(threadContext);
                    throw throwable;
                }
            }
            throw returnJump;
        }
        if (ruby.hasEventHooks()) {
            this.traceReturn(threadContext, ruby, string);
        }
        this.callConfig.post(threadContext);
        return iRubyObject2;
    }

    private void prepareArguments(ThreadContext threadContext, Ruby ruby, IRubyObject[] iRubyObjectArray) {
        boolean bl;
        threadContext.setFile(this.iseq.filename);
        threadContext.setLine(-1);
        int n = this.iseq.args_argc;
        int n2 = this.iseq.args_rest;
        boolean bl2 = bl = this.iseq.args_arg_opts > 0;
        if (n > iRubyObjectArray.length) {
            throw ruby.newArgumentError("Wrong # of arguments(" + iRubyObjectArray.length + " for " + n + ")");
        }
        if (bl || n2 != -1) {
            this.prepareOptOrRestArgs(threadContext, ruby, iRubyObjectArray, n, n2, bl);
        }
    }

    private IRubyObject[] prepareOptOrRestArgs(ThreadContext threadContext, Ruby ruby, IRubyObject[] iRubyObjectArray, int n, int n2, boolean bl) {
        int n3;
        int n4;
        if (n2 == 0 && bl && (n4 = n + this.iseq.args_arg_opts) < iRubyObjectArray.length) {
            throw ruby.newArgumentError("wrong # of arguments(" + iRubyObjectArray.length + " for " + n4 + ")");
        }
        n4 = n + this.iseq.args_arg_opts + this.iseq.args_rest;
        ArrayList<IRubyObject> arrayList = new ArrayList<IRubyObject>();
        for (n3 = 0; n3 < n4 && n3 < iRubyObjectArray.length; ++n3) {
            arrayList.add(iRubyObjectArray[n3]);
        }
        if (n2 != 0) {
            for (n3 = n; n3 < iRubyObjectArray.length; ++n3) {
                arrayList.add(iRubyObjectArray[n3]);
            }
            if (n2 >= 0) {
                RubyArray rubyArray = ruby.newArray(iRubyObjectArray.length - n);
                for (int i = n; i < iRubyObjectArray.length; ++i) {
                    rubyArray.append(iRubyObjectArray[i]);
                }
                threadContext.getCurrentScope().setValue(n2, rubyArray, 0);
            }
        }
        iRubyObjectArray = arrayList.toArray(new IRubyObject[arrayList.size()]);
        return iRubyObjectArray;
    }

    private void traceReturn(ThreadContext threadContext, Ruby ruby, String string) {
        if (!ruby.hasEventHooks()) {
            return;
        }
        Frame frame = threadContext.getPreviousFrame();
        ruby.callEventHooks(threadContext, 4, frame.getFile(), frame.getLine(), string, this.getImplementationClass());
    }

    private void traceCall(ThreadContext threadContext, Ruby ruby, String string) {
        if (!ruby.hasEventHooks()) {
            return;
        }
        ruby.callEventHooks(threadContext, 3, threadContext.getFile(), threadContext.getLine(), string, this.getImplementationClass());
    }

    public Arity getArity() {
        return this.arity;
    }

    public DynamicMethod dup() {
        return new YARVMethod(this.getImplementationClass(), this.iseq, this.staticScope, this.getVisibility());
    }
}

