/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.javasupport.JavaArray;
import org.jruby.javasupport.JavaClass;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ObjectMarshal;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaObject
extends RubyObject {
    private static Object NULL_LOCK = new Object();
    private final Object value;

    protected JavaObject(Ruby ruby, RubyClass rubyClass, Object object) {
        super(ruby, rubyClass);
        this.value = object;
    }

    protected JavaObject(Ruby ruby, Object object) {
        this(ruby, ruby.getJavaSupport().getJavaObjectClass(), object);
    }

    public static JavaObject wrap(Ruby ruby, Object object) {
        if (object != null) {
            if (object instanceof Class) {
                return JavaClass.get(ruby, (Class)object);
            }
            if (object.getClass().isArray()) {
                return new JavaArray(ruby, object);
            }
        }
        return new JavaObject(ruby, object);
    }

    @Override
    public Class<?> getJavaClass() {
        return this.value != null ? this.value.getClass() : Void.TYPE;
    }

    public Object getValue() {
        return this.value;
    }

    public static RubyClass createJavaObjectClass(Ruby ruby, RubyModule rubyModule) {
        RubyClass rubyClass = rubyModule.defineClassUnder("JavaObject", ruby.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        JavaObject.registerRubyMethods(ruby, rubyClass);
        rubyClass.getMetaClass().undefineMethod("new");
        rubyClass.getMetaClass().undefineMethod("allocate");
        rubyClass.setMarshal(ObjectMarshal.NOT_MARSHALABLE_MARSHAL);
        return rubyClass;
    }

    protected static void registerRubyMethods(Ruby ruby, RubyClass rubyClass) {
        rubyClass.defineAnnotatedMethods(JavaObject.class);
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof JavaObject && this.value == ((JavaObject)object).value;
    }

    @Override
    public int hashCode() {
        if (this.value != null) {
            return this.value.hashCode();
        }
        return 0;
    }

    @Override
    @JRubyMethod
    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(this.hashCode());
    }

    @Override
    @JRubyMethod
    public IRubyObject to_s() {
        if (this.value != null) {
            String string = this.value.toString();
            if (string != null) {
                return RubyString.newUnicodeString(this.getRuntime(), this.value.toString());
            }
            return this.getRuntime().getNil();
        }
        return this.getRuntime().newString("");
    }

    @JRubyMethod(name={"==", "eql?"}, required=1)
    public IRubyObject op_equal(IRubyObject iRubyObject) {
        if (!(iRubyObject instanceof JavaObject) && !((iRubyObject = iRubyObject.getInstanceVariables().fastGetInstanceVariable("@java_object")) instanceof JavaObject)) {
            return this.getRuntime().getFalse();
        }
        if (this.getValue() == null && ((JavaObject)iRubyObject).getValue() == null) {
            return this.getRuntime().getTrue();
        }
        boolean bl = this.getValue().equals(((JavaObject)iRubyObject).getValue());
        return bl ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"equal?"}, required=1)
    public IRubyObject same(IRubyObject iRubyObject) {
        if (!(iRubyObject instanceof JavaObject) && !((iRubyObject = iRubyObject.getInstanceVariables().fastGetInstanceVariable("@java_object")) instanceof JavaObject)) {
            return this.getRuntime().getFalse();
        }
        if (this.getValue() == null && ((JavaObject)iRubyObject).getValue() == null) {
            return this.getRuntime().getTrue();
        }
        boolean bl = this.getValue() == ((JavaObject)iRubyObject).getValue();
        return bl ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod
    public RubyString java_type() {
        return this.getRuntime().newString(this.getJavaClass().getName());
    }

    @JRubyMethod
    public IRubyObject java_class() {
        return JavaClass.get(this.getRuntime(), this.getJavaClass());
    }

    @JRubyMethod
    public RubyFixnum length() {
        throw this.getRuntime().newTypeError("not a java array");
    }

    @JRubyMethod(name={"[]"}, required=1)
    public IRubyObject aref(IRubyObject iRubyObject) {
        throw this.getRuntime().newTypeError("not a java array");
    }

    @JRubyMethod(name={"[]="}, required=2)
    public IRubyObject aset(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        throw this.getRuntime().newTypeError("not a java array");
    }

    @JRubyMethod(name={"fill"}, required=3)
    public IRubyObject afill(IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        throw this.getRuntime().newTypeError("not a java array");
    }

    @JRubyMethod(name={"java_proxy?"})
    public IRubyObject is_java_proxy() {
        return this.getRuntime().getTrue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"synchronized"})
    public IRubyObject ruby_synchronized(ThreadContext threadContext, Block block) {
        Object object = this.getValue();
        Object object2 = object != null ? object : NULL_LOCK;
        synchronized (object2) {
            return block.yield(threadContext, null);
        }
    }
}

